/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom.hanim;

import java.util.ArrayList;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.geom.hanim.HAnimSegment;
import org.j3d.renderer.aviatrix3d.geom.hanim.AVHumanoidPart;

class AVSegment
extends HAnimSegment
implements AVHumanoidPart,
NodeUpdateListener {
    private static final String NODE_CHILD_ERR = "Child must be an Aviatrix3D Node instance";
    private Group group = new Group();
    private ArrayList removedChildren;
    private ArrayList addedChildren;
    private boolean boundsChanged = false;
    private BoundingBox bounds;

    AVSegment() {
    }

    public Node getSceneGraphObject() {
        return this.group;
    }

    public void updateNodeBoundsChanges(Object object) {
        int n;
        if (this.removedChildren != null) {
            for (n = 0; n < this.removedChildren.size(); ++n) {
                this.group.removeChild((Node)this.removedChildren.get(n));
            }
            this.removedChildren.clear();
            this.removedChildren = null;
        }
        if (this.addedChildren != null) {
            for (n = 0; n < this.addedChildren.size(); ++n) {
                this.group.addChild((Node)this.addedChildren.get(n));
            }
            this.addedChildren.clear();
            this.addedChildren = null;
        }
        if (this.boundsChanged) {
            this.boundsChanged = false;
            this.group.setBounds(this.bounds);
        }
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void setBboxCenter(float[] fArray) {
        super.setBboxCenter(fArray);
        if (this.bboxSize[0] == -1.0f && this.bboxSize[1] == -1.0f && this.bboxSize[2] == 0.0f) {
            return;
        }
        if (this.bounds == null) {
            this.bounds = new BoundingBox();
        }
        float f = this.bboxCenter[0] - this.bboxSize[0];
        float f2 = this.bboxCenter[1] - this.bboxSize[1];
        float f3 = this.bboxCenter[2] - this.bboxSize[2];
        this.bounds.setMinimum(f, f2, f3);
        f = this.bboxCenter[0] + this.bboxSize[0];
        f2 = this.bboxCenter[1] + this.bboxSize[1];
        f3 = this.bboxCenter[2] + this.bboxSize[2];
        this.bounds.setMaximum(f, f2, f3);
        if (this.group.isLive()) {
            this.boundsChanged = true;
            this.group.boundsChanged(this);
        } else {
            this.group.setBounds(this.bounds);
        }
    }

    public void setBboxSize(float[] fArray) {
        super.setBboxSize(fArray);
        if (fArray[0] == -1.0f && fArray[1] == -1.0f && fArray[2] == 0.0f) {
            this.bounds = null;
        } else if (this.bounds == null) {
            this.bounds = new BoundingBox();
            float f = this.bboxCenter[0] - this.bboxSize[0];
            float f2 = this.bboxCenter[1] - this.bboxSize[1];
            float f3 = this.bboxCenter[2] - this.bboxSize[2];
            this.bounds.setMinimum(f, f2, f3);
            f = this.bboxCenter[0] + this.bboxSize[0];
            f2 = this.bboxCenter[1] + this.bboxSize[1];
            f3 = this.bboxCenter[2] + this.bboxSize[2];
            this.bounds.setMaximum(f, f2, f3);
        }
        if (this.group.isLive()) {
            this.boundsChanged = true;
            this.group.boundsChanged(this);
        } else {
            this.group.setBounds(this.bounds);
        }
    }

    public void setChildren(Object[] objectArray, int n) {
        if (this.group.isLive()) {
            int n2;
            if (this.addedChildren == null) {
                this.addedChildren = new ArrayList();
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (!(objectArray[n2] instanceof Node)) {
                    throw new IllegalArgumentException(NODE_CHILD_ERR);
                }
                this.addedChildren.add(objectArray[n2]);
            }
            if (this.removedChildren == null) {
                this.removedChildren = new ArrayList();
            }
            for (n2 = 0; n2 < this.numChildren; ++n2) {
                this.removedChildren.add(this.children[n2]);
            }
            this.group.boundsChanged(this);
        } else {
            this.group.removeAllChildren();
            for (int i = 0; i < n; ++i) {
                if (!(objectArray[i] instanceof Node)) {
                    throw new IllegalArgumentException(NODE_CHILD_ERR);
                }
                this.group.addChild((Node)objectArray[i]);
            }
        }
        super.setChildren(objectArray, n);
    }

    public void addChild(Object object) {
        if (!(object instanceof Node)) {
            throw new IllegalArgumentException(NODE_CHILD_ERR);
        }
        super.addChild(object);
        if (this.group.isLive()) {
            if (this.addedChildren == null) {
                this.addedChildren = new ArrayList();
            }
            this.addedChildren.add(object);
            this.group.boundsChanged(this);
        } else {
            this.group.addChild((Node)object);
        }
    }

    public void removeChild(Object object) {
        for (int i = 0; i < this.numChildren; ++i) {
            if (this.children[i] != object) continue;
            if (this.group.isLive()) {
                if (this.removedChildren == null) {
                    this.removedChildren = new ArrayList();
                }
                this.removedChildren.add(object);
                this.group.boundsChanged(this);
                break;
            }
            this.group.removeChild((Node)object);
            break;
        }
        super.removeChild(object);
    }
}

