/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom.hanim;

import java.util.ArrayList;
import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.geom.hanim.HAnimJoint;
import org.j3d.geom.hanim.HAnimObject;
import org.j3d.renderer.aviatrix3d.geom.hanim.AVHumanoidPart;

class AVJoint
extends HAnimJoint
implements AVHumanoidPart,
NodeUpdateListener {
    private static final String NODE_CHILD_ERR = "Child must implement the AVHumanoidPart interface";
    private TransformGroup transform = new TransformGroup();
    private ArrayList removedChildren;
    private ArrayList addedChildren;
    private boolean boundsChanged = false;
    private BoundingBox bounds;

    AVJoint() {
    }

    public Node getSceneGraphObject() {
        return this.transform;
    }

    public void updateNodeBoundsChanges(Object object) {
        int n;
        this.transform.setTransform(this.localMatrix);
        if (this.removedChildren != null) {
            for (n = 0; n < this.removedChildren.size(); ++n) {
                this.transform.removeChild((Node)this.removedChildren.get(n));
            }
            this.removedChildren.clear();
            this.removedChildren = null;
        }
        if (this.addedChildren != null) {
            for (n = 0; n < this.addedChildren.size(); ++n) {
                this.transform.addChild((Node)this.addedChildren.get(n));
            }
            this.addedChildren.clear();
            this.addedChildren = null;
        }
        if (this.boundsChanged) {
            this.boundsChanged = false;
            this.transform.setBounds(this.bounds);
        }
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void setBboxCenter(float[] fArray) {
        super.setBboxCenter(fArray);
        if (this.bboxSize[0] == -1.0f && this.bboxSize[1] == -1.0f && this.bboxSize[2] == 0.0f) {
            return;
        }
        if (this.bounds == null) {
            this.bounds = new BoundingBox();
        }
        float f = this.bboxCenter[0] - this.bboxSize[0];
        float f2 = this.bboxCenter[1] - this.bboxSize[1];
        float f3 = this.bboxCenter[2] - this.bboxSize[2];
        this.bounds.setMinimum(f, f2, f3);
        f = this.bboxCenter[0] + this.bboxSize[0];
        f2 = this.bboxCenter[1] + this.bboxSize[1];
        f3 = this.bboxCenter[2] + this.bboxSize[2];
        this.bounds.setMaximum(f, f2, f3);
        if (this.transform.isLive()) {
            this.boundsChanged = true;
            this.transform.boundsChanged(this);
        } else {
            this.transform.setBounds(this.bounds);
        }
    }

    public void setBboxSize(float[] fArray) {
        super.setBboxSize(fArray);
        if (fArray[0] == -1.0f && fArray[1] == -1.0f && fArray[2] == 0.0f) {
            this.bounds = null;
        } else if (this.bounds == null) {
            this.bounds = new BoundingBox();
            float f = this.bboxCenter[0] - this.bboxSize[0];
            float f2 = this.bboxCenter[1] - this.bboxSize[1];
            float f3 = this.bboxCenter[2] - this.bboxSize[2];
            this.bounds.setMinimum(f, f2, f3);
            f = this.bboxCenter[0] + this.bboxSize[0];
            f2 = this.bboxCenter[1] + this.bboxSize[1];
            f3 = this.bboxCenter[2] + this.bboxSize[2];
            this.bounds.setMaximum(f, f2, f3);
        }
        if (this.transform.isLive()) {
            this.boundsChanged = true;
            this.transform.boundsChanged(this);
        } else {
            this.transform.setBounds(this.bounds);
        }
    }

    public void setChildren(HAnimObject[] hAnimObjectArray, int n) {
        if (this.transform.isLive()) {
            Node node;
            int n2;
            if (this.addedChildren == null) {
                this.addedChildren = new ArrayList();
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (!(hAnimObjectArray[n2] instanceof AVHumanoidPart)) {
                    throw new IllegalArgumentException(NODE_CHILD_ERR);
                }
                node = ((AVHumanoidPart)hAnimObjectArray[n2]).getSceneGraphObject();
                this.addedChildren.add(node);
            }
            if (this.removedChildren == null) {
                this.removedChildren = new ArrayList();
            }
            for (n2 = 0; n2 < this.numChildren; ++n2) {
                node = ((AVHumanoidPart)this.children[n2]).getSceneGraphObject();
                this.removedChildren.add(node);
            }
            this.transform.boundsChanged(this);
        } else {
            this.transform.removeAllChildren();
            for (int i = 0; i < n; ++i) {
                if (!(hAnimObjectArray[i] instanceof AVHumanoidPart)) {
                    throw new IllegalArgumentException(NODE_CHILD_ERR);
                }
                Node node = ((AVHumanoidPart)hAnimObjectArray[i]).getSceneGraphObject();
                this.transform.addChild(node);
            }
        }
        super.setChildren(hAnimObjectArray, n);
    }

    public void addChild(HAnimObject hAnimObject) {
        if (!(hAnimObject instanceof AVHumanoidPart)) {
            throw new IllegalArgumentException(NODE_CHILD_ERR);
        }
        super.addChild(hAnimObject);
        if (this.transform.isLive()) {
            if (this.addedChildren == null) {
                this.addedChildren = new ArrayList();
            }
            Node node = ((AVHumanoidPart)hAnimObject).getSceneGraphObject();
            this.addedChildren.add(node);
            this.transform.boundsChanged(this);
        } else {
            Node node = ((AVHumanoidPart)hAnimObject).getSceneGraphObject();
            this.transform.addChild(node);
        }
    }

    public void removeChild(HAnimObject hAnimObject) {
        for (int i = 0; i < this.numChildren; ++i) {
            if (this.children[i] != hAnimObject) continue;
            if (this.transform.isLive()) {
                if (this.removedChildren == null) {
                    this.removedChildren = new ArrayList();
                }
                Node node = ((AVHumanoidPart)hAnimObject).getSceneGraphObject();
                this.removedChildren.add(node);
                this.transform.boundsChanged(this);
                break;
            }
            Node node = ((AVHumanoidPart)hAnimObject).getSceneGraphObject();
            this.transform.removeChild(node);
            break;
        }
        super.removeChild(hAnimObject);
    }

    protected void updateSkeleton(Matrix4f matrix4f, boolean bl) {
        if (this.matrixChanged) {
            if (this.transform.isLive()) {
                this.transform.boundsChanged(this);
            } else {
                this.updateNodeBoundsChanges(this.transform);
            }
        }
        super.updateSkeleton(matrix4f, bl);
    }
}

