/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom;

import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.TriangleStripArray;
import org.j3d.aviatrix3d.VertexGeometry;
import org.j3d.geom.GeometryData;
import org.j3d.geom.TorusGenerator;

public class Torus
extends Shape3D
implements NodeUpdateListener {
    private static final float DEFAULT_ORADIUS = 1.0f;
    private static final float DEFAULT_IRADIUS = 0.25f;
    private static final int DEFAULT_OFACETS = 16;
    private static final int DEFAULT_IFACETS = 16;
    private TorusGenerator generator;
    private GeometryData data = new GeometryData();

    public Torus() {
        this(1.0f, 0.25f, 16, 16, null);
    }

    public Torus(Appearance appearance) {
        this(0.25f, 1.0f, 16, 16, appearance);
    }

    public Torus(int n, int n2) {
        this(0.25f, 1.0f, n, n2, null);
    }

    public Torus(float f, float f2) {
        this(f, f2, 16, 16, null);
    }

    public Torus(int n, int n2, Appearance appearance) {
        this(1.0f, 0.25f, n, n2, appearance);
    }

    public Torus(float f, float f2, Appearance appearance) {
        this(f, f2, 16, 16, appearance);
    }

    public Torus(float f, float f2, int n, int n2, Appearance appearance) {
        this.data.geometryType = 3;
        this.data.geometryComponents = 2;
        this.generator = new TorusGenerator(f, f2, n, n2);
        this.generator.generate(this.data);
        TriangleStripArray triangleStripArray = new TriangleStripArray();
        triangleStripArray.setVertices(3, this.data.coordinates, this.data.vertexCount);
        triangleStripArray.setStripCount(this.data.stripCounts, this.data.numStrips);
        triangleStripArray.setNormals(this.data.normals);
        triangleStripArray.setUserData(this.data);
        this.setAppearance(appearance);
        this.setGeometry(triangleStripArray);
    }

    public void updateNodeBoundsChanges(Object object) {
        this.generator.generate(this.data);
        VertexGeometry vertexGeometry = (VertexGeometry)object;
        vertexGeometry.setVertices(3, this.data.coordinates, this.data.vertexCount);
        ((TriangleStripArray)vertexGeometry).setStripCount(this.data.stripCounts, this.data.numStrips);
        vertexGeometry.setNormals(this.data.normals);
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void setDimensions(float f, float f2) {
        this.generator.setDimensions(f, f2);
        VertexGeometry vertexGeometry = (VertexGeometry)this.getGeometry();
        vertexGeometry.boundsChanged(this);
    }

    public void setFacetCount(int n, int n2) {
        this.generator.setFacetCount(n, n2);
        VertexGeometry vertexGeometry = (VertexGeometry)this.getGeometry();
        vertexGeometry.boundsChanged(this);
    }
}

