/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.nio.Buffer;
import java.util.ArrayList;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.picking.NotPickableException;
import org.j3d.geom.CharacterCreator;
import org.j3d.geom.CharacterData;

public class Text2D
extends Geometry {
    private static final String INVALID_SPACING_MSG = "The value for the spacing is not positive definite: ";
    private static final String INVALID_SIZE_MSG = "The value for the size is not positive definite: ";
    private static final String INVALID_JUSTIFY_MSG = "Invalid justification constant provided. Must be one of the JUSTIFY_* values defined by this class";
    private static final CharacterCreator DEFAULT_CREATOR = new CharacterCreator(new Font(null, 0, 12), 0.01);
    public static final int JUSTIFY_FIRST = 0;
    public static final int JUSTIFY_BEGIN = 1;
    public static final int JUSTIFY_MIDDLE = 2;
    public static final int JUSTIFY_END = 3;
    private CharacterCreator generator;
    private String[] text;
    private ArrayList[] textCharacters;
    private ArrayList[] renderedCharacters;
    private float[] lengths;
    private float[] lineStartPos;
    private float[] lineSpacing;
    private float maxExtents;
    private boolean horizontal;
    private boolean leftToRight;
    private boolean topToBottom;
    private float sizeScale;
    private float spacingScale;
    private int hJustification;
    private int vJustification;
    private float[] wkTmp;

    public Text2D() {
        this(null);
        this.wkTmp = new float[3];
    }

    public Text2D(CharacterCreator characterCreator) {
        this.generator = characterCreator != null ? characterCreator : DEFAULT_CREATOR;
        this.bounds = INVALID_BOUNDS;
        this.horizontal = true;
        this.leftToRight = true;
        this.topToBottom = true;
        this.sizeScale = 1.0f;
        this.spacingScale = 1.0f;
        this.hJustification = 1;
        this.vJustification = 1;
        this.maxExtents = 0.0f;
        this.wkTmp = new float[3];
    }

    public void render(GL gL) {
        if (this.text == null) {
            return;
        }
        gL.glNormal3f(0.0f, 0.0f, 1.0f);
        gL.glEnableClientState(32884);
        if (this.horizontal) {
            float f = 0.0f;
            for (int i = 0; i < this.text.length; ++i) {
                ArrayList arrayList = this.renderedCharacters[i];
                int n = arrayList.size();
                gL.glPushMatrix();
                gL.glTranslatef(this.lineStartPos[i], f -= this.lineSpacing[i], 0.0f);
                gL.glScalef(this.sizeScale, this.sizeScale, 1.0f);
                for (int j = 0; j < n; ++j) {
                    CharacterData characterData = (CharacterData)arrayList.get(j);
                    if (characterData.coordinates == null) {
                        gL.glTranslatef(characterData.bounds.width, 0.0f, 0.0f);
                        continue;
                    }
                    gL.glVertexPointer(3, 5126, 0, (Buffer)characterData.coordinates);
                    gL.glDrawElements(4, characterData.numIndex, 5125, (Buffer)characterData.coordIndex);
                    gL.glTranslatef(characterData.bounds.width, 0.0f, 0.0f);
                }
                gL.glPopMatrix();
            }
        } else {
            float f = 0.0f;
            for (int i = 0; i < this.text.length; ++i) {
                ArrayList arrayList = this.renderedCharacters[i];
                int n = arrayList.size();
                gL.glPushMatrix();
                gL.glTranslatef(f, this.lineStartPos[i], 0.0f);
                gL.glScalef(this.sizeScale, this.sizeScale, 1.0f);
                for (int j = 0; j < n; ++j) {
                    CharacterData characterData = (CharacterData)arrayList.get(j);
                    if (characterData.coordinates == null) {
                        gL.glTranslatef(0.0f, -characterData.bounds.height, 0.0f);
                        continue;
                    }
                    gL.glVertexPointer(3, 5126, 0, (Buffer)characterData.coordinates);
                    gL.glDrawElements(4, characterData.numIndex, 5125, (Buffer)characterData.coordIndex);
                    gL.glTranslatef(0.0f, -characterData.bounds.height, 0.0f);
                }
                gL.glPopMatrix();
                f += this.lineSpacing[i];
            }
        }
        gL.glDisableClientState(32884);
    }

    public void postRender(GL gL) {
    }

    public int compareTo(Object object) throws ClassCastException {
        Text2D text2D = (Text2D)object;
        return this.compareTo(text2D);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Text2D)) {
            return false;
        }
        return this.equals((Text2D)object);
    }

    protected boolean isVisible() {
        return this.text != null && this.text.length != 0;
    }

    public boolean is2D() {
        return false;
    }

    protected void setLive(boolean bl) {
        boolean bl2 = this.alive;
        super.setLive(bl);
        if (!bl2 && bl) {
            this.recomputeBounds();
        }
    }

    protected void recomputeBounds() {
        int n;
        float f;
        float f2;
        block48: {
            int n2;
            int n3;
            Object object;
            block47: {
                if (this.text == null) {
                    this.bounds = INVALID_BOUNDS;
                    return;
                }
                if (this.bounds == INVALID_BOUNDS) {
                    this.bounds = new BoundingBox();
                }
                f2 = 0.0f;
                f = 0.0f;
                if (!this.horizontal) break block47;
                Font font = this.generator.getFont();
                object = this.generator.getFontRenderContext();
                for (n3 = 0; n3 < this.text.length; ++n3) {
                    Object object2;
                    ArrayList arrayList = this.textCharacters[n3];
                    n = arrayList.size();
                    float f3 = 0.0f;
                    float f4 = 0.0f;
                    if (n == 0) continue;
                    for (int i = 0; i < n; ++i) {
                        object2 = (CharacterData)arrayList.get(i);
                        f4 += ((CharacterData)object2).bounds.width;
                        float f5 = ((CharacterData)object2).bounds.height;
                        if (!(f5 > f3)) continue;
                        f3 = f5;
                    }
                    CharacterData characterData = (CharacterData)arrayList.get(0);
                    object2 = font.getLineMetrics(this.text[n3], (FontRenderContext)object);
                    f3 = ((LineMetrics)object2).getAscent() * characterData.scale;
                    this.lineStartPos[n3] = f4 * this.sizeScale;
                    this.lineSpacing[n3] = f3 * this.sizeScale * this.spacingScale;
                    if (this.lengths[n3] > 0.0f) {
                        this.lineStartPos[n3] = this.lengths[n3];
                    }
                    if (f4 > f2) {
                        f2 = this.lengths[n3] > 0.0f ? this.lengths[n3] : f4;
                    }
                    f += f3;
                }
                f2 *= this.sizeScale * (float)this.text.length;
                f *= this.sizeScale * this.spacingScale * (float)this.text.length;
                if (this.maxExtents > 0.0f) {
                    f2 = this.maxExtents;
                }
                switch (this.hJustification) {
                    case 0: 
                    case 1: {
                        for (n3 = 0; n3 < this.text.length; ++n3) {
                            this.lineStartPos[n3] = 0.0f;
                        }
                        break block48;
                    }
                    case 2: {
                        for (n3 = 0; n3 < this.text.length; ++n3) {
                            this.lineStartPos[n3] = this.lineStartPos[n3] * -0.5f;
                        }
                        break block48;
                    }
                    case 3: {
                        for (n3 = 0; n3 < this.text.length; ++n3) {
                            this.lineStartPos[n3] = f2 - this.lineStartPos[n3];
                        }
                        break;
                    }
                }
                break block48;
            }
            for (n2 = 0; n2 < this.text.length; ++n2) {
                object = this.textCharacters[n2];
                n3 = ((ArrayList)object).size();
                float f6 = 0.0f;
                float f7 = 0.0f;
                for (int i = 0; i < n3; ++i) {
                    CharacterData characterData = (CharacterData)((ArrayList)object).get(i);
                    f7 += characterData.bounds.width;
                    float f8 = characterData.bounds.height;
                    if (!(f8 > f6)) continue;
                    f6 = f8;
                }
                this.lineStartPos[n2] = f7 * this.sizeScale;
                this.lineSpacing[n2] = f6 * this.sizeScale * this.spacingScale;
                if (this.lengths[n2] > 0.0f) {
                    this.lineStartPos[n2] = this.lengths[n2];
                }
                if (f7 > f) {
                    f = this.lengths[n2] > 0.0f ? this.lengths[n2] : f7;
                }
                f2 += f6;
            }
            f2 *= this.sizeScale * this.spacingScale * (float)this.text.length;
            f *= this.sizeScale * (float)this.text.length;
            if (this.maxExtents > 0.0f) {
                f2 = this.maxExtents;
            }
            switch (this.vJustification) {
                case 0: 
                case 1: {
                    for (n2 = 0; n2 < this.text.length; ++n2) {
                        this.lineStartPos[n2] = 0.0f;
                    }
                    break;
                }
                case 2: {
                    for (n2 = 0; n2 < this.text.length; ++n2) {
                        this.lineStartPos[n2] = this.lineStartPos[n2] * -0.5f;
                    }
                    break;
                }
                case 3: {
                    for (n2 = 0; n2 < this.text.length; ++n2) {
                        this.lineStartPos[n2] = f - this.lineStartPos[n2];
                    }
                    break;
                }
            }
        }
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        switch (this.hJustification) {
            case 0: {
                f11 = f2;
                break;
            }
            case 1: {
                f11 = f2;
                break;
            }
            case 2: {
                f9 = -f2 * 0.5f;
                f11 = f2 * 0.5f;
                break;
            }
            case 3: {
                f9 = -f2;
            }
        }
        switch (this.vJustification) {
            case 0: {
                f12 = -f;
                break;
            }
            case 1: {
                f12 = -f;
                break;
            }
            case 2: {
                f10 = f * 0.5f;
                f12 = -f * 0.5f;
                break;
            }
            case 3: {
                f10 = f;
            }
        }
        ((BoundingBox)this.bounds).setMinimum(f9, f12, 0.0f);
        ((BoundingBox)this.bounds).setMaximum(f11, f10, 0.0f);
        if (this.leftToRight) {
            for (n = 0; n < this.textCharacters.length; ++n) {
                this.renderedCharacters[n].clear();
                this.renderedCharacters[n].addAll(this.textCharacters[n]);
            }
        } else {
            for (n = 0; n < this.textCharacters.length; ++n) {
                this.renderedCharacters[n].clear();
                ArrayList arrayList = this.textCharacters[n];
                int n4 = arrayList.size();
                for (int i = 0; i < n4; ++i) {
                    this.renderedCharacters[n].add(arrayList.get(n4 - i - 1));
                }
            }
        }
        if (!this.topToBottom) {
            n = this.renderedCharacters.length;
            for (int i = 0; i < n / 2; ++i) {
                ArrayList arrayList = this.renderedCharacters[i];
                this.renderedCharacters[i] = this.renderedCharacters[n - i - 1];
                this.renderedCharacters[n - i - 1] = arrayList;
                float f13 = this.lineStartPos[i];
                this.lineStartPos[i] = this.lineStartPos[n - i - 1];
                this.lineStartPos[n - i - 1] = f13;
                f13 = this.lengths[i];
                this.lengths[i] = this.lengths[n - i - 1];
                this.lengths[n - i - 1] = f13;
                f13 = this.lineSpacing[i];
                this.lineSpacing[i] = this.lineSpacing[n - i - 1];
                this.lineSpacing[n - i - 1] = f13;
            }
        }
    }

    public boolean pickLineSegment(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineSegment(fArray, fArray2, bl, fArray3, n);
        if (fArray[2] < 0.0f && fArray2[2] < 0.0f || fArray[2] > 0.0f && fArray2[2] > 0.0f) {
            return false;
        }
        float f = 0.0f;
        float f2 = fArray2[0] - fArray[0];
        float f3 = 0.0f;
        float f4 = fArray2[1] - fArray[1];
        float f5 = 1.0f;
        float f6 = fArray2[2] - fArray[2];
        float f7 = f * f2 + f3 * f4 + f5 * f6;
        if (f7 == 0.0f) {
            return false;
        }
        BoundingBox boundingBox = (BoundingBox)this.bounds;
        boundingBox.getMinimum(this.wkTmp);
        float f8 = f * this.wkTmp[0] + f3 * this.wkTmp[1] + f5 * this.wkTmp[2];
        float f9 = f * fArray[0] + f3 * fArray[1] + f5 * fArray[2];
        float f10 = (f8 - f9) / f7;
        fArray3[0] = fArray[0] + f2 * f10;
        fArray3[1] = fArray[1] + f4 * f10;
        fArray3[2] = fArray[2] + f6 * f10;
        return true;
    }

    public boolean pickLineRay(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineRay(fArray, fArray2, bl, fArray3, n);
        if (fArray[2] < 0.0f) {
            return false;
        }
        if (fArray2[2] > 0.0f) {
            return false;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f4 = f * fArray2[0] + f2 * fArray2[1] + f3 * fArray2[2];
        if (f4 == 0.0f) {
            return false;
        }
        BoundingBox boundingBox = (BoundingBox)this.bounds;
        boundingBox.getMinimum(this.wkTmp);
        float f5 = f * this.wkTmp[0] + f2 * this.wkTmp[1] + f3 * this.wkTmp[2];
        float f6 = f * fArray[0] + f2 * fArray[1] + f3 * fArray[2];
        float f7 = (f5 - f6) / f4;
        if (f7 < 0.0f) {
            return false;
        }
        fArray3[0] = fArray[0] + fArray2[0] * f7;
        fArray3[1] = fArray[1] + fArray2[1] * f7;
        fArray3[2] = fArray[2] + fArray2[2] * f7;
        return true;
    }

    public void setCharacterCreator(CharacterCreator characterCreator) {
        this.generator = characterCreator != null ? characterCreator : DEFAULT_CREATOR;
    }

    public void setText(String[] stringArray, int n) {
        int n2;
        if (this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n3 = n2 = this.text == null ? 0 : this.text.length;
        if (n == 0) {
            this.text = null;
            this.textCharacters = null;
        } else {
            int n4;
            if (n != n2) {
                this.text = new String[n];
                this.textCharacters = new ArrayList[n];
                this.renderedCharacters = new ArrayList[n];
                this.lineStartPos = new float[n];
                this.lineSpacing = new float[n];
                this.lengths = new float[n];
                for (n4 = 0; n4 < n; ++n4) {
                    this.textCharacters[n4] = new ArrayList();
                    this.renderedCharacters[n4] = new ArrayList();
                }
            } else {
                for (n4 = 0; n4 < n; ++n4) {
                    this.textCharacters[n4].clear();
                    this.renderedCharacters[n4].clear();
                }
            }
            System.arraycopy(stringArray, 0, this.text, 0, n);
            for (n4 = 0; n4 < n; ++n4) {
                char[] cArray = stringArray[n4].toCharArray();
                this.generator.createCharacterTriangles(cArray, cArray.length, this.textCharacters[n4]);
                int n5 = this.textCharacters[n4].size();
                for (int i = 0; i < n5; ++i) {
                    CharacterData characterData = (CharacterData)this.textCharacters[n4].get(i);
                    if (characterData.coordinates == null) continue;
                    characterData.coordinates.rewind();
                    characterData.coordIndex.rewind();
                }
            }
        }
    }

    public String[] getText() {
        return this.text;
    }

    public void setHorizontal(boolean bl) throws InvalidWriteTimingException {
        if (this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.horizontal = bl;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setLeftToRight(boolean bl) throws InvalidWriteTimingException {
        if (this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.leftToRight = bl;
    }

    public boolean isLeftToRight() {
        return this.leftToRight;
    }

    public void setTopToBottom(boolean bl) throws InvalidWriteTimingException {
        if (this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.topToBottom = bl;
    }

    public boolean isTopToBottom() {
        return this.topToBottom;
    }

    public void setSpacing(float f) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException(INVALID_SPACING_MSG + f);
        }
        this.spacingScale = f;
    }

    public float getSpacing() {
        return this.spacingScale;
    }

    public void setSize(float f) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException(INVALID_SIZE_MSG + f);
        }
        this.sizeScale = f;
    }

    public float getSize() {
        return this.sizeScale;
    }

    public void setHorizontalJustification(int n) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException(INVALID_JUSTIFY_MSG);
        }
        this.hJustification = n;
    }

    public float getHorizontalJustification() {
        return this.hJustification;
    }

    public void setVerticalJustification(int n) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException(INVALID_JUSTIFY_MSG);
        }
        this.vJustification = n;
    }

    public float getVerticalJustification() {
        return this.vJustification;
    }

    public int compareTo(Text2D text2D) {
        if (text2D == null) {
            return 1;
        }
        if (text2D == this) {
            return 0;
        }
        if (this.generator != text2D.generator) {
            return this.generator.hashCode() < text2D.generator.hashCode() ? -1 : 1;
        }
        if (this.text.length == text2D.text.length) {
            for (int i = 0; i < this.text.length; ++i) {
                int n = this.text[i].compareTo(text2D.text[i]);
                if (n == 0) continue;
                return n;
            }
        } else {
            return this.text.length < text2D.text.length ? -1 : 1;
        }
        if (this.topToBottom != text2D.topToBottom) {
            return this.topToBottom ? 1 : -1;
        }
        if (this.leftToRight != text2D.leftToRight) {
            return this.leftToRight ? 1 : -1;
        }
        if (this.horizontal != text2D.horizontal) {
            return this.horizontal ? 1 : -1;
        }
        if (this.sizeScale != text2D.sizeScale) {
            return this.sizeScale < text2D.sizeScale ? 1 : -1;
        }
        if (this.spacingScale != text2D.spacingScale) {
            return this.spacingScale < text2D.spacingScale ? 1 : -1;
        }
        if (this.hJustification != text2D.hJustification) {
            return this.hJustification < text2D.hJustification ? 1 : -1;
        }
        if (this.vJustification != text2D.vJustification) {
            return this.vJustification < text2D.vJustification ? 1 : -1;
        }
        return 0;
    }

    public boolean equals(Text2D text2D) {
        if (text2D == this) {
            return true;
        }
        return text2D != null && this.generator == text2D.generator && this.text.length == text2D.text.length && this.topToBottom == text2D.topToBottom && this.leftToRight == text2D.leftToRight && this.horizontal == text2D.horizontal && this.sizeScale == text2D.sizeScale && this.spacingScale == text2D.spacingScale && this.hJustification == text2D.hJustification && this.vJustification == text2D.vJustification;
    }
}

