/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom;

import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.TriangleStripArray;
import org.j3d.aviatrix3d.VertexGeometry;
import org.j3d.geom.GeometryData;
import org.j3d.geom.SpringGenerator;

public class Spring
extends Shape3D
implements NodeUpdateListener {
    private static final float DEFAULT_INNER_RADIUS = 0.25f;
    private static final float DEFAULT_OUTER_RADIUS = 1.0f;
    private static final int DEFAULT_INNER_FACETS = 16;
    private static final int DEFAULT_OUTER_FACETS = 16;
    private static final int DEFAULT_LOOP_COUNT = 4;
    private static final float DEFAULT_LOOP_SPACING = 1.0f;
    private SpringGenerator generator;
    private GeometryData data = new GeometryData();

    public Spring() {
        this(0.25f, 1.0f, 1.0f, 4, 16, 16, null);
    }

    public Spring(Appearance appearance) {
        this(0.25f, 1.0f, 1.0f, 4, 16, 16, appearance);
    }

    public Spring(float f, float f2) {
        this(f, f2, 1.0f, 4, 16, 16, null);
    }

    public Spring(float f, float f2, Appearance appearance) {
        this(f, f2, 1.0f, 4, 16, 16, appearance);
    }

    public Spring(int n) {
        this(0.25f, 1.0f, 1.0f, n, 16, 16, null);
    }

    public Spring(int n, Appearance appearance) {
        this(0.25f, 1.0f, 1.0f, n, 16, 16, appearance);
    }

    public Spring(float f) {
        this(0.25f, 1.0f, f, 4, 16, 16, null);
    }

    public Spring(float f, Appearance appearance) {
        this(0.25f, 1.0f, f, 4, 16, 16, appearance);
    }

    public Spring(int n, int n2) {
        this(0.25f, 1.0f, 1.0f, 4, n, n2, null);
    }

    public Spring(int n, int n2, Appearance appearance) {
        this(0.25f, 1.0f, 1.0f, 4, n, n2, appearance);
    }

    public Spring(float f, float f2, float f3, int n) {
        this(f, f2, f3, n, 16, 16, null);
    }

    public Spring(float f, float f2, float f3, int n, int n2, int n3, Appearance appearance) {
        this.data.geometryType = 3;
        this.data.geometryComponents = 2;
        this.generator = new SpringGenerator(f, f2, (float)n2, n3);
        this.generator.generate(this.data);
        TriangleStripArray triangleStripArray = new TriangleStripArray();
        triangleStripArray.setVertices(3, this.data.coordinates, this.data.vertexCount);
        triangleStripArray.setStripCount(this.data.stripCounts, this.data.numStrips);
        triangleStripArray.setNormals(this.data.normals);
        triangleStripArray.setUserData(this.data);
        this.setAppearance(appearance);
        this.setGeometry(triangleStripArray);
    }

    public void updateNodeBoundsChanges(Object object) {
        this.generator.generate(this.data);
        VertexGeometry vertexGeometry = (VertexGeometry)object;
        vertexGeometry.setVertices(3, this.data.coordinates, this.data.vertexCount);
        ((TriangleStripArray)vertexGeometry).setStripCount(this.data.stripCounts, this.data.numStrips);
        vertexGeometry.setNormals(this.data.normals);
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void setDimensions(float f, float f2) {
        this.generator.setDimensions(f, f2);
        VertexGeometry vertexGeometry = (VertexGeometry)this.getGeometry();
        vertexGeometry.boundsChanged(this);
    }

    public void setLoopDimensions(float f, int n) {
        this.generator.setLoopDimensions(f, n);
        VertexGeometry vertexGeometry = (VertexGeometry)this.getGeometry();
        vertexGeometry.boundsChanged(this);
    }

    public void setFacetCount(int n, int n2) {
        this.generator.setFacetCount(n, n2);
        VertexGeometry vertexGeometry = (VertexGeometry)this.getGeometry();
        vertexGeometry.boundsChanged(this);
    }
}

