/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom;

import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.TriangleStripArray;
import org.j3d.aviatrix3d.VertexGeometry;
import org.j3d.geom.GeometryData;
import org.j3d.geom.SphereGenerator;

public class Sphere
extends Shape3D
implements NodeUpdateListener {
    private static final float DEFAULT_RADIUS = 1.0f;
    private static final int DEFAULT_FACETS = 16;
    private SphereGenerator generator;
    private GeometryData data = new GeometryData();

    public Sphere() {
        this(1.0f, 16, null);
    }

    public Sphere(Appearance appearance) {
        this(1.0f, 16, appearance);
    }

    public Sphere(int n) {
        this(1.0f, n, null);
    }

    public Sphere(float f) {
        this(f, 16, null);
    }

    public Sphere(int n, Appearance appearance) {
        this(1.0f, n, appearance);
    }

    public Sphere(float f, Appearance appearance) {
        this(f, 16, appearance);
    }

    public Sphere(float f, int n, Appearance appearance) {
        this.data.geometryType = 3;
        this.data.geometryComponents = 2;
        this.generator = new SphereGenerator(f, n);
        this.generator.generate(this.data);
        TriangleStripArray triangleStripArray = new TriangleStripArray();
        triangleStripArray.setVertices(3, this.data.coordinates, this.data.vertexCount);
        triangleStripArray.setStripCount(this.data.stripCounts, this.data.numStrips);
        triangleStripArray.setNormals(this.data.normals);
        triangleStripArray.setUserData(this.data);
        this.setAppearance(appearance);
        this.setGeometry(triangleStripArray);
    }

    public void updateNodeBoundsChanges(Object object) {
        this.generator.generate(this.data);
        VertexGeometry vertexGeometry = (VertexGeometry)object;
        vertexGeometry.setVertices(3, this.data.coordinates, this.data.vertexCount);
        ((TriangleStripArray)vertexGeometry).setStripCount(this.data.stripCounts, this.data.numStrips);
        vertexGeometry.setNormals(this.data.normals);
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void setDimensions(float f) {
        this.generator.setDimensions(f, true);
        VertexGeometry vertexGeometry = (VertexGeometry)this.getGeometry();
        vertexGeometry.boundsChanged(this);
    }

    public void setFacetCount(int n) {
        this.generator.setFacetCount(n);
        VertexGeometry vertexGeometry = (VertexGeometry)this.getGeometry();
        vertexGeometry.boundsChanged(this);
    }
}

