/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Material;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.TriangleStripArray;
import org.j3d.geom.BoxGenerator;
import org.j3d.geom.ConeGenerator;
import org.j3d.geom.CoordinateUtils;
import org.j3d.geom.GeometryData;

public class Axis
extends Group {
    private static final float DEFAULT_AXIS_LENGTH = 5.0f;
    private static final float DEFAULT_X_SIZE = 0.05f;

    public Axis() {
        this(5.0f, 1.0f);
    }

    public Axis(float f) {
        this(f, 1.0f);
    }

    public Axis(float f, float f2) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Axis length is not positive");
        }
        float f3 = 0.05f;
        if (f > 5.0f) {
            f3 = f * 0.04f;
        }
        BoxGenerator boxGenerator = new BoxGenerator(f3, f, f3);
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 3;
        geometryData.geometryComponents = 2;
        boxGenerator.generate(geometryData);
        TriangleStripArray triangleStripArray = new TriangleStripArray();
        triangleStripArray.setVertices(3, geometryData.coordinates, geometryData.vertexCount);
        triangleStripArray.setNormals(geometryData.normals);
        triangleStripArray.setStripCount(geometryData.stripCounts, geometryData.numStrips);
        ConeGenerator coneGenerator = new ConeGenerator(f3 * 4.0f, f3 * 2.0f, 4);
        geometryData.geometryType = 4;
        geometryData.vertexCount = 0;
        geometryData.coordinates = null;
        geometryData.normals = null;
        geometryData.stripCounts = null;
        coneGenerator.generate(geometryData);
        CoordinateUtils coordinateUtils = new CoordinateUtils();
        coordinateUtils.translate(geometryData.coordinates, geometryData.vertexCount, 0.0f, f * 0.5f + f3 * 2.0f, 0.0f);
        TriangleStripArray triangleStripArray2 = new TriangleStripArray();
        triangleStripArray2.setVertices(3, geometryData.coordinates, geometryData.vertexCount);
        triangleStripArray2.setStripCount(geometryData.stripCounts, geometryData.numStrips);
        triangleStripArray2.setNormals(geometryData.normals);
        float[] fArray = new float[]{0.0f, 0.0f, 0.8f};
        Material material = new Material();
        material.setDiffuseColor(fArray);
        material.setLightingEnabled(true);
        material.setTransparency(f2);
        float[] fArray2 = new float[]{0.8f, 0.0f, 0.0f};
        Material material2 = new Material();
        material2.setDiffuseColor(fArray2);
        material2.setLightingEnabled(true);
        material2.setTransparency(f2);
        float[] fArray3 = new float[]{0.0f, 0.8f, 0.0f};
        Material material3 = new Material();
        material3.setDiffuseColor(fArray3);
        material3.setLightingEnabled(true);
        material3.setTransparency(f2);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material2);
        Appearance appearance2 = new Appearance();
        appearance2.setMaterial(material3);
        Appearance appearance3 = new Appearance();
        appearance3.setMaterial(material);
        Shape3D shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.setGeometry(triangleStripArray);
        Shape3D shape3D2 = new Shape3D();
        shape3D2.setAppearance(appearance);
        shape3D2.setGeometry(triangleStripArray2);
        Shape3D shape3D3 = new Shape3D();
        shape3D3.setAppearance(appearance2);
        shape3D3.setGeometry(triangleStripArray);
        Shape3D shape3D4 = new Shape3D();
        shape3D4.setAppearance(appearance2);
        shape3D4.setGeometry(triangleStripArray2);
        Shape3D shape3D5 = new Shape3D();
        shape3D5.setAppearance(appearance3);
        shape3D5.setGeometry(triangleStripArray);
        Shape3D shape3D6 = new Shape3D();
        shape3D6.setAppearance(appearance3);
        shape3D6.setGeometry(triangleStripArray2);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        AxisAngle4f axisAngle4f = new AxisAngle4f();
        matrix4f.rotZ(-1.5707964f);
        TransformGroup transformGroup = new TransformGroup(matrix4f);
        transformGroup.setTransform(matrix4f);
        transformGroup.addChild(shape3D);
        transformGroup.addChild(shape3D2);
        matrix4f.rotX(1.5707964f);
        TransformGroup transformGroup2 = new TransformGroup(matrix4f);
        transformGroup2.setTransform(matrix4f);
        transformGroup2.addChild(shape3D5);
        transformGroup2.addChild(shape3D6);
        this.addChild(transformGroup);
        this.addChild(shape3D3);
        this.addChild(shape3D4);
        this.addChild(transformGroup2);
    }
}

