/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline.graphics;

import org.j3d.aviatrix3d.rendering.Renderable;

public class VisualDetails {
    private int hash = 0;
    private Renderable renderable;
    private float[] transform = new float[16];

    public int compareTo(Object object) throws ClassCastException {
        VisualDetails visualDetails = (VisualDetails)object;
        return this.compareTo(visualDetails);
    }

    public boolean equals(Object object) {
        if (!(object instanceof VisualDetails)) {
            return false;
        }
        VisualDetails visualDetails = (VisualDetails)object;
        if (this.renderable != visualDetails.renderable) {
            return false;
        }
        for (int i = 0; i < 16; ++i) {
            if (this.transform[i] == visualDetails.transform[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }

    public void update(Renderable renderable, float[] fArray) {
        this.renderable = renderable;
        System.arraycopy(fArray, 0, this.transform, 0, 16);
        float f = 0.0f;
        f = 31.0f * this.transform[0] + this.transform[1];
        f = 31.0f * f + this.transform[2];
        f = 31.0f * f + this.transform[3];
        f = 31.0f * f + this.transform[4];
        f = 31.0f * f + this.transform[5];
        f = 31.0f * f + this.transform[6];
        f = 31.0f * f + this.transform[7];
        f = 31.0f * f + this.transform[8];
        f = 31.0f * f + this.transform[9];
        f = 31.0f * f + this.transform[10];
        f = 31.0f * f + this.transform[11];
        f = 31.0f * f + this.transform[12];
        f = 31.0f * f + this.transform[13];
        f = 31.0f * f + this.transform[14];
        f = 31.0f * f + this.transform[15];
        long l = Float.floatToIntBits(f) + this.renderable.hashCode();
        this.hash = (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    public float[] getTransform() {
        return this.transform;
    }

    public Renderable getRenderable() {
        return this.renderable;
    }

    public void clear() {
        this.renderable = null;
        this.hash = 0;
    }

    public int compareTo(VisualDetails visualDetails) {
        int n;
        if (visualDetails == this) {
            return 0;
        }
        if (visualDetails == null) {
            return 1;
        }
        if (this.renderable != visualDetails.renderable) {
            if (this.renderable == null) {
                return -1;
            }
            if (visualDetails.renderable == null) {
                return 1;
            }
            n = this.renderable.compareTo(visualDetails.renderable);
            if (n != 0) {
                return n;
            }
        }
        for (n = 0; n < 16; ++n) {
            if (this.transform[n] == visualDetails.transform[n]) continue;
            return this.transform[n] < visualDetails.transform[n] ? -1 : 1;
        }
        return 0;
    }
}

