/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline.graphics;

import java.util.ArrayList;
import org.j3d.aviatrix3d.Viewport;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsResizeListener;

public class ViewportResizeManager
implements GraphicsResizeListener {
    private ArrayList viewports = new ArrayList();
    private boolean newSizeSet = false;
    private int viewX;
    private int viewY;
    private int viewWidth;
    private int viewHeight;
    private boolean validSizeSet = false;

    public void graphicsDeviceResized(int n, int n2, int n3, int n4) {
        this.viewX = n;
        this.viewY = n2;
        this.viewWidth = n3;
        this.viewHeight = n4;
        this.newSizeSet = true;
        this.validSizeSet = true;
    }

    public void sendResizeUpdates() {
        if (!this.newSizeSet) {
            return;
        }
        for (int i = 0; i < this.viewports.size(); ++i) {
            Viewport viewport = (Viewport)this.viewports.get(i);
            viewport.setDimensions(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
        }
        this.newSizeSet = false;
    }

    public void addManagedViewport(Viewport viewport) {
        if (viewport == null || this.viewports.contains(viewport)) {
            return;
        }
        this.viewports.add(viewport);
        if (this.validSizeSet) {
            viewport.setDimensions(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
        }
    }

    public void removeManagedViewport(Viewport viewport) {
        if (viewport == null) {
            return;
        }
        this.viewports.remove(viewport);
    }

    public void clear() {
        this.viewports.clear();
    }
}

