/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline.graphics;

import org.j3d.aviatrix3d.pipeline.graphics.MultipassRenderBucket;
import org.j3d.aviatrix3d.pipeline.graphics.SceneRenderBucket;

public class ViewportLayerCollection {
    private static final String NEG_SIZE_MSG = "The argument given must be greater than zero.";
    public static final int SINGLE_SCENE = 1;
    public static final int MULTIPASS_SCENE = 2;
    public static final int FLAT_SCENE = 3;
    public SceneRenderBucket[] scenes;
    public int numScenes;
    public MultipassRenderBucket[] multipass;
    public int numMultipass;
    public byte[] sceneType;
    public int numBuckets;

    public ViewportLayerCollection() {
        this(1);
    }

    public ViewportLayerCollection(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException(NEG_SIZE_MSG);
        }
        this.scenes = new SceneRenderBucket[n];
        for (int i = 0; i < n; ++i) {
            this.scenes[i] = new SceneRenderBucket();
        }
        this.sceneType = new byte[n];
    }

    public void ensureSceneCapacity(int n) {
        if (this.scenes.length < n) {
            int n2;
            int n3 = this.scenes.length;
            SceneRenderBucket[] sceneRenderBucketArray = new SceneRenderBucket[n];
            System.arraycopy(this.scenes, 0, sceneRenderBucketArray, 0, this.scenes.length);
            this.scenes = sceneRenderBucketArray;
            for (n2 = n3; n2 < n; ++n2) {
                this.scenes[n2] = new SceneRenderBucket();
            }
            n2 = n + (this.multipass == null ? 0 : this.multipass.length);
            byte[] byArray = new byte[n2];
            System.arraycopy(this.sceneType, 0, byArray, 0, this.sceneType.length);
            this.sceneType = byArray;
        }
    }

    public void ensureMultipassCapacity(int n) {
        if (this.multipass == null || this.multipass.length < n) {
            int n2;
            int n3 = this.multipass == null ? 0 : this.multipass.length;
            MultipassRenderBucket[] multipassRenderBucketArray = new MultipassRenderBucket[n];
            if (n3 != 0) {
                System.arraycopy(this.multipass, 0, multipassRenderBucketArray, 0, this.multipass.length);
            }
            this.multipass = multipassRenderBucketArray;
            for (n2 = n3; n2 < n; ++n2) {
                this.multipass[n2] = new MultipassRenderBucket();
            }
            n2 = n + this.scenes.length;
            byte[] byArray = new byte[n];
            System.arraycopy(this.sceneType, 0, byArray, 0, this.sceneType.length);
            this.sceneType = byArray;
        }
    }
}

