/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline.graphics;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.Pixmap;
import org.j3d.aviatrix3d.Raster;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.TextureUnit;
import org.j3d.aviatrix3d.pipeline.graphics.BaseSortStage;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsCullOutputDetails;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsEnvironmentData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsInstructions;
import org.j3d.aviatrix3d.pipeline.graphics.MultipassRenderBucket;
import org.j3d.aviatrix3d.pipeline.graphics.SceneRenderBucket;
import org.j3d.aviatrix3d.pipeline.graphics.VisualDetails;
import org.j3d.aviatrix3d.rendering.AppearanceRenderable;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.aviatrix3d.rendering.CustomRenderable;
import org.j3d.aviatrix3d.rendering.Renderable;
import org.j3d.aviatrix3d.rendering.ShapeRenderable;
import org.j3d.util.MatrixUtils;

public class TransparencyDepthSortStage
extends BaseSortStage {
    private static final String INVALID_DEPTH_MSG = "The depthBits must be greater than or equal to 1";
    private static final int TRANSPARENT_LIST_SIZE = 200;
    private static final int DEFAULT_DEPTH_BITS = 16;
    private final int depthAccuracy;
    private GraphicsCullOutputDetails[] transparentList;
    private GraphicsCullOutputDetails[] unsortedTransparentList;
    private float[] depthList1;
    private int[] depthList2;
    private int[] countList;
    private Matrix4f modelMatrix;
    private Matrix4f cameraMatrix;
    private Point3f wkPoint;
    private float[] center;
    private MatrixUtils matrixUtils;
    private TextureUnit[] textureTmp;

    public TransparencyDepthSortStage() {
        this(1, 16);
    }

    public TransparencyDepthSortStage(int n) {
        this(n, 16);
    }

    public TransparencyDepthSortStage(int n, int n2) {
        super(n);
        if (n2 < 1) {
            throw new IllegalArgumentException(INVALID_DEPTH_MSG);
        }
        int n3 = 1;
        for (int i = 1; i < n2; ++i) {
            n3 <<= 1;
        }
        this.depthAccuracy = n3;
        this.transparentList = new GraphicsCullOutputDetails[200];
        this.unsortedTransparentList = new GraphicsCullOutputDetails[200];
        this.depthList1 = new float[200];
        this.depthList2 = new int[200];
        this.countList = new int[this.depthAccuracy];
        this.wkPoint = new Point3f();
        this.modelMatrix = new Matrix4f();
        this.cameraMatrix = new Matrix4f();
        this.center = new float[3];
        this.matrixUtils = new MatrixUtils();
        this.textureTmp = new TextureUnit[32];
    }

    protected int sortNodes(GraphicsCullOutputDetails[] graphicsCullOutputDetailsArray, int n, GraphicsEnvironmentData graphicsEnvironmentData, GraphicsInstructions graphicsInstructions, int n2) {
        int n3;
        Renderable renderable;
        int n4 = this.estimateInstructionSize(graphicsCullOutputDetailsArray, n);
        if (this.transparentList.length < n4) {
            this.transparentList = new GraphicsCullOutputDetails[n4];
            this.unsortedTransparentList = new GraphicsCullOutputDetails[n4];
            this.depthList1 = new float[n4];
            this.depthList2 = new int[n4];
        }
        Matrix4f matrix4f = graphicsEnvironmentData.viewTransform;
        int n5 = n2;
        int n6 = 0;
        for (int i = 0; i < n && !this.terminate; ++i) {
            if (graphicsCullOutputDetailsArray[i].renderable instanceof ShapeRenderable) {
                ShapeRenderable shapeRenderable = (ShapeRenderable)graphicsCullOutputDetailsArray[i].renderable;
                AppearanceRenderable appearanceRenderable = shapeRenderable.getAppearanceRenderable();
                if (appearanceRenderable != null && appearanceRenderable.hasTransparency()) {
                    this.unsortedTransparentList[n6++] = graphicsCullOutputDetailsArray[i];
                    continue;
                }
                renderable = shapeRenderable.getGeometryRenderable();
                if (renderable.hasTransparency()) {
                    this.unsortedTransparentList[n6++] = graphicsCullOutputDetailsArray[i];
                    continue;
                }
            } else if (graphicsCullOutputDetailsArray[i].renderable instanceof CustomRenderable) {
                if (((CustomRenderable)graphicsCullOutputDetailsArray[i].renderable).hasTransparency()) {
                    this.unsortedTransparentList[n6++] = graphicsCullOutputDetailsArray[i];
                    continue;
                }
            } else {
                System.out.println("Unknown renderable node in sorter " + graphicsCullOutputDetailsArray[i].renderable);
                continue;
            }
            n5 = this.appendOutputShape(n5, graphicsCullOutputDetailsArray[i], graphicsInstructions);
        }
        switch (n6) {
            case 0: {
                return n5;
            }
            case 1: {
                graphicsInstructions.renderOps[n5++] = 14;
                n5 = this.appendOutputShape(n5, this.unsortedTransparentList[0], graphicsInstructions);
                this.unsortedTransparentList[0] = null;
                graphicsInstructions.renderOps[n5++] = 15;
                return n5;
            }
        }
        float f = Float.NEGATIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        this.matrixUtils.inverse(matrix4f, this.cameraMatrix);
        for (int i = 0; i < n6 && !this.terminate; ++i) {
            this.modelMatrix.set(this.unsortedTransparentList[i].transform);
            renderable = (Shape3D)this.unsortedTransparentList[i].renderable;
            BoundingVolume boundingVolume = ((Node)((Object)renderable)).getBounds();
            boundingVolume.getCenter(this.center);
            this.wkPoint.x = this.center[0];
            this.wkPoint.y = this.center[1];
            this.wkPoint.z = this.center[2];
            this.modelMatrix.transform(this.wkPoint);
            this.cameraMatrix.transform(this.wkPoint);
            this.depthList1[i] = this.wkPoint.z;
            if (f < this.wkPoint.z) {
                f = this.wkPoint.z;
            }
            if (!(f2 > this.wkPoint.z)) continue;
            f2 = this.wkPoint.z;
        }
        float f3 = f - f2;
        float f4 = (float)(this.depthAccuracy - 1) / f3;
        for (n3 = 0; n3 < n6; ++n3) {
            this.depthList2[n3] = (int)((this.depthList1[n3] - f2) * f4);
        }
        if (this.terminate) {
            return n5;
        }
        for (n3 = 0; n3 < this.depthAccuracy; ++n3) {
            this.countList[n3] = 0;
        }
        if (this.terminate) {
            return n5;
        }
        for (n3 = 0; n3 < n6; ++n3) {
            int n7 = this.depthList2[n3];
            this.countList[n7] = this.countList[n7] + 1;
        }
        if (this.terminate) {
            return n5;
        }
        for (n3 = 1; n3 < this.depthAccuracy; ++n3) {
            int n8 = n3;
            this.countList[n8] = this.countList[n8] + this.countList[n3 - 1];
        }
        if (this.terminate) {
            return n5;
        }
        n3 = n6;
        while (--n3 >= 0 && !this.terminate) {
            int n9 = this.depthList2[n3];
            this.transparentList[this.countList[n9] - 1] = this.unsortedTransparentList[n3];
            int n10 = n9;
            this.countList[n10] = this.countList[n10] - 1;
        }
        graphicsInstructions.renderOps[n5++] = 14;
        for (n3 = 0; n3 < n6 && !this.terminate; ++n3) {
            n5 = this.appendOutputShape(n5, this.transparentList[n3], graphicsInstructions);
            this.transparentList[n3] = null;
        }
        graphicsInstructions.renderOps[n5++] = 15;
        return n5;
    }

    protected int sort2DNodes(GraphicsCullOutputDetails[] graphicsCullOutputDetailsArray, int n, GraphicsEnvironmentData graphicsEnvironmentData, GraphicsInstructions graphicsInstructions, int n2) {
        int n3;
        int n4 = this.estimateInstructionSize(graphicsCullOutputDetailsArray, n);
        if (this.transparentList.length < n4) {
            this.transparentList = new GraphicsCullOutputDetails[n4];
        }
        int n5 = n2;
        int n6 = 0;
        for (n3 = 0; n3 < n && !this.terminate; ++n3) {
            if (graphicsCullOutputDetailsArray[n3].renderable instanceof Pixmap) {
                Pixmap pixmap = (Pixmap)graphicsCullOutputDetailsArray[n3].renderable;
                Raster raster = pixmap.getRaster();
                if (raster.hasTransparency()) {
                    this.transparentList[n6++] = graphicsCullOutputDetailsArray[n3];
                    continue;
                }
            } else if (graphicsCullOutputDetailsArray[n3].renderable instanceof CustomRenderable) {
                if (((CustomRenderable)graphicsCullOutputDetailsArray[n3].renderable).hasTransparency()) {
                    this.transparentList[n6++] = graphicsCullOutputDetailsArray[n3];
                    continue;
                }
            } else {
                System.out.println("Non-shape node in sorter " + graphicsCullOutputDetailsArray[n3].renderable);
                continue;
            }
            n5 = this.appendOutputShape(n5, graphicsCullOutputDetailsArray[n3], graphicsInstructions);
        }
        if (n6 == 0) {
            return n5;
        }
        graphicsInstructions.renderOps[n5++] = 14;
        for (n3 = 0; n3 < n6 && !this.terminate; ++n3) {
            n5 = this.appendOutputShape(n5, this.transparentList[n3], graphicsInstructions);
            this.transparentList[n3] = null;
        }
        graphicsInstructions.renderOps[n5++] = 15;
        return n5;
    }

    protected int estimateInstructionSize(SceneRenderBucket sceneRenderBucket) {
        int n = 4 + sceneRenderBucket.numNodes << 1;
        for (int i = 0; i < sceneRenderBucket.numNodes; ++i) {
            n += (sceneRenderBucket.nodes[i].numLights << 1) + (sceneRenderBucket.nodes[i].numClipPlanes << 1);
        }
        return n;
    }

    protected int estimateInstructionSize(MultipassRenderBucket multipassRenderBucket) {
        int n = 4;
        for (int i = 0; i < multipassRenderBucket.mainScene.numPasses; ++i) {
            n += 10 + multipassRenderBucket.mainScene.numNodes[i] << 1;
            for (int j = 0; j < multipassRenderBucket.mainScene.numNodes[i]; ++j) {
                n += (multipassRenderBucket.mainScene.nodes[i][j].numLights << 1) + (multipassRenderBucket.mainScene.nodes[i][j].numClipPlanes << 1);
            }
        }
        return n;
    }

    private int estimateInstructionSize(GraphicsCullOutputDetails[] graphicsCullOutputDetailsArray, int n) {
        int n2 = 4 + n << 1;
        for (int i = 0; i < n; ++i) {
            n2 += (graphicsCullOutputDetailsArray[i].numLights << 1) + (graphicsCullOutputDetailsArray[i].numClipPlanes << 1);
        }
        return n2;
    }

    private int appendOutputShape(int n, GraphicsCullOutputDetails graphicsCullOutputDetails, GraphicsInstructions graphicsInstructions) {
        Object object;
        Object object2;
        int n2;
        if (graphicsCullOutputDetails.numLights != 0) {
            for (n2 = 0; n2 < graphicsCullOutputDetails.numLights; ++n2) {
                object2 = graphicsCullOutputDetails.lights[n2];
                graphicsInstructions.renderList[n].renderable = ((VisualDetails)object2).getRenderable();
                System.arraycopy(((VisualDetails)object2).getTransform(), 0, graphicsInstructions.renderList[n].transform, 0, 16);
                ++this.lastGlobalId;
                graphicsInstructions.renderList[n].id = graphicsInstructions.renderList[n].id;
                graphicsInstructions.renderOps[n] = 12;
                ++n;
            }
        }
        if (graphicsCullOutputDetails.numClipPlanes != 0) {
            for (n2 = 0; n2 < graphicsCullOutputDetails.numClipPlanes; ++n2) {
                object2 = graphicsCullOutputDetails.clipPlanes[n2];
                graphicsInstructions.renderList[n].renderable = ((VisualDetails)object2).getRenderable();
                System.arraycopy(((VisualDetails)object2).getTransform(), 0, graphicsInstructions.renderList[n].transform, 0, 16);
                ++this.lastGlobalId;
                graphicsInstructions.renderList[n].id = graphicsInstructions.renderList[n].id;
                graphicsInstructions.renderOps[n] = 20;
                ++n;
            }
        }
        n2 = 0;
        if (graphicsCullOutputDetails.localFog != null) {
            graphicsInstructions.renderList[n].id = n2 = this.lastGlobalId++;
            graphicsInstructions.renderList[n].renderable = graphicsCullOutputDetails.localFog;
            graphicsInstructions.renderOps[n] = 22;
            ++n;
        }
        if (graphicsCullOutputDetails.renderable instanceof ShapeRenderable) {
            object2 = (ShapeRenderable)graphicsCullOutputDetails.renderable;
            object = graphicsCullOutputDetails.transform;
            if (!object2.is2D()) {
                graphicsInstructions.renderList[n].transform[0] = ((Matrix4f)object).m00;
                graphicsInstructions.renderList[n].transform[1] = ((Matrix4f)object).m10;
                graphicsInstructions.renderList[n].transform[2] = ((Matrix4f)object).m20;
                graphicsInstructions.renderList[n].transform[3] = ((Matrix4f)object).m30;
                graphicsInstructions.renderList[n].transform[4] = ((Matrix4f)object).m01;
                graphicsInstructions.renderList[n].transform[5] = ((Matrix4f)object).m11;
                graphicsInstructions.renderList[n].transform[6] = ((Matrix4f)object).m21;
                graphicsInstructions.renderList[n].transform[7] = ((Matrix4f)object).m31;
                graphicsInstructions.renderList[n].transform[8] = ((Matrix4f)object).m02;
                graphicsInstructions.renderList[n].transform[9] = ((Matrix4f)object).m12;
                graphicsInstructions.renderList[n].transform[10] = ((Matrix4f)object).m22;
                graphicsInstructions.renderList[n].transform[11] = ((Matrix4f)object).m32;
                graphicsInstructions.renderList[n].transform[12] = ((Matrix4f)object).m03;
                graphicsInstructions.renderList[n].transform[13] = ((Matrix4f)object).m13;
                graphicsInstructions.renderList[n].transform[14] = ((Matrix4f)object).m23;
                graphicsInstructions.renderList[n].transform[15] = ((Matrix4f)object).m33;
                graphicsInstructions.renderList[n].renderable = object2;
                graphicsInstructions.renderOps[n] = 1;
                graphicsInstructions.renderList[++n].renderable = object2;
                graphicsInstructions.renderOps[n] = 2;
                ++n;
            } else {
                AppearanceRenderable appearanceRenderable = object2.getAppearanceRenderable();
                if (appearanceRenderable != null) {
                    graphicsInstructions.renderList[n].renderable = appearanceRenderable;
                    graphicsInstructions.renderOps[n] = 1;
                    ++n;
                }
                graphicsInstructions.renderList[n].transform[0] = ((Matrix4f)object).m00;
                graphicsInstructions.renderList[n].transform[1] = 0.0f;
                graphicsInstructions.renderList[n].transform[2] = 0.0f;
                graphicsInstructions.renderList[n].transform[3] = ((Matrix4f)object).m30;
                graphicsInstructions.renderList[n].transform[4] = 0.0f;
                graphicsInstructions.renderList[n].transform[5] = ((Matrix4f)object).m11;
                graphicsInstructions.renderList[n].transform[6] = 0.0f;
                graphicsInstructions.renderList[n].transform[7] = ((Matrix4f)object).m31;
                graphicsInstructions.renderList[n].transform[8] = 0.0f;
                graphicsInstructions.renderList[n].transform[9] = 0.0f;
                graphicsInstructions.renderList[n].transform[10] = 0.0f;
                graphicsInstructions.renderList[n].transform[11] = 0.0f;
                graphicsInstructions.renderList[n].transform[12] = 0.0f;
                graphicsInstructions.renderList[n].transform[13] = 0.0f;
                graphicsInstructions.renderList[n].transform[14] = 0.0f;
                graphicsInstructions.renderList[n].transform[15] = 0.0f;
                graphicsInstructions.renderList[n].renderable = object2.getGeometryRenderable();
                graphicsInstructions.renderOps[n] = 6;
                ++n;
                if (appearanceRenderable != null) {
                    graphicsInstructions.renderList[n].renderable = appearanceRenderable;
                    graphicsInstructions.renderOps[n] = 2;
                    ++n;
                }
            }
        } else if (graphicsCullOutputDetails.renderable instanceof CustomRenderable) {
            graphicsInstructions.renderList[n].renderable = graphicsCullOutputDetails.renderable;
            graphicsInstructions.renderList[n].instructions = graphicsCullOutputDetails.customData;
            object2 = graphicsCullOutputDetails.transform;
            graphicsInstructions.renderList[n].transform[0] = ((Matrix4f)object2).m00;
            graphicsInstructions.renderList[n].transform[1] = ((Matrix4f)object2).m10;
            graphicsInstructions.renderList[n].transform[2] = ((Matrix4f)object2).m20;
            graphicsInstructions.renderList[n].transform[3] = ((Matrix4f)object2).m30;
            graphicsInstructions.renderList[n].transform[4] = ((Matrix4f)object2).m01;
            graphicsInstructions.renderList[n].transform[5] = ((Matrix4f)object2).m11;
            graphicsInstructions.renderList[n].transform[6] = ((Matrix4f)object2).m21;
            graphicsInstructions.renderList[n].transform[7] = ((Matrix4f)object2).m31;
            graphicsInstructions.renderList[n].transform[8] = ((Matrix4f)object2).m02;
            graphicsInstructions.renderList[n].transform[9] = ((Matrix4f)object2).m12;
            graphicsInstructions.renderList[n].transform[10] = ((Matrix4f)object2).m22;
            graphicsInstructions.renderList[n].transform[11] = ((Matrix4f)object2).m32;
            graphicsInstructions.renderList[n].transform[12] = ((Matrix4f)object2).m03;
            graphicsInstructions.renderList[n].transform[13] = ((Matrix4f)object2).m13;
            graphicsInstructions.renderList[n].transform[14] = ((Matrix4f)object2).m23;
            graphicsInstructions.renderList[n].transform[15] = ((Matrix4f)object2).m33;
            graphicsInstructions.renderOps[n] = 9;
            ++n;
        } else if (graphicsCullOutputDetails.renderable instanceof Pixmap) {
            object2 = (Pixmap)graphicsCullOutputDetails.renderable;
            object = ((Pixmap)object2).getRaster();
            graphicsInstructions.renderList[n].renderable = object;
            graphicsInstructions.renderList[n].transform[0] = graphicsCullOutputDetails.transform.m00;
            graphicsInstructions.renderList[n].transform[1] = 0.0f;
            graphicsInstructions.renderList[n].transform[2] = 0.0f;
            graphicsInstructions.renderList[n].transform[3] = graphicsCullOutputDetails.transform.m30;
            graphicsInstructions.renderList[n].transform[4] = 0.0f;
            graphicsInstructions.renderList[n].transform[5] = graphicsCullOutputDetails.transform.m11;
            graphicsInstructions.renderList[n].transform[6] = 0.0f;
            graphicsInstructions.renderList[n].transform[7] = graphicsCullOutputDetails.transform.m31;
            graphicsInstructions.renderList[n].transform[8] = 0.0f;
            graphicsInstructions.renderList[n].transform[9] = 0.0f;
            graphicsInstructions.renderList[n].transform[10] = 0.0f;
            graphicsInstructions.renderList[n].transform[11] = 0.0f;
            graphicsInstructions.renderList[n].transform[12] = 0.0f;
            graphicsInstructions.renderList[n].transform[13] = 0.0f;
            graphicsInstructions.renderList[n].transform[14] = 0.0f;
            graphicsInstructions.renderList[n].transform[15] = 0.0f;
            graphicsInstructions.renderOps[n] = 6;
            ++n;
        }
        if (graphicsCullOutputDetails.localFog != null) {
            graphicsInstructions.renderList[n].id = n2;
            graphicsInstructions.renderList[n].renderable = graphicsCullOutputDetails.localFog;
            graphicsInstructions.renderOps[n] = 23;
            ++n;
        }
        if (graphicsCullOutputDetails.numClipPlanes != 0) {
            for (int i = graphicsCullOutputDetails.numClipPlanes - 1; i >= 0; --i) {
                object = graphicsCullOutputDetails.clipPlanes[i];
                graphicsInstructions.renderList[n].renderable = ((VisualDetails)object).getRenderable();
                graphicsInstructions.renderList[n].id = this.lastGlobalId - (1 + i);
                graphicsInstructions.renderOps[n] = 21;
                ++n;
            }
        }
        if (graphicsCullOutputDetails.numLights != 0) {
            for (int i = graphicsCullOutputDetails.numLights - 1; i >= 0; --i) {
                object = graphicsCullOutputDetails.lights[i];
                graphicsInstructions.renderList[n].renderable = ((VisualDetails)object).getRenderable();
                graphicsInstructions.renderList[n].id = this.lastGlobalId - (1 + i);
                graphicsInstructions.renderOps[n] = 13;
                ++n;
            }
        }
        return n;
    }
}

