/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline.graphics;

import java.util.Arrays;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.pipeline.graphics.BaseStateSortStage;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsCullOutputDetails;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsEnvironmentData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsInstructions;
import org.j3d.aviatrix3d.pipeline.graphics.MultipassRenderBucket;
import org.j3d.aviatrix3d.pipeline.graphics.SceneRenderBucket;
import org.j3d.aviatrix3d.rendering.AppearanceRenderable;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.aviatrix3d.rendering.CustomRenderable;
import org.j3d.aviatrix3d.rendering.GeometryRenderable;
import org.j3d.aviatrix3d.rendering.ShapeRenderable;
import org.j3d.util.MatrixUtils;

public class StateAndTransparencyDepthSortStage
extends BaseStateSortStage {
    private static final String INVALID_DEPTH_MSG = "The depthBits must be greater than or equal to 1";
    private static final int TRANSPARENT_LIST_SIZE = 200;
    private static final int GUESS_NUM_COMPONENTS = 5;
    private static final int DEFAULT_DEPTH_BITS = 16;
    private final int depthAccuracy;
    private GraphicsCullOutputDetails[] transparentList;
    private GraphicsCullOutputDetails[] unsortedTransparentList;
    private GraphicsCullOutputDetails[] opaqueList;
    private float[] depthList1;
    private int[] depthList2;
    private int[] countList;
    private Matrix4f modelMatrix;
    private Matrix4f cameraMatrix;
    private Point3f wkPoint;
    private float[] center;
    private int reqdSize;
    private MatrixUtils matrixUtils;

    public StateAndTransparencyDepthSortStage() {
        this(1, 16);
    }

    public StateAndTransparencyDepthSortStage(int n) {
        this(n, 16);
    }

    public StateAndTransparencyDepthSortStage(int n, int n2) {
        super(n);
        if (n2 < 1) {
            throw new IllegalArgumentException(INVALID_DEPTH_MSG);
        }
        int n3 = 1;
        for (int i = 1; i < n2; ++i) {
            n3 <<= 1;
        }
        this.depthAccuracy = n3;
        this.transparentList = new GraphicsCullOutputDetails[200];
        this.unsortedTransparentList = new GraphicsCullOutputDetails[200];
        this.opaqueList = new GraphicsCullOutputDetails[200];
        this.depthList1 = new float[200];
        this.depthList2 = new int[200];
        this.countList = new int[this.depthAccuracy];
        this.wkPoint = new Point3f();
        this.modelMatrix = new Matrix4f();
        this.cameraMatrix = new Matrix4f();
        this.center = new float[3];
        this.matrixUtils = new MatrixUtils();
    }

    protected int estimateInstructionSize(SceneRenderBucket sceneRenderBucket) {
        return 4 + sceneRenderBucket.numNodes * 5;
    }

    protected int estimateInstructionSize(MultipassRenderBucket multipassRenderBucket) {
        int n = 2;
        for (int i = 0; i < multipassRenderBucket.mainScene.numPasses; ++i) {
            n += 10 + multipassRenderBucket.mainScene.numNodes[i] * 5;
        }
        return n;
    }

    protected int sortNodes(GraphicsCullOutputDetails[] graphicsCullOutputDetailsArray, int n, GraphicsEnvironmentData graphicsEnvironmentData, GraphicsInstructions graphicsInstructions, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = this.estimateInstructionSize(graphicsCullOutputDetailsArray, n);
        if (n6 > this.reqdSize) {
            this.reqdSize = n6;
            this.realloc(graphicsInstructions, this.reqdSize);
            this.reqdSize = graphicsInstructions.renderList.length;
        }
        if (this.transparentList.length < this.reqdSize) {
            this.transparentList = new GraphicsCullOutputDetails[this.reqdSize];
            this.unsortedTransparentList = new GraphicsCullOutputDetails[this.reqdSize];
            this.depthList1 = new float[this.reqdSize];
            this.depthList2 = new int[this.reqdSize];
            this.opaqueList = new GraphicsCullOutputDetails[this.reqdSize];
        }
        Matrix4f matrix4f = graphicsEnvironmentData.viewTransform;
        int n7 = n2;
        int n8 = 0;
        int n9 = 0;
        for (n5 = 0; n5 < n && !this.terminate; ++n5) {
            if (graphicsCullOutputDetailsArray[n5].renderable instanceof ShapeRenderable) {
                ShapeRenderable shapeRenderable = (ShapeRenderable)graphicsCullOutputDetailsArray[n5].renderable;
                AppearanceRenderable appearanceRenderable = shapeRenderable.getAppearanceRenderable();
                GeometryRenderable geometryRenderable = shapeRenderable.getGeometryRenderable();
                if (appearanceRenderable != null) {
                    if (appearanceRenderable.hasTransparency()) {
                        this.unsortedTransparentList[n8++] = graphicsCullOutputDetailsArray[n5];
                        continue;
                    }
                    this.opaqueList[n9++] = graphicsCullOutputDetailsArray[n5];
                    continue;
                }
                if (geometryRenderable.hasTransparency()) {
                    ++n6;
                    this.unsortedTransparentList[n8++] = graphicsCullOutputDetailsArray[n5];
                    continue;
                }
            } else if (graphicsCullOutputDetailsArray[n5].renderable instanceof CustomRenderable) {
                if (((CustomRenderable)graphicsCullOutputDetailsArray[n5].renderable).hasTransparency()) {
                    ++n6;
                    this.unsortedTransparentList[n8++] = graphicsCullOutputDetailsArray[n5];
                } else {
                    this.opaqueList[n9++] = graphicsCullOutputDetailsArray[n5];
                }
            } else {
                System.out.println("Unknown renderable node in sorter " + graphicsCullOutputDetailsArray[n5].renderable);
                continue;
            }
            this.opaqueList[n9++] = graphicsCullOutputDetailsArray[n5];
        }
        if (this.terminate) {
            return n7;
        }
        Arrays.sort(this.opaqueList, 0, n9, this.stateComparator);
        if (this.terminate) {
            return n7;
        }
        n5 = 0;
        boolean bl = false;
        while (!bl) {
            try {
                for (int i = n5; i < n9 && !this.terminate; ++i) {
                    n7 = this.appendObject(this.opaqueList[i], graphicsInstructions, n7);
                }
                bl = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n5 = n7;
                this.realloc(graphicsInstructions, this.reqdSize);
            }
        }
        bl = false;
        while (!bl) {
            try {
                n7 = this.cleanupVisuals(graphicsInstructions, n7);
                bl = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.realloc(graphicsInstructions, this.reqdSize);
            }
        }
        n6 = n7 + 1 + n8 << 1;
        if (n6 > this.reqdSize) {
            this.reqdSize = n6;
        }
        if (n8 > 0 && graphicsInstructions.renderList.length < this.reqdSize) {
            this.realloc(graphicsInstructions, this.reqdSize);
        }
        if (this.terminate) {
            return n7;
        }
        switch (n8) {
            case 0: {
                bl = false;
                while (!bl) {
                    try {
                        n7 = this.cleanupObjects(graphicsInstructions, n7);
                        bl = true;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.realloc(graphicsInstructions, this.reqdSize);
                    }
                }
                return n7;
            }
            case 1: {
                graphicsInstructions.renderOps[n7++] = 14;
                n7 = this.appendObject(this.unsortedTransparentList[0], graphicsInstructions, n7);
                this.unsortedTransparentList[0] = null;
                bl = false;
                while (!bl) {
                    try {
                        n7 = this.cleanupObjects(graphicsInstructions, n7);
                        bl = true;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.realloc(graphicsInstructions, this.reqdSize);
                    }
                }
                graphicsInstructions.renderOps[n7++] = 15;
                return n7;
            }
        }
        float f = Float.NEGATIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        this.matrixUtils.inverse(matrix4f, this.cameraMatrix);
        for (int i = 0; i < n8 && !this.terminate; ++i) {
            this.modelMatrix.set(this.unsortedTransparentList[i].transform);
            Shape3D shape3D = (Shape3D)this.unsortedTransparentList[i].renderable;
            BoundingVolume boundingVolume = shape3D.getBounds();
            boundingVolume.getCenter(this.center);
            this.wkPoint.x = this.center[0];
            this.wkPoint.y = this.center[1];
            this.wkPoint.z = this.center[2];
            this.modelMatrix.transform(this.wkPoint);
            this.cameraMatrix.transform(this.wkPoint);
            this.depthList1[i] = this.wkPoint.z;
            if (f < this.wkPoint.z) {
                f = this.wkPoint.z;
            }
            if (!(f2 > this.wkPoint.z)) continue;
            f2 = this.wkPoint.z;
        }
        float f3 = f - f2;
        float f4 = (float)(this.depthAccuracy - 1) / f3;
        for (n4 = 0; n4 < n8; ++n4) {
            this.depthList2[n4] = (int)Math.floor((this.depthList1[n4] - f2) * f4);
        }
        for (n4 = 0; n4 < this.depthAccuracy; ++n4) {
            this.countList[n4] = 0;
        }
        try {
            for (n4 = 0; n4 < n8; ++n4) {
                int n10 = this.depthList2[n4];
                this.countList[n10] = this.countList[n10] + 1;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            System.out.println("Please report these values to the maintainers");
            System.out.println("depthValue: " + this.depthList2[n4]);
            System.out.println("depth range: " + f3 + " quanta: " + f4 + " accuracy: " + this.depthAccuracy + " min_depth: " + f2);
        }
        if (this.terminate) {
            return n7;
        }
        for (n3 = 1; n3 < this.depthAccuracy; ++n3) {
            int n11 = n3;
            this.countList[n11] = this.countList[n11] + this.countList[n3 - 1];
        }
        if (this.terminate) {
            return n7;
        }
        n3 = n8;
        while (--n3 >= 0) {
            int n12 = this.depthList2[n3];
            this.transparentList[this.countList[n12] - 1] = this.unsortedTransparentList[n3];
            int n13 = n12;
            this.countList[n13] = this.countList[n13] - 1;
        }
        graphicsInstructions.renderOps[n7++] = 14;
        bl = false;
        n5 = 0;
        while (!bl) {
            try {
                for (int i = n5; i < n8 && !this.terminate; ++i) {
                    n7 = this.appendObject(this.transparentList[i], graphicsInstructions, n7);
                    this.transparentList[i] = null;
                }
                bl = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n5 = n7;
                this.realloc(graphicsInstructions, this.reqdSize);
            }
        }
        bl = false;
        while (!bl) {
            try {
                n7 = this.cleanupObjects(graphicsInstructions, n7);
                bl = true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.realloc(graphicsInstructions, this.reqdSize);
            }
        }
        graphicsInstructions.renderOps[n7++] = 15;
        return n7;
    }

    protected int sort2DNodes(GraphicsCullOutputDetails[] graphicsCullOutputDetailsArray, int n, GraphicsEnvironmentData graphicsEnvironmentData, GraphicsInstructions graphicsInstructions, int n2) {
        int n3;
        int n4 = this.estimateInstructionSize(graphicsCullOutputDetailsArray, n);
        if (this.transparentList.length < n4) {
            this.transparentList = new GraphicsCullOutputDetails[n4];
        }
        int n5 = n2;
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; n3 < n && !this.terminate; ++n3) {
            if (graphicsCullOutputDetailsArray[n3].renderable instanceof ShapeRenderable) {
                ShapeRenderable shapeRenderable = (ShapeRenderable)graphicsCullOutputDetailsArray[n3].renderable;
                AppearanceRenderable appearanceRenderable = shapeRenderable.getAppearanceRenderable();
                if (appearanceRenderable != null) {
                    if (appearanceRenderable.hasTransparency()) {
                        this.unsortedTransparentList[n6++] = graphicsCullOutputDetailsArray[n3];
                        continue;
                    }
                    this.opaqueList[n7++] = graphicsCullOutputDetailsArray[n3];
                    continue;
                }
                GeometryRenderable geometryRenderable = shapeRenderable.getGeometryRenderable();
                if (geometryRenderable.hasTransparency()) {
                    this.unsortedTransparentList[n6++] = graphicsCullOutputDetailsArray[n3];
                    continue;
                }
            } else if (graphicsCullOutputDetailsArray[n3].renderable instanceof CustomRenderable) {
                if (((CustomRenderable)graphicsCullOutputDetailsArray[n3].renderable).hasTransparency()) {
                    this.transparentList[n6++] = graphicsCullOutputDetailsArray[n3];
                    continue;
                }
            } else {
                System.out.println("Non-shape node in sorter " + graphicsCullOutputDetailsArray[n3].renderable);
                continue;
            }
            n5 = this.appendObject(graphicsCullOutputDetailsArray[n3], graphicsInstructions, n5);
        }
        if (n6 == 0) {
            return n5;
        }
        graphicsInstructions.renderOps[n5++] = 14;
        for (n3 = 0; n3 < n6 && !this.terminate; ++n3) {
            n5 = this.appendObject(this.transparentList[n3], graphicsInstructions, n5);
            this.transparentList[n3] = null;
        }
        graphicsInstructions.renderOps[n5++] = 15;
        return n5;
    }

    private int estimateInstructionSize(GraphicsCullOutputDetails[] graphicsCullOutputDetailsArray, int n) {
        int n2 = 4 + n << 1;
        for (int i = 0; i < n; ++i) {
            n2 += (graphicsCullOutputDetailsArray[i].numLights << 1) + (graphicsCullOutputDetailsArray[i].numClipPlanes << 1);
        }
        return n2;
    }
}

