/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline.graphics;

import org.j3d.aviatrix3d.pipeline.RenderEnvironmentData;
import org.j3d.aviatrix3d.rendering.ObjectRenderable;
import org.j3d.aviatrix3d.rendering.RenderEffectsProcessor;

public class GraphicsEnvironmentData
extends RenderEnvironmentData {
    public static final int VIEW_X = 0;
    public static final int VIEW_Y = 1;
    public static final int VIEW_WIDTH = 2;
    public static final int VIEW_HEIGHT = 3;
    public RenderEffectsProcessor effectsProcessor;
    public ObjectRenderable fog;
    public ObjectRenderable background;
    public float[] eyeOffset;
    public double[] viewFrustum;
    public double[] backgroundFrustum;
    public int viewProjectionType;
    public boolean useStereo;
    public int[] viewport = new int[4];
    public float[] backgroundTransform;
    public float[] cameraTransform;

    public GraphicsEnvironmentData() {
        this.eyeOffset = new float[3];
        this.viewFrustum = new double[6];
        this.backgroundFrustum = new double[6];
        this.backgroundTransform = new float[16];
        this.cameraTransform = new float[16];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("GraphicsEnvironmentData:\n");
        stringBuffer.append("Layer : ");
        stringBuffer.append(this.layerId);
        stringBuffer.append(" sub layer: ");
        stringBuffer.append(this.subLayerId);
        stringBuffer.append("\nViewport: ");
        stringBuffer.append(this.viewport[0]);
        stringBuffer.append(' ');
        stringBuffer.append(this.viewport[1]);
        stringBuffer.append(' ');
        stringBuffer.append(this.viewport[2]);
        stringBuffer.append(' ');
        stringBuffer.append(this.viewport[3]);
        stringBuffer.append("\nFog? ");
        stringBuffer.append(this.fog != null);
        stringBuffer.append(" Background? ");
        stringBuffer.append(this.background != null);
        stringBuffer.append(" Stereo: ");
        stringBuffer.append(this.useStereo);
        stringBuffer.append("\nEye Offset: ");
        stringBuffer.append(this.eyeOffset[0]);
        stringBuffer.append(' ');
        stringBuffer.append(this.eyeOffset[1]);
        stringBuffer.append(' ');
        stringBuffer.append(this.eyeOffset[2]);
        return stringBuffer.toString();
    }

    public void setViewport(int[] nArray) {
        this.viewport[0] = nArray[0];
        this.viewport[1] = nArray[1];
        this.viewport[2] = nArray[2];
        this.viewport[3] = nArray[3];
    }
}

