/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline.graphics;

import javax.vecmath.Matrix4f;
import javax.vecmath.Vector4f;
import org.j3d.aviatrix3d.Pixmap;
import org.j3d.aviatrix3d.pipeline.graphics.BaseCullStage;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsEnvironmentData;
import org.j3d.aviatrix3d.pipeline.graphics.MultipassDetails;
import org.j3d.aviatrix3d.pipeline.graphics.SceneRenderBucket;
import org.j3d.aviatrix3d.pipeline.graphics.ViewportLayerCollection;
import org.j3d.aviatrix3d.pipeline.graphics.VisualDetails;
import org.j3d.aviatrix3d.rendering.CullInstructions;
import org.j3d.aviatrix3d.rendering.Cullable;
import org.j3d.aviatrix3d.rendering.CustomCullable;
import org.j3d.aviatrix3d.rendering.CustomGeometryRenderable;
import org.j3d.aviatrix3d.rendering.CustomRenderable;
import org.j3d.aviatrix3d.rendering.EffectRenderable;
import org.j3d.aviatrix3d.rendering.GeometryRenderable;
import org.j3d.aviatrix3d.rendering.GroupCullable;
import org.j3d.aviatrix3d.rendering.LeafCullable;
import org.j3d.aviatrix3d.rendering.RenderPassCullable;
import org.j3d.aviatrix3d.rendering.Renderable;
import org.j3d.aviatrix3d.rendering.RenderableInstructions;
import org.j3d.aviatrix3d.rendering.SceneCullable;
import org.j3d.aviatrix3d.rendering.ShapeRenderable;
import org.j3d.aviatrix3d.rendering.SingleCullable;
import org.j3d.aviatrix3d.rendering.TransformCullable;
import org.j3d.aviatrix3d.rendering.ViewEnvironmentCullable;

public class GenericCullStage
extends BaseCullStage {
    private Matrix4f viewMatrix = new Matrix4f();
    private CullInstructions cullInstructions;
    private RenderableInstructions renderInstructions;
    private float angularResolution;
    private double[] viewFrustum;
    private Vector4f[] frustumPlanes;
    private Matrix4f prjMatrix = new Matrix4f();
    private float[] projectionMatrix = new float[16];

    public GenericCullStage() {
        this(1);
    }

    public GenericCullStage(int n) {
        super(n);
        this.cullInstructions = new CullInstructions();
        this.renderInstructions = new RenderableInstructions();
        this.frustumPlanes = new Vector4f[6];
        for (int i = 0; i < 6; ++i) {
            this.frustumPlanes[i] = new Vector4f();
        }
    }

    protected void cullScene(RenderPassCullable renderPassCullable, int n, int n2, int n3, int n4) {
        this.lastLight = 0;
        this.lastClip = 0;
        this.lastTxStack = 0;
        this.lastFogStack = 0;
        this.activeParent = null;
        SceneRenderBucket sceneRenderBucket = this.workLayers[n][n2].viewports[n3].scenes[n4];
        this.workCullList = sceneRenderBucket.nodes;
        this.validSceneParents[0][0] = null;
        this.validSceneParents[0][1] = null;
        Cullable cullable = renderPassCullable.getRootCullable();
        sceneRenderBucket.data.layerId = n2;
        sceneRenderBucket.data.subLayerId = n4;
        if (this.terminate) {
            return;
        }
        if (cullable instanceof CustomCullable) {
            this.transformStack[0].setIdentity();
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), sceneRenderBucket.data);
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            sceneRenderBucket.numNodes = this.findAllNodes((CustomCullable)cullable, 0);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof GroupCullable) {
            if (cullable instanceof TransformCullable) {
                ((TransformCullable)cullable).getTransform(this.transformStack[0]);
            } else {
                this.transformStack[0].setIdentity();
            }
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), sceneRenderBucket.data);
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            sceneRenderBucket.numNodes = this.findAllNodes((GroupCullable)cullable, 0);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof SingleCullable) {
            this.transformStack[0].setIdentity();
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), sceneRenderBucket.data);
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            sceneRenderBucket.numNodes = this.findNextNode((SingleCullable)cullable, 0);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof CustomRenderable) {
            this.transformStack[0].setIdentity();
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), sceneRenderBucket.data);
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            sceneRenderBucket.numNodes = this.findAllNodes((CustomRenderable)((Object)cullable), 0);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof LeafCullable) {
            LeafCullable leafCullable = (LeafCullable)cullable;
            if (leafCullable.getCullableType() != 4) {
                return;
            }
            Renderable renderable = leafCullable.getRenderable();
            if (renderable instanceof ShapeRenderable && ((ShapeRenderable)renderable).is2D()) {
                if (this.checkOffscreens) {
                    this.checkForOffscreens((ShapeRenderable)renderable);
                }
                this.workCullList[0].renderable = renderable;
                this.workCullList[0].transform.setIdentity();
                this.workCullList[0].numLights = 0;
                this.workCullList[0].numClipPlanes = 0;
                sceneRenderBucket.numNodes = 1;
                sceneRenderBucket.nodes = this.workCullList;
                ++this.lastOutputList;
            }
        }
    }

    protected void cullScene2D(RenderPassCullable renderPassCullable, int n, int n2, int n3, int n4) {
        this.lastLight = 0;
        this.lastClip = 0;
        this.lastTxStack = 0;
        this.lastFogStack = 0;
        this.activeParent = null;
        SceneRenderBucket sceneRenderBucket = this.workLayers[n][n2].viewports[n3].scenes[n4];
        this.workCullList = sceneRenderBucket.nodes;
        this.validSceneParents[0][0] = null;
        this.validSceneParents[0][1] = null;
        Cullable cullable = renderPassCullable.getRootCullable();
        sceneRenderBucket.data.layerId = n2;
        sceneRenderBucket.data.subLayerId = n4;
        if (this.terminate) {
            return;
        }
        if (cullable instanceof CustomCullable) {
            this.transformStack[0].setIdentity();
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), sceneRenderBucket.data);
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            sceneRenderBucket.numNodes = this.findAllNodes((CustomCullable)cullable, 0);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof GroupCullable) {
            if (cullable instanceof TransformCullable) {
                ((TransformCullable)cullable).getTransform(this.transformStack[0]);
            } else {
                this.transformStack[0].setIdentity();
            }
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), sceneRenderBucket.data);
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            sceneRenderBucket.numNodes = this.findAllNodes((GroupCullable)cullable, 0);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof SingleCullable) {
            this.transformStack[0].setIdentity();
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), sceneRenderBucket.data);
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            sceneRenderBucket.numNodes = this.findNextNode((SingleCullable)cullable, 0);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof CustomRenderable) {
            this.transformStack[0].setIdentity();
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), sceneRenderBucket.data);
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            sceneRenderBucket.numNodes = this.findAllNodes((CustomRenderable)((Object)cullable), 0);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof LeafCullable) {
            LeafCullable leafCullable = (LeafCullable)cullable;
            if (leafCullable.getCullableType() != 4) {
                return;
            }
            Renderable renderable = leafCullable.getRenderable();
            if (renderable instanceof ShapeRenderable && ((ShapeRenderable)renderable).is2D()) {
                if (this.checkOffscreens) {
                    this.checkForOffscreens((ShapeRenderable)renderable);
                }
                this.workCullList[0].renderable = renderable;
                this.workCullList[0].transform.setIdentity();
                this.workCullList[0].numLights = 0;
                this.workCullList[0].numClipPlanes = 0;
                sceneRenderBucket.numNodes = 1;
                sceneRenderBucket.nodes = this.workCullList;
                ++this.lastOutputList;
            }
        }
    }

    protected void cullRenderPass(RenderPassCullable renderPassCullable, int n, int n2, int n3, int n4, int n5) {
        this.lastLight = 0;
        this.lastClip = 0;
        this.lastTxStack = 0;
        this.lastFogStack = 0;
        this.activeParent = null;
        ViewportLayerCollection viewportLayerCollection = this.workLayers[n2][n3].viewports[n4];
        MultipassDetails multipassDetails = viewportLayerCollection.multipass[viewportLayerCollection.numMultipass].mainScene;
        this.workCullList = multipassDetails.nodes[n];
        this.validSceneParents[0][0] = null;
        this.validSceneParents[0][1] = null;
        Cullable cullable = renderPassCullable.getRootCullable();
        this.fillRenderPassEnvData(renderPassCullable, multipassDetails.data[n], multipassDetails.buffers[n]);
        multipassDetails.data[n].layerId = n3;
        multipassDetails.data[n].subLayerId = n5;
        if (this.terminate) {
            return;
        }
        if (cullable instanceof CustomCullable) {
            this.transformStack[0].setIdentity();
            this.viewFrustum = multipassDetails.data[n].viewFrustum;
            this.viewMatrix.set(multipassDetails.data[n].viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), multipassDetails.data[n]);
            this.viewMatrix.set(multipassDetails.data[n].viewTransform);
            multipassDetails.numNodes[n] = this.findAllNodes((CustomCullable)cullable, 0);
            multipassDetails.nodes[n] = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof GroupCullable) {
            this.transformStack[0].setIdentity();
            if (cullable instanceof TransformCullable) {
                ((TransformCullable)cullable).getTransform(this.transformStack[0]);
            } else {
                this.transformStack[0].setIdentity();
            }
            this.viewFrustum = multipassDetails.data[n].viewFrustum;
            this.viewMatrix.set(multipassDetails.data[n].viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), multipassDetails.data[n]);
            multipassDetails.numNodes[n] = this.findAllNodes((GroupCullable)cullable, 0);
            multipassDetails.nodes[n] = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof SingleCullable) {
            this.transformStack[0].setIdentity();
            this.viewFrustum = multipassDetails.data[n].viewFrustum;
            this.viewMatrix.set(multipassDetails.data[n].viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), multipassDetails.data[n]);
            multipassDetails.numNodes[n] = this.findNextNode((SingleCullable)cullable, 0);
            multipassDetails.nodes[n] = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof CustomRenderable) {
            this.transformStack[0].setIdentity();
            this.viewFrustum = multipassDetails.data[n].viewFrustum;
            this.viewMatrix.set(multipassDetails.data[n].viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), multipassDetails.data[n]);
            this.viewMatrix.set(multipassDetails.data[n].viewTransform);
            multipassDetails.numNodes[n] = this.findAllNodes((CustomRenderable)((Object)cullable), 0);
            multipassDetails.nodes[n] = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof LeafCullable) {
            LeafCullable leafCullable = (LeafCullable)cullable;
            if (leafCullable.getCullableType() != 4) {
                return;
            }
            Renderable renderable = leafCullable.getRenderable();
            if (renderable instanceof ShapeRenderable && ((ShapeRenderable)renderable).is2D()) {
                if (this.checkOffscreens) {
                    this.checkForOffscreens((ShapeRenderable)renderable);
                }
                this.workCullList[0].renderable = renderable;
                this.workCullList[0].transform.setIdentity();
                this.workCullList[0].numLights = 0;
                this.workCullList[0].numClipPlanes = 0;
                multipassDetails.numNodes[n] = 1;
                multipassDetails.nodes[n] = this.workCullList;
                ++this.lastOutputList;
            }
        }
    }

    protected void fillSingleEnvData(SceneCullable sceneCullable, GraphicsEnvironmentData graphicsEnvironmentData) {
        Object[] objectArray;
        super.fillSingleEnvData(sceneCullable, graphicsEnvironmentData);
        ViewEnvironmentCullable viewEnvironmentCullable = sceneCullable.getViewCullable();
        if (viewEnvironmentCullable.getProjectionType() == 1) {
            this.angularResolution = (float)viewEnvironmentCullable.getFieldOfView();
        } else {
            objectArray = new double[6];
            viewEnvironmentCullable.getViewFrustum((double[])objectArray);
            double d = Math.atan2(objectArray[1], objectArray[5]) - Math.atan2(objectArray[0], objectArray[5]);
            this.angularResolution = (float)Math.toDegrees(d);
        }
        objectArray = viewEnvironmentCullable.getViewportDimensions();
        this.angularResolution /= (float)objectArray[2];
    }

    protected void cleanupOldRefs() {
        this.renderInstructions.instructions = null;
        for (int i = 0; i < this.cullInstructions.children.length; ++i) {
            this.cullInstructions.children[i] = null;
        }
        super.cleanupOldRefs();
    }

    private int findAllNodes(GroupCullable groupCullable, int n) {
        Object object;
        Renderable renderable;
        Object object2;
        int n2;
        if (this.terminate) {
            return 0;
        }
        Cullable[] cullableArray = groupCullable.getCullableChildren();
        int n3 = groupCullable.numCullableChildren();
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        boolean bl = false;
        block5: for (n2 = 0; n2 < n3; ++n2) {
            LeafCullable leafCullable;
            if (!(cullableArray[n2] instanceof LeafCullable) || !((object2 = (leafCullable = (LeafCullable)cullableArray[n2]).getRenderable()) instanceof EffectRenderable) || !(renderable = (EffectRenderable)object2).isEnabled()) continue;
            switch (leafCullable.getCullableType()) {
                case 2: {
                    this.resizeLightList();
                    this.lightList[this.lastLight] = renderable;
                    object = this.transformStack[this.lastTxStack];
                    this.lightTxList[this.lastLight][0] = ((Matrix4f)object).m00;
                    this.lightTxList[this.lastLight][1] = ((Matrix4f)object).m10;
                    this.lightTxList[this.lastLight][2] = ((Matrix4f)object).m20;
                    this.lightTxList[this.lastLight][3] = ((Matrix4f)object).m30;
                    this.lightTxList[this.lastLight][4] = ((Matrix4f)object).m01;
                    this.lightTxList[this.lastLight][5] = ((Matrix4f)object).m11;
                    this.lightTxList[this.lastLight][6] = ((Matrix4f)object).m21;
                    this.lightTxList[this.lastLight][7] = ((Matrix4f)object).m31;
                    this.lightTxList[this.lastLight][8] = ((Matrix4f)object).m02;
                    this.lightTxList[this.lastLight][9] = ((Matrix4f)object).m12;
                    this.lightTxList[this.lastLight][10] = ((Matrix4f)object).m22;
                    this.lightTxList[this.lastLight][11] = ((Matrix4f)object).m32;
                    this.lightTxList[this.lastLight][12] = ((Matrix4f)object).m03;
                    this.lightTxList[this.lastLight][13] = ((Matrix4f)object).m13;
                    this.lightTxList[this.lastLight][14] = ((Matrix4f)object).m23;
                    this.lightTxList[this.lastLight][15] = ((Matrix4f)object).m33;
                    ++this.lastLight;
                    ++n4;
                    continue block5;
                }
                case 3: {
                    this.resizeClipList();
                    this.clipList[this.lastClip] = renderable;
                    object = this.transformStack[this.lastTxStack];
                    this.clipTxList[this.lastClip][0] = ((Matrix4f)object).m00;
                    this.clipTxList[this.lastClip][1] = ((Matrix4f)object).m10;
                    this.clipTxList[this.lastClip][2] = ((Matrix4f)object).m20;
                    this.clipTxList[this.lastClip][3] = ((Matrix4f)object).m30;
                    this.clipTxList[this.lastClip][4] = ((Matrix4f)object).m01;
                    this.clipTxList[this.lastClip][5] = ((Matrix4f)object).m11;
                    this.clipTxList[this.lastClip][6] = ((Matrix4f)object).m21;
                    this.clipTxList[this.lastClip][7] = ((Matrix4f)object).m31;
                    this.clipTxList[this.lastClip][8] = ((Matrix4f)object).m02;
                    this.clipTxList[this.lastClip][9] = ((Matrix4f)object).m12;
                    this.clipTxList[this.lastClip][10] = ((Matrix4f)object).m22;
                    this.clipTxList[this.lastClip][11] = ((Matrix4f)object).m32;
                    this.clipTxList[this.lastClip][12] = ((Matrix4f)object).m03;
                    this.clipTxList[this.lastClip][13] = ((Matrix4f)object).m13;
                    this.clipTxList[this.lastClip][14] = ((Matrix4f)object).m23;
                    this.clipTxList[this.lastClip][15] = ((Matrix4f)object).m33;
                    ++this.lastClip;
                    ++n5;
                    continue block5;
                }
                case 1: {
                    if (renderable.isGlobalOnly() || bl) continue block5;
                    this.resizeFogStack();
                    bl = true;
                    ++this.lastFogStack;
                    this.fogStack[this.lastFogStack] = renderable;
                }
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            boolean bl2 = cullableArray[n2] instanceof TransformCullable;
            if (bl2) {
                this.resizeStack();
                object2 = (TransformCullable)cullableArray[n2];
                object2.getTransform(this.transformStack[this.lastTxStack + 1]);
                this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.transformStack[this.lastTxStack + 1]);
                ++this.lastTxStack;
            }
            if (cullableArray[n2] instanceof GroupCullable) {
                n6 = this.findAllNodes((GroupCullable)cullableArray[n2], n6);
            } else if (cullableArray[n2] instanceof LeafCullable) {
                object2 = (LeafCullable)cullableArray[n2];
                if (object2.getCullableType() == 4) {
                    renderable = object2.getRenderable();
                    if (renderable instanceof ShapeRenderable) {
                        CustomGeometryRenderable customGeometryRenderable;
                        object = (ShapeRenderable)renderable;
                        if (!object.isVisible()) continue;
                        GeometryRenderable geometryRenderable = object.getGeometryRenderable();
                        if (geometryRenderable instanceof CustomGeometryRenderable) {
                            customGeometryRenderable = (CustomGeometryRenderable)geometryRenderable;
                            this.workCullList[n6].customData = customGeometryRenderable.processCull(this.transformStack[this.lastTxStack], this.viewMatrix, this.frustumPlanes, this.angularResolution);
                        }
                        if (object.is2D()) {
                            this.resizeCullList(n6);
                            this.workCullList[n6].renderable = renderable;
                            this.workCullList[n6].localFog = null;
                            this.workCullList[n6].numLights = 0;
                            this.workCullList[n6].numClipPlanes = 0;
                            customGeometryRenderable = this.transformStack[this.lastTxStack];
                            this.workCullList[n6].transform.set((Matrix4f)customGeometryRenderable);
                            ++n6;
                        } else {
                            int n7;
                            int n8;
                            VisualDetails[] visualDetailsArray;
                            int n9;
                            if (this.checkOffscreens) {
                                this.checkForOffscreens((ShapeRenderable)object);
                            }
                            this.resizeCullList(n6);
                            this.workCullList[n6].renderable = renderable;
                            this.workCullList[n6].localFog = this.fogStack[this.lastFogStack];
                            customGeometryRenderable = this.transformStack[this.lastTxStack];
                            this.workCullList[n6].transform.set((Matrix4f)customGeometryRenderable);
                            int n10 = n9 = this.workCullList[n6].lights == null ? 0 : this.workCullList[n6].lights.length;
                            if (n9 < this.lastLight) {
                                visualDetailsArray = new VisualDetails[this.lastLight];
                                if (n9 != 0) {
                                    System.arraycopy(this.workCullList[n6].lights, 0, visualDetailsArray, 0, n9);
                                }
                                for (n8 = n9; n8 < this.lastLight; ++n8) {
                                    visualDetailsArray[n8] = new VisualDetails();
                                }
                                this.workCullList[n6].lights = visualDetailsArray;
                            }
                            visualDetailsArray = this.workCullList[n6].lights;
                            this.workCullList[n6].numLights = this.lastLight;
                            for (n8 = 0; n8 < this.lastLight; ++n8) {
                                visualDetailsArray[n8].update(this.lightList[n8], this.lightTxList[n8]);
                            }
                            int n11 = n9 = this.workCullList[n6].clipPlanes == null ? 0 : this.workCullList[n6].clipPlanes.length;
                            if (n9 < this.lastClip) {
                                VisualDetails[] visualDetailsArray2 = new VisualDetails[this.lastClip];
                                if (n9 != 0) {
                                    System.arraycopy(this.workCullList[n6].clipPlanes, 0, visualDetailsArray2, 0, n9);
                                }
                                for (n7 = n9; n7 < this.lastClip; ++n7) {
                                    visualDetailsArray2[n7] = new VisualDetails();
                                }
                                this.workCullList[n6].clipPlanes = visualDetailsArray2;
                            }
                            VisualDetails[] visualDetailsArray3 = this.workCullList[n6].clipPlanes;
                            this.workCullList[n6].numClipPlanes = this.lastClip;
                            for (n7 = 0; n7 < this.lastClip; ++n7) {
                                visualDetailsArray3[n7].update(this.clipList[n7], this.clipTxList[n7]);
                            }
                            ++n6;
                        }
                    } else if (cullableArray[n2] instanceof CustomRenderable) {
                        n6 = this.findAllNodes((CustomRenderable)((Object)cullableArray[n2]), n6);
                    }
                }
            } else if (cullableArray[n2] instanceof SingleCullable) {
                n6 = this.findNextNode((SingleCullable)cullableArray[n2], n6);
            } else if (cullableArray[n2] instanceof CustomCullable) {
                n6 = this.findAllNodes((CustomCullable)cullableArray[n2], n6);
            }
            if (!bl2) continue;
            --this.lastTxStack;
        }
        this.lastLight -= n4;
        this.lastClip -= n5;
        if (bl) {
            this.fogStack[this.lastFogStack] = null;
            --this.lastFogStack;
        }
        return n6;
    }

    private int findAllNodes(CustomCullable customCullable, int n) {
        Object object;
        Renderable renderable;
        Object object2;
        int n2;
        if (this.terminate) {
            return 0;
        }
        customCullable.cullChildren(this.cullInstructions, this.transformStack[this.lastTxStack], this.viewMatrix, this.frustumPlanes, this.angularResolution);
        if (this.cullInstructions.numChildren == 0) {
            return n;
        }
        boolean bl = this.cullInstructions.hasTransform;
        if (bl) {
            this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.cullInstructions.localTransform);
            ++this.lastTxStack;
        }
        Cullable[] cullableArray = (Cullable[])this.cullInstructions.children.clone();
        int n3 = this.cullInstructions.numChildren;
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        boolean bl2 = false;
        block5: for (n2 = 0; n2 < n3; ++n2) {
            LeafCullable leafCullable;
            if (!(cullableArray[n2] instanceof LeafCullable) || !((object2 = (leafCullable = (LeafCullable)cullableArray[n2]).getRenderable()) instanceof EffectRenderable) || !(renderable = (EffectRenderable)object2).isEnabled()) continue;
            switch (leafCullable.getCullableType()) {
                case 2: {
                    this.resizeLightList();
                    this.lightList[this.lastLight] = renderable;
                    object = this.transformStack[this.lastTxStack];
                    this.lightTxList[this.lastLight][0] = ((Matrix4f)object).m00;
                    this.lightTxList[this.lastLight][1] = ((Matrix4f)object).m10;
                    this.lightTxList[this.lastLight][2] = ((Matrix4f)object).m20;
                    this.lightTxList[this.lastLight][3] = ((Matrix4f)object).m30;
                    this.lightTxList[this.lastLight][4] = ((Matrix4f)object).m01;
                    this.lightTxList[this.lastLight][5] = ((Matrix4f)object).m11;
                    this.lightTxList[this.lastLight][6] = ((Matrix4f)object).m21;
                    this.lightTxList[this.lastLight][7] = ((Matrix4f)object).m31;
                    this.lightTxList[this.lastLight][8] = ((Matrix4f)object).m02;
                    this.lightTxList[this.lastLight][9] = ((Matrix4f)object).m12;
                    this.lightTxList[this.lastLight][10] = ((Matrix4f)object).m22;
                    this.lightTxList[this.lastLight][11] = ((Matrix4f)object).m32;
                    this.lightTxList[this.lastLight][12] = ((Matrix4f)object).m03;
                    this.lightTxList[this.lastLight][13] = ((Matrix4f)object).m13;
                    this.lightTxList[this.lastLight][14] = ((Matrix4f)object).m23;
                    this.lightTxList[this.lastLight][15] = ((Matrix4f)object).m33;
                    ++this.lastLight;
                    ++n4;
                    continue block5;
                }
                case 3: {
                    this.resizeClipList();
                    this.clipList[this.lastClip] = renderable;
                    object = this.transformStack[this.lastTxStack];
                    this.clipTxList[this.lastClip][0] = ((Matrix4f)object).m00;
                    this.clipTxList[this.lastClip][1] = ((Matrix4f)object).m10;
                    this.clipTxList[this.lastClip][2] = ((Matrix4f)object).m20;
                    this.clipTxList[this.lastClip][3] = ((Matrix4f)object).m30;
                    this.clipTxList[this.lastClip][4] = ((Matrix4f)object).m01;
                    this.clipTxList[this.lastClip][5] = ((Matrix4f)object).m11;
                    this.clipTxList[this.lastClip][6] = ((Matrix4f)object).m21;
                    this.clipTxList[this.lastClip][7] = ((Matrix4f)object).m31;
                    this.clipTxList[this.lastClip][8] = ((Matrix4f)object).m02;
                    this.clipTxList[this.lastClip][9] = ((Matrix4f)object).m12;
                    this.clipTxList[this.lastClip][10] = ((Matrix4f)object).m22;
                    this.clipTxList[this.lastClip][11] = ((Matrix4f)object).m32;
                    this.clipTxList[this.lastClip][12] = ((Matrix4f)object).m03;
                    this.clipTxList[this.lastClip][13] = ((Matrix4f)object).m13;
                    this.clipTxList[this.lastClip][14] = ((Matrix4f)object).m23;
                    this.clipTxList[this.lastClip][15] = ((Matrix4f)object).m33;
                    ++this.lastClip;
                    ++n5;
                    continue block5;
                }
                case 1: {
                    if (renderable.isGlobalOnly() || bl2) continue block5;
                    this.resizeFogStack();
                    bl2 = true;
                    ++this.lastFogStack;
                    this.fogStack[this.lastFogStack] = renderable;
                }
            }
        }
        if (this.terminate) {
            return 0;
        }
        for (n2 = 0; n2 < n3 && !this.terminate; ++n2) {
            boolean bl3 = cullableArray[n2] instanceof TransformCullable;
            if (bl3) {
                this.resizeStack();
                object2 = (TransformCullable)cullableArray[n2];
                object2.getTransform(this.transformStack[this.lastTxStack + 1]);
                this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.transformStack[this.lastTxStack + 1]);
                ++this.lastTxStack;
            }
            if (cullableArray[n2] instanceof GroupCullable) {
                n6 = this.findAllNodes((GroupCullable)cullableArray[n2], n6);
            } else if (cullableArray[n2] instanceof LeafCullable) {
                object2 = (LeafCullable)cullableArray[n2];
                if (object2.getCullableType() == 4) {
                    renderable = object2.getRenderable();
                    if (renderable instanceof ShapeRenderable) {
                        CustomGeometryRenderable customGeometryRenderable;
                        object = (ShapeRenderable)renderable;
                        if (!object.isVisible()) continue;
                        GeometryRenderable geometryRenderable = object.getGeometryRenderable();
                        if (geometryRenderable instanceof CustomGeometryRenderable) {
                            customGeometryRenderable = (CustomGeometryRenderable)geometryRenderable;
                            this.workCullList[n6].customData = customGeometryRenderable.processCull(this.transformStack[this.lastTxStack], this.viewMatrix, this.frustumPlanes, this.angularResolution);
                        }
                        if (object.is2D()) {
                            this.resizeCullList(n);
                            this.workCullList[n6].renderable = (Pixmap)cullableArray[n2];
                            this.workCullList[n6].numLights = 0;
                            this.workCullList[n6].numClipPlanes = 0;
                            customGeometryRenderable = this.transformStack[this.lastTxStack];
                            this.workCullList[n6].transform.set((Matrix4f)customGeometryRenderable);
                            ++n6;
                        } else {
                            int n7;
                            int n8;
                            VisualDetails[] visualDetailsArray;
                            int n9;
                            if (this.checkOffscreens) {
                                this.checkForOffscreens((ShapeRenderable)object);
                            }
                            this.resizeCullList(n6);
                            this.workCullList[n6].renderable = renderable;
                            this.workCullList[n6].localFog = this.fogStack[this.lastFogStack];
                            customGeometryRenderable = this.transformStack[this.lastTxStack];
                            this.workCullList[n6].transform.set((Matrix4f)customGeometryRenderable);
                            int n10 = n9 = this.workCullList[n6].lights == null ? 0 : this.workCullList[n6].lights.length;
                            if (n9 < this.lastLight) {
                                visualDetailsArray = new VisualDetails[this.lastLight];
                                if (n9 != 0) {
                                    System.arraycopy(this.workCullList[n6].lights, 0, visualDetailsArray, 0, n9);
                                }
                                for (n8 = n9; n8 < this.lastLight; ++n8) {
                                    visualDetailsArray[n8] = new VisualDetails();
                                }
                                this.workCullList[n6].lights = visualDetailsArray;
                            }
                            visualDetailsArray = this.workCullList[n6].lights;
                            this.workCullList[n6].numLights = this.lastLight;
                            for (n8 = 0; n8 < this.lastLight; ++n8) {
                                visualDetailsArray[n8].update(this.lightList[n8], this.lightTxList[n8]);
                            }
                            int n11 = n9 = this.workCullList[n6].clipPlanes == null ? 0 : this.workCullList[n6].clipPlanes.length;
                            if (n9 < this.lastClip) {
                                VisualDetails[] visualDetailsArray2 = new VisualDetails[this.lastClip];
                                if (n9 != 0) {
                                    System.arraycopy(this.workCullList[n6].clipPlanes, 0, visualDetailsArray2, 0, n9);
                                }
                                for (n7 = n9; n7 < this.lastClip; ++n7) {
                                    visualDetailsArray2[n7] = new VisualDetails();
                                }
                                this.workCullList[n6].clipPlanes = visualDetailsArray2;
                            }
                            VisualDetails[] visualDetailsArray3 = this.workCullList[n6].clipPlanes;
                            this.workCullList[n6].numClipPlanes = this.lastClip;
                            for (n7 = 0; n7 < this.lastClip; ++n7) {
                                visualDetailsArray3[n7].update(this.clipList[n7], this.clipTxList[n7]);
                            }
                            ++n6;
                        }
                    } else if (cullableArray[n2] instanceof CustomRenderable) {
                        n6 = this.findAllNodes((CustomRenderable)((Object)cullableArray[n2]), n6);
                    }
                }
            } else if (cullableArray[n2] instanceof SingleCullable) {
                n6 = this.findNextNode((SingleCullable)cullableArray[n2], n6);
            } else if (cullableArray[n2] instanceof CustomCullable) {
                n6 = this.findAllNodes((CustomCullable)cullableArray[n2], n6);
            }
            if (!bl3) continue;
            --this.lastTxStack;
        }
        this.lastLight -= n4;
        this.lastClip -= n5;
        if (bl2) {
            this.fogStack[this.lastFogStack] = null;
            --this.lastFogStack;
        }
        if (bl) {
            --this.lastTxStack;
        }
        return n6;
    }

    private int findAllNodes(CustomRenderable customRenderable, int n) {
        int n2;
        int n3;
        VisualDetails[] visualDetailsArray;
        int n4;
        if (this.terminate) {
            return 0;
        }
        if (!customRenderable.processCull(this.renderInstructions, this.transformStack[this.lastTxStack], this.viewMatrix, this.frustumPlanes, this.angularResolution)) {
            return n;
        }
        if (this.renderInstructions.hasTransform) {
            this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.renderInstructions.localTransform);
            ++this.lastTxStack;
        }
        int n5 = n;
        this.resizeCullList(n5);
        this.workCullList[n5].renderable = customRenderable;
        this.workCullList[n5].localFog = this.fogStack[this.lastFogStack];
        this.workCullList[n5].customData = this.renderInstructions.instructions;
        Matrix4f matrix4f = this.transformStack[this.lastTxStack];
        this.workCullList[n5].transform.set(matrix4f);
        int n6 = n4 = this.workCullList[n5].lights == null ? 0 : this.workCullList[n5].lights.length;
        if (n4 < this.lastLight) {
            visualDetailsArray = new VisualDetails[this.lastLight];
            if (n4 != 0) {
                System.arraycopy(this.workCullList[n5].lights, 0, visualDetailsArray, 0, n4);
            }
            for (n3 = n4; n3 < this.lastLight; ++n3) {
                visualDetailsArray[n3] = new VisualDetails();
            }
            this.workCullList[n5].lights = visualDetailsArray;
        }
        visualDetailsArray = this.workCullList[n5].lights;
        this.workCullList[n5].numLights = this.lastLight;
        for (n3 = 0; n3 < this.lastLight; ++n3) {
            visualDetailsArray[n3].update(this.lightList[n3], this.lightTxList[n3]);
        }
        int n7 = n4 = this.workCullList[n5].clipPlanes == null ? 0 : this.workCullList[n5].clipPlanes.length;
        if (n4 < this.lastClip) {
            VisualDetails[] visualDetailsArray2 = new VisualDetails[this.lastClip];
            if (n4 != 0) {
                System.arraycopy(this.workCullList[n5].clipPlanes, 0, visualDetailsArray2, 0, n4);
            }
            for (n2 = n4; n2 < this.lastClip; ++n2) {
                visualDetailsArray2[n2] = new VisualDetails();
            }
            this.workCullList[n5].clipPlanes = visualDetailsArray2;
        }
        VisualDetails[] visualDetailsArray3 = this.workCullList[n5].clipPlanes;
        this.workCullList[n5].numClipPlanes = this.lastClip;
        for (n2 = 0; n2 < this.lastClip; ++n2) {
            visualDetailsArray3[n2].update(this.clipList[n2], this.clipTxList[n2]);
        }
        ++n5;
        if (this.renderInstructions.hasTransform) {
            --this.lastTxStack;
        }
        return n5;
    }

    private int findNextNode(SingleCullable singleCullable, int n) {
        Cullable cullable;
        if (this.terminate) {
            return 0;
        }
        int n2 = n;
        Cullable cullable2 = singleCullable.getCullableChild();
        while (cullable2 != null && cullable2 instanceof SingleCullable) {
            cullable2 = ((SingleCullable)cullable2).getCullableChild();
        }
        boolean bl = cullable2 instanceof TransformCullable;
        if (bl) {
            this.resizeStack();
            cullable = (TransformCullable)cullable2;
            cullable.getTransform(this.transformStack[this.lastTxStack + 1]);
            this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.transformStack[this.lastTxStack + 1]);
            ++this.lastTxStack;
        }
        if (cullable2 instanceof GroupCullable) {
            n2 = this.findAllNodes((GroupCullable)cullable2, n);
        } else if (cullable2 instanceof LeafCullable) {
            cullable = (LeafCullable)cullable2;
            if (cullable.getCullableType() == 4) {
                Renderable renderable = cullable.getRenderable();
                if (renderable instanceof ShapeRenderable) {
                    ShapeRenderable shapeRenderable = (ShapeRenderable)renderable;
                    if (shapeRenderable.isVisible()) {
                        CustomGeometryRenderable customGeometryRenderable;
                        GeometryRenderable geometryRenderable = shapeRenderable.getGeometryRenderable();
                        if (geometryRenderable instanceof CustomGeometryRenderable) {
                            customGeometryRenderable = (CustomGeometryRenderable)geometryRenderable;
                            this.workCullList[n2].customData = customGeometryRenderable.processCull(this.transformStack[this.lastTxStack], this.viewMatrix, this.frustumPlanes, this.angularResolution);
                        }
                        if (shapeRenderable.is2D()) {
                            this.resizeCullList(n);
                            this.workCullList[n2].renderable = renderable;
                            this.workCullList[n2].numLights = 0;
                            this.workCullList[n2].numClipPlanes = 0;
                            customGeometryRenderable = this.transformStack[this.lastTxStack];
                            this.workCullList[n2].transform.set((Matrix4f)customGeometryRenderable);
                            ++n2;
                        } else {
                            int n3;
                            int n4;
                            VisualDetails[] visualDetailsArray;
                            int n5;
                            if (this.checkOffscreens) {
                                this.checkForOffscreens(shapeRenderable);
                            }
                            this.resizeCullList(n);
                            this.workCullList[n].renderable = renderable;
                            this.workCullList[n].localFog = this.fogStack[this.lastFogStack];
                            customGeometryRenderable = this.transformStack[this.lastTxStack];
                            this.workCullList[n].transform.set((Matrix4f)customGeometryRenderable);
                            int n6 = n5 = this.workCullList[n].lights == null ? 0 : this.workCullList[n].lights.length;
                            if (n5 < this.lastLight) {
                                visualDetailsArray = new VisualDetails[this.lastLight];
                                if (n5 != 0) {
                                    System.arraycopy(this.workCullList[n].lights, 0, visualDetailsArray, 0, n5);
                                }
                                for (n4 = n5; n4 < this.lastLight; ++n4) {
                                    visualDetailsArray[n4] = new VisualDetails();
                                }
                                this.workCullList[n].lights = visualDetailsArray;
                            }
                            visualDetailsArray = this.workCullList[n].lights;
                            this.workCullList[n].numLights = this.lastLight;
                            for (n4 = 0; n4 < this.lastLight; ++n4) {
                                visualDetailsArray[n4].update(this.lightList[n4], this.lightTxList[n4]);
                            }
                            int n7 = n5 = this.workCullList[n].clipPlanes == null ? 0 : this.workCullList[n].clipPlanes.length;
                            if (n5 < this.lastClip) {
                                VisualDetails[] visualDetailsArray2 = new VisualDetails[this.lastClip];
                                if (n5 != 0) {
                                    System.arraycopy(this.workCullList[n].clipPlanes, 0, visualDetailsArray2, 0, n5);
                                }
                                for (n3 = n5; n3 < this.lastClip; ++n3) {
                                    visualDetailsArray2[n3] = new VisualDetails();
                                }
                                this.workCullList[n].clipPlanes = visualDetailsArray2;
                            }
                            VisualDetails[] visualDetailsArray3 = this.workCullList[n].clipPlanes;
                            this.workCullList[n].numClipPlanes = this.lastClip;
                            for (n3 = 0; n3 < this.lastClip; ++n3) {
                                visualDetailsArray3[n3].update(this.clipList[n3], this.clipTxList[n3]);
                            }
                            ++n;
                            ++n2;
                        }
                    }
                } else if (cullable2 instanceof CustomRenderable) {
                    n2 = this.findAllNodes((CustomRenderable)((Object)cullable2), n2);
                }
            }
        } else if (cullable2 instanceof CustomCullable) {
            n2 = this.findAllNodes((CustomCullable)cullable2, n2);
        }
        if (bl) {
            --this.lastTxStack;
        }
        return n2;
    }

    private void updateFrustum(ViewEnvironmentCullable viewEnvironmentCullable, GraphicsEnvironmentData graphicsEnvironmentData) {
        viewEnvironmentCullable.getProjectionMatrix(this.projectionMatrix);
        this.prjMatrix.m00 = this.projectionMatrix[0];
        this.prjMatrix.m01 = this.projectionMatrix[1];
        this.prjMatrix.m02 = this.projectionMatrix[2];
        this.prjMatrix.m03 = this.projectionMatrix[3];
        this.prjMatrix.m10 = this.projectionMatrix[4];
        this.prjMatrix.m11 = this.projectionMatrix[5];
        this.prjMatrix.m12 = this.projectionMatrix[6];
        this.prjMatrix.m13 = this.projectionMatrix[7];
        this.prjMatrix.m20 = this.projectionMatrix[8];
        this.prjMatrix.m21 = this.projectionMatrix[9];
        this.prjMatrix.m22 = this.projectionMatrix[10];
        this.prjMatrix.m23 = this.projectionMatrix[11];
        this.prjMatrix.m30 = this.projectionMatrix[12];
        this.prjMatrix.m31 = this.projectionMatrix[13];
        this.prjMatrix.m32 = this.projectionMatrix[14];
        this.prjMatrix.m33 = this.projectionMatrix[15];
        this.matrixUtils.inverse(this.viewMatrix, this.viewMatrix);
        this.viewMatrix.mul(this.prjMatrix, this.viewMatrix);
        this.prjMatrix.m00 = this.viewMatrix.m00;
        this.prjMatrix.m01 = this.viewMatrix.m10;
        this.prjMatrix.m02 = this.viewMatrix.m20;
        this.prjMatrix.m03 = this.viewMatrix.m30;
        this.prjMatrix.m10 = this.viewMatrix.m01;
        this.prjMatrix.m11 = this.viewMatrix.m11;
        this.prjMatrix.m12 = this.viewMatrix.m21;
        this.prjMatrix.m13 = this.viewMatrix.m31;
        this.prjMatrix.m20 = this.viewMatrix.m02;
        this.prjMatrix.m21 = this.viewMatrix.m12;
        this.prjMatrix.m22 = this.viewMatrix.m22;
        this.prjMatrix.m23 = this.viewMatrix.m32;
        this.prjMatrix.m30 = this.viewMatrix.m03;
        this.prjMatrix.m31 = this.viewMatrix.m13;
        this.prjMatrix.m32 = this.viewMatrix.m23;
        this.prjMatrix.m33 = this.viewMatrix.m33;
        float f = this.prjMatrix.m03 - this.prjMatrix.m00;
        float f2 = this.prjMatrix.m13 - this.prjMatrix.m10;
        float f3 = this.prjMatrix.m23 - this.prjMatrix.m20;
        float f4 = this.prjMatrix.m33 - this.prjMatrix.m30;
        float f5 = 1.0f / (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        this.frustumPlanes[0].x = f * f5;
        this.frustumPlanes[0].y = f2 * f5;
        this.frustumPlanes[0].z = f3 * f5;
        this.frustumPlanes[0].w = f4 * f5;
        f = this.prjMatrix.m03 + this.prjMatrix.m00;
        f2 = this.prjMatrix.m13 + this.prjMatrix.m10;
        f3 = this.prjMatrix.m23 + this.prjMatrix.m20;
        f4 = this.prjMatrix.m33 + this.prjMatrix.m30;
        f5 = 1.0f / (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        this.frustumPlanes[1].x = f * f5;
        this.frustumPlanes[1].y = f2 * f5;
        this.frustumPlanes[1].z = f3 * f5;
        this.frustumPlanes[1].w = f4 * f5;
        f = this.prjMatrix.m03 + this.prjMatrix.m01;
        f2 = this.prjMatrix.m13 + this.prjMatrix.m11;
        f3 = this.prjMatrix.m23 + this.prjMatrix.m21;
        f4 = this.prjMatrix.m33 + this.prjMatrix.m31;
        f5 = 1.0f / (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        this.frustumPlanes[2].x = f * f5;
        this.frustumPlanes[2].y = f2 * f5;
        this.frustumPlanes[2].z = f3 * f5;
        this.frustumPlanes[2].w = f4 * f5;
        f = this.prjMatrix.m03 - this.prjMatrix.m01;
        f2 = this.prjMatrix.m13 - this.prjMatrix.m11;
        f3 = this.prjMatrix.m23 - this.prjMatrix.m21;
        f4 = this.prjMatrix.m33 - this.prjMatrix.m31;
        f5 = 1.0f / (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        this.frustumPlanes[3].x = f * f5;
        this.frustumPlanes[3].y = f2 * f5;
        this.frustumPlanes[3].z = f3 * f5;
        this.frustumPlanes[3].w = f4 * f5;
        f = this.prjMatrix.m03 - this.prjMatrix.m02;
        f2 = this.prjMatrix.m13 - this.prjMatrix.m12;
        f3 = this.prjMatrix.m23 - this.prjMatrix.m22;
        f4 = this.prjMatrix.m33 - this.prjMatrix.m32;
        f5 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        this.frustumPlanes[4].x = f * f5;
        this.frustumPlanes[4].y = f2 * f5;
        this.frustumPlanes[4].z = f3 * f5;
        this.frustumPlanes[4].w = f4 * f5;
        f = this.prjMatrix.m03 + this.prjMatrix.m02;
        f2 = this.prjMatrix.m13 + this.prjMatrix.m12;
        f3 = this.prjMatrix.m23 + this.prjMatrix.m22;
        f4 = this.prjMatrix.m33 + this.prjMatrix.m32;
        f5 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        this.frustumPlanes[5].x = f * f5;
        this.frustumPlanes[5].y = f2 * f5;
        this.frustumPlanes[5].z = f3 * f5;
        this.frustumPlanes[5].w = f4 * f5;
    }
}

