/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline.graphics;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector4f;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.Light;
import org.j3d.aviatrix3d.Pixmap;
import org.j3d.aviatrix3d.pipeline.graphics.BaseCullStage;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsEnvironmentData;
import org.j3d.aviatrix3d.pipeline.graphics.MultipassDetails;
import org.j3d.aviatrix3d.pipeline.graphics.SceneRenderBucket;
import org.j3d.aviatrix3d.pipeline.graphics.ViewportLayerCollection;
import org.j3d.aviatrix3d.pipeline.graphics.VisualDetails;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.aviatrix3d.rendering.CullInstructions;
import org.j3d.aviatrix3d.rendering.Cullable;
import org.j3d.aviatrix3d.rendering.CustomCullable;
import org.j3d.aviatrix3d.rendering.CustomGeometryRenderable;
import org.j3d.aviatrix3d.rendering.CustomRenderable;
import org.j3d.aviatrix3d.rendering.EffectRenderable;
import org.j3d.aviatrix3d.rendering.GeometryRenderable;
import org.j3d.aviatrix3d.rendering.GroupCullable;
import org.j3d.aviatrix3d.rendering.LeafCullable;
import org.j3d.aviatrix3d.rendering.RenderPassCullable;
import org.j3d.aviatrix3d.rendering.Renderable;
import org.j3d.aviatrix3d.rendering.RenderableInstructions;
import org.j3d.aviatrix3d.rendering.SceneCullable;
import org.j3d.aviatrix3d.rendering.ShapeRenderable;
import org.j3d.aviatrix3d.rendering.SingleCullable;
import org.j3d.aviatrix3d.rendering.TransformCullable;
import org.j3d.aviatrix3d.rendering.ViewEnvironmentCullable;

public class FrustumCullStage
extends BaseCullStage {
    private double[] viewFrustum;
    private Matrix4f viewMatrix;
    private Point4f[] frustumPoints;
    private Vector4f[] frustumPlanes;
    private Matrix4f prjMatrix;
    private float[] projectionMatrix;
    private CullInstructions cullInstructions = new CullInstructions();
    private RenderableInstructions renderInstructions = new RenderableInstructions();
    private float angularResolution;
    private BoundingVolume[] lightBounds;
    private EffectRenderable[] globalLightList;
    private float[][] globalLightTxList;
    private BoundingVolume[] globalLightBounds;
    private int lastGlobalLight;
    private EffectRenderable[] globalBoundedLightList;
    private float[][] globalBoundedLightTxList;
    private BoundingVolume[] globalBoundedLightBounds;
    private int lastGlobalBoundedLight;

    public FrustumCullStage() {
        this(1);
    }

    public FrustumCullStage(int n) {
        super(n);
        int n2;
        this.prjMatrix = new Matrix4f();
        this.viewMatrix = new Matrix4f();
        this.projectionMatrix = new float[16];
        this.frustumPoints = new Point4f[8];
        for (n2 = 0; n2 < 8; ++n2) {
            this.frustumPoints[n2] = new Point4f();
        }
        this.frustumPlanes = new Vector4f[6];
        for (n2 = 0; n2 < 6; ++n2) {
            this.frustumPlanes[n2] = new Vector4f();
        }
        this.globalLightList = new EffectRenderable[32];
        this.globalLightTxList = new float[32][16];
        this.globalBoundedLightList = new EffectRenderable[32];
        this.globalBoundedLightTxList = new float[32][16];
    }

    protected void cullScene(RenderPassCullable renderPassCullable, int n, int n2, int n3, int n4) {
        this.lastLight = 0;
        this.lastGlobalLight = 0;
        this.lastGlobalBoundedLight = 0;
        this.lastClip = 0;
        this.lastTxStack = 0;
        this.lastFogStack = 0;
        this.activeParent = null;
        SceneRenderBucket sceneRenderBucket = this.workLayers[n][n2].viewports[n3].scenes[n4];
        this.workCullList = sceneRenderBucket.nodes;
        this.validSceneParents[0][0] = null;
        this.validSceneParents[0][1] = null;
        Cullable cullable = renderPassCullable.getRootCullable();
        sceneRenderBucket.data.layerId = n2;
        sceneRenderBucket.data.subLayerId = n4;
        if (cullable instanceof TransformCullable) {
            ((TransformCullable)cullable).getTransform(this.transformStack[0]);
        } else {
            this.transformStack[0].setIdentity();
        }
        if (cullable instanceof CustomCullable) {
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), sceneRenderBucket.data);
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            sceneRenderBucket.numNodes = this.findAllNodes((CustomCullable)cullable, 0);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof GroupCullable) {
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), sceneRenderBucket.data);
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            sceneRenderBucket.numNodes = this.findAllNodes((GroupCullable)cullable, false, false, 0);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof SingleCullable) {
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), sceneRenderBucket.data);
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            sceneRenderBucket.numNodes = this.findNextNode((SingleCullable)cullable, false, false, 0);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof LeafCullable) {
            LeafCullable leafCullable = (LeafCullable)cullable;
            if (leafCullable.getCullableType() != 4) {
                return;
            }
            Renderable renderable = leafCullable.getRenderable();
            if (renderable instanceof ShapeRenderable && ((ShapeRenderable)renderable).is2D()) {
                if (this.checkOffscreens) {
                    this.checkForOffscreens((ShapeRenderable)renderable);
                }
                this.workCullList[0].renderable = renderable;
                this.workCullList[0].transform.setIdentity();
                this.workCullList[0].numLights = 0;
                this.workCullList[0].numClipPlanes = 0;
                sceneRenderBucket.numNodes = 1;
                sceneRenderBucket.nodes = this.workCullList;
                ++this.lastOutputList;
            }
        }
        this.processGlobalLights(sceneRenderBucket.numNodes);
    }

    protected void cullRenderPass(RenderPassCullable renderPassCullable, int n, int n2, int n3, int n4, int n5) {
        this.lastLight = 0;
        this.lastGlobalLight = 0;
        this.lastGlobalBoundedLight = 0;
        this.lastClip = 0;
        this.lastTxStack = 0;
        this.lastFogStack = 0;
        this.activeParent = null;
        ViewportLayerCollection viewportLayerCollection = this.workLayers[n2][n3].viewports[n4];
        MultipassDetails multipassDetails = viewportLayerCollection.multipass[viewportLayerCollection.numMultipass].mainScene;
        this.workCullList = multipassDetails.nodes[n];
        this.validSceneParents[0][0] = null;
        this.validSceneParents[0][1] = null;
        Cullable cullable = renderPassCullable.getRootCullable();
        this.fillRenderPassEnvData(renderPassCullable, multipassDetails.data[n], multipassDetails.buffers[n]);
        multipassDetails.data[n].layerId = n3;
        multipassDetails.data[n].subLayerId = n5;
        if (this.terminate) {
            return;
        }
        if (cullable instanceof CustomCullable) {
            this.transformStack[0].setIdentity();
            this.viewFrustum = multipassDetails.data[n].viewFrustum;
            this.viewMatrix.set(multipassDetails.data[n].viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), multipassDetails.data[n]);
            this.viewMatrix.set(multipassDetails.data[n].viewTransform);
            multipassDetails.numNodes[n] = this.findAllNodes((CustomCullable)cullable, 0);
            multipassDetails.nodes[n] = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof GroupCullable) {
            this.transformStack[0].setIdentity();
            if (cullable instanceof TransformCullable) {
                ((TransformCullable)cullable).getTransform(this.transformStack[0]);
            } else {
                this.transformStack[0].setIdentity();
            }
            this.viewFrustum = multipassDetails.data[n].viewFrustum;
            this.viewMatrix.set(multipassDetails.data[n].viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), multipassDetails.data[n]);
            multipassDetails.numNodes[n] = this.findAllNodes((GroupCullable)cullable, false, false, 0);
            multipassDetails.nodes[n] = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof SingleCullable) {
            this.transformStack[0].setIdentity();
            this.viewFrustum = multipassDetails.data[n].viewFrustum;
            this.viewMatrix.set(multipassDetails.data[n].viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), multipassDetails.data[n]);
            multipassDetails.numNodes[n] = this.findNextNode((SingleCullable)cullable, false, false, 0);
            multipassDetails.nodes[n] = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof LeafCullable) {
            LeafCullable leafCullable = (LeafCullable)cullable;
            if (leafCullable.getCullableType() != 4) {
                return;
            }
            Renderable renderable = leafCullable.getRenderable();
            if (renderable instanceof ShapeRenderable && ((ShapeRenderable)renderable).is2D()) {
                if (this.checkOffscreens) {
                    this.checkForOffscreens((ShapeRenderable)renderable);
                }
                this.workCullList[0].renderable = renderable;
                this.workCullList[0].transform.setIdentity();
                this.workCullList[0].numLights = 0;
                this.workCullList[0].numClipPlanes = 0;
                multipassDetails.numNodes[n] = 1;
                multipassDetails.nodes[n] = this.workCullList;
                ++this.lastOutputList;
            }
        }
        this.processGlobalLights(multipassDetails.numNodes[n]);
    }

    protected void cullScene2D(RenderPassCullable renderPassCullable, int n, int n2, int n3, int n4) {
        this.lastLight = 0;
        this.lastGlobalLight = 0;
        this.lastGlobalBoundedLight = 0;
        this.lastClip = 0;
        this.lastTxStack = 0;
        this.lastFogStack = 0;
        this.activeParent = null;
        SceneRenderBucket sceneRenderBucket = this.workLayers[n][n2].viewports[n3].scenes[n4];
        this.workCullList = sceneRenderBucket.nodes;
        this.validSceneParents[0][0] = null;
        this.validSceneParents[0][1] = null;
        Cullable cullable = renderPassCullable.getRootCullable();
        sceneRenderBucket.data.layerId = n2;
        sceneRenderBucket.data.subLayerId = n4;
        if (cullable instanceof TransformCullable) {
            ((TransformCullable)cullable).getTransform(this.transformStack[0]);
        } else {
            this.transformStack[0].setIdentity();
        }
        if (cullable instanceof CustomCullable) {
            this.transformStack[0].setIdentity();
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), sceneRenderBucket.data);
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            sceneRenderBucket.numNodes = this.findAllNodes((CustomCullable)cullable, 0);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof GroupCullable) {
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), sceneRenderBucket.data);
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            sceneRenderBucket.numNodes = this.findAllNodes((GroupCullable)cullable, false, false, 0);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof SingleCullable) {
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(renderPassCullable.getViewCullable(), sceneRenderBucket.data);
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            sceneRenderBucket.numNodes = this.findNextNode((SingleCullable)cullable, false, false, 0);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof LeafCullable) {
            LeafCullable leafCullable = (LeafCullable)cullable;
            if (leafCullable.getCullableType() != 4) {
                return;
            }
            Renderable renderable = leafCullable.getRenderable();
            if (renderable instanceof ShapeRenderable && ((ShapeRenderable)renderable).is2D()) {
                this.workCullList[0].renderable = renderable;
                this.workCullList[0].transform.setIdentity();
                this.workCullList[0].numLights = 0;
                this.workCullList[0].numClipPlanes = 0;
                sceneRenderBucket.numNodes = 1;
                sceneRenderBucket.nodes = this.workCullList;
                ++this.lastOutputList;
            }
        }
        this.processGlobalLights(sceneRenderBucket.numNodes);
    }

    protected void fillSingleEnvData(SceneCullable sceneCullable, GraphicsEnvironmentData graphicsEnvironmentData) {
        Object[] objectArray;
        super.fillSingleEnvData(sceneCullable, graphicsEnvironmentData);
        ViewEnvironmentCullable viewEnvironmentCullable = sceneCullable.getViewCullable();
        switch (viewEnvironmentCullable.getProjectionType()) {
            case 1: 
            case 3: {
                this.angularResolution = (float)viewEnvironmentCullable.getFieldOfView();
                break;
            }
            case 2: {
                objectArray = new double[6];
                viewEnvironmentCullable.getViewFrustum((double[])objectArray);
                double d = Math.atan2(objectArray[1], objectArray[5]) - Math.atan2(objectArray[0], objectArray[5]);
                this.angularResolution = (float)Math.toDegrees(d);
            }
            case 4: {
                this.angularResolution = 1.0f;
            }
        }
        objectArray = viewEnvironmentCullable.getViewportDimensions();
        this.angularResolution /= (float)objectArray[2];
    }

    protected void cleanupOldRefs() {
        int n;
        this.renderInstructions.instructions = null;
        for (n = 0; n < this.cullInstructions.children.length; ++n) {
            this.cullInstructions.children[n] = null;
        }
        for (n = 0; n < this.lastGlobalLight; ++n) {
            this.globalLightList[n] = null;
        }
        for (n = 0; n < this.lastGlobalBoundedLight; ++n) {
            this.globalBoundedLightList[n] = null;
        }
        super.cleanupOldRefs();
    }

    private int findAllNodes(CustomCullable customCullable, int n) {
        Object object;
        Object object2;
        Renderable renderable;
        Object object3;
        int n2;
        if (this.terminate) {
            return 0;
        }
        customCullable.cullChildren(this.cullInstructions, this.transformStack[this.lastTxStack], this.viewMatrix, this.frustumPlanes, this.angularResolution);
        if (this.cullInstructions.numChildren == 0) {
            return n;
        }
        boolean bl = this.cullInstructions.hasTransform;
        if (bl) {
            this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.cullInstructions.localTransform);
            ++this.lastTxStack;
        }
        Cullable[] cullableArray = (Cullable[])this.cullInstructions.children.clone();
        int n3 = this.cullInstructions.numChildren;
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        boolean bl2 = false;
        block5: for (n2 = 0; n2 < n3; ++n2) {
            LeafCullable leafCullable;
            if (!(cullableArray[n2] instanceof LeafCullable) || !((object3 = (leafCullable = (LeafCullable)cullableArray[n2]).getRenderable()) instanceof EffectRenderable) || !(renderable = (EffectRenderable)object3).isEnabled()) continue;
            switch (leafCullable.getCullableType()) {
                case 2: {
                    if (renderable.isGlobalOnly()) {
                        object2 = renderable.getEffectBounds();
                        if (object2 instanceof BoundingVoid) continue block5;
                        object = this.transformStack[this.lastTxStack];
                        if (object2 == null) {
                            this.resizeGlobalLightList();
                            this.globalLightList[this.lastGlobalLight] = renderable;
                            this.globalLightTxList[this.lastGlobalLight][0] = object.m00;
                            this.globalLightTxList[this.lastGlobalLight][1] = object.m10;
                            this.globalLightTxList[this.lastGlobalLight][2] = object.m20;
                            this.globalLightTxList[this.lastGlobalLight][3] = object.m30;
                            this.globalLightTxList[this.lastGlobalLight][4] = object.m01;
                            this.globalLightTxList[this.lastGlobalLight][5] = object.m11;
                            this.globalLightTxList[this.lastGlobalLight][6] = object.m21;
                            this.globalLightTxList[this.lastGlobalLight][7] = object.m31;
                            this.globalLightTxList[this.lastGlobalLight][8] = object.m02;
                            this.globalLightTxList[this.lastGlobalLight][9] = object.m12;
                            this.globalLightTxList[this.lastGlobalLight][10] = object.m22;
                            this.globalLightTxList[this.lastGlobalLight][11] = object.m32;
                            this.globalLightTxList[this.lastGlobalLight][12] = object.m03;
                            this.globalLightTxList[this.lastGlobalLight][13] = object.m13;
                            this.globalLightTxList[this.lastGlobalLight][14] = object.m23;
                            this.globalLightTxList[this.lastGlobalLight][15] = object.m33;
                            ++this.lastGlobalLight;
                            continue block5;
                        }
                        this.resizeGlobalBoundedLightList();
                        this.globalBoundedLightList[this.lastGlobalBoundedLight] = renderable;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][0] = object.m00;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][1] = object.m10;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][2] = object.m20;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][3] = object.m30;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][4] = object.m01;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][5] = object.m11;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][6] = object.m21;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][7] = object.m31;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][8] = object.m02;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][9] = object.m12;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][10] = object.m22;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][11] = object.m32;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][12] = object.m03;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][13] = object.m13;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][14] = object.m23;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][15] = object.m33;
                        ++this.lastGlobalBoundedLight;
                        continue block5;
                    }
                    object2 = renderable.getEffectBounds();
                    if (object2 instanceof BoundingVoid) continue block5;
                    this.resizeLightList();
                    this.lightList[this.lastLight] = renderable;
                    object = this.transformStack[this.lastTxStack];
                    this.lightTxList[this.lastLight][0] = object.m00;
                    this.lightTxList[this.lastLight][1] = object.m10;
                    this.lightTxList[this.lastLight][2] = object.m20;
                    this.lightTxList[this.lastLight][3] = object.m30;
                    this.lightTxList[this.lastLight][4] = object.m01;
                    this.lightTxList[this.lastLight][5] = object.m11;
                    this.lightTxList[this.lastLight][6] = object.m21;
                    this.lightTxList[this.lastLight][7] = object.m31;
                    this.lightTxList[this.lastLight][8] = object.m02;
                    this.lightTxList[this.lastLight][9] = object.m12;
                    this.lightTxList[this.lastLight][10] = object.m22;
                    this.lightTxList[this.lastLight][11] = object.m32;
                    this.lightTxList[this.lastLight][12] = object.m03;
                    this.lightTxList[this.lastLight][13] = object.m13;
                    this.lightTxList[this.lastLight][14] = object.m23;
                    this.lightTxList[this.lastLight][15] = object.m33;
                    ++this.lastLight;
                    ++n4;
                    continue block5;
                }
                case 3: {
                    this.resizeClipList();
                    this.clipList[this.lastClip] = renderable;
                    object2 = this.transformStack[this.lastTxStack];
                    this.clipTxList[this.lastClip][0] = ((Matrix4f)object2).m00;
                    this.clipTxList[this.lastClip][1] = ((Matrix4f)object2).m10;
                    this.clipTxList[this.lastClip][2] = ((Matrix4f)object2).m20;
                    this.clipTxList[this.lastClip][3] = ((Matrix4f)object2).m30;
                    this.clipTxList[this.lastClip][4] = ((Matrix4f)object2).m01;
                    this.clipTxList[this.lastClip][5] = ((Matrix4f)object2).m11;
                    this.clipTxList[this.lastClip][6] = ((Matrix4f)object2).m21;
                    this.clipTxList[this.lastClip][7] = ((Matrix4f)object2).m31;
                    this.clipTxList[this.lastClip][8] = ((Matrix4f)object2).m02;
                    this.clipTxList[this.lastClip][9] = ((Matrix4f)object2).m12;
                    this.clipTxList[this.lastClip][10] = ((Matrix4f)object2).m22;
                    this.clipTxList[this.lastClip][11] = ((Matrix4f)object2).m32;
                    this.clipTxList[this.lastClip][12] = ((Matrix4f)object2).m03;
                    this.clipTxList[this.lastClip][13] = ((Matrix4f)object2).m13;
                    this.clipTxList[this.lastClip][14] = ((Matrix4f)object2).m23;
                    this.clipTxList[this.lastClip][15] = ((Matrix4f)object2).m33;
                    ++this.lastClip;
                    ++n5;
                    continue block5;
                }
                case 1: {
                    if (renderable.isGlobalOnly() || bl2) continue block5;
                    this.resizeFogStack();
                    bl2 = true;
                    ++this.lastFogStack;
                    this.fogStack[this.lastFogStack] = renderable;
                }
            }
        }
        for (n2 = 0; n2 < n3 && !this.terminate; ++n2) {
            boolean bl3 = cullableArray[n2] instanceof TransformCullable;
            if (bl3) {
                this.resizeStack();
                object3 = (TransformCullable)cullableArray[n2];
                object3.getTransform(this.transformStack[this.lastTxStack + 1]);
                this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.transformStack[this.lastTxStack + 1]);
                ++this.lastTxStack;
            }
            if (cullableArray[n2] instanceof GroupCullable) {
                n6 = this.findAllNodes((GroupCullable)cullableArray[n2], true, bl3, n6);
            } else if (cullableArray[n2] instanceof LeafCullable) {
                object3 = (LeafCullable)cullableArray[n2];
                if (object3.getCullableType() == 4) {
                    renderable = object3.getRenderable();
                    if (renderable instanceof ShapeRenderable) {
                        CustomGeometryRenderable customGeometryRenderable;
                        object2 = (ShapeRenderable)renderable;
                        if (!object2.isVisible()) continue;
                        object = object2.getGeometryRenderable();
                        if (object instanceof CustomGeometryRenderable) {
                            customGeometryRenderable = (CustomGeometryRenderable)object;
                            this.workCullList[n6].customData = customGeometryRenderable.processCull(this.transformStack[this.lastTxStack], this.viewMatrix, this.frustumPlanes, this.angularResolution);
                        }
                        if (object2.is2D()) {
                            this.resizeCullList(n6);
                            this.workCullList[n6].renderable = renderable;
                            this.workCullList[n6].localFog = null;
                            this.workCullList[n6].numLights = 0;
                            this.workCullList[n6].numClipPlanes = 0;
                            customGeometryRenderable = this.transformStack[this.lastTxStack];
                            this.workCullList[n6].transform.set((Matrix4f)customGeometryRenderable);
                            ++n6;
                        } else {
                            BoundingVolume boundingVolume;
                            if (this.checkOffscreens) {
                                this.checkForOffscreens((ShapeRenderable)object2);
                            }
                            this.resizeCullList(n6);
                            this.workCullList[n6].renderable = renderable;
                            this.workCullList[n6].localFog = this.fogStack[this.lastFogStack];
                            customGeometryRenderable = this.transformStack[this.lastTxStack];
                            this.workCullList[n6].transform.set((Matrix4f)customGeometryRenderable);
                            int n7 = this.workCullList[n6].lights == null ? 0 : this.workCullList[n6].lights.length;
                            int n8 = this.lastLight;
                            if (n7 < n8) {
                                VisualDetails[] visualDetailsArray = new VisualDetails[n8];
                                if (n7 != 0) {
                                    System.arraycopy(this.workCullList[n6].lights, 0, visualDetailsArray, 0, n7);
                                }
                                for (int i = n7; i < n8; ++i) {
                                    visualDetailsArray[i] = new VisualDetails();
                                }
                                this.workCullList[n6].lights = visualDetailsArray;
                            }
                            int n9 = 0;
                            this.workCullList[n6].cullableBounds = boundingVolume = object3.getBounds();
                            VisualDetails[] visualDetailsArray = this.workCullList[n6].lights;
                            for (int i = 0; i < this.lastLight; ++i) {
                                BoundingVolume boundingVolume2 = this.lightList[i].getEffectBounds();
                                if (boundingVolume2 != null && !this.checkBoundsIntersect(boundingVolume, (Matrix4f)customGeometryRenderable, boundingVolume2, this.lightTxList[i])) continue;
                                visualDetailsArray[n9].update(this.lightList[i], this.lightTxList[i]);
                                ++n9;
                            }
                            this.workCullList[n6].numLights = n9;
                            int n10 = n7 = this.workCullList[n6].clipPlanes == null ? 0 : this.workCullList[n6].clipPlanes.length;
                            if (n7 < this.lastClip) {
                                VisualDetails[] visualDetailsArray2 = new VisualDetails[this.lastClip];
                                if (n7 != 0) {
                                    System.arraycopy(this.workCullList[n6].clipPlanes, 0, visualDetailsArray2, 0, n7);
                                }
                                for (int i = n7; i < this.lastClip; ++i) {
                                    visualDetailsArray2[i] = new VisualDetails();
                                }
                                this.workCullList[n6].clipPlanes = visualDetailsArray2;
                            }
                            VisualDetails[] visualDetailsArray3 = this.workCullList[n6].clipPlanes;
                            this.workCullList[n6].numClipPlanes = this.lastClip;
                            for (int i = 0; i < this.lastClip; ++i) {
                                visualDetailsArray3[i].update(this.clipList[i], this.clipTxList[i]);
                            }
                            ++n6;
                        }
                    } else if (cullableArray[n2] instanceof CustomRenderable) {
                        object2 = object3.getBounds();
                        n6 = this.findAllNodes((CustomRenderable)((Object)cullableArray[n2]), n6, (BoundingVolume)object2);
                    }
                }
            } else if (cullableArray[n2] instanceof SingleCullable) {
                n6 = this.findNextNode((SingleCullable)cullableArray[n2], false, false, n6);
            } else if (cullableArray[n2] instanceof CustomCullable) {
                n6 = this.findAllNodes((CustomCullable)cullableArray[n2], n6);
            }
            if (!bl3) continue;
            --this.lastTxStack;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            this.lightList[--this.lastLight] = null;
        }
        for (n2 = 0; n2 < n5; ++n2) {
            this.clipList[--this.lastClip] = null;
        }
        if (bl2) {
            this.fogStack[this.lastFogStack] = null;
            --this.lastFogStack;
        }
        if (bl) {
            --this.lastTxStack;
        }
        return n6;
    }

    private int findAllNodes(CustomRenderable customRenderable, int n, BoundingVolume boundingVolume) {
        if (this.terminate) {
            return 0;
        }
        if (!customRenderable.processCull(this.renderInstructions, this.transformStack[this.lastTxStack], this.viewMatrix, this.frustumPlanes, this.angularResolution)) {
            return n;
        }
        if (this.renderInstructions.hasTransform) {
            this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.renderInstructions.localTransform);
            ++this.lastTxStack;
        }
        int n2 = n;
        if (this.checkOffscreens && customRenderable instanceof ShapeRenderable) {
            this.checkForOffscreens((ShapeRenderable)((Object)customRenderable));
        }
        this.resizeCullList(n2);
        this.workCullList[n2].renderable = customRenderable;
        this.workCullList[n2].localFog = this.fogStack[this.lastFogStack];
        this.workCullList[n2].customData = this.renderInstructions.instructions;
        Matrix4f matrix4f = this.transformStack[this.lastTxStack];
        this.workCullList[n2].transform.set(matrix4f);
        int n3 = this.workCullList[n2].lights == null ? 0 : this.workCullList[n2].lights.length;
        int n4 = this.lastLight;
        if (n3 < n4) {
            VisualDetails[] visualDetailsArray = new VisualDetails[n4];
            if (n3 != 0) {
                System.arraycopy(this.workCullList[n2].lights, 0, visualDetailsArray, 0, n3);
            }
            for (int i = n3; i < n4; ++i) {
                visualDetailsArray[i] = new VisualDetails();
            }
            this.workCullList[n2].lights = visualDetailsArray;
        }
        int n5 = 0;
        this.workCullList[n2].cullableBounds = boundingVolume;
        VisualDetails[] visualDetailsArray = this.workCullList[n2].lights;
        for (int i = 0; i < this.lastLight; ++i) {
            BoundingVolume boundingVolume2 = this.lightList[i].getEffectBounds();
            if (boundingVolume2 != null && !this.checkBoundsIntersect(boundingVolume, matrix4f, boundingVolume2, this.lightTxList[i])) continue;
            visualDetailsArray[n5].update(this.lightList[i], this.lightTxList[i]);
            ++n5;
        }
        this.workCullList[n2].numLights = n5;
        int n6 = n3 = this.workCullList[n2].clipPlanes == null ? 0 : this.workCullList[n2].clipPlanes.length;
        if (n3 < this.lastClip) {
            VisualDetails[] visualDetailsArray2 = new VisualDetails[this.lastClip];
            if (n3 != 0) {
                System.arraycopy(this.workCullList[n2].clipPlanes, 0, visualDetailsArray2, 0, n3);
            }
            for (int i = n3; i < this.lastClip; ++i) {
                visualDetailsArray2[i] = new VisualDetails();
            }
            this.workCullList[n2].clipPlanes = visualDetailsArray2;
        }
        VisualDetails[] visualDetailsArray3 = this.workCullList[n2].clipPlanes;
        this.workCullList[n2].numClipPlanes = this.lastClip;
        for (int i = 0; i < this.lastClip; ++i) {
            visualDetailsArray3[i].update(this.clipList[i], this.clipTxList[i]);
        }
        ++n2;
        if (this.renderInstructions.hasTransform) {
            --this.lastTxStack;
        }
        return n2;
    }

    private int findAllNodes(GroupCullable groupCullable, boolean bl, boolean bl2, int n) {
        Object object;
        Object object2;
        Renderable renderable;
        Object object3;
        int n2;
        int n3;
        Matrix4f matrix4f;
        int n4;
        if (this.terminate) {
            return 0;
        }
        BoundingVolume boundingVolume = groupCullable.getBounds();
        boolean bl3 = bl;
        if (!bl) {
            n4 = bl2 ? this.lastTxStack - 1 : this.lastTxStack;
            matrix4f = this.transformStack[n4];
            n3 = boundingVolume.checkIntersectionFrustum(this.frustumPlanes, matrix4f);
            switch (n3) {
                case 0: {
                    return n;
                }
                case 2: {
                    bl3 = true;
                    break;
                }
            }
        }
        matrix4f = groupCullable.getCullableChildren();
        n4 = groupCullable.numCullableChildren();
        n3 = 0;
        int n5 = 0;
        int n6 = n;
        boolean bl4 = false;
        block9: for (n2 = 0; n2 < n4; ++n2) {
            LeafCullable leafCullable;
            if (!(matrix4f[n2] instanceof LeafCullable) || !((object3 = (leafCullable = (LeafCullable)matrix4f[n2]).getRenderable()) instanceof EffectRenderable) || !(renderable = (EffectRenderable)object3).isEnabled()) continue;
            switch (leafCullable.getCullableType()) {
                case 2: {
                    if (renderable.isGlobalOnly()) {
                        object2 = renderable.getEffectBounds();
                        if (object2 instanceof BoundingVoid) continue block9;
                        object = this.transformStack[this.lastTxStack];
                        if (boundingVolume == null) {
                            this.resizeGlobalLightList();
                            this.globalLightList[this.lastGlobalLight] = renderable;
                            this.globalLightTxList[this.lastGlobalLight][0] = object.m00;
                            this.globalLightTxList[this.lastGlobalLight][1] = object.m10;
                            this.globalLightTxList[this.lastGlobalLight][2] = object.m20;
                            this.globalLightTxList[this.lastGlobalLight][3] = object.m30;
                            this.globalLightTxList[this.lastGlobalLight][4] = object.m01;
                            this.globalLightTxList[this.lastGlobalLight][5] = object.m11;
                            this.globalLightTxList[this.lastGlobalLight][6] = object.m21;
                            this.globalLightTxList[this.lastGlobalLight][7] = object.m31;
                            this.globalLightTxList[this.lastGlobalLight][8] = object.m02;
                            this.globalLightTxList[this.lastGlobalLight][9] = object.m12;
                            this.globalLightTxList[this.lastGlobalLight][10] = object.m22;
                            this.globalLightTxList[this.lastGlobalLight][11] = object.m32;
                            this.globalLightTxList[this.lastGlobalLight][12] = object.m03;
                            this.globalLightTxList[this.lastGlobalLight][13] = object.m13;
                            this.globalLightTxList[this.lastGlobalLight][14] = object.m23;
                            this.globalLightTxList[this.lastGlobalLight][15] = object.m33;
                            ++this.lastGlobalLight;
                            continue block9;
                        }
                        this.resizeGlobalBoundedLightList();
                        this.globalBoundedLightList[this.lastGlobalBoundedLight] = renderable;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][0] = object.m00;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][1] = object.m10;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][2] = object.m20;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][3] = object.m30;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][4] = object.m01;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][5] = object.m11;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][6] = object.m21;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][7] = object.m31;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][8] = object.m02;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][9] = object.m12;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][10] = object.m22;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][11] = object.m32;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][12] = object.m03;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][13] = object.m13;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][14] = object.m23;
                        this.globalBoundedLightTxList[this.lastGlobalBoundedLight][15] = object.m33;
                        ++this.lastGlobalBoundedLight;
                        continue block9;
                    }
                    object2 = renderable.getEffectBounds();
                    if (object2 instanceof BoundingVoid) continue block9;
                    this.resizeLightList();
                    this.lightList[this.lastLight] = renderable;
                    object = this.transformStack[this.lastTxStack];
                    this.lightTxList[this.lastLight][0] = object.m00;
                    this.lightTxList[this.lastLight][1] = object.m10;
                    this.lightTxList[this.lastLight][2] = object.m20;
                    this.lightTxList[this.lastLight][3] = object.m30;
                    this.lightTxList[this.lastLight][4] = object.m01;
                    this.lightTxList[this.lastLight][5] = object.m11;
                    this.lightTxList[this.lastLight][6] = object.m21;
                    this.lightTxList[this.lastLight][7] = object.m31;
                    this.lightTxList[this.lastLight][8] = object.m02;
                    this.lightTxList[this.lastLight][9] = object.m12;
                    this.lightTxList[this.lastLight][10] = object.m22;
                    this.lightTxList[this.lastLight][11] = object.m32;
                    this.lightTxList[this.lastLight][12] = object.m03;
                    this.lightTxList[this.lastLight][13] = object.m13;
                    this.lightTxList[this.lastLight][14] = object.m23;
                    this.lightTxList[this.lastLight][15] = object.m33;
                    ++this.lastLight;
                    ++n3;
                    continue block9;
                }
                case 3: {
                    this.resizeClipList();
                    this.clipList[this.lastClip] = renderable;
                    object2 = this.transformStack[this.lastTxStack];
                    this.clipTxList[this.lastClip][0] = ((Matrix4f)object2).m00;
                    this.clipTxList[this.lastClip][1] = ((Matrix4f)object2).m10;
                    this.clipTxList[this.lastClip][2] = ((Matrix4f)object2).m20;
                    this.clipTxList[this.lastClip][3] = ((Matrix4f)object2).m30;
                    this.clipTxList[this.lastClip][4] = ((Matrix4f)object2).m01;
                    this.clipTxList[this.lastClip][5] = ((Matrix4f)object2).m11;
                    this.clipTxList[this.lastClip][6] = ((Matrix4f)object2).m21;
                    this.clipTxList[this.lastClip][7] = ((Matrix4f)object2).m31;
                    this.clipTxList[this.lastClip][8] = ((Matrix4f)object2).m02;
                    this.clipTxList[this.lastClip][9] = ((Matrix4f)object2).m12;
                    this.clipTxList[this.lastClip][10] = ((Matrix4f)object2).m22;
                    this.clipTxList[this.lastClip][11] = ((Matrix4f)object2).m32;
                    this.clipTxList[this.lastClip][12] = ((Matrix4f)object2).m03;
                    this.clipTxList[this.lastClip][13] = ((Matrix4f)object2).m13;
                    this.clipTxList[this.lastClip][14] = ((Matrix4f)object2).m23;
                    this.clipTxList[this.lastClip][15] = ((Matrix4f)object2).m33;
                    ++this.lastClip;
                    ++n5;
                    continue block9;
                }
                case 1: {
                    if (renderable.isGlobalOnly() || bl4) continue block9;
                    this.resizeFogStack();
                    bl4 = true;
                    ++this.lastFogStack;
                    this.fogStack[this.lastFogStack] = renderable;
                }
            }
        }
        for (n2 = 0; n2 < n4 && !this.terminate; ++n2) {
            boolean bl5 = matrix4f[n2] instanceof TransformCullable;
            if (bl5) {
                this.resizeStack();
                object3 = (TransformCullable)matrix4f[n2];
                object3.getTransform(this.transformStack[this.lastTxStack + 1]);
                this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.transformStack[this.lastTxStack + 1]);
                ++this.lastTxStack;
            }
            if (matrix4f[n2] instanceof GroupCullable) {
                n6 = this.findAllNodes((GroupCullable)matrix4f[n2], bl3, bl5, n6);
            } else if (matrix4f[n2] instanceof LeafCullable) {
                object3 = (LeafCullable)matrix4f[n2];
                if (object3.getCullableType() == 4) {
                    renderable = object3.getRenderable();
                    if (renderable instanceof ShapeRenderable) {
                        CustomGeometryRenderable customGeometryRenderable;
                        object2 = (ShapeRenderable)renderable;
                        if (!object2.isVisible()) continue;
                        object = object2.getGeometryRenderable();
                        if (object instanceof CustomGeometryRenderable) {
                            customGeometryRenderable = (CustomGeometryRenderable)object;
                            this.workCullList[n6].customData = customGeometryRenderable.processCull(this.transformStack[this.lastTxStack], this.viewMatrix, this.frustumPlanes, this.angularResolution);
                        }
                        if (object2.is2D()) {
                            this.resizeCullList(n);
                            this.workCullList[n6].renderable = (Pixmap)matrix4f[n2];
                            this.workCullList[n6].numLights = 0;
                            this.workCullList[n6].numClipPlanes = 0;
                            customGeometryRenderable = this.transformStack[this.lastTxStack];
                            this.workCullList[n6].transform.set((Matrix4f)customGeometryRenderable);
                            ++n6;
                        } else {
                            BoundingVolume boundingVolume2;
                            if (this.checkOffscreens) {
                                this.checkForOffscreens((ShapeRenderable)object2);
                            }
                            this.resizeCullList(n6);
                            this.workCullList[n6].renderable = renderable;
                            this.workCullList[n6].localFog = this.fogStack[this.lastFogStack];
                            customGeometryRenderable = this.transformStack[this.lastTxStack];
                            this.workCullList[n6].transform.set((Matrix4f)customGeometryRenderable);
                            int n7 = this.workCullList[n6].lights == null ? 0 : this.workCullList[n6].lights.length;
                            int n8 = this.lastLight;
                            if (n7 < n8) {
                                VisualDetails[] visualDetailsArray = new VisualDetails[n8];
                                if (n7 != 0) {
                                    System.arraycopy(this.workCullList[n6].lights, 0, visualDetailsArray, 0, n7);
                                }
                                for (int i = n7; i < n8; ++i) {
                                    visualDetailsArray[i] = new VisualDetails();
                                }
                                this.workCullList[n6].lights = visualDetailsArray;
                            }
                            int n9 = 0;
                            this.workCullList[n6].cullableBounds = boundingVolume2 = object3.getBounds();
                            VisualDetails[] visualDetailsArray = this.workCullList[n6].lights;
                            for (int i = 0; i < this.lastLight; ++i) {
                                BoundingVolume boundingVolume3 = this.lightList[i].getEffectBounds();
                                if (boundingVolume3 != null && !this.checkBoundsIntersect(boundingVolume2, (Matrix4f)customGeometryRenderable, boundingVolume3, this.lightTxList[i])) continue;
                                visualDetailsArray[n9].update(this.lightList[i], this.lightTxList[i]);
                                ++n9;
                            }
                            this.workCullList[n6].numLights = n9;
                            int n10 = n7 = this.workCullList[n6].clipPlanes == null ? 0 : this.workCullList[n6].clipPlanes.length;
                            if (n7 < this.lastClip) {
                                VisualDetails[] visualDetailsArray2 = new VisualDetails[this.lastClip];
                                if (n7 != 0) {
                                    System.arraycopy(this.workCullList[n6].clipPlanes, 0, visualDetailsArray2, 0, n7);
                                }
                                for (int i = n7; i < this.lastClip; ++i) {
                                    visualDetailsArray2[i] = new VisualDetails();
                                }
                                this.workCullList[n6].clipPlanes = visualDetailsArray2;
                            }
                            VisualDetails[] visualDetailsArray3 = this.workCullList[n6].clipPlanes;
                            this.workCullList[n6].numClipPlanes = this.lastClip;
                            for (int i = 0; i < this.lastClip; ++i) {
                                visualDetailsArray3[i].update(this.clipList[i], this.clipTxList[i]);
                            }
                            ++n6;
                        }
                    } else if (matrix4f[n2] instanceof CustomRenderable) {
                        object2 = object3.getBounds();
                        n6 = this.findAllNodes((CustomRenderable)matrix4f[n2], n6, (BoundingVolume)object2);
                    }
                }
            } else if (matrix4f[n2] instanceof SingleCullable) {
                n6 = this.findNextNode((SingleCullable)matrix4f[n2], bl3, false, n6);
            } else if (matrix4f[n2] instanceof CustomCullable) {
                n6 = this.findAllNodes((CustomCullable)matrix4f[n2], n6);
            }
            if (!bl5) continue;
            --this.lastTxStack;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.lightList[--this.lastLight] = null;
        }
        for (n2 = 0; n2 < n5; ++n2) {
            this.clipList[--this.lastClip] = null;
        }
        if (bl4) {
            this.fogStack[this.lastFogStack] = null;
            --this.lastFogStack;
        }
        return n6;
    }

    private int findNextNode(SingleCullable singleCullable, boolean bl, boolean bl2, int n) {
        Cullable cullable;
        if (this.terminate) {
            return 0;
        }
        int n2 = n;
        Cullable cullable2 = singleCullable.getCullableChild();
        while (cullable2 != null && cullable2 instanceof SingleCullable) {
            cullable2 = ((SingleCullable)cullable2).getCullableChild();
        }
        boolean bl3 = cullable2 instanceof TransformCullable;
        if (bl3) {
            this.resizeStack();
            cullable = (TransformCullable)cullable2;
            cullable.getTransform(this.transformStack[this.lastTxStack + 1]);
            this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.transformStack[this.lastTxStack + 1]);
            ++this.lastTxStack;
        }
        if (cullable2 instanceof GroupCullable) {
            n2 = this.findAllNodes((GroupCullable)cullable2, bl, bl3, n2);
        } else if (cullable2 instanceof LeafCullable) {
            cullable = (LeafCullable)cullable2;
            if (cullable.getCullableType() == 4) {
                Renderable renderable = cullable.getRenderable();
                if (renderable instanceof ShapeRenderable) {
                    ShapeRenderable shapeRenderable = (ShapeRenderable)renderable;
                    if (shapeRenderable.isVisible()) {
                        CustomGeometryRenderable customGeometryRenderable;
                        GeometryRenderable geometryRenderable = shapeRenderable.getGeometryRenderable();
                        if (geometryRenderable instanceof CustomGeometryRenderable) {
                            customGeometryRenderable = (CustomGeometryRenderable)geometryRenderable;
                            this.workCullList[n2].customData = customGeometryRenderable.processCull(this.transformStack[this.lastTxStack], this.viewMatrix, this.frustumPlanes, this.angularResolution);
                        }
                        if (shapeRenderable.is2D()) {
                            this.resizeCullList(n);
                            this.workCullList[n2].renderable = renderable;
                            this.workCullList[n2].numLights = 0;
                            this.workCullList[n2].numClipPlanes = 0;
                            customGeometryRenderable = this.transformStack[this.lastTxStack];
                            this.workCullList[n2].transform.set((Matrix4f)customGeometryRenderable);
                            ++n2;
                        } else {
                            BoundingVolume boundingVolume;
                            if (this.checkOffscreens) {
                                this.checkForOffscreens((ShapeRenderable)renderable);
                            }
                            this.resizeCullList(n);
                            this.workCullList[n].renderable = renderable;
                            this.workCullList[n2].localFog = this.fogStack[this.lastFogStack];
                            customGeometryRenderable = this.transformStack[this.lastTxStack];
                            this.workCullList[n].transform.set((Matrix4f)customGeometryRenderable);
                            int n3 = this.workCullList[n].lights == null ? 0 : this.workCullList[n].lights.length;
                            int n4 = this.lastLight;
                            if (n3 < n4) {
                                VisualDetails[] visualDetailsArray = new VisualDetails[n4];
                                if (n3 != 0) {
                                    System.arraycopy(this.workCullList[n].lights, 0, visualDetailsArray, 0, n3);
                                }
                                for (int i = n3; i < n4; ++i) {
                                    visualDetailsArray[i] = new VisualDetails();
                                }
                                this.workCullList[n].lights = visualDetailsArray;
                            }
                            int n5 = 0;
                            this.workCullList[n2].cullableBounds = boundingVolume = cullable.getBounds();
                            VisualDetails[] visualDetailsArray = this.workCullList[n2].lights;
                            for (int i = 0; i < this.lastLight; ++i) {
                                BoundingVolume boundingVolume2 = this.lightList[i].getEffectBounds();
                                if (boundingVolume2 != null && !this.checkBoundsIntersect(boundingVolume, (Matrix4f)customGeometryRenderable, boundingVolume2, this.lightTxList[i])) continue;
                                visualDetailsArray[n5].update(this.lightList[i], this.lightTxList[i]);
                                ++n5;
                            }
                            this.workCullList[n2].numLights = n5;
                            int n6 = n3 = this.workCullList[n].clipPlanes == null ? 0 : this.workCullList[n].clipPlanes.length;
                            if (n3 < this.lastClip) {
                                VisualDetails[] visualDetailsArray2 = new VisualDetails[this.lastClip];
                                if (n3 != 0) {
                                    System.arraycopy(this.workCullList[n].clipPlanes, 0, visualDetailsArray2, 0, n3);
                                }
                                for (int i = n3; i < this.lastClip; ++i) {
                                    visualDetailsArray2[i] = new VisualDetails();
                                }
                                this.workCullList[n].clipPlanes = visualDetailsArray2;
                            }
                            VisualDetails[] visualDetailsArray3 = this.workCullList[n].clipPlanes;
                            this.workCullList[n].numClipPlanes = this.lastClip;
                            for (int i = 0; i < this.lastClip; ++i) {
                                visualDetailsArray3[i].update(this.clipList[i], this.clipTxList[i]);
                            }
                            ++n;
                            ++n2;
                        }
                    }
                } else if (cullable2 instanceof CustomRenderable) {
                    BoundingVolume boundingVolume = cullable.getBounds();
                    n2 = this.findAllNodes((CustomRenderable)((Object)cullable2), n2, boundingVolume);
                }
            }
        } else if (cullable2 instanceof CustomCullable) {
            n2 = this.findAllNodes((CustomCullable)cullable2, n2);
        }
        if (bl3) {
            --this.lastTxStack;
        }
        return n2;
    }

    private boolean checkBoundsIntersect(BoundingVolume boundingVolume, Matrix4f matrix4f, BoundingVolume boundingVolume2, float[] fArray) {
        return true;
    }

    private void updateFrustum(ViewEnvironmentCullable viewEnvironmentCullable, GraphicsEnvironmentData graphicsEnvironmentData) {
        viewEnvironmentCullable.getProjectionMatrix(this.projectionMatrix);
        this.prjMatrix.m00 = this.projectionMatrix[0];
        this.prjMatrix.m01 = this.projectionMatrix[1];
        this.prjMatrix.m02 = this.projectionMatrix[2];
        this.prjMatrix.m03 = this.projectionMatrix[3];
        this.prjMatrix.m10 = this.projectionMatrix[4];
        this.prjMatrix.m11 = this.projectionMatrix[5];
        this.prjMatrix.m12 = this.projectionMatrix[6];
        this.prjMatrix.m13 = this.projectionMatrix[7];
        this.prjMatrix.m20 = this.projectionMatrix[8];
        this.prjMatrix.m21 = this.projectionMatrix[9];
        this.prjMatrix.m22 = this.projectionMatrix[10];
        this.prjMatrix.m23 = this.projectionMatrix[11];
        this.prjMatrix.m30 = this.projectionMatrix[12];
        this.prjMatrix.m31 = this.projectionMatrix[13];
        this.prjMatrix.m32 = this.projectionMatrix[14];
        this.prjMatrix.m33 = this.projectionMatrix[15];
        this.matrixUtils.inverse(this.viewMatrix, this.viewMatrix);
        this.viewMatrix.mul(this.prjMatrix, this.viewMatrix);
        this.prjMatrix.m00 = this.viewMatrix.m00;
        this.prjMatrix.m01 = this.viewMatrix.m10;
        this.prjMatrix.m02 = this.viewMatrix.m20;
        this.prjMatrix.m03 = this.viewMatrix.m30;
        this.prjMatrix.m10 = this.viewMatrix.m01;
        this.prjMatrix.m11 = this.viewMatrix.m11;
        this.prjMatrix.m12 = this.viewMatrix.m21;
        this.prjMatrix.m13 = this.viewMatrix.m31;
        this.prjMatrix.m20 = this.viewMatrix.m02;
        this.prjMatrix.m21 = this.viewMatrix.m12;
        this.prjMatrix.m22 = this.viewMatrix.m22;
        this.prjMatrix.m23 = this.viewMatrix.m32;
        this.prjMatrix.m30 = this.viewMatrix.m03;
        this.prjMatrix.m31 = this.viewMatrix.m13;
        this.prjMatrix.m32 = this.viewMatrix.m23;
        this.prjMatrix.m33 = this.viewMatrix.m33;
        float f = this.prjMatrix.m03 - this.prjMatrix.m00;
        float f2 = this.prjMatrix.m13 - this.prjMatrix.m10;
        float f3 = this.prjMatrix.m23 - this.prjMatrix.m20;
        float f4 = this.prjMatrix.m33 - this.prjMatrix.m30;
        float f5 = 1.0f / (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        this.frustumPlanes[0].x = f * f5;
        this.frustumPlanes[0].y = f2 * f5;
        this.frustumPlanes[0].z = f3 * f5;
        this.frustumPlanes[0].w = f4 * f5;
        f = this.prjMatrix.m03 + this.prjMatrix.m00;
        f2 = this.prjMatrix.m13 + this.prjMatrix.m10;
        f3 = this.prjMatrix.m23 + this.prjMatrix.m20;
        f4 = this.prjMatrix.m33 + this.prjMatrix.m30;
        f5 = 1.0f / (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        this.frustumPlanes[1].x = f * f5;
        this.frustumPlanes[1].y = f2 * f5;
        this.frustumPlanes[1].z = f3 * f5;
        this.frustumPlanes[1].w = f4 * f5;
        f = this.prjMatrix.m03 + this.prjMatrix.m01;
        f2 = this.prjMatrix.m13 + this.prjMatrix.m11;
        f3 = this.prjMatrix.m23 + this.prjMatrix.m21;
        f4 = this.prjMatrix.m33 + this.prjMatrix.m31;
        f5 = 1.0f / (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        this.frustumPlanes[2].x = f * f5;
        this.frustumPlanes[2].y = f2 * f5;
        this.frustumPlanes[2].z = f3 * f5;
        this.frustumPlanes[2].w = f4 * f5;
        f = this.prjMatrix.m03 - this.prjMatrix.m01;
        f2 = this.prjMatrix.m13 - this.prjMatrix.m11;
        f3 = this.prjMatrix.m23 - this.prjMatrix.m21;
        f4 = this.prjMatrix.m33 - this.prjMatrix.m31;
        f5 = 1.0f / (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        this.frustumPlanes[3].x = f * f5;
        this.frustumPlanes[3].y = f2 * f5;
        this.frustumPlanes[3].z = f3 * f5;
        this.frustumPlanes[3].w = f4 * f5;
        f = this.prjMatrix.m03 - this.prjMatrix.m02;
        f2 = this.prjMatrix.m13 - this.prjMatrix.m12;
        f3 = this.prjMatrix.m23 - this.prjMatrix.m22;
        f4 = this.prjMatrix.m33 - this.prjMatrix.m32;
        f5 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        f5 = f5 == 0.0f ? 8388608.0f : 1.0f / f5;
        this.frustumPlanes[4].x = f * f5;
        this.frustumPlanes[4].y = f2 * f5;
        this.frustumPlanes[4].z = f3 * f5;
        this.frustumPlanes[4].w = f4 * f5;
        f = this.prjMatrix.m03 + this.prjMatrix.m02;
        f2 = this.prjMatrix.m13 + this.prjMatrix.m12;
        f3 = this.prjMatrix.m23 + this.prjMatrix.m22;
        f4 = this.prjMatrix.m33 + this.prjMatrix.m32;
        f5 = 1.0f / (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        this.frustumPlanes[5].x = f * f5;
        this.frustumPlanes[5].y = f2 * f5;
        this.frustumPlanes[5].z = f3 * f5;
        this.frustumPlanes[5].w = f4 * f5;
    }

    private final void resizeGlobalLightList() {
        if (this.lastGlobalLight + 1 == this.globalLightList.length) {
            int n = this.globalLightList.length;
            int n2 = n + 20;
            EffectRenderable[] effectRenderableArray = new EffectRenderable[n2];
            System.arraycopy(this.globalLightList, 0, effectRenderableArray, 0, n);
            this.globalLightList = effectRenderableArray;
            float[][] fArrayArray = new float[n2][];
            System.arraycopy(this.globalLightTxList, 0, fArrayArray, 0, n);
            for (int i = n; i < n2; ++i) {
                fArrayArray[i] = new float[16];
            }
            this.globalLightTxList = fArrayArray;
        }
    }

    private final void resizeGlobalBoundedLightList() {
        if (this.lastGlobalBoundedLight + 1 == this.globalBoundedLightList.length) {
            int n = this.globalBoundedLightList.length;
            int n2 = n + 20;
            Light[] lightArray = new Light[n2];
            System.arraycopy(this.globalBoundedLightList, 0, lightArray, 0, n);
            this.globalBoundedLightList = lightArray;
            float[][] fArrayArray = new float[n2][];
            System.arraycopy(this.globalBoundedLightTxList, 0, fArrayArray, 0, n);
            for (int i = n; i < n2; ++i) {
                fArrayArray[i] = new float[16];
            }
            this.globalBoundedLightTxList = fArrayArray;
        }
    }

    private void processGlobalLights(int n) {
        int n2 = this.lastGlobalLight + this.lastGlobalBoundedLight;
        if (n2 == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            int n3;
            VisualDetails[] visualDetailsArray;
            int n4;
            int n5;
            Renderable renderable = this.workCullList[i].renderable;
            boolean bl = false;
            if (renderable instanceof ShapeRenderable) {
                ShapeRenderable shapeRenderable = (ShapeRenderable)renderable;
                bl = shapeRenderable.isVisible() && !shapeRenderable.is2D();
            } else if (renderable instanceof CustomRenderable) {
                bl = true;
            }
            if (!bl) continue;
            int n6 = this.workCullList[i].lights == null ? 0 : this.workCullList[i].lights.length;
            if (n6 < (n5 = (n4 = this.workCullList[i].numLights) + n2)) {
                visualDetailsArray = new VisualDetails[n5];
                if (n6 != 0) {
                    System.arraycopy(this.workCullList[i].lights, 0, visualDetailsArray, 0, n6);
                }
                for (n3 = n6; n3 < n5; ++n3) {
                    visualDetailsArray[n3] = new VisualDetails();
                }
                this.workCullList[i].lights = visualDetailsArray;
            }
            visualDetailsArray = this.workCullList[i].lights;
            for (n3 = 0; n3 < this.lastGlobalLight; ++n3) {
                visualDetailsArray[n4].update(this.globalLightList[n3], this.globalLightTxList[n3]);
                ++n4;
            }
            for (n3 = 0; n3 < this.lastGlobalBoundedLight; ++n3) {
                if (!this.checkBoundsIntersect(this.workCullList[i].cullableBounds, this.workCullList[i].transform, this.globalBoundedLightList[n3].getEffectBounds(), this.globalBoundedLightTxList[n3])) continue;
                visualDetailsArray[n4].update(this.globalBoundedLightList[n3], this.globalBoundedLightTxList[n3]);
                ++n4;
            }
            this.workCullList[i].numLights = n4;
        }
    }
}

