/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline.graphics;

import org.j3d.aviatrix3d.pipeline.RenderableRequestData;
import org.j3d.aviatrix3d.pipeline.graphics.CullToSingleSortListener;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsCullStage;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsOutputDevice;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsProfilingData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsRenderPipeline;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsRequestData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsSortStage;
import org.j3d.aviatrix3d.pipeline.graphics.SortToSingleDrawListener;
import org.j3d.aviatrix3d.rendering.LayerCullable;

public class DefaultGraphicsPipeline
implements GraphicsRenderPipeline {
    private GraphicsCullStage culler;
    private GraphicsSortStage sorter;
    private GraphicsOutputDevice drawable;
    private CullToSingleSortListener ctsListener = new CullToSingleSortListener();
    private SortToSingleDrawListener stdListener = new SortToSingleDrawListener();
    private LayerCullable[] layers;
    private int numLayers;
    private float[] screenOrientation = new float[4];
    private float[] eyePoint = new float[3];
    private boolean useOrientation = false;
    private boolean useEyePoint = false;
    private boolean terminate = false;
    private GraphicsRequestData otherData;

    public DefaultGraphicsPipeline() {
        this.layers = new LayerCullable[1];
    }

    public DefaultGraphicsPipeline(GraphicsCullStage graphicsCullStage, GraphicsSortStage graphicsSortStage) {
        this();
        this.culler = graphicsCullStage;
        this.sorter = graphicsSortStage;
        if (graphicsCullStage != null) {
            graphicsCullStage.setCulledGeometryReceiver(this.ctsListener);
        }
        if (graphicsSortStage != null) {
            this.ctsListener.setSorter(graphicsSortStage);
            graphicsSortStage.setSortedGeometryReceiver(this.stdListener);
        }
    }

    public void setGraphicsOutputDevice(GraphicsOutputDevice graphicsOutputDevice) {
        this.stdListener.setGraphicsOutputDevice(graphicsOutputDevice);
        this.drawable = graphicsOutputDevice;
    }

    public GraphicsOutputDevice getGraphicsOutputDevice() {
        return this.drawable;
    }

    public void setEyePointOffset(float f, float f2, float f3) {
        if (this.culler != null) {
            this.culler.setEyePointOffset(f, f2, f3);
        }
        this.useEyePoint = true;
        this.eyePoint[0] = f;
        this.eyePoint[1] = f2;
        this.eyePoint[2] = f3;
    }

    public void setScreenOrientation(float f, float f2, float f3, float f4) throws IllegalArgumentException {
        if (this.culler != null) {
            this.culler.setScreenOrientation(f, f2, f3, f4);
        }
        this.useOrientation = true;
        this.screenOrientation[0] = f;
        this.screenOrientation[1] = f2;
        this.screenOrientation[2] = f3;
        this.screenOrientation[3] = f4;
    }

    public void setRequestData(RenderableRequestData renderableRequestData) {
        this.otherData = (GraphicsRequestData)renderableRequestData;
    }

    public boolean render() {
        if (this.numLayers == 0) {
            return true;
        }
        boolean bl = true;
        GraphicsProfilingData graphicsProfilingData = new GraphicsProfilingData();
        if (this.culler != null) {
            this.culler.cull(this.otherData, graphicsProfilingData, this.layers, this.numLayers);
            this.otherData = null;
            if (!this.terminate && this.drawable != null) {
                bl = this.drawable.draw(graphicsProfilingData);
            }
            if (!bl && !this.drawable.isDisposed()) {
                bl = true;
            }
        }
        return bl && !this.terminate;
    }

    public boolean displayOnly() {
        boolean bl = true;
        GraphicsProfilingData graphicsProfilingData = new GraphicsProfilingData();
        if (!this.terminate && this.numLayers != 0 && this.drawable != null) {
            bl = this.drawable.draw(graphicsProfilingData);
        }
        if (!bl && !this.drawable.isDisposed()) {
            bl = true;
        }
        return bl;
    }

    public void swapBuffers() {
        if (!this.terminate && this.drawable != null) {
            this.drawable.swap();
        }
    }

    public void setRenderableLayers(LayerCullable[] layerCullableArray, int n) {
        if (layerCullableArray != null) {
            if (this.layers.length < n) {
                this.layers = new LayerCullable[n];
            }
            System.arraycopy(layerCullableArray, 0, this.layers, 0, n);
        }
        this.numLayers = n;
    }

    public void halt() {
        this.terminate = true;
        if (this.culler != null) {
            this.culler.halt();
        }
        if (this.sorter != null) {
            this.sorter.halt();
        }
    }

    public void setSorter(GraphicsSortStage graphicsSortStage) {
        this.ctsListener.setSorter(graphicsSortStage);
        if (this.sorter != null) {
            this.sorter.setSortedGeometryReceiver(null);
        }
        if (graphicsSortStage != null) {
            graphicsSortStage.setSortedGeometryReceiver(this.stdListener);
        }
        this.sorter = graphicsSortStage;
    }

    public void setCuller(GraphicsCullStage graphicsCullStage) {
        if (this.culler != null) {
            this.culler.setCulledGeometryReceiver(null);
        }
        if (graphicsCullStage != null) {
            graphicsCullStage.setCulledGeometryReceiver(this.ctsListener);
            if (this.useEyePoint) {
                graphicsCullStage.setEyePointOffset(this.eyePoint[0], this.eyePoint[1], this.eyePoint[2]);
            }
            if (this.useOrientation) {
                graphicsCullStage.setScreenOrientation(this.screenOrientation[0], this.screenOrientation[1], this.screenOrientation[2], this.screenOrientation[3]);
            }
        }
        this.culler = graphicsCullStage;
    }
}

