/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline.graphics;

import java.util.HashMap;
import java.util.Stack;
import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.pipeline.graphics.BaseSortStage;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsCullOutputDetails;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsInstructions;
import org.j3d.aviatrix3d.pipeline.graphics.StateSortComparator;
import org.j3d.aviatrix3d.pipeline.graphics.VisualDetails;
import org.j3d.aviatrix3d.rendering.AppearanceAttributeRenderable;
import org.j3d.aviatrix3d.rendering.AppearanceRenderable;
import org.j3d.aviatrix3d.rendering.ComponentRenderable;
import org.j3d.aviatrix3d.rendering.CustomGeometryRenderable;
import org.j3d.aviatrix3d.rendering.CustomRenderable;
import org.j3d.aviatrix3d.rendering.GeometryRenderable;
import org.j3d.aviatrix3d.rendering.ObjectRenderable;
import org.j3d.aviatrix3d.rendering.Renderable;
import org.j3d.aviatrix3d.rendering.ShaderComponentRenderable;
import org.j3d.aviatrix3d.rendering.ShaderRenderable;
import org.j3d.aviatrix3d.rendering.ShapeRenderable;
import org.j3d.aviatrix3d.rendering.TextureRenderable;
import org.j3d.util.HashSet;

public abstract class BaseStateSortStage
extends BaseSortStage {
    protected static final int GUESS_NUM_COMPONENTS = 5;
    protected static final Integer[] TEX_IDS = new Integer[32];
    protected StateSortComparator stateComparator = new StateSortComparator();
    protected VisualDetails[] newLights;
    protected Stack<VisualDetails> currentLights = new Stack();
    protected Stack<VisualDetails> oldLights;
    protected Stack<VisualDetails> keepLights = new Stack();
    protected HashMap<VisualDetails, Integer> lightIdMap;
    protected VisualDetails[] newClipPlanes;
    protected Object[] clipTmp;
    protected HashSet currentClipPlanes;
    protected HashSet oldClipPlanes;
    protected HashSet keepClipPlanes;
    private HashMap<VisualDetails, Integer> clipIdMap;
    protected AppearanceRenderable currentAppearance;
    protected ObjectRenderable currentMaterial;
    protected AppearanceAttributeRenderable currentPolyAttr;
    protected AppearanceAttributeRenderable currentLineAttr;
    protected AppearanceAttributeRenderable currentPointAttr;
    protected AppearanceAttributeRenderable currentBlendAttr;
    protected AppearanceAttributeRenderable currentDepthAttr;
    protected AppearanceAttributeRenderable currentStencilAttr;
    protected ShaderRenderable currentShader;
    protected ComponentRenderable currentShaderArgs;
    protected Renderable currentFog;
    protected ComponentRenderable[] currentTextures;
    protected int numTextures;

    protected BaseStateSortStage(int n) {
        super(n);
        this.oldLights = new Stack();
        this.lightIdMap = new HashMap();
        this.newLights = new VisualDetails[32];
        this.currentClipPlanes = new HashSet();
        this.keepClipPlanes = new HashSet();
        this.oldClipPlanes = new HashSet();
        this.clipIdMap = new HashMap();
        this.clipTmp = new Object[24];
        this.newClipPlanes = new VisualDetails[32];
        this.currentTextures = new ComponentRenderable[32];
    }

    protected int appendObject(GraphicsCullOutputDetails graphicsCullOutputDetails, GraphicsInstructions graphicsInstructions, int n) {
        int n2 = n;
        n2 = this.appendLights(graphicsCullOutputDetails, graphicsInstructions, n2);
        n2 = this.appendClipPlanes(graphicsCullOutputDetails, graphicsInstructions, n2);
        n2 = this.updateFog(graphicsCullOutputDetails.localFog, graphicsInstructions, n2);
        if (graphicsCullOutputDetails.renderable instanceof ShapeRenderable) {
            ShapeRenderable shapeRenderable = (ShapeRenderable)graphicsCullOutputDetails.renderable;
            AppearanceRenderable appearanceRenderable = shapeRenderable.getAppearanceRenderable();
            GeometryRenderable geometryRenderable = shapeRenderable.getGeometryRenderable();
            if (this.currentAppearance != appearanceRenderable) {
                if (appearanceRenderable == null) {
                    n2 = this.cleanupVisuals(graphicsInstructions, n2);
                } else {
                    n2 = this.updateMaterial(appearanceRenderable, graphicsInstructions, n2);
                    n2 = this.updatePolyAttribs(appearanceRenderable, graphicsInstructions, n2);
                    n2 = this.updateLineAttribs(appearanceRenderable, graphicsInstructions, n2);
                    n2 = this.updatePointAttribs(appearanceRenderable, graphicsInstructions, n2);
                    n2 = this.updateBlendAttribs(appearanceRenderable, graphicsInstructions, n2);
                    n2 = this.updateDepthAttribs(appearanceRenderable, graphicsInstructions, n2);
                    n2 = this.updateStencilAttribs(appearanceRenderable, graphicsInstructions, n2);
                    n2 = this.updateTextures(appearanceRenderable, graphicsInstructions, n2);
                    n2 = this.updateShader(appearanceRenderable, graphicsInstructions, n2);
                }
                this.currentAppearance = appearanceRenderable;
            }
            graphicsInstructions.renderList[n2].renderable = geometryRenderable;
            Matrix4f matrix4f = graphicsCullOutputDetails.transform;
            if (!shapeRenderable.is2D()) {
                graphicsInstructions.renderList[n2].transform[0] = matrix4f.m00;
                graphicsInstructions.renderList[n2].transform[1] = matrix4f.m10;
                graphicsInstructions.renderList[n2].transform[2] = matrix4f.m20;
                graphicsInstructions.renderList[n2].transform[3] = matrix4f.m30;
                graphicsInstructions.renderList[n2].transform[4] = matrix4f.m01;
                graphicsInstructions.renderList[n2].transform[5] = matrix4f.m11;
                graphicsInstructions.renderList[n2].transform[6] = matrix4f.m21;
                graphicsInstructions.renderList[n2].transform[7] = matrix4f.m31;
                graphicsInstructions.renderList[n2].transform[8] = matrix4f.m02;
                graphicsInstructions.renderList[n2].transform[9] = matrix4f.m12;
                graphicsInstructions.renderList[n2].transform[10] = matrix4f.m22;
                graphicsInstructions.renderList[n2].transform[11] = matrix4f.m32;
                graphicsInstructions.renderList[n2].transform[12] = matrix4f.m03;
                graphicsInstructions.renderList[n2].transform[13] = matrix4f.m13;
                graphicsInstructions.renderList[n2].transform[14] = matrix4f.m23;
                graphicsInstructions.renderList[n2].transform[15] = matrix4f.m33;
                if (geometryRenderable instanceof CustomGeometryRenderable) {
                    graphicsInstructions.renderOps[n2] = 7;
                    graphicsInstructions.renderList[n2].instructions = graphicsCullOutputDetails.customData;
                } else {
                    graphicsInstructions.renderOps[n2] = 5;
                }
            } else {
                graphicsInstructions.renderList[n2].transform[0] = matrix4f.m00;
                graphicsInstructions.renderList[n2].transform[1] = 0.0f;
                graphicsInstructions.renderList[n2].transform[2] = 0.0f;
                graphicsInstructions.renderList[n2].transform[3] = matrix4f.m30;
                graphicsInstructions.renderList[n2].transform[4] = 0.0f;
                graphicsInstructions.renderList[n2].transform[5] = matrix4f.m11;
                graphicsInstructions.renderList[n2].transform[6] = 0.0f;
                graphicsInstructions.renderList[n2].transform[7] = matrix4f.m31;
                graphicsInstructions.renderList[n2].transform[8] = 0.0f;
                graphicsInstructions.renderList[n2].transform[9] = 0.0f;
                graphicsInstructions.renderList[n2].transform[10] = 0.0f;
                graphicsInstructions.renderList[n2].transform[11] = 0.0f;
                graphicsInstructions.renderList[n2].transform[12] = 0.0f;
                graphicsInstructions.renderList[n2].transform[13] = 0.0f;
                graphicsInstructions.renderList[n2].transform[14] = 0.0f;
                graphicsInstructions.renderList[n2].transform[15] = 0.0f;
                graphicsInstructions.renderOps[n2] = 6;
            }
            ++n2;
        } else if (graphicsCullOutputDetails.renderable instanceof CustomRenderable) {
            n2 = this.cleanupVisuals(graphicsInstructions, n2);
            graphicsInstructions.renderList[n2].renderable = graphicsCullOutputDetails.renderable;
            graphicsInstructions.renderList[n2].instructions = graphicsCullOutputDetails.customData;
            Matrix4f matrix4f = graphicsCullOutputDetails.transform;
            graphicsInstructions.renderList[n2].transform[0] = matrix4f.m00;
            graphicsInstructions.renderList[n2].transform[1] = matrix4f.m10;
            graphicsInstructions.renderList[n2].transform[2] = matrix4f.m20;
            graphicsInstructions.renderList[n2].transform[3] = matrix4f.m30;
            graphicsInstructions.renderList[n2].transform[4] = matrix4f.m01;
            graphicsInstructions.renderList[n2].transform[5] = matrix4f.m11;
            graphicsInstructions.renderList[n2].transform[6] = matrix4f.m21;
            graphicsInstructions.renderList[n2].transform[7] = matrix4f.m31;
            graphicsInstructions.renderList[n2].transform[8] = matrix4f.m02;
            graphicsInstructions.renderList[n2].transform[9] = matrix4f.m12;
            graphicsInstructions.renderList[n2].transform[10] = matrix4f.m22;
            graphicsInstructions.renderList[n2].transform[11] = matrix4f.m32;
            graphicsInstructions.renderList[n2].transform[12] = matrix4f.m03;
            graphicsInstructions.renderList[n2].transform[13] = matrix4f.m13;
            graphicsInstructions.renderList[n2].transform[14] = matrix4f.m23;
            graphicsInstructions.renderList[n2].transform[15] = matrix4f.m33;
            graphicsInstructions.renderOps[n2] = 9;
            ++n2;
        } else {
            System.out.println("Non-shape node in sorter " + graphicsCullOutputDetails.renderable);
        }
        return n2;
    }

    protected int appendLights(GraphicsCullOutputDetails graphicsCullOutputDetails, GraphicsInstructions graphicsInstructions, int n) {
        VisualDetails visualDetails;
        int n2;
        if (graphicsCullOutputDetails.numLights == 0 && this.currentLights.size() == 0) {
            return n;
        }
        int n3 = n;
        int n4 = 0;
        for (n2 = 0; n2 < graphicsCullOutputDetails.numLights; ++n2) {
            VisualDetails visualDetails2 = graphicsCullOutputDetails.lights[n2];
            if (this.currentLights.contains(visualDetails2)) {
                this.keepLights.add(visualDetails2);
                continue;
            }
            this.newLights[n4++] = visualDetails2;
        }
        this.oldLights.addAll(this.currentLights);
        this.currentLights.retainAll(this.keepLights);
        this.oldLights.removeAll(this.currentLights);
        this.keepLights.clear();
        n2 = this.oldLights.size();
        if (n2 != 0) {
            for (int i = 0; i < n2; ++i) {
                visualDetails = this.oldLights.pop();
                Integer n5 = this.lightIdMap.remove(visualDetails);
                graphicsInstructions.renderList[n3].renderable = visualDetails.getRenderable();
                graphicsInstructions.renderList[n3].id = n5;
                graphicsInstructions.renderOps[n3] = 13;
                ++n3;
            }
        }
        if (n4 != 0) {
            for (int i = 0; i < n4; ++i) {
                visualDetails = this.newLights[i];
                this.currentLights.add(visualDetails);
                graphicsInstructions.renderList[n3].renderable = visualDetails.getRenderable();
                System.arraycopy(visualDetails.getTransform(), 0, graphicsInstructions.renderList[n3].transform, 0, 16);
                this.lightIdMap.put(visualDetails, new Integer(this.lastGlobalId));
                ++this.lastGlobalId;
                graphicsInstructions.renderList[n3].id = graphicsInstructions.renderList[n3].id;
                graphicsInstructions.renderOps[n3] = 12;
                ++n3;
                this.newLights[i] = null;
            }
        }
        return n3;
    }

    protected int appendClipPlanes(GraphicsCullOutputDetails graphicsCullOutputDetails, GraphicsInstructions graphicsInstructions, int n) {
        VisualDetails visualDetails;
        int n2;
        if (graphicsCullOutputDetails.numClipPlanes == 0 && this.currentClipPlanes.size() == 0) {
            return n;
        }
        int n3 = n;
        int n4 = 0;
        for (n2 = 0; n2 < graphicsCullOutputDetails.numClipPlanes; ++n2) {
            VisualDetails visualDetails2 = graphicsCullOutputDetails.clipPlanes[n2];
            if (this.currentClipPlanes.contains((Object)visualDetails2)) {
                this.keepClipPlanes.add((Object)visualDetails2);
                continue;
            }
            this.newClipPlanes[n4++] = visualDetails2;
        }
        this.currentClipPlanes.retainAll(this.keepClipPlanes, this.oldClipPlanes);
        this.keepClipPlanes.clear();
        n2 = this.oldClipPlanes.size();
        if (n2 != 0) {
            if (n2 > this.clipTmp.length) {
                this.clipTmp = new Object[n2];
            }
            this.oldClipPlanes.toArray(this.clipTmp);
            this.oldClipPlanes.clear();
            for (int i = 0; i < n2; ++i) {
                visualDetails = (VisualDetails)this.clipTmp[i];
                Integer n5 = this.clipIdMap.remove(visualDetails);
                graphicsInstructions.renderList[n3].renderable = visualDetails.getRenderable();
                graphicsInstructions.renderList[n3].id = n5;
                graphicsInstructions.renderOps[n3] = 21;
                ++n3;
                this.clipTmp[i] = null;
            }
        }
        if (n4 != 0) {
            for (int i = 0; i < n4; ++i) {
                visualDetails = this.newClipPlanes[i];
                this.currentClipPlanes.add((Object)visualDetails);
                graphicsInstructions.renderList[n3].renderable = visualDetails.getRenderable();
                System.arraycopy(visualDetails.getTransform(), 0, graphicsInstructions.renderList[n3].transform, 0, 16);
                this.clipIdMap.put(visualDetails, new Integer(this.lastGlobalId));
                ++this.lastGlobalId;
                graphicsInstructions.renderList[n3].id = graphicsInstructions.renderList[n3].id;
                graphicsInstructions.renderOps[n3] = 20;
                ++n3;
                this.newClipPlanes[i] = null;
            }
        }
        return n3;
    }

    protected int updateFog(Renderable renderable, GraphicsInstructions graphicsInstructions, int n) {
        int n2 = n;
        if (renderable != this.currentFog) {
            if (renderable != null) {
                if (!((Object)renderable).equals(this.currentFog)) {
                    if (this.currentFog != null) {
                        graphicsInstructions.renderList[n2].renderable = this.currentFog;
                        graphicsInstructions.renderOps[n2] = 23;
                        ++n2;
                    }
                    graphicsInstructions.renderList[n2].renderable = renderable;
                    graphicsInstructions.renderOps[n2] = 22;
                    ++n2;
                }
                this.currentFog = renderable;
            } else {
                graphicsInstructions.renderList[n2].renderable = this.currentFog;
                graphicsInstructions.renderOps[n2] = 23;
                ++n2;
                this.currentFog = null;
            }
        }
        return n2;
    }

    protected int updateShader(AppearanceRenderable appearanceRenderable, GraphicsInstructions graphicsInstructions, int n) {
        ShaderRenderable shaderRenderable = appearanceRenderable.getShaderRenderable();
        if (shaderRenderable == this.currentShader) {
            return n;
        }
        int n2 = n;
        ShaderComponentRenderable shaderComponentRenderable = null;
        if (shaderRenderable == null) {
            shaderComponentRenderable = this.currentShader.getShaderRenderable(4);
            if (shaderComponentRenderable != null) {
                graphicsInstructions.renderList[n2].renderable = shaderComponentRenderable;
                graphicsInstructions.renderOps[n2] = 25;
                ++n2;
            } else {
                graphicsInstructions.renderList[n2].renderable = this.currentShader;
                graphicsInstructions.renderOps[n2] = 11;
                ++n2;
            }
            this.currentShader = null;
            this.currentShaderArgs = null;
            return n2;
        }
        shaderComponentRenderable = shaderRenderable.getShaderRenderable(4);
        if (shaderComponentRenderable != null) {
            Renderable renderable;
            if (this.currentShader != null && (renderable = this.currentShader.getShaderRenderable(4)) == null) {
                graphicsInstructions.renderList[n2].renderable = this.currentShader;
                graphicsInstructions.renderOps[n2] = 11;
                ++n2;
            }
            graphicsInstructions.renderList[n2].renderable = shaderComponentRenderable;
            graphicsInstructions.renderOps[n2] = 24;
            ++n2;
            renderable = shaderRenderable.getArgumentsRenderable();
            if (this.currentShaderArgs != renderable) {
                graphicsInstructions.renderList[n2].renderable = renderable;
                graphicsInstructions.renderOps[n2] = 26;
                ++n2;
                this.currentShaderArgs = renderable;
            }
        } else {
            Renderable renderable;
            if (this.currentShader != null && (renderable = this.currentShader.getShaderRenderable(4)) != null) {
                graphicsInstructions.renderList[n2].renderable = renderable;
                graphicsInstructions.renderOps[n2] = 25;
                ++n2;
            }
            graphicsInstructions.renderList[n2].renderable = shaderRenderable;
            graphicsInstructions.renderOps[n2] = 10;
            ++n2;
            renderable = shaderRenderable.getArgumentsRenderable();
            if (this.currentShaderArgs != renderable) {
                graphicsInstructions.renderList[n2].renderable = renderable;
                graphicsInstructions.renderOps[n2] = 26;
                ++n2;
                this.currentShaderArgs = renderable;
            }
        }
        this.currentShader = shaderRenderable;
        return n2;
    }

    protected int updateMaterial(AppearanceRenderable appearanceRenderable, GraphicsInstructions graphicsInstructions, int n) {
        int n2 = n;
        ObjectRenderable objectRenderable = appearanceRenderable.getMaterialRenderable();
        if (objectRenderable != this.currentMaterial) {
            if (objectRenderable != null) {
                if (!objectRenderable.equals(this.currentMaterial)) {
                    if (this.currentMaterial != null) {
                        graphicsInstructions.renderList[n2].renderable = this.currentMaterial;
                        graphicsInstructions.renderOps[n2] = 11;
                        ++n2;
                    }
                    graphicsInstructions.renderList[n2].renderable = objectRenderable;
                    graphicsInstructions.renderOps[n2] = 10;
                    ++n2;
                }
                this.currentMaterial = objectRenderable;
            } else {
                graphicsInstructions.renderList[n2].renderable = this.currentMaterial;
                graphicsInstructions.renderOps[n2] = 11;
                ++n2;
                this.currentMaterial = null;
            }
        }
        return n2;
    }

    protected int updatePolyAttribs(AppearanceRenderable appearanceRenderable, GraphicsInstructions graphicsInstructions, int n) {
        int n2 = n;
        AppearanceAttributeRenderable appearanceAttributeRenderable = appearanceRenderable.getAttributeRenderable(5);
        if (appearanceAttributeRenderable != this.currentPolyAttr) {
            if (appearanceAttributeRenderable != null) {
                if (!appearanceAttributeRenderable.equals(this.currentPolyAttr)) {
                    if (this.currentPolyAttr != null) {
                        graphicsInstructions.renderList[n2].renderable = this.currentPolyAttr;
                        graphicsInstructions.renderOps[n2] = 11;
                        ++n2;
                    }
                    graphicsInstructions.renderList[n2].renderable = appearanceAttributeRenderable;
                    graphicsInstructions.renderOps[n2] = 10;
                    ++n2;
                }
                this.currentPolyAttr = appearanceAttributeRenderable;
            } else {
                graphicsInstructions.renderList[n2].renderable = this.currentPolyAttr;
                graphicsInstructions.renderOps[n2] = 11;
                ++n2;
                this.currentPolyAttr = null;
            }
        }
        return n2;
    }

    protected int updateLineAttribs(AppearanceRenderable appearanceRenderable, GraphicsInstructions graphicsInstructions, int n) {
        int n2 = n;
        AppearanceAttributeRenderable appearanceAttributeRenderable = appearanceRenderable.getAttributeRenderable(3);
        if (appearanceAttributeRenderable != this.currentLineAttr) {
            if (appearanceAttributeRenderable != null) {
                if (!appearanceAttributeRenderable.equals(this.currentLineAttr)) {
                    if (this.currentLineAttr != null) {
                        graphicsInstructions.renderList[n2].renderable = this.currentLineAttr;
                        graphicsInstructions.renderOps[n2] = 11;
                        ++n2;
                    }
                    graphicsInstructions.renderList[n2].renderable = appearanceAttributeRenderable;
                    graphicsInstructions.renderOps[n2] = 10;
                    ++n2;
                }
                this.currentLineAttr = appearanceAttributeRenderable;
            } else {
                graphicsInstructions.renderList[n2].renderable = this.currentLineAttr;
                graphicsInstructions.renderOps[n2] = 11;
                ++n2;
                this.currentLineAttr = null;
            }
        }
        return n2;
    }

    protected int updateDepthAttribs(AppearanceRenderable appearanceRenderable, GraphicsInstructions graphicsInstructions, int n) {
        int n2 = n;
        AppearanceAttributeRenderable appearanceAttributeRenderable = appearanceRenderable.getAttributeRenderable(2);
        if (appearanceAttributeRenderable != this.currentDepthAttr) {
            if (appearanceAttributeRenderable != null) {
                if (!appearanceAttributeRenderable.equals(this.currentDepthAttr)) {
                    if (this.currentDepthAttr != null) {
                        graphicsInstructions.renderList[n2].renderable = this.currentDepthAttr;
                        graphicsInstructions.renderOps[n2] = 11;
                        ++n2;
                    }
                    graphicsInstructions.renderList[n2].renderable = appearanceAttributeRenderable;
                    graphicsInstructions.renderOps[n2] = 10;
                    ++n2;
                }
                this.currentDepthAttr = appearanceAttributeRenderable;
            } else {
                graphicsInstructions.renderList[n2].renderable = this.currentDepthAttr;
                graphicsInstructions.renderOps[n2] = 11;
                ++n2;
                this.currentDepthAttr = null;
            }
        }
        return n2;
    }

    protected int updateStencilAttribs(AppearanceRenderable appearanceRenderable, GraphicsInstructions graphicsInstructions, int n) {
        int n2 = n;
        AppearanceAttributeRenderable appearanceAttributeRenderable = appearanceRenderable.getAttributeRenderable(6);
        if (appearanceAttributeRenderable != this.currentStencilAttr) {
            if (appearanceAttributeRenderable != null) {
                if (!appearanceAttributeRenderable.equals(this.currentStencilAttr)) {
                    if (this.currentStencilAttr != null) {
                        graphicsInstructions.renderList[n2].renderable = this.currentStencilAttr;
                        graphicsInstructions.renderOps[n2] = 11;
                        ++n2;
                    }
                    graphicsInstructions.renderList[n2].renderable = appearanceAttributeRenderable;
                    graphicsInstructions.renderOps[n2] = 10;
                    ++n2;
                }
                this.currentStencilAttr = appearanceAttributeRenderable;
            } else {
                graphicsInstructions.renderList[n2].renderable = this.currentStencilAttr;
                graphicsInstructions.renderOps[n2] = 11;
                ++n2;
                this.currentStencilAttr = null;
            }
        }
        return n2;
    }

    protected int updatePointAttribs(AppearanceRenderable appearanceRenderable, GraphicsInstructions graphicsInstructions, int n) {
        int n2 = n;
        AppearanceAttributeRenderable appearanceAttributeRenderable = appearanceRenderable.getAttributeRenderable(4);
        if (appearanceAttributeRenderable != this.currentPointAttr) {
            if (appearanceAttributeRenderable != null) {
                if (!appearanceAttributeRenderable.equals(this.currentPointAttr)) {
                    if (this.currentPointAttr != null) {
                        graphicsInstructions.renderList[n2].renderable = this.currentPointAttr;
                        graphicsInstructions.renderOps[n2] = 11;
                        ++n2;
                    }
                    graphicsInstructions.renderList[n2].renderable = appearanceAttributeRenderable;
                    graphicsInstructions.renderOps[n2] = 10;
                    ++n2;
                }
                this.currentPointAttr = appearanceAttributeRenderable;
            } else {
                graphicsInstructions.renderList[n2].renderable = this.currentPointAttr;
                graphicsInstructions.renderOps[n2] = 11;
                ++n2;
                this.currentPointAttr = null;
            }
        }
        return n2;
    }

    protected int updateBlendAttribs(AppearanceRenderable appearanceRenderable, GraphicsInstructions graphicsInstructions, int n) {
        int n2 = n;
        AppearanceAttributeRenderable appearanceAttributeRenderable = appearanceRenderable.getAttributeRenderable(1);
        if (appearanceAttributeRenderable != this.currentBlendAttr) {
            if (appearanceAttributeRenderable != null) {
                if (!appearanceAttributeRenderable.equals(this.currentBlendAttr)) {
                    if (this.currentBlendAttr != null) {
                        graphicsInstructions.renderList[n2].renderable = this.currentBlendAttr;
                        graphicsInstructions.renderOps[n2] = 11;
                        ++n2;
                    }
                    graphicsInstructions.renderList[n2].renderable = appearanceAttributeRenderable;
                    graphicsInstructions.renderOps[n2] = 10;
                    ++n2;
                }
                this.currentBlendAttr = appearanceAttributeRenderable;
            } else {
                graphicsInstructions.renderList[n2].renderable = this.currentBlendAttr;
                graphicsInstructions.renderOps[n2] = 11;
                ++n2;
                this.currentBlendAttr = null;
            }
        }
        return n2;
    }

    protected int updateTextures(AppearanceRenderable appearanceRenderable, GraphicsInstructions graphicsInstructions, int n) {
        int n2 = n;
        int n3 = appearanceRenderable.numTextureRenderables();
        if (n3 != this.numTextures) {
            if (n3 == 0) {
                for (int i = 0; i < this.numTextures; ++i) {
                    graphicsInstructions.renderList[n2].renderable = this.currentTextures[i];
                    graphicsInstructions.renderList[n2].instructions = TEX_IDS[i];
                    graphicsInstructions.renderOps[n2] = 28;
                    ++n2;
                    this.currentTextures[i] = null;
                }
            } else if (this.numTextures == 0) {
                for (int i = 0; i < n3; ++i) {
                    TextureRenderable textureRenderable = appearanceRenderable.getTextureRenderable(i);
                    graphicsInstructions.renderList[n2].renderable = textureRenderable;
                    graphicsInstructions.renderList[n2].instructions = TEX_IDS[i];
                    graphicsInstructions.renderOps[n2] = 27;
                    ++n2;
                    this.currentTextures[i] = textureRenderable;
                }
            } else {
                TextureRenderable textureRenderable;
                int n4;
                int n5 = this.numTextures < n3 ? this.numTextures : n3;
                for (n4 = 0; n4 < n5; ++n4) {
                    textureRenderable = appearanceRenderable.getTextureRenderable(n4);
                    if (textureRenderable.equals(this.currentTextures[n4])) continue;
                    graphicsInstructions.renderList[n2].renderable = this.currentTextures[n4];
                    graphicsInstructions.renderList[n2].instructions = TEX_IDS[n4];
                    graphicsInstructions.renderOps[n2] = 28;
                    graphicsInstructions.renderList[++n2].renderable = textureRenderable;
                    graphicsInstructions.renderList[n2].instructions = TEX_IDS[n4];
                    graphicsInstructions.renderOps[n2] = 27;
                    ++n2;
                    this.currentTextures[n4] = textureRenderable;
                }
                if (this.numTextures < n3) {
                    for (n4 = n5; n4 < n3; ++n4) {
                        textureRenderable = appearanceRenderable.getTextureRenderable(n4);
                        graphicsInstructions.renderList[n2].renderable = textureRenderable;
                        graphicsInstructions.renderList[n2].instructions = TEX_IDS[n4];
                        graphicsInstructions.renderOps[n2] = 27;
                        ++n2;
                        this.currentTextures[n4] = textureRenderable;
                    }
                } else {
                    for (n4 = n5; n4 < this.numTextures; ++n4) {
                        graphicsInstructions.renderList[n2].renderable = this.currentTextures[n4];
                        graphicsInstructions.renderList[n2].instructions = TEX_IDS[n4];
                        graphicsInstructions.renderOps[n2] = 28;
                        ++n2;
                        this.currentTextures[n4] = null;
                    }
                }
            }
            this.numTextures = n3;
        } else if (n3 != 0) {
            if (n3 == 1) {
                TextureRenderable textureRenderable = appearanceRenderable.getTextureRenderable(0);
                if (!textureRenderable.equals(this.currentTextures[0])) {
                    graphicsInstructions.renderList[n2].renderable = this.currentTextures[0];
                    graphicsInstructions.renderList[n2].instructions = TEX_IDS[0];
                    graphicsInstructions.renderOps[n2] = 28;
                    graphicsInstructions.renderList[++n2].renderable = textureRenderable;
                    graphicsInstructions.renderList[n2].instructions = TEX_IDS[0];
                    graphicsInstructions.renderOps[n2] = 27;
                    ++n2;
                    this.currentTextures[0] = textureRenderable;
                }
            } else {
                for (int i = 0; i < this.numTextures; ++i) {
                    TextureRenderable textureRenderable = appearanceRenderable.getTextureRenderable(0);
                    if (textureRenderable.equals(this.currentTextures[i])) continue;
                    graphicsInstructions.renderList[n2].renderable = this.currentTextures[i];
                    graphicsInstructions.renderList[n2].instructions = TEX_IDS[i];
                    graphicsInstructions.renderOps[n2] = 28;
                    graphicsInstructions.renderList[++n2].renderable = textureRenderable;
                    graphicsInstructions.renderList[n2].instructions = TEX_IDS[i];
                    graphicsInstructions.renderOps[n2] = 27;
                    ++n2;
                    this.currentTextures[i] = textureRenderable;
                }
            }
        }
        return n2;
    }

    protected int cleanupObjects(GraphicsInstructions graphicsInstructions, int n) {
        Object object;
        int n2;
        int n3 = n;
        int n4 = this.currentLights.size();
        if (n4 != 0) {
            for (n2 = 0; n2 < n4; ++n2) {
                VisualDetails visualDetails = this.currentLights.pop();
                object = this.lightIdMap.remove(visualDetails);
                graphicsInstructions.renderList[n3].renderable = visualDetails.getRenderable();
                graphicsInstructions.renderList[n3].id = (Integer)object;
                graphicsInstructions.renderOps[n3] = 13;
                ++n3;
            }
        }
        if ((n2 = this.currentClipPlanes.size()) != 0) {
            if (n2 > this.clipTmp.length) {
                this.clipTmp = new Object[n2];
            }
            this.currentClipPlanes.toArray(this.clipTmp);
            this.currentClipPlanes.clear();
            for (int i = 0; i < n2; ++i) {
                object = (VisualDetails)this.clipTmp[i];
                Integer n5 = this.clipIdMap.remove(object);
                graphicsInstructions.renderList[n3].renderable = ((VisualDetails)object).getRenderable();
                graphicsInstructions.renderList[n3].id = n5;
                graphicsInstructions.renderOps[n3] = 21;
                ++n3;
                this.clipTmp[i] = null;
            }
        }
        return this.cleanupVisuals(graphicsInstructions, n3);
    }

    protected int cleanupVisuals(GraphicsInstructions graphicsInstructions, int n) {
        int n2 = n;
        if (this.currentMaterial != null) {
            graphicsInstructions.renderList[n2].renderable = this.currentMaterial;
            graphicsInstructions.renderOps[n2] = 11;
            ++n2;
            this.currentMaterial = null;
        }
        if (this.currentShader != null) {
            ShaderComponentRenderable shaderComponentRenderable = this.currentShader.getShaderRenderable(4);
            if (shaderComponentRenderable != null) {
                graphicsInstructions.renderList[n2].renderable = shaderComponentRenderable;
                graphicsInstructions.renderOps[n2] = 25;
                ++n2;
            } else {
                graphicsInstructions.renderList[n2].renderable = this.currentShader;
                graphicsInstructions.renderOps[n2] = 11;
                ++n2;
            }
            this.currentShader = null;
        }
        if (this.currentShaderArgs != null) {
            this.currentShaderArgs = null;
        }
        if (this.currentPolyAttr != null) {
            graphicsInstructions.renderList[n2].renderable = this.currentPolyAttr;
            graphicsInstructions.renderOps[n2] = 11;
            ++n2;
            this.currentPolyAttr = null;
        }
        if (this.currentLineAttr != null) {
            graphicsInstructions.renderList[n2].renderable = this.currentLineAttr;
            graphicsInstructions.renderOps[n2] = 11;
            ++n2;
            this.currentLineAttr = null;
        }
        if (this.currentPointAttr != null) {
            graphicsInstructions.renderList[n2].renderable = this.currentPointAttr;
            graphicsInstructions.renderOps[n2] = 11;
            ++n2;
            this.currentPointAttr = null;
        }
        if (this.currentBlendAttr != null) {
            graphicsInstructions.renderList[n2].renderable = this.currentBlendAttr;
            graphicsInstructions.renderOps[n2] = 11;
            ++n2;
            this.currentBlendAttr = null;
        }
        for (int i = 0; i < this.numTextures; ++i) {
            graphicsInstructions.renderList[n2].renderable = this.currentTextures[i];
            graphicsInstructions.renderList[n2].instructions = TEX_IDS[i];
            graphicsInstructions.renderOps[n2] = 28;
            ++n2;
            this.currentTextures[i] = null;
        }
        if (this.currentFog != null) {
            graphicsInstructions.renderList[n2].renderable = this.currentFog;
            graphicsInstructions.renderOps[n2] = 23;
            ++n2;
            this.currentFog = null;
        }
        this.numTextures = 0;
        this.currentAppearance = null;
        return n2;
    }

    static {
        for (int i = 0; i < 32; ++i) {
            BaseStateSortStage.TEX_IDS[i] = new Integer(33984 + i);
        }
    }
}

