/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline.graphics;

import java.util.HashMap;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsCullOutputDetails;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsDetails;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsEnvironmentData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsInstructions;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsProfilingData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsRequestData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsSortStage;
import org.j3d.aviatrix3d.pipeline.graphics.MultipassDetails;
import org.j3d.aviatrix3d.pipeline.graphics.MultipassRenderBucket;
import org.j3d.aviatrix3d.pipeline.graphics.SceneRenderBucket;
import org.j3d.aviatrix3d.pipeline.graphics.SortedGeometryReceiver;
import org.j3d.aviatrix3d.pipeline.graphics.ViewportCollection;
import org.j3d.aviatrix3d.pipeline.graphics.ViewportLayerCollection;
import org.j3d.aviatrix3d.rendering.BufferStateRenderable;
import org.j3d.aviatrix3d.rendering.OffscreenBufferRenderable;

public abstract class BaseSortStage
implements GraphicsSortStage {
    private static final int REALLOC_SIZE = 1024;
    protected static final int LIST_START_SIZE = 1;
    private SortedGeometryReceiver receiver;
    protected GraphicsInstructions[] commandList;
    protected int lastGlobalId;
    protected HashMap<OffscreenBufferRenderable, GraphicsInstructions> instructionMap;
    protected boolean terminate;

    protected BaseSortStage(int n) {
        this.commandList = new GraphicsInstructions[n];
        this.lastGlobalId = 0;
        for (int i = 0; i < n; ++i) {
            this.commandList[i] = new GraphicsInstructions();
        }
        this.instructionMap = new HashMap();
    }

    public void sort(GraphicsRequestData graphicsRequestData, GraphicsProfilingData graphicsProfilingData, ViewportCollection[][] viewportCollectionArray, int[] nArray, int n, OffscreenBufferRenderable[][] offscreenBufferRenderableArray) {
        int n2;
        long l = System.nanoTime();
        this.terminate = false;
        if (this.commandList.length < n) {
            GraphicsInstructions[] graphicsInstructionsArray = new GraphicsInstructions[n];
            System.arraycopy(this.commandList, 0, graphicsInstructionsArray, 0, this.commandList.length);
            for (n2 = this.commandList.length; n2 < n; ++n2) {
                graphicsInstructionsArray[n2] = new GraphicsInstructions();
            }
            this.commandList = graphicsInstructionsArray;
        }
        int n3 = 0;
        n2 = 0;
        for (int i = 0; i < n && !this.terminate; ++i) {
            this.commandList[i].ensureEnvDataCapacity(nArray[i]);
            if (offscreenBufferRenderableArray[i][0] == null) {
                n3 = i;
                continue;
            }
            this.commandList[n2].pbuffer = offscreenBufferRenderableArray[i][0];
            this.commandList[n2].parentSource = offscreenBufferRenderableArray[i][1];
            GraphicsInstructions graphicsInstructions = this.instructionMap.get(offscreenBufferRenderableArray[i][0]);
            if (graphicsInstructions != null) {
                this.commandList[n2].copyOf = graphicsInstructions;
            } else {
                this.commandList[n2].copyOf = null;
                this.sortSingleSurface(viewportCollectionArray[i], nArray[i], this.commandList[n2]);
                this.instructionMap.put(offscreenBufferRenderableArray[i][0], this.commandList[n2]);
            }
            ++n2;
        }
        if (this.terminate) {
            this.instructionMap.clear();
            return;
        }
        this.commandList[n2].pbuffer = null;
        this.sortSingleSurface(viewportCollectionArray[n3], nArray[n3], this.commandList[n2]);
        if (this.terminate) {
            this.instructionMap.clear();
            return;
        }
        graphicsProfilingData.sceneSortTime = System.nanoTime() - l;
        if (this.receiver != null) {
            this.receiver.sortedOutput(graphicsRequestData, graphicsProfilingData, this.commandList, n);
        }
        this.instructionMap.clear();
    }

    public void setSortedGeometryReceiver(SortedGeometryReceiver sortedGeometryReceiver) {
        this.receiver = sortedGeometryReceiver;
    }

    public void halt() {
        this.terminate = true;
    }

    protected abstract int sortNodes(GraphicsCullOutputDetails[] var1, int var2, GraphicsEnvironmentData var3, GraphicsInstructions var4, int var5);

    protected abstract int sort2DNodes(GraphicsCullOutputDetails[] var1, int var2, GraphicsEnvironmentData var3, GraphicsInstructions var4, int var5);

    protected abstract int estimateInstructionSize(SceneRenderBucket var1);

    protected abstract int estimateInstructionSize(MultipassRenderBucket var1);

    private void sortSingleSurface(ViewportCollection[] viewportCollectionArray, int n, GraphicsInstructions graphicsInstructions) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        this.checkInstructionCapacity(viewportCollectionArray, n, graphicsInstructions);
        for (n2 = 0; n2 < n && !this.terminate; ++n2) {
            for (int i = 0; i < viewportCollectionArray[n2].numViewports && !this.terminate; ++i) {
                ViewportLayerCollection viewportLayerCollection = viewportCollectionArray[n2].viewports[i];
                if (viewportLayerCollection.numBuckets == 0) continue;
                graphicsInstructions.renderOps[n3] = 31;
                graphicsInstructions.renderList[n3].clear();
                ++n3;
                int n5 = 0;
                int n6 = 0;
                for (int j = 0; j < viewportLayerCollection.numBuckets && !this.terminate; ++j) {
                    graphicsInstructions.renderOps[n3] = 29;
                    graphicsInstructions.renderList[n3].clear();
                    ++n3;
                    switch (viewportLayerCollection.sceneType[j]) {
                        case 1: {
                            SceneRenderBucket sceneRenderBucket = viewportLayerCollection.scenes[n5++];
                            graphicsInstructions.renderData[n4++] = sceneRenderBucket.data;
                            n3 = this.sortNodes(sceneRenderBucket.nodes, sceneRenderBucket.numNodes, sceneRenderBucket.data, graphicsInstructions, n3);
                            break;
                        }
                        case 2: {
                            MultipassDetails multipassDetails = viewportLayerCollection.multipass[n6].mainScene;
                            graphicsInstructions.renderData[n4++] = multipassDetails.globalData;
                            for (int k = 0; k < multipassDetails.numPasses; ++k) {
                                graphicsInstructions.renderData[n4++] = multipassDetails.data[k];
                            }
                            n3 = this.sortMultipassLayer(viewportLayerCollection.multipass[n6++], graphicsInstructions, n3);
                            break;
                        }
                        case 3: {
                            SceneRenderBucket sceneRenderBucket = viewportLayerCollection.scenes[n5++];
                            graphicsInstructions.renderData[n4++] = sceneRenderBucket.data;
                            n3 = this.sort2DNodes(sceneRenderBucket.nodes, sceneRenderBucket.numNodes, sceneRenderBucket.data, graphicsInstructions, n3);
                        }
                    }
                    graphicsInstructions.renderOps[n3] = 30;
                    graphicsInstructions.renderList[n3].clear();
                    ++n3;
                }
                graphicsInstructions.renderOps[n3] = 32;
                graphicsInstructions.renderList[n3].clear();
                ++n3;
            }
        }
        graphicsInstructions.numValid = n3;
        for (n2 = n3; n2 < graphicsInstructions.renderList.length; ++n2) {
            graphicsInstructions.renderList[n2].clear();
        }
    }

    private void checkInstructionCapacity(ViewportCollection[] viewportCollectionArray, int n, GraphicsInstructions graphicsInstructions) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (n2 = 0; n2 < viewportCollectionArray[i].numViewports; ++n2) {
                int n5;
                ViewportLayerCollection viewportLayerCollection = viewportCollectionArray[i].viewports[n2];
                n3 += 2;
                n4 += viewportLayerCollection.numScenes;
                for (n5 = 0; n5 < viewportLayerCollection.numScenes; ++n5) {
                    n3 += this.estimateInstructionSize(viewportLayerCollection.scenes[n5]);
                }
                if (viewportLayerCollection.numMultipass != 0) {
                    n3 += 2;
                }
                for (n5 = 0; n5 < viewportLayerCollection.numMultipass; ++n5) {
                    n3 += this.estimateInstructionSize(viewportLayerCollection.multipass[n5]);
                    n4 += viewportLayerCollection.multipass[n5].mainScene.numPasses + 1;
                }
            }
        }
        if (this.terminate) {
            return;
        }
        if (graphicsInstructions.renderList.length < n3) {
            GraphicsDetails[] graphicsDetailsArray = new GraphicsDetails[n3];
            System.arraycopy(graphicsInstructions.renderList, 0, graphicsDetailsArray, 0, graphicsInstructions.renderList.length);
            for (n2 = graphicsInstructions.renderList.length; n2 < n3; ++n2) {
                graphicsDetailsArray[n2] = new GraphicsDetails();
            }
            graphicsInstructions.renderList = graphicsDetailsArray;
            graphicsInstructions.renderOps = new int[n3];
        }
        if (this.terminate) {
            return;
        }
        if (graphicsInstructions.renderData.length < n4) {
            GraphicsEnvironmentData[] graphicsEnvironmentDataArray = new GraphicsEnvironmentData[n4];
            System.arraycopy(graphicsInstructions.renderData, 0, graphicsEnvironmentDataArray, 0, graphicsInstructions.renderData.length);
            for (n2 = graphicsInstructions.renderData.length; n2 < n4; ++n2) {
                graphicsEnvironmentDataArray[n2] = new GraphicsEnvironmentData();
            }
            graphicsInstructions.renderData = graphicsEnvironmentDataArray;
        }
    }

    protected void realloc(GraphicsInstructions graphicsInstructions, int n) {
        if (n < graphicsInstructions.renderList.length) {
            n = graphicsInstructions.renderList.length + 1024;
        } else if (n - graphicsInstructions.renderList.length < 1024) {
            n += 1024;
        }
        GraphicsDetails[] graphicsDetailsArray = new GraphicsDetails[n];
        int[] nArray = new int[n];
        System.arraycopy(graphicsInstructions.renderList, 0, graphicsDetailsArray, 0, graphicsInstructions.renderList.length);
        System.arraycopy(graphicsInstructions.renderOps, 0, nArray, 0, graphicsInstructions.renderOps.length);
        for (int i = graphicsInstructions.renderList.length; i < n; ++i) {
            graphicsDetailsArray[i] = new GraphicsDetails();
        }
        graphicsInstructions.renderList = graphicsDetailsArray;
        graphicsInstructions.renderOps = nArray;
    }

    private int sortMultipassLayer(MultipassRenderBucket multipassRenderBucket, GraphicsInstructions graphicsInstructions, int n) {
        MultipassDetails multipassDetails = multipassRenderBucket.mainScene;
        int n2 = n;
        graphicsInstructions.renderOps[n2] = 33;
        graphicsInstructions.renderList[n2].clear();
        ++n2;
        BufferStateRenderable bufferStateRenderable = null;
        BufferStateRenderable bufferStateRenderable2 = null;
        BufferStateRenderable bufferStateRenderable3 = null;
        BufferStateRenderable bufferStateRenderable4 = null;
        for (int i = 0; i < multipassDetails.numPasses && !this.terminate; ++i) {
            if (multipassDetails.buffers[i].colorBufferState != null) {
                if (bufferStateRenderable == null) {
                    graphicsInstructions.renderOps[n2] = 35;
                    graphicsInstructions.renderList[n2].renderable = multipassDetails.buffers[i].colorBufferState;
                    ++n2;
                } else if (!multipassDetails.buffers[i].colorBufferState.equals(bufferStateRenderable)) {
                    graphicsInstructions.renderOps[n2] = 37;
                    graphicsInstructions.renderList[n2].renderable = multipassDetails.buffers[i].colorBufferState;
                    ++n2;
                }
            } else if (bufferStateRenderable != null) {
                graphicsInstructions.renderOps[n2] = 38;
                graphicsInstructions.renderList[n2].renderable = bufferStateRenderable;
                ++n2;
            }
            if (multipassDetails.buffers[i].stencilBufferState != null) {
                if (bufferStateRenderable2 == null) {
                    graphicsInstructions.renderOps[n2] = 35;
                    graphicsInstructions.renderList[n2].renderable = multipassDetails.buffers[i].stencilBufferState;
                    ++n2;
                } else if (!multipassDetails.buffers[i].stencilBufferState.equals(bufferStateRenderable2)) {
                    graphicsInstructions.renderOps[n2] = 37;
                    graphicsInstructions.renderList[n2].renderable = multipassDetails.buffers[i].stencilBufferState;
                    ++n2;
                }
            } else if (bufferStateRenderable2 != null) {
                graphicsInstructions.renderOps[n2] = 38;
                graphicsInstructions.renderList[n2].renderable = bufferStateRenderable2;
                ++n2;
            }
            if (multipassDetails.buffers[i].depthBufferState != null) {
                if (bufferStateRenderable3 == null) {
                    graphicsInstructions.renderOps[n2] = 35;
                    graphicsInstructions.renderList[n2].renderable = multipassDetails.buffers[i].depthBufferState;
                    ++n2;
                } else if (!multipassDetails.buffers[i].depthBufferState.equals(bufferStateRenderable3)) {
                    graphicsInstructions.renderOps[n2] = 37;
                    graphicsInstructions.renderList[n2].renderable = multipassDetails.buffers[i].depthBufferState;
                    ++n2;
                }
            } else if (bufferStateRenderable3 != null) {
                graphicsInstructions.renderOps[n2] = 38;
                graphicsInstructions.renderList[n2].renderable = bufferStateRenderable3;
                ++n2;
            }
            if (multipassDetails.buffers[i].accumBufferState != null) {
                if (bufferStateRenderable4 != null && multipassDetails.buffers[i].accumBufferState.checkClearBufferState()) {
                    graphicsInstructions.renderOps[n2] = 38;
                    graphicsInstructions.renderList[n2].renderable = multipassDetails.buffers[i].accumBufferState;
                    ++n2;
                }
                if (bufferStateRenderable4 == null) {
                    graphicsInstructions.renderOps[n2] = 35;
                    graphicsInstructions.renderList[n2].renderable = multipassDetails.buffers[i].accumBufferState;
                    ++n2;
                } else {
                    graphicsInstructions.renderOps[n2] = 36;
                    graphicsInstructions.renderList[n2].renderable = multipassDetails.buffers[i].accumBufferState;
                    ++n2;
                }
            }
            bufferStateRenderable = multipassDetails.buffers[i].colorBufferState;
            bufferStateRenderable3 = multipassDetails.buffers[i].depthBufferState;
            bufferStateRenderable2 = multipassDetails.buffers[i].stencilBufferState;
            graphicsInstructions.renderOps[n2] = 34;
            graphicsInstructions.renderList[n2].clear();
            ++n2;
            n2 = this.sortNodes(multipassDetails.nodes[i], multipassDetails.numNodes[i], multipassDetails.data[i], graphicsInstructions, n2);
            graphicsInstructions.renderOps[n2] = 39;
            graphicsInstructions.renderList[n2].clear();
            ++n2;
            if (multipassDetails.buffers[i].accumBufferState != null) {
                graphicsInstructions.renderOps[n2] = 37;
                graphicsInstructions.renderList[n2].renderable = multipassDetails.buffers[i].accumBufferState;
                ++n2;
            } else if (bufferStateRenderable4 != null) {
                graphicsInstructions.renderOps[n2] = 38;
                graphicsInstructions.renderList[n2].renderable = bufferStateRenderable4;
                ++n2;
            }
            bufferStateRenderable4 = multipassDetails.buffers[i].accumBufferState;
        }
        if (bufferStateRenderable != null) {
            graphicsInstructions.renderOps[n2] = 38;
            graphicsInstructions.renderList[n2].renderable = bufferStateRenderable;
            ++n2;
        }
        if (bufferStateRenderable3 != null) {
            graphicsInstructions.renderOps[n2] = 38;
            graphicsInstructions.renderList[n2].renderable = bufferStateRenderable3;
            ++n2;
        }
        if (bufferStateRenderable2 != null) {
            graphicsInstructions.renderOps[n2] = 38;
            graphicsInstructions.renderList[n2].renderable = bufferStateRenderable2;
            ++n2;
        }
        if (bufferStateRenderable4 != null) {
            graphicsInstructions.renderOps[n2] = 38;
            graphicsInstructions.renderList[n2].renderable = bufferStateRenderable4;
            ++n2;
        }
        graphicsInstructions.renderOps[n2] = 40;
        graphicsInstructions.renderList[n2].clear();
        return ++n2;
    }
}

