/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline.graphics;

import java.util.ArrayList;
import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.pipeline.RenderableRequestData;
import org.j3d.aviatrix3d.pipeline.graphics.BufferDetails;
import org.j3d.aviatrix3d.pipeline.graphics.CulledGeometryReceiver;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsCullOutputDetails;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsCullStage;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsEnvironmentData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsProfilingData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsRequestData;
import org.j3d.aviatrix3d.pipeline.graphics.SceneRenderBucket;
import org.j3d.aviatrix3d.pipeline.graphics.ViewportCollection;
import org.j3d.aviatrix3d.pipeline.graphics.ViewportLayerCollection;
import org.j3d.aviatrix3d.rendering.AppearanceRenderable;
import org.j3d.aviatrix3d.rendering.Cullable;
import org.j3d.aviatrix3d.rendering.EffectRenderable;
import org.j3d.aviatrix3d.rendering.EnvironmentCullable;
import org.j3d.aviatrix3d.rendering.GroupCullable;
import org.j3d.aviatrix3d.rendering.LayerCullable;
import org.j3d.aviatrix3d.rendering.LeafCullable;
import org.j3d.aviatrix3d.rendering.ObjectRenderable;
import org.j3d.aviatrix3d.rendering.OffscreenBufferRenderable;
import org.j3d.aviatrix3d.rendering.OffscreenCullable;
import org.j3d.aviatrix3d.rendering.ProfilingData;
import org.j3d.aviatrix3d.rendering.RenderPassCullable;
import org.j3d.aviatrix3d.rendering.SceneCullable;
import org.j3d.aviatrix3d.rendering.ShapeRenderable;
import org.j3d.aviatrix3d.rendering.SingleCullable;
import org.j3d.aviatrix3d.rendering.TextureRenderable;
import org.j3d.aviatrix3d.rendering.TransformCullable;
import org.j3d.aviatrix3d.rendering.ViewEnvironmentCullable;
import org.j3d.aviatrix3d.rendering.ViewportCullable;
import org.j3d.aviatrix3d.rendering.ViewportLayerCullable;
import org.j3d.util.HashSet;
import org.j3d.util.MatrixUtils;

public abstract class BaseCullStage
implements GraphicsCullStage {
    protected static final String SHARED_VP_MSG = "The path from the root of the scene graph to the viewpoint contains a SharedGroup or SharedNode instance. This is not permitted.";
    private static final int TRANSFORM_DEPTH_SIZE = 64;
    private static final int STACK_INCREMENT = 32;
    protected static final int LIST_START_LENGTH = 1;
    protected static final int LIST_INCREMENT = 20;
    protected static final int LIGHT_START_SIZE = 32;
    protected static final int LIGHT_INCREMENT = 8;
    protected boolean checkOffscreens;
    protected OffscreenCullable[] pendingSubscenes;
    protected OffscreenCullable[] pendingParents;
    protected int lastSubscene;
    protected ViewportCollection[][] workLayers;
    protected ViewportCollection[][] outputLayers;
    protected int[] workLayerCounts;
    protected int[] outputLayerCounts;
    protected int lastOutputLayer;
    protected OffscreenBufferRenderable[][] validSceneParents;
    protected OffscreenBufferRenderable[][] outputSceneParents;
    protected GraphicsCullOutputDetails[] workCullList;
    protected int lastOutputList;
    protected Matrix4f[] transformStack;
    protected int lastTxStack;
    protected EffectRenderable[] fogStack;
    protected int lastFogStack;
    protected EffectRenderable[] lightList;
    protected float[][] lightTxList;
    protected int lastLight;
    protected EffectRenderable[] clipList;
    protected float[][] clipTxList;
    protected int lastClip;
    protected HashSet processedPBufferTextures;
    protected HashSet visitedNodes;
    protected CulledGeometryReceiver receiver;
    protected OffscreenCullable activeParent;
    protected ArrayList<Cullable> currentViewpointPath;
    protected Matrix4f viewMatrix1;
    protected Matrix4f viewMatrix2;
    protected Matrix4f orientationMatrix;
    protected float[] screenOrientation;
    protected float[] eyePoint;
    protected boolean useOrientation;
    protected boolean useEyePoint;
    protected boolean terminate;
    protected LayerCullable[] layersTmp;
    protected MatrixUtils matrixUtils;

    public BaseCullStage(int n) {
        int n2;
        this.validSceneParents = new OffscreenBufferRenderable[n][2];
        this.outputSceneParents = new OffscreenBufferRenderable[n][2];
        this.pendingSubscenes = new OffscreenCullable[n];
        this.pendingParents = new OffscreenCullable[n];
        this.workLayers = new ViewportCollection[n][1];
        this.workLayerCounts = new int[n];
        this.outputLayers = new ViewportCollection[n][1];
        this.outputLayerCounts = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            this.workLayers[n2][0] = new ViewportCollection();
        }
        this.layersTmp = new LayerCullable[1];
        this.processedPBufferTextures = new HashSet();
        this.visitedNodes = new HashSet();
        this.currentViewpointPath = new ArrayList(64);
        this.viewMatrix1 = new Matrix4f();
        this.viewMatrix2 = new Matrix4f();
        this.orientationMatrix = new Matrix4f();
        this.orientationMatrix.setIdentity();
        this.screenOrientation = new float[4];
        this.eyePoint = new float[3];
        this.useEyePoint = false;
        this.useOrientation = false;
        this.transformStack = new Matrix4f[64];
        for (n2 = 0; n2 < 64; ++n2) {
            this.transformStack[n2] = new Matrix4f();
        }
        this.fogStack = new EffectRenderable[64];
        this.lightList = new EffectRenderable[32];
        this.lightTxList = new float[32][16];
        this.clipList = new EffectRenderable[32];
        this.clipTxList = new float[32][16];
        this.checkOffscreens = true;
        this.matrixUtils = new MatrixUtils();
    }

    public void cull(RenderableRequestData renderableRequestData, ProfilingData profilingData, LayerCullable[] layerCullableArray, int n) {
        int n2;
        int n3;
        long l = System.nanoTime();
        this.terminate = false;
        if (this.workLayers[0].length < n) {
            this.workLayers = new ViewportCollection[1][n];
            for (n3 = 0; n3 < n; ++n3) {
                this.workLayers[0][n3] = new ViewportCollection();
            }
            this.workLayerCounts = new int[n];
        }
        n3 = 0;
        this.lastOutputLayer = 0;
        this.lastOutputList = 0;
        this.lastSubscene = 0;
        for (n2 = 0; n2 < n && !this.terminate; ++n2) {
            if (layerCullableArray[n2] == null) continue;
            LayerCullable layerCullable = layerCullableArray[n2];
            this.processLayer(layerCullable, 0, n2);
            ++n3;
        }
        this.workLayerCounts[0] = n3;
        ++this.lastOutputLayer;
        if (this.checkOffscreens) {
            this.resizeOutputLists();
            for (n2 = 0; n2 < this.lastSubscene && !this.terminate; ++n2) {
                this.activeParent = this.pendingSubscenes[n2];
                this.visitedNodes.clear();
                n3 = 0;
                if (this.processedPBufferTextures.contains((Object)this.pendingSubscenes[n2])) {
                    this.validSceneParents[this.lastOutputList][0] = this.pendingSubscenes[n2].getOffscreenRenderable();
                    this.validSceneParents[this.lastOutputList][1] = this.pendingParents[n2].getOffscreenRenderable();
                } else {
                    int n4 = this.pendingSubscenes[n2].numCullableChildren();
                    for (int i = 0; i < n4; ++i) {
                        LayerCullable layerCullable = this.pendingSubscenes[n2].getCullableLayer(i);
                        this.lastLight = 0;
                        this.lastClip = 0;
                        this.lastTxStack = 0;
                        this.lastFogStack = 0;
                        this.processLayer(layerCullable, n2 + 1, i);
                        ++n3;
                    }
                    this.processedPBufferTextures.add((Object)this.pendingSubscenes[n2]);
                    this.validSceneParents[this.lastOutputList][0] = this.pendingSubscenes[n2].getOffscreenRenderable();
                    this.validSceneParents[this.lastOutputList][1] = this.pendingParents[n2].getOffscreenRenderable();
                }
                this.workLayerCounts[this.lastOutputLayer] = n3;
                ++this.lastOutputLayer;
                ++this.lastOutputList;
            }
            if (this.outputSceneParents.length < this.lastOutputList) {
                this.outputSceneParents = new OffscreenBufferRenderable[this.lastOutputList][2];
            }
            for (n2 = 0; n2 < this.lastOutputList; ++n2) {
                this.outputSceneParents[n2][0] = this.validSceneParents[this.lastOutputList - n2 - 1][0];
                this.outputSceneParents[n2][1] = this.validSceneParents[this.lastOutputList - n2 - 1][1];
            }
            if (this.outputLayers.length < this.lastOutputLayer) {
                this.outputLayers = new ViewportCollection[this.lastOutputLayer][];
                this.outputLayerCounts = new int[this.lastOutputLayer];
            }
            for (n2 = 0; n2 < this.lastOutputLayer; ++n2) {
                this.outputLayers[n2] = this.workLayers[this.lastOutputLayer - n2 - 1];
                this.outputLayerCounts[n2] = this.workLayerCounts[this.lastOutputLayer - n2 - 1];
            }
        } else {
            this.outputSceneParents[0][0] = this.validSceneParents[0][0];
            this.outputSceneParents[0][1] = this.validSceneParents[0][1];
            this.outputLayers[0] = this.workLayers[0];
            this.outputLayerCounts[0] = this.workLayerCounts[0];
        }
        this.processedPBufferTextures.clear();
        this.cleanupOldRefs();
        profilingData.sceneCullTime = System.nanoTime() - l;
        if (this.receiver != null && !this.terminate) {
            this.receiver.culledOutput((GraphicsRequestData)renderableRequestData, (GraphicsProfilingData)profilingData, this.outputLayers, this.outputLayerCounts, this.lastOutputLayer, this.outputSceneParents);
        }
    }

    public void setCulledGeometryReceiver(CulledGeometryReceiver culledGeometryReceiver) {
        this.receiver = culledGeometryReceiver;
    }

    public void setOffscreenCheckEnabled(boolean bl) {
        this.checkOffscreens = bl;
    }

    public boolean isOffscreenCheckEnabled() {
        return this.checkOffscreens;
    }

    public void setEyePointOffset(float f, float f2, float f3) {
        this.useEyePoint = true;
        this.eyePoint[0] = f;
        this.eyePoint[1] = f2;
        this.eyePoint[2] = f3;
    }

    public void setScreenOrientation(float f, float f2, float f3, float f4) throws IllegalArgumentException {
        float f5 = f * f + f2 * f2 + f3 * f3;
        if (f5 == 0.0f) {
            throw new IllegalArgumentException("Zero length axis vector");
        }
        this.useOrientation = true;
        this.screenOrientation[0] = f;
        this.screenOrientation[1] = f2;
        this.screenOrientation[2] = f3;
        this.screenOrientation[3] = f4;
        double d = Math.cos(f4);
        double d2 = Math.sin(f4);
        this.orientationMatrix.m00 = (float)(d + (double)(f * f) * (1.0 - d));
        this.orientationMatrix.m01 = (float)((double)f3 * d2 + (double)(f2 * f) * (1.0 - d));
        this.orientationMatrix.m02 = (float)((double)(-f2) * d2 + (double)(f3 * f) * (1.0 - d));
        this.orientationMatrix.m10 = (float)((double)(-f3) * d2 + (double)(f * f2) * (1.0 - d));
        this.orientationMatrix.m11 = (float)(d + (double)(f2 * f2) * (1.0 - d));
        this.orientationMatrix.m12 = (float)((double)f * d2 + (double)(f3 * f2) * (1.0 - d));
        this.orientationMatrix.m20 = (float)((double)f2 * d2 + (double)(f * f3) * (1.0 - d));
        this.orientationMatrix.m21 = (float)((double)(-f) * d2 + (double)(f2 * f3) * (1.0 - d));
        this.orientationMatrix.m22 = (float)(d + (double)(f3 * f3) * (1.0 - d));
    }

    public void halt() {
        this.terminate = true;
    }

    protected abstract void cullScene(RenderPassCullable var1, int var2, int var3, int var4, int var5);

    protected abstract void cullScene2D(RenderPassCullable var1, int var2, int var3, int var4, int var5);

    protected abstract void cullRenderPass(RenderPassCullable var1, int var2, int var3, int var4, int var5, int var6);

    protected void processLayer(LayerCullable layerCullable, int n, int n2) {
        if (layerCullable == null) {
            return;
        }
        int n3 = layerCullable.numCullableChildren();
        this.workLayers[n][n2].ensureCapacity(n3);
        this.workLayers[n][n2].numViewports = 0;
        for (int i = 0; i < n3; ++i) {
            ViewportCullable viewportCullable = layerCullable.getCullableViewport(i);
            this.cullViewport(viewportCullable, n, n2, i);
            ++this.workLayers[n][n2].numViewports;
        }
    }

    protected void cullViewport(ViewportCullable viewportCullable, int n, int n2, int n3) {
        if (viewportCullable == null || !viewportCullable.isValid()) {
            return;
        }
        int n4 = viewportCullable.numCullableChildren();
        ViewportLayerCollection viewportLayerCollection = this.workLayers[n][n2].viewports[n3];
        viewportLayerCollection.ensureSceneCapacity(n4);
        viewportLayerCollection.numBuckets = 0;
        viewportLayerCollection.numScenes = 0;
        viewportLayerCollection.numMultipass = 0;
        for (int i = 0; i < n4; ++i) {
            ViewportLayerCullable viewportLayerCullable = viewportCullable.getCullableLayer(i);
            if (viewportLayerCullable.isMultipassViewport()) {
                this.cullMultipassViewportLayer(viewportLayerCullable.getCullableScene(), n, n2, n3, i);
                continue;
            }
            this.cullSingleViewportLayer(viewportLayerCullable.getCullableScene(), n, n2, n3, i);
        }
    }

    protected void cullSingleViewportLayer(SceneCullable sceneCullable, int n, int n2, int n3, int n4) {
        ViewportLayerCollection viewportLayerCollection = this.workLayers[n][n2].viewports[n3];
        viewportLayerCollection.ensureSceneCapacity(1);
        viewportLayerCollection.scenes[n4].ensureCapacity(1);
        RenderPassCullable renderPassCullable = sceneCullable.getCullablePass(0);
        if (renderPassCullable.is2D()) {
            this.fill2DEnvData(sceneCullable, viewportLayerCollection.scenes[n4].data);
            viewportLayerCollection.sceneType[viewportLayerCollection.numBuckets] = 3;
            this.cullScene2D(renderPassCullable, n, n2, n3, n4);
        } else {
            this.fillSingleEnvData(sceneCullable, viewportLayerCollection.scenes[n4].data);
            viewportLayerCollection.sceneType[viewportLayerCollection.numBuckets] = 1;
            this.cullScene(renderPassCullable, n, n2, n3, n4);
        }
        ++viewportLayerCollection.numBuckets;
        ++viewportLayerCollection.numScenes;
    }

    protected void cullMultipassViewportLayer(SceneCullable sceneCullable, int n, int n2, int n3, int n4) {
        ViewportLayerCollection viewportLayerCollection = this.workLayers[n][n2].viewports[n3];
        viewportLayerCollection.sceneType[viewportLayerCollection.numBuckets] = 2;
        int n5 = sceneCullable.numCullableChildren();
        viewportLayerCollection.ensureMultipassCapacity(1);
        viewportLayerCollection.multipass[0].mainScene.ensureCapacity(n5);
        this.fillMultipassEnvData(sceneCullable, viewportLayerCollection.multipass[viewportLayerCollection.numMultipass].mainScene.globalData);
        viewportLayerCollection.multipass[viewportLayerCollection.numMultipass].mainScene.numPasses = n5;
        for (int i = 0; i < n5; ++i) {
            RenderPassCullable renderPassCullable = sceneCullable.getCullablePass(i);
            this.cullRenderPass(renderPassCullable, i, n, n2, n3, n4);
        }
        ++viewportLayerCollection.numBuckets;
        ++viewportLayerCollection.numMultipass;
    }

    protected void fillSingleEnvData(SceneCullable sceneCullable, GraphicsEnvironmentData graphicsEnvironmentData) {
        TransformCullable transformCullable;
        int n;
        graphicsEnvironmentData.userData = sceneCullable.getUserData();
        graphicsEnvironmentData.effectsProcessor = sceneCullable.getRenderEffectsProcessor();
        ViewEnvironmentCullable viewEnvironmentCullable = sceneCullable.getViewCullable();
        graphicsEnvironmentData.viewProjectionType = viewEnvironmentCullable.getProjectionType();
        graphicsEnvironmentData.useStereo = viewEnvironmentCullable.isStereoEnabled();
        RenderPassCullable renderPassCullable = sceneCullable.getCullablePass(0);
        EnvironmentCullable environmentCullable = renderPassCullable.getViewpointCullable();
        graphicsEnvironmentData.viewpoint = (ObjectRenderable)environmentCullable.getRenderable();
        EnvironmentCullable environmentCullable2 = renderPassCullable.getBackgroundCullable();
        graphicsEnvironmentData.background = environmentCullable2 != null ? (ObjectRenderable)environmentCullable2.getRenderable() : null;
        LeafCullable leafCullable = renderPassCullable.getFogCullable();
        graphicsEnvironmentData.fog = leafCullable != null ? (ObjectRenderable)leafCullable.getRenderable() : null;
        graphicsEnvironmentData.eyeOffset[0] = this.eyePoint[0];
        graphicsEnvironmentData.eyeOffset[1] = this.eyePoint[1];
        graphicsEnvironmentData.eyeOffset[2] = this.eyePoint[2];
        int[] nArray = viewEnvironmentCullable.getViewportDimensions();
        graphicsEnvironmentData.setViewport(nArray);
        viewEnvironmentCullable.getViewFrustum(graphicsEnvironmentData.viewFrustum);
        if (this.useEyePoint) {
            graphicsEnvironmentData.viewFrustum[0] = graphicsEnvironmentData.viewFrustum[0] - (double)this.eyePoint[0];
            graphicsEnvironmentData.viewFrustum[1] = graphicsEnvironmentData.viewFrustum[1] - (double)this.eyePoint[0];
            graphicsEnvironmentData.viewFrustum[2] = graphicsEnvironmentData.viewFrustum[2] - (double)this.eyePoint[1];
            graphicsEnvironmentData.viewFrustum[3] = graphicsEnvironmentData.viewFrustum[3] - (double)this.eyePoint[1];
            graphicsEnvironmentData.viewFrustum[4] = graphicsEnvironmentData.viewFrustum[4] - (double)this.eyePoint[2];
            graphicsEnvironmentData.viewFrustum[5] = graphicsEnvironmentData.viewFrustum[5] - (double)this.eyePoint[2];
        }
        Cullable cullable = environmentCullable.getCullableParent();
        while (cullable != null) {
            if (cullable instanceof TransformCullable) {
                this.currentViewpointPath.add(cullable);
            }
            if (cullable instanceof GroupCullable) {
                if (((GroupCullable)cullable).hasMultipleParents()) {
                    throw new IllegalArgumentException(SHARED_VP_MSG);
                }
                cullable = ((GroupCullable)cullable).getCullableParent();
                continue;
            }
            if (cullable instanceof SingleCullable) {
                if (((SingleCullable)cullable).hasMultipleParents()) {
                    throw new IllegalArgumentException(SHARED_VP_MSG);
                }
                cullable = ((SingleCullable)cullable).getCullableParent();
                continue;
            }
            cullable = null;
        }
        int n2 = this.currentViewpointPath.size();
        this.viewMatrix2.setIdentity();
        for (n = n2 - 1; n >= 0; --n) {
            transformCullable = (TransformCullable)this.currentViewpointPath.get(n);
            transformCullable.getTransform(this.viewMatrix1);
            this.viewMatrix2.mul(this.viewMatrix1);
        }
        this.currentViewpointPath.clear();
        if (this.useOrientation) {
            this.viewMatrix2.mul(this.orientationMatrix);
        }
        graphicsEnvironmentData.viewTransform.set(this.viewMatrix2);
        this.matrixUtils.inverse(graphicsEnvironmentData.viewTransform, this.viewMatrix2);
        graphicsEnvironmentData.cameraTransform[0] = this.viewMatrix2.m00;
        graphicsEnvironmentData.cameraTransform[1] = this.viewMatrix2.m10;
        graphicsEnvironmentData.cameraTransform[2] = this.viewMatrix2.m20;
        graphicsEnvironmentData.cameraTransform[3] = this.viewMatrix2.m30;
        graphicsEnvironmentData.cameraTransform[4] = this.viewMatrix2.m01;
        graphicsEnvironmentData.cameraTransform[5] = this.viewMatrix2.m11;
        graphicsEnvironmentData.cameraTransform[6] = this.viewMatrix2.m21;
        graphicsEnvironmentData.cameraTransform[7] = this.viewMatrix2.m31;
        graphicsEnvironmentData.cameraTransform[8] = this.viewMatrix2.m02;
        graphicsEnvironmentData.cameraTransform[9] = this.viewMatrix2.m12;
        graphicsEnvironmentData.cameraTransform[10] = this.viewMatrix2.m22;
        graphicsEnvironmentData.cameraTransform[11] = this.viewMatrix2.m32;
        graphicsEnvironmentData.cameraTransform[12] = this.viewMatrix2.m03;
        graphicsEnvironmentData.cameraTransform[13] = this.viewMatrix2.m13;
        graphicsEnvironmentData.cameraTransform[14] = this.viewMatrix2.m23;
        graphicsEnvironmentData.cameraTransform[15] = this.viewMatrix2.m33;
        if (graphicsEnvironmentData.background != null) {
            cullable = environmentCullable2.getCullableParent();
            while (cullable != null) {
                if (cullable instanceof TransformCullable) {
                    this.currentViewpointPath.add(cullable);
                }
                if (cullable instanceof GroupCullable) {
                    if (((GroupCullable)cullable).hasMultipleParents()) {
                        throw new IllegalArgumentException(SHARED_VP_MSG);
                    }
                    cullable = ((GroupCullable)cullable).getCullableParent();
                    continue;
                }
                if (cullable instanceof SingleCullable) {
                    if (((SingleCullable)cullable).hasMultipleParents()) {
                        throw new IllegalArgumentException(SHARED_VP_MSG);
                    }
                    cullable = ((SingleCullable)cullable).getCullableParent();
                    continue;
                }
                cullable = null;
            }
            n2 = this.currentViewpointPath.size();
            this.viewMatrix2.setIdentity();
            for (n = n2 - 1; n >= 0; --n) {
                transformCullable = (TransformCullable)this.currentViewpointPath.get(n);
                transformCullable.getTransform(this.viewMatrix1);
                this.viewMatrix2.mul(this.viewMatrix1);
            }
            this.currentViewpointPath.clear();
            this.viewMatrix2.m30 = 0.0f;
            this.viewMatrix2.m31 = 0.0f;
            this.viewMatrix2.m32 = 0.0f;
            this.viewMatrix2.mul(graphicsEnvironmentData.viewTransform);
            graphicsEnvironmentData.backgroundTransform[0] = this.viewMatrix2.m00;
            graphicsEnvironmentData.backgroundTransform[1] = this.viewMatrix2.m01;
            graphicsEnvironmentData.backgroundTransform[2] = this.viewMatrix2.m02;
            graphicsEnvironmentData.backgroundTransform[3] = 0.0f;
            graphicsEnvironmentData.backgroundTransform[4] = this.viewMatrix2.m10;
            graphicsEnvironmentData.backgroundTransform[5] = this.viewMatrix2.m11;
            graphicsEnvironmentData.backgroundTransform[6] = this.viewMatrix2.m12;
            graphicsEnvironmentData.backgroundTransform[7] = 0.0f;
            graphicsEnvironmentData.backgroundTransform[8] = this.viewMatrix2.m20;
            graphicsEnvironmentData.backgroundTransform[9] = this.viewMatrix2.m21;
            graphicsEnvironmentData.backgroundTransform[10] = this.viewMatrix2.m22;
            graphicsEnvironmentData.backgroundTransform[11] = 0.0f;
            graphicsEnvironmentData.backgroundTransform[12] = this.viewMatrix2.m30;
            graphicsEnvironmentData.backgroundTransform[13] = this.viewMatrix2.m31;
            graphicsEnvironmentData.backgroundTransform[14] = this.viewMatrix2.m32;
            graphicsEnvironmentData.backgroundTransform[15] = this.viewMatrix2.m33;
            this.setupBackgroundFrustum(0.01, 1.1, viewEnvironmentCullable.getFieldOfView(), graphicsEnvironmentData);
        }
    }

    protected void fill2DEnvData(SceneCullable sceneCullable, GraphicsEnvironmentData graphicsEnvironmentData) {
        graphicsEnvironmentData.userData = sceneCullable.getUserData();
        graphicsEnvironmentData.effectsProcessor = sceneCullable.getRenderEffectsProcessor();
        RenderPassCullable renderPassCullable = sceneCullable.getCullablePass(0);
        EnvironmentCullable environmentCullable = renderPassCullable.getViewpointCullable();
        graphicsEnvironmentData.viewpoint = (ObjectRenderable)environmentCullable.getRenderable();
        EnvironmentCullable environmentCullable2 = renderPassCullable.getBackgroundCullable();
        graphicsEnvironmentData.background = environmentCullable2 != null ? (ObjectRenderable)environmentCullable2.getRenderable() : null;
        graphicsEnvironmentData.useStereo = false;
        graphicsEnvironmentData.eyeOffset[0] = 0.0f;
        graphicsEnvironmentData.eyeOffset[1] = 0.0f;
        graphicsEnvironmentData.eyeOffset[2] = 0.0f;
        graphicsEnvironmentData.viewProjectionType = 2;
        ViewEnvironmentCullable viewEnvironmentCullable = sceneCullable.getViewCullable();
        int[] nArray = viewEnvironmentCullable.getViewportDimensions();
        graphicsEnvironmentData.setViewport(nArray);
        graphicsEnvironmentData.viewFrustum[0] = nArray[-1];
        graphicsEnvironmentData.viewFrustum[1] = nArray[-1];
        graphicsEnvironmentData.viewFrustum[2] = nArray[1];
        graphicsEnvironmentData.viewFrustum[3] = nArray[1];
        graphicsEnvironmentData.viewFrustum[4] = 1.0;
        graphicsEnvironmentData.viewFrustum[5] = -1.0;
        Cullable cullable = environmentCullable.getCullableParent();
        while (cullable != null) {
            if (cullable instanceof TransformCullable) {
                this.currentViewpointPath.add(cullable);
            }
            if (cullable instanceof GroupCullable) {
                if (((GroupCullable)cullable).hasMultipleParents()) {
                    throw new IllegalArgumentException(SHARED_VP_MSG);
                }
                cullable = ((GroupCullable)cullable).getCullableParent();
                continue;
            }
            if (cullable instanceof SingleCullable) {
                if (((SingleCullable)cullable).hasMultipleParents()) {
                    throw new IllegalArgumentException(SHARED_VP_MSG);
                }
                cullable = ((SingleCullable)cullable).getCullableParent();
                continue;
            }
            cullable = null;
        }
        int n = this.currentViewpointPath.size();
        this.viewMatrix2.setIdentity();
        for (int i = n - 1; i >= 0; --i) {
            TransformCullable transformCullable = (TransformCullable)this.currentViewpointPath.get(i);
            transformCullable.getTransform(this.viewMatrix1);
            this.viewMatrix2.mul(this.viewMatrix1);
        }
        this.currentViewpointPath.clear();
        if (this.useOrientation) {
            this.viewMatrix2.mul(this.orientationMatrix);
        }
        graphicsEnvironmentData.viewTransform.set(this.viewMatrix2);
        this.matrixUtils.inverse(graphicsEnvironmentData.viewTransform, this.viewMatrix2);
        graphicsEnvironmentData.cameraTransform[0] = this.viewMatrix2.m00;
        graphicsEnvironmentData.cameraTransform[1] = this.viewMatrix2.m10;
        graphicsEnvironmentData.cameraTransform[2] = this.viewMatrix2.m20;
        graphicsEnvironmentData.cameraTransform[3] = this.viewMatrix2.m30;
        graphicsEnvironmentData.cameraTransform[4] = this.viewMatrix2.m01;
        graphicsEnvironmentData.cameraTransform[5] = this.viewMatrix2.m11;
        graphicsEnvironmentData.cameraTransform[6] = this.viewMatrix2.m21;
        graphicsEnvironmentData.cameraTransform[7] = this.viewMatrix2.m31;
        graphicsEnvironmentData.cameraTransform[8] = this.viewMatrix2.m02;
        graphicsEnvironmentData.cameraTransform[9] = this.viewMatrix2.m12;
        graphicsEnvironmentData.cameraTransform[10] = this.viewMatrix2.m22;
        graphicsEnvironmentData.cameraTransform[11] = this.viewMatrix2.m32;
        graphicsEnvironmentData.cameraTransform[12] = this.viewMatrix2.m03;
        graphicsEnvironmentData.cameraTransform[13] = this.viewMatrix2.m13;
        graphicsEnvironmentData.cameraTransform[14] = this.viewMatrix2.m23;
        graphicsEnvironmentData.cameraTransform[15] = this.viewMatrix2.m33;
        if (graphicsEnvironmentData.background != null) {
            graphicsEnvironmentData.backgroundTransform[0] = 1.0f;
            graphicsEnvironmentData.backgroundTransform[1] = 0.0f;
            graphicsEnvironmentData.backgroundTransform[2] = 0.0f;
            graphicsEnvironmentData.backgroundTransform[3] = 0.0f;
            graphicsEnvironmentData.backgroundTransform[4] = 0.0f;
            graphicsEnvironmentData.backgroundTransform[5] = 1.0f;
            graphicsEnvironmentData.backgroundTransform[6] = 0.0f;
            graphicsEnvironmentData.backgroundTransform[7] = 0.0f;
            graphicsEnvironmentData.backgroundTransform[8] = 0.0f;
            graphicsEnvironmentData.backgroundTransform[9] = 0.0f;
            graphicsEnvironmentData.backgroundTransform[10] = 1.0f;
            graphicsEnvironmentData.backgroundTransform[11] = 0.0f;
            graphicsEnvironmentData.backgroundTransform[12] = 0.0f;
            graphicsEnvironmentData.backgroundTransform[13] = 0.0f;
            graphicsEnvironmentData.backgroundTransform[14] = 0.0f;
            graphicsEnvironmentData.backgroundTransform[15] = 1.0f;
            graphicsEnvironmentData.backgroundFrustum[0] = graphicsEnvironmentData.viewFrustum[0];
            graphicsEnvironmentData.backgroundFrustum[1] = graphicsEnvironmentData.viewFrustum[1];
            graphicsEnvironmentData.backgroundFrustum[2] = graphicsEnvironmentData.viewFrustum[2];
            graphicsEnvironmentData.backgroundFrustum[3] = graphicsEnvironmentData.viewFrustum[3];
            graphicsEnvironmentData.backgroundFrustum[4] = 1.0;
            graphicsEnvironmentData.backgroundFrustum[5] = -1.0;
        }
    }

    protected void fillMultipassEnvData(SceneCullable sceneCullable, GraphicsEnvironmentData graphicsEnvironmentData) {
        graphicsEnvironmentData.userData = sceneCullable.getUserData();
        graphicsEnvironmentData.effectsProcessor = sceneCullable.getRenderEffectsProcessor();
        ViewEnvironmentCullable viewEnvironmentCullable = sceneCullable.getViewCullable();
        graphicsEnvironmentData.viewProjectionType = viewEnvironmentCullable.getProjectionType();
        graphicsEnvironmentData.useStereo = viewEnvironmentCullable.isStereoEnabled();
        RenderPassCullable renderPassCullable = sceneCullable.getCullablePass(0);
        graphicsEnvironmentData.viewpoint = null;
        EnvironmentCullable environmentCullable = renderPassCullable.getBackgroundCullable();
        graphicsEnvironmentData.background = environmentCullable != null ? (ObjectRenderable)environmentCullable.getRenderable() : null;
        graphicsEnvironmentData.viewProjectionType = viewEnvironmentCullable.getProjectionType();
        graphicsEnvironmentData.useStereo = viewEnvironmentCullable.isStereoEnabled();
        graphicsEnvironmentData.fog = null;
        graphicsEnvironmentData.eyeOffset[0] = this.eyePoint[0];
        graphicsEnvironmentData.eyeOffset[1] = this.eyePoint[1];
        graphicsEnvironmentData.eyeOffset[2] = this.eyePoint[2];
        int[] nArray = viewEnvironmentCullable.getViewportDimensions();
        graphicsEnvironmentData.setViewport(nArray);
        viewEnvironmentCullable.getViewFrustum(graphicsEnvironmentData.viewFrustum);
        if (this.useEyePoint) {
            graphicsEnvironmentData.viewFrustum[0] = graphicsEnvironmentData.viewFrustum[0] - (double)this.eyePoint[0];
            graphicsEnvironmentData.viewFrustum[1] = graphicsEnvironmentData.viewFrustum[1] - (double)this.eyePoint[0];
            graphicsEnvironmentData.viewFrustum[2] = graphicsEnvironmentData.viewFrustum[2] - (double)this.eyePoint[1];
            graphicsEnvironmentData.viewFrustum[3] = graphicsEnvironmentData.viewFrustum[3] - (double)this.eyePoint[1];
            graphicsEnvironmentData.viewFrustum[4] = graphicsEnvironmentData.viewFrustum[4] - (double)this.eyePoint[2];
            graphicsEnvironmentData.viewFrustum[5] = graphicsEnvironmentData.viewFrustum[5] - (double)this.eyePoint[2];
        }
    }

    protected void fillRenderPassEnvData(RenderPassCullable renderPassCullable, GraphicsEnvironmentData graphicsEnvironmentData, BufferDetails bufferDetails) {
        bufferDetails.colorBufferState = renderPassCullable.getColorBufferRenderable();
        bufferDetails.depthBufferState = renderPassCullable.getDepthBufferRenderable();
        bufferDetails.stencilBufferState = renderPassCullable.getStencilBufferRenderable();
        bufferDetails.accumBufferState = renderPassCullable.getAccumBufferRenderable();
        ViewEnvironmentCullable viewEnvironmentCullable = renderPassCullable.getViewCullable();
        graphicsEnvironmentData.userData = renderPassCullable.getUserData();
        graphicsEnvironmentData.effectsProcessor = null;
        EnvironmentCullable environmentCullable = renderPassCullable.getViewpointCullable();
        graphicsEnvironmentData.viewpoint = (ObjectRenderable)environmentCullable.getRenderable();
        graphicsEnvironmentData.background = null;
        graphicsEnvironmentData.viewProjectionType = viewEnvironmentCullable.getProjectionType();
        graphicsEnvironmentData.useStereo = false;
        graphicsEnvironmentData.eyeOffset[0] = this.eyePoint[0];
        graphicsEnvironmentData.eyeOffset[1] = this.eyePoint[1];
        graphicsEnvironmentData.eyeOffset[2] = this.eyePoint[2];
        int[] nArray = viewEnvironmentCullable.getViewportDimensions();
        graphicsEnvironmentData.setViewport(nArray);
        viewEnvironmentCullable.getViewFrustum(graphicsEnvironmentData.viewFrustum);
        if (this.useEyePoint) {
            graphicsEnvironmentData.viewFrustum[0] = graphicsEnvironmentData.viewFrustum[0] - (double)this.eyePoint[0];
            graphicsEnvironmentData.viewFrustum[1] = graphicsEnvironmentData.viewFrustum[1] - (double)this.eyePoint[0];
            graphicsEnvironmentData.viewFrustum[2] = graphicsEnvironmentData.viewFrustum[2] - (double)this.eyePoint[1];
            graphicsEnvironmentData.viewFrustum[3] = graphicsEnvironmentData.viewFrustum[3] - (double)this.eyePoint[1];
            graphicsEnvironmentData.viewFrustum[4] = graphicsEnvironmentData.viewFrustum[4] - (double)this.eyePoint[2];
            graphicsEnvironmentData.viewFrustum[5] = graphicsEnvironmentData.viewFrustum[5] - (double)this.eyePoint[2];
        }
        Cullable cullable = environmentCullable.getCullableParent();
        while (cullable != null) {
            if (cullable instanceof TransformCullable) {
                this.currentViewpointPath.add(cullable);
            }
            if (cullable instanceof GroupCullable) {
                if (((GroupCullable)cullable).hasMultipleParents()) {
                    throw new IllegalArgumentException(SHARED_VP_MSG);
                }
                cullable = ((GroupCullable)cullable).getCullableParent();
                continue;
            }
            if (cullable instanceof SingleCullable) {
                if (((SingleCullable)cullable).hasMultipleParents()) {
                    throw new IllegalArgumentException(SHARED_VP_MSG);
                }
                cullable = ((SingleCullable)cullable).getCullableParent();
                continue;
            }
            cullable = null;
        }
        int n = this.currentViewpointPath.size();
        this.viewMatrix2.setIdentity();
        for (int i = n - 1; i >= 0; --i) {
            TransformCullable transformCullable = (TransformCullable)this.currentViewpointPath.get(i);
            transformCullable.getTransform(this.viewMatrix1);
            this.viewMatrix2.mul(this.viewMatrix1);
        }
        this.currentViewpointPath.clear();
        if (this.useOrientation) {
            this.viewMatrix2.mul(this.orientationMatrix);
        }
        graphicsEnvironmentData.viewTransform.set(this.viewMatrix2);
        this.matrixUtils.inverse(graphicsEnvironmentData.viewTransform, this.viewMatrix2);
        graphicsEnvironmentData.cameraTransform[0] = this.viewMatrix2.m00;
        graphicsEnvironmentData.cameraTransform[1] = this.viewMatrix2.m10;
        graphicsEnvironmentData.cameraTransform[2] = this.viewMatrix2.m20;
        graphicsEnvironmentData.cameraTransform[3] = this.viewMatrix2.m30;
        graphicsEnvironmentData.cameraTransform[4] = this.viewMatrix2.m01;
        graphicsEnvironmentData.cameraTransform[5] = this.viewMatrix2.m11;
        graphicsEnvironmentData.cameraTransform[6] = this.viewMatrix2.m21;
        graphicsEnvironmentData.cameraTransform[7] = this.viewMatrix2.m31;
        graphicsEnvironmentData.cameraTransform[8] = this.viewMatrix2.m02;
        graphicsEnvironmentData.cameraTransform[9] = this.viewMatrix2.m12;
        graphicsEnvironmentData.cameraTransform[10] = this.viewMatrix2.m22;
        graphicsEnvironmentData.cameraTransform[11] = this.viewMatrix2.m32;
        graphicsEnvironmentData.cameraTransform[12] = this.viewMatrix2.m03;
        graphicsEnvironmentData.cameraTransform[13] = this.viewMatrix2.m13;
        graphicsEnvironmentData.cameraTransform[14] = this.viewMatrix2.m23;
        graphicsEnvironmentData.cameraTransform[15] = this.viewMatrix2.m33;
    }

    private void setupBackgroundFrustum(double d, double d2, double d3, GraphicsEnvironmentData graphicsEnvironmentData) {
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = (double)graphicsEnvironmentData.viewport[2] / (double)graphicsEnvironmentData.viewport[3];
        d7 = d * Math.tan(d3 * Math.PI / 360.0);
        d6 = -d7;
        d4 = d6 * d8;
        d5 = d7 * d8;
        graphicsEnvironmentData.backgroundFrustum[0] = d4;
        graphicsEnvironmentData.backgroundFrustum[1] = d5;
        graphicsEnvironmentData.backgroundFrustum[2] = d6;
        graphicsEnvironmentData.backgroundFrustum[3] = d7;
        graphicsEnvironmentData.backgroundFrustum[4] = d;
        graphicsEnvironmentData.backgroundFrustum[5] = d2;
    }

    protected void checkForOffscreens(ShapeRenderable shapeRenderable) {
        AppearanceRenderable appearanceRenderable = shapeRenderable.getAppearanceRenderable();
        if (appearanceRenderable == null) {
            return;
        }
        int n = appearanceRenderable.numTextureRenderables();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            TextureRenderable textureRenderable = appearanceRenderable.getTextureRenderable(i);
            if (!textureRenderable.isOffscreenSource()) continue;
            OffscreenCullable offscreenCullable = textureRenderable.getOffscreenSource();
            if (this.visitedNodes.contains((Object)textureRenderable) || !offscreenCullable.isRepaintRequired()) continue;
            this.resizeOffscreenList();
            this.pendingSubscenes[this.lastSubscene] = offscreenCullable;
            this.pendingParents[this.lastSubscene] = this.activeParent;
            this.visitedNodes.add((Object)textureRenderable);
            ++this.lastSubscene;
        }
    }

    protected void cleanupOldRefs() {
        for (int i = 0; i < this.workLayers.length; ++i) {
            for (int j = 0; j < this.workLayers[i].length && this.workLayers[i][j] != null; ++j) {
                for (int k = 0; k < this.workLayers[i][j].numViewports; ++k) {
                    ViewportLayerCollection viewportLayerCollection = this.workLayers[i][j].viewports[k];
                    for (int i2 = 0; i2 < viewportLayerCollection.numScenes; ++i2) {
                        SceneRenderBucket sceneRenderBucket = viewportLayerCollection.scenes[i2];
                        for (int i3 = sceneRenderBucket.numNodes; i3 < sceneRenderBucket.nodes.length && sceneRenderBucket.nodes[i3] != null; ++i3) {
                            int n;
                            sceneRenderBucket.nodes[i3].renderable = null;
                            sceneRenderBucket.nodes[i3].localFog = null;
                            sceneRenderBucket.nodes[i3].customData = null;
                            for (n = 0; n < sceneRenderBucket.nodes[i3].numLights; ++n) {
                                sceneRenderBucket.nodes[i3].lights[n].clear();
                            }
                            for (n = 0; n < sceneRenderBucket.nodes[i3].numClipPlanes; ++n) {
                                sceneRenderBucket.nodes[i3].clipPlanes[n].clear();
                            }
                            sceneRenderBucket.nodes[i3].numLights = 0;
                            sceneRenderBucket.nodes[i3].numClipPlanes = 0;
                        }
                    }
                }
            }
        }
    }

    protected final void resizeCullList(int n) {
        if (n + 1 == this.workCullList.length) {
            int n2 = this.workCullList.length;
            int n3 = n2 + 20;
            GraphicsCullOutputDetails[] graphicsCullOutputDetailsArray = new GraphicsCullOutputDetails[n3];
            System.arraycopy(this.workCullList, 0, graphicsCullOutputDetailsArray, 0, n2);
            for (int i = n2; i < n3; ++i) {
                graphicsCullOutputDetailsArray[i] = new GraphicsCullOutputDetails();
            }
            this.workCullList = graphicsCullOutputDetailsArray;
        }
    }

    protected final void resizeOutputLists() {
        if (this.lastSubscene + 1 < this.validSceneParents.length) {
            return;
        }
        int n = this.validSceneParents.length;
        int n2 = n + 20;
        OffscreenBufferRenderable[][] offscreenBufferRenderableArrayArray = new OffscreenBufferRenderable[n2][];
        System.arraycopy(this.validSceneParents, 0, offscreenBufferRenderableArrayArray, 0, n);
        for (int i = n; i < n2; ++i) {
            offscreenBufferRenderableArrayArray[i] = new OffscreenBufferRenderable[2];
        }
        this.validSceneParents = offscreenBufferRenderableArrayArray;
        ViewportCollection[][] viewportCollectionArrayArray = new ViewportCollection[n2][];
        int[] nArray = new int[n2];
        System.arraycopy(this.workLayers, 0, viewportCollectionArrayArray, 0, this.workLayers.length);
        System.arraycopy(this.workLayerCounts, 0, nArray, 0, this.workLayerCounts.length);
        for (int i = this.workLayers.length; i < n2; ++i) {
            viewportCollectionArrayArray[i] = new ViewportCollection[1];
            viewportCollectionArrayArray[i][0] = new ViewportCollection();
        }
        this.workLayers = viewportCollectionArrayArray;
        this.workLayerCounts = nArray;
    }

    protected final void resizeOffscreenList() {
        if (this.lastSubscene + 1 == this.pendingSubscenes.length) {
            int n = this.pendingSubscenes.length;
            int n2 = n + 20;
            OffscreenCullable[] offscreenCullableArray = new OffscreenCullable[n2];
            System.arraycopy(this.pendingSubscenes, 0, offscreenCullableArray, 0, n);
            this.pendingSubscenes = offscreenCullableArray;
            offscreenCullableArray = new OffscreenCullable[n2];
            System.arraycopy(this.pendingParents, 0, offscreenCullableArray, 0, n);
            this.pendingParents = offscreenCullableArray;
        }
    }

    protected final void resizeLightList() {
        if (this.lastLight + 1 == this.lightList.length) {
            int n = this.lightList.length;
            int n2 = n + 20;
            EffectRenderable[] effectRenderableArray = new EffectRenderable[n2];
            System.arraycopy(this.lightList, 0, effectRenderableArray, 0, n);
            this.lightList = effectRenderableArray;
            float[][] fArrayArray = new float[n2][];
            System.arraycopy(this.lightTxList, 0, fArrayArray, 0, n);
            for (int i = n; i < n2; ++i) {
                fArrayArray[i] = new float[16];
            }
            this.lightTxList = fArrayArray;
        }
    }

    protected final void resizeClipList() {
        if (this.lastClip + 1 == this.clipList.length) {
            int n = this.clipList.length;
            int n2 = n + 20;
            EffectRenderable[] effectRenderableArray = new EffectRenderable[n2];
            System.arraycopy(this.clipList, 0, effectRenderableArray, 0, n);
            this.clipList = effectRenderableArray;
            float[][] fArrayArray = new float[n2][];
            System.arraycopy(this.clipTxList, 0, fArrayArray, 0, n);
            for (int i = n; i < n2; ++i) {
                fArrayArray[i] = new float[16];
            }
            this.clipTxList = fArrayArray;
        }
    }

    protected final void resizeStack() {
        if (this.lastTxStack + 1 == this.transformStack.length) {
            int n = this.transformStack.length;
            int n2 = n + 32;
            Matrix4f[] matrix4fArray = new Matrix4f[n2];
            System.arraycopy(this.transformStack, 0, matrix4fArray, 0, n);
            for (int i = n; i < n2; ++i) {
                matrix4fArray[i] = new Matrix4f();
            }
            this.transformStack = matrix4fArray;
        }
    }

    protected final void resizeFogStack() {
        if (this.lastFogStack + 1 == this.fogStack.length) {
            int n = this.fogStack.length;
            int n2 = n + 32;
            EffectRenderable[] effectRenderableArray = new EffectRenderable[n2];
            System.arraycopy(this.fogStack, 0, effectRenderableArray, 0, n);
            this.fogStack = effectRenderableArray;
        }
    }
}

