/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline.audio;

import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.pipeline.RenderableRequestData;
import org.j3d.aviatrix3d.pipeline.audio.AudioCullOutputDetails;
import org.j3d.aviatrix3d.pipeline.audio.AudioDetails;
import org.j3d.aviatrix3d.pipeline.audio.AudioEnvironmentData;
import org.j3d.aviatrix3d.pipeline.audio.AudioInstructions;
import org.j3d.aviatrix3d.pipeline.audio.AudioSortStage;
import org.j3d.aviatrix3d.pipeline.audio.SortedAudioReceiver;
import org.j3d.aviatrix3d.rendering.AudioRenderable;
import org.j3d.util.MatrixUtils;

public class NullAudioSortStage
implements AudioSortStage {
    private static final int LIST_START_SIZE = 1;
    private SortedAudioReceiver receiver;
    private AudioInstructions commandList = new AudioInstructions();
    private int lastGlobalId = 0;
    private MatrixUtils matrixUtils = new MatrixUtils();
    private boolean terminate;

    public void sort(RenderableRequestData renderableRequestData, AudioEnvironmentData audioEnvironmentData, AudioCullOutputDetails[] audioCullOutputDetailsArray, int n) {
        this.terminate = false;
        this.commandList.renderData = audioEnvironmentData;
        this.sortSingle(audioCullOutputDetailsArray, n, this.commandList);
        if (this.terminate) {
            return;
        }
        if (this.receiver != null) {
            this.receiver.sortedOutput(renderableRequestData, this.commandList);
        }
    }

    public void setSortedAudioReceiver(SortedAudioReceiver sortedAudioReceiver) {
        this.receiver = sortedAudioReceiver;
    }

    public void halt() {
        this.terminate = true;
    }

    private void sortSingle(AudioCullOutputDetails[] audioCullOutputDetailsArray, int n, AudioInstructions audioInstructions) {
        int n2;
        int n3 = n << 1;
        if (audioInstructions.renderList.length < n3) {
            AudioDetails[] audioDetailsArray = new AudioDetails[n3];
            System.arraycopy(audioInstructions.renderList, 0, audioDetailsArray, 0, audioInstructions.renderList.length);
            for (n2 = audioInstructions.renderList.length; n2 < n3; ++n2) {
                audioDetailsArray[n2] = new AudioDetails();
            }
            audioInstructions.renderList = audioDetailsArray;
            audioInstructions.renderOps = new int[n3];
        }
        int n4 = 0;
        for (n2 = 0; n2 < n && !this.terminate; ++n2) {
            if (!(audioCullOutputDetailsArray[n2].renderable instanceof AudioRenderable)) continue;
            AudioRenderable audioRenderable = (AudioRenderable)audioCullOutputDetailsArray[n2].renderable;
            audioInstructions.renderList[n4].renderable = audioCullOutputDetailsArray[n2].renderable;
            if (audioRenderable.isSpatialised()) {
                Matrix4f matrix4f = audioCullOutputDetailsArray[n2].transform;
                this.matrixUtils.inverse(matrix4f, matrix4f);
                audioInstructions.renderList[n4].transform = matrix4f;
            }
            audioInstructions.renderOps[n4] = 1;
            audioInstructions.renderList[++n4].renderable = audioCullOutputDetailsArray[n2].renderable;
            audioInstructions.renderOps[n4] = 2;
            ++n4;
        }
        audioInstructions.numValid = n4;
    }
}

