/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline.audio;

import java.util.ArrayList;
import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.pipeline.RenderableRequestData;
import org.j3d.aviatrix3d.pipeline.audio.AudioCullOutputDetails;
import org.j3d.aviatrix3d.pipeline.audio.AudioCullStage;
import org.j3d.aviatrix3d.pipeline.audio.AudioEnvironmentData;
import org.j3d.aviatrix3d.pipeline.audio.CulledAudioReceiver;
import org.j3d.aviatrix3d.rendering.AudioRenderable;
import org.j3d.aviatrix3d.rendering.Cullable;
import org.j3d.aviatrix3d.rendering.EnvironmentCullable;
import org.j3d.aviatrix3d.rendering.GroupCullable;
import org.j3d.aviatrix3d.rendering.LayerCullable;
import org.j3d.aviatrix3d.rendering.LeafCullable;
import org.j3d.aviatrix3d.rendering.ObjectRenderable;
import org.j3d.aviatrix3d.rendering.ProfilingData;
import org.j3d.aviatrix3d.rendering.RenderPassCullable;
import org.j3d.aviatrix3d.rendering.Renderable;
import org.j3d.aviatrix3d.rendering.SceneCullable;
import org.j3d.aviatrix3d.rendering.SingleCullable;
import org.j3d.aviatrix3d.rendering.TransformCullable;
import org.j3d.aviatrix3d.rendering.ViewEnvironmentCullable;
import org.j3d.aviatrix3d.rendering.ViewportCullable;
import org.j3d.aviatrix3d.rendering.ViewportLayerCullable;

public class NullAudioCullStage
implements AudioCullStage {
    private static final String SHARED_VP_MSG = "The path from the root of the scene graph to the viewpoint contains a GroupCullable or SingleCullable instance. This is not permitted.";
    private static final int TRANSFORM_DEPTH_SIZE = 64;
    private static final int STACK_INCREMENT = 32;
    private static final int LIST_START_DEPTH = 200;
    private static final int LIST_INCREMENT = 20;
    private AudioCullOutputDetails[][] outputCullList;
    private AudioCullOutputDetails[][] validCullList;
    private AudioCullOutputDetails[] workCullList;
    private int[] outputCullSize;
    private AudioEnvironmentData[] validEnvData;
    private AudioEnvironmentData[] outputEnvData;
    private int[] validCullSize;
    private int lastOutputList;
    private Matrix4f[] transformStack;
    private int lastTxStack;
    private CulledAudioReceiver receiver;
    private ArrayList<Cullable> currentViewpointPath;
    private Matrix4f viewMatrix1;
    private Matrix4f viewMatrix2;
    private boolean terminate;

    public NullAudioCullStage() {
        int n;
        int n2 = 1;
        this.outputCullList = new AudioCullOutputDetails[n2][];
        this.validCullList = new AudioCullOutputDetails[n2][200];
        this.outputEnvData = new AudioEnvironmentData[n2];
        this.validEnvData = new AudioEnvironmentData[n2];
        this.outputCullSize = new int[n2];
        this.validCullSize = new int[n2];
        this.currentViewpointPath = new ArrayList(64);
        this.viewMatrix1 = new Matrix4f();
        this.viewMatrix2 = new Matrix4f();
        for (n = 0; n < n2; ++n) {
            this.validEnvData[n] = new AudioEnvironmentData();
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < 200; ++i) {
                this.validCullList[n][i] = new AudioCullOutputDetails();
            }
        }
        this.transformStack = new Matrix4f[64];
        for (n = 0; n < 64; ++n) {
            this.transformStack[n] = new Matrix4f();
        }
    }

    public void setCulledAudioReceiver(CulledAudioReceiver culledAudioReceiver) {
        this.receiver = culledAudioReceiver;
    }

    public void cull(RenderableRequestData renderableRequestData, ProfilingData profilingData, LayerCullable[] layerCullableArray, int n) {
        LayerCullable layerCullable;
        this.terminate = false;
        for (int i = 0; !(i >= n || this.terminate || layerCullableArray[i] != null && this.processLayer(layerCullable = layerCullableArray[i], 0, i)); ++i) {
        }
        this.outputEnvData[0] = this.validEnvData[0];
        this.outputCullList[0] = this.validCullList[0];
        this.outputCullSize[0] = this.validCullSize[0];
        if (this.lastOutputList != 0 && this.receiver != null && !this.terminate) {
            this.receiver.culledOutput(renderableRequestData, this.outputEnvData[0], this.outputCullList[0], this.outputCullSize[0]);
        }
    }

    public void halt() {
        this.terminate = true;
    }

    private boolean processLayer(LayerCullable layerCullable, int n, int n2) {
        int n3 = layerCullable.numCullableChildren();
        for (int i = 0; i < n3; ++i) {
            ViewportCullable viewportCullable = layerCullable.getCullableViewport(i);
            if (!this.cullViewport(viewportCullable, n, n2, i)) continue;
            return true;
        }
        return false;
    }

    private boolean cullViewport(ViewportCullable viewportCullable, int n, int n2, int n3) {
        if (viewportCullable == null || !viewportCullable.isValid()) {
            return false;
        }
        int n4 = viewportCullable.numCullableChildren();
        boolean bl = false;
        for (int i = 0; i < n4 && !bl && !this.terminate; ++i) {
            ViewportLayerCullable viewportLayerCullable = viewportCullable.getCullableLayer(i);
            if (viewportLayerCullable.isMultipassViewport()) {
                bl = this.cullMultipassViewportLayer(viewportLayerCullable.getCullableScene(), n, n2, n3, i);
                continue;
            }
            if (!viewportLayerCullable.isAudioSource()) continue;
            bl = true;
            this.cullSingleViewportLayer(viewportLayerCullable.getCullableScene(), n, n2, n3, i);
        }
        return bl;
    }

    private void cullSingleViewportLayer(SceneCullable sceneCullable, int n, int n2, int n3, int n4) {
        RenderPassCullable renderPassCullable = sceneCullable.getCullablePass(0);
        this.fillEnvData(sceneCullable, this.validEnvData[0]);
        if (renderPassCullable.is2D()) {
            this.cullScene2D(renderPassCullable, n, n2, n3, n4);
        } else {
            this.cullScene(renderPassCullable, n, n2, n3, n4);
        }
    }

    private boolean cullMultipassViewportLayer(SceneCullable sceneCullable, int n, int n2, int n3, int n4) {
        int n5 = sceneCullable.numCullableChildren();
        boolean bl = false;
        for (int i = 0; i < n5 && !bl && !this.terminate; ++i) {
            RenderPassCullable renderPassCullable = sceneCullable.getCullablePass(i);
            bl = renderPassCullable.isAudioSource();
            this.cullRenderPass(renderPassCullable, i, n, n2, n3, n4);
        }
        return bl;
    }

    private void cullScene(RenderPassCullable renderPassCullable, int n, int n2, int n3, int n4) {
        this.terminate = false;
        this.lastOutputList = 0;
        this.lastTxStack = 0;
        this.workCullList = this.validCullList[0];
        Cullable cullable = renderPassCullable.getRootCullable();
        if (this.terminate) {
            return;
        }
        if (cullable instanceof GroupCullable) {
            if (cullable instanceof TransformCullable) {
                ((TransformCullable)cullable).getTransform(this.transformStack[0]);
            } else {
                this.transformStack[0].setIdentity();
            }
            this.validCullSize[0] = this.findAllNodes((GroupCullable)cullable, 0);
            this.validCullList[0] = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof SingleCullable) {
            this.transformStack[0].setIdentity();
            this.validCullSize[0] = this.findNextNode((SingleCullable)cullable, 0);
            this.validCullList[0] = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof LeafCullable) {
            this.findAudioLeaf((LeafCullable)cullable, 0);
            this.validCullSize[0] = 1;
            this.validCullList[0] = this.workCullList;
            ++this.lastOutputList;
        }
    }

    private void cullScene2D(RenderPassCullable renderPassCullable, int n, int n2, int n3, int n4) {
    }

    private void cullRenderPass(RenderPassCullable renderPassCullable, int n, int n2, int n3, int n4, int n5) {
    }

    private int cullSingle(GroupCullable groupCullable) {
        this.transformStack[0].setIdentity();
        if (groupCullable instanceof TransformCullable) {
            ((TransformCullable)((Object)groupCullable)).getTransform(this.transformStack[0]);
        }
        return this.findAllNodes(groupCullable, 0);
    }

    private int findAllNodes(GroupCullable groupCullable, int n) {
        if (this.terminate) {
            return 0;
        }
        Cullable[] cullableArray = groupCullable.getCullableChildren();
        int n2 = groupCullable.numCullableChildren();
        int n3 = n;
        for (int i = 0; i < n2 && !this.terminate; ++i) {
            boolean bl = cullableArray[i] instanceof TransformCullable;
            if (bl) {
                this.resizeStack();
                TransformCullable transformCullable = (TransformCullable)cullableArray[i];
                transformCullable.getTransform(this.transformStack[this.lastTxStack + 1]);
                this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.transformStack[this.lastTxStack + 1]);
                ++this.lastTxStack;
            }
            if (cullableArray[i] instanceof GroupCullable) {
                n3 = this.findAllNodes((GroupCullable)cullableArray[i], n3);
            } else if (cullableArray[i] instanceof SingleCullable) {
                n3 = this.findNextNode((SingleCullable)cullableArray[i], n3);
            } else if (cullableArray[i] instanceof LeafCullable) {
                n3 = this.findAudioLeaf((LeafCullable)cullableArray[i], n3);
            }
            if (!bl) continue;
            --this.lastTxStack;
        }
        return n3;
    }

    private int findNextNode(SingleCullable singleCullable, int n) {
        if (this.terminate) {
            return 0;
        }
        int n2 = n;
        Cullable cullable = singleCullable.getCullableChild();
        while (cullable != null && cullable instanceof SingleCullable) {
            cullable = ((SingleCullable)cullable).getCullableChild();
        }
        boolean bl = cullable instanceof TransformCullable;
        if (bl) {
            this.resizeStack();
            TransformCullable transformCullable = (TransformCullable)cullable;
            transformCullable.getTransform(this.transformStack[this.lastTxStack + 1]);
            this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.transformStack[this.lastTxStack + 1]);
            ++this.lastTxStack;
        }
        if (cullable instanceof GroupCullable) {
            n2 = this.findAllNodes((GroupCullable)cullable, n);
        } else if (cullable instanceof LeafCullable) {
            n2 = this.findAudioLeaf((LeafCullable)cullable, n2);
        }
        if (bl) {
            --this.lastTxStack;
        }
        return n2;
    }

    private int findAudioLeaf(LeafCullable leafCullable, int n) {
        if (leafCullable.getCullableType() != 5) {
            return n;
        }
        Renderable renderable = leafCullable.getRenderable();
        if (!(renderable instanceof AudioRenderable)) {
            return n;
        }
        int n2 = n;
        AudioRenderable audioRenderable = (AudioRenderable)renderable;
        if (audioRenderable.isEnabled()) {
            this.resizeCullList(n2);
            this.workCullList[n2].renderable = audioRenderable;
            Matrix4f matrix4f = this.transformStack[this.lastTxStack];
            this.workCullList[n2].transform.set(matrix4f);
            ++n2;
        }
        return n2;
    }

    private void fillEnvData(SceneCullable sceneCullable, AudioEnvironmentData audioEnvironmentData) {
        ViewEnvironmentCullable viewEnvironmentCullable = sceneCullable.getViewCullable();
        audioEnvironmentData.userData = sceneCullable.getUserData();
        RenderPassCullable renderPassCullable = sceneCullable.getCullablePass(0);
        EnvironmentCullable environmentCullable = renderPassCullable.getViewpointCullable();
        audioEnvironmentData.viewpoint = (ObjectRenderable)environmentCullable.getRenderable();
        Cullable cullable = environmentCullable.getCullableParent();
        while (cullable != null) {
            if (cullable instanceof TransformCullable) {
                this.currentViewpointPath.add(cullable);
            }
            if (cullable instanceof GroupCullable) {
                if (((GroupCullable)cullable).hasMultipleParents()) {
                    throw new IllegalArgumentException(SHARED_VP_MSG);
                }
                cullable = ((GroupCullable)cullable).getCullableParent();
                continue;
            }
            if (cullable instanceof SingleCullable) {
                if (((SingleCullable)cullable).hasMultipleParents()) {
                    throw new IllegalArgumentException(SHARED_VP_MSG);
                }
                cullable = ((SingleCullable)cullable).getCullableParent();
                continue;
            }
            cullable = null;
        }
        int n = this.currentViewpointPath.size();
        this.viewMatrix2.setIdentity();
        for (int i = n - 1; i >= 0; --i) {
            TransformCullable transformCullable = (TransformCullable)this.currentViewpointPath.get(i);
            transformCullable.getTransform(this.viewMatrix1);
            this.viewMatrix2.mul(this.viewMatrix1);
        }
        this.currentViewpointPath.clear();
        audioEnvironmentData.viewTransform.set(this.viewMatrix2);
    }

    private final void resizeCullList(int n) {
        if (n + 1 == this.workCullList.length) {
            int n2 = this.workCullList.length;
            int n3 = n2 + 20;
            AudioCullOutputDetails[] audioCullOutputDetailsArray = new AudioCullOutputDetails[n3];
            System.arraycopy(this.workCullList, 0, audioCullOutputDetailsArray, 0, n2);
            for (int i = n2; i < n3; ++i) {
                audioCullOutputDetailsArray[i] = new AudioCullOutputDetails();
            }
            this.workCullList = audioCullOutputDetailsArray;
        }
    }

    private final void resizeStack() {
        if (this.lastTxStack + 1 == this.transformStack.length) {
            int n = this.transformStack.length;
            int n2 = n + 32;
            Matrix4f[] matrix4fArray = new Matrix4f[n2];
            System.arraycopy(this.transformStack, 0, matrix4fArray, 0, n);
            for (int i = n; i < n2; ++i) {
                matrix4fArray[i] = new Matrix4f();
            }
            this.transformStack = matrix4fArray;
        }
    }
}

