/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.pipeline.audio;

import org.j3d.aviatrix3d.pipeline.RenderableRequestData;
import org.j3d.aviatrix3d.pipeline.audio.AudioCullStage;
import org.j3d.aviatrix3d.pipeline.audio.AudioCullToSingleSortListener;
import org.j3d.aviatrix3d.pipeline.audio.AudioOutputDevice;
import org.j3d.aviatrix3d.pipeline.audio.AudioRenderPipeline;
import org.j3d.aviatrix3d.pipeline.audio.AudioSortStage;
import org.j3d.aviatrix3d.pipeline.audio.AudioSortToSingleDeviceListener;
import org.j3d.aviatrix3d.rendering.LayerCullable;
import org.j3d.aviatrix3d.rendering.ProfilingData;

public class DefaultAudioPipeline
implements AudioRenderPipeline {
    private AudioCullStage culler;
    private AudioSortStage sorter;
    private AudioOutputDevice device;
    private AudioCullToSingleSortListener ctsListener = new AudioCullToSingleSortListener();
    private AudioSortToSingleDeviceListener stdListener = new AudioSortToSingleDeviceListener();
    private LayerCullable[] layers = new LayerCullable[1];
    private int numLayers;
    private boolean terminate = false;
    private RenderableRequestData otherData;

    public DefaultAudioPipeline() {
    }

    public DefaultAudioPipeline(AudioCullStage audioCullStage, AudioSortStage audioSortStage) {
        this();
        this.culler = audioCullStage;
        this.sorter = audioSortStage;
        if (audioCullStage != null) {
            audioCullStage.setCulledAudioReceiver(this.ctsListener);
        }
        if (audioSortStage != null) {
            this.ctsListener.setSorter(audioSortStage);
            audioSortStage.setSortedAudioReceiver(this.stdListener);
        }
    }

    public void setAudioOutputDevice(AudioOutputDevice audioOutputDevice) {
        this.stdListener.setDevice(audioOutputDevice);
        this.device = audioOutputDevice;
    }

    public AudioOutputDevice getAudioOutputDevice() {
        return this.device;
    }

    public void setRequestData(RenderableRequestData renderableRequestData) {
        this.otherData = renderableRequestData;
    }

    public boolean render() {
        if (this.numLayers == 0) {
            return true;
        }
        boolean bl = true;
        ProfilingData profilingData = new ProfilingData();
        if (this.culler != null) {
            this.culler.cull(this.otherData, profilingData, this.layers, this.numLayers);
            this.otherData = null;
            if (!this.terminate && this.device != null) {
                bl = this.device.draw(profilingData);
            }
        }
        return bl;
    }

    public boolean displayOnly() {
        boolean bl = true;
        ProfilingData profilingData = new ProfilingData();
        if (!this.terminate && this.numLayers != 0 && this.device != null) {
            bl = this.device.draw(profilingData);
        }
        return bl;
    }

    public void setRenderableLayers(LayerCullable[] layerCullableArray, int n) {
        if (layerCullableArray != null) {
            if (this.layers.length < n) {
                this.layers = new LayerCullable[n];
            }
            System.arraycopy(layerCullableArray, 0, this.layers, 0, n);
        }
        this.numLayers = n;
    }

    public void halt() {
        this.terminate = true;
        if (this.culler != null) {
            this.culler.halt();
        }
        if (this.sorter != null) {
            this.sorter.halt();
        }
        if (this.device != null) {
            this.device.dispose();
        }
    }

    public void setSorter(AudioSortStage audioSortStage) {
        this.ctsListener.setSorter(audioSortStage);
        if (this.sorter != null) {
            this.sorter.setSortedAudioReceiver(null);
        }
        if (audioSortStage != null) {
            audioSortStage.setSortedAudioReceiver(this.stdListener);
        }
        this.sorter = audioSortStage;
    }

    public void setCuller(AudioCullStage audioCullStage) {
        if (this.culler != null) {
            this.culler.setCulledAudioReceiver(null);
        }
        if (audioCullStage != null) {
            audioCullStage.setCulledAudioReceiver(this.ctsListener);
        }
        this.culler = audioCullStage;
    }
}

