/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.output.graphics;

import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLPbuffer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.j3d.aviatrix3d.output.graphics.BaseSWTSurface;
import org.j3d.aviatrix3d.output.graphics.BaseSurface;
import org.j3d.aviatrix3d.output.graphics.QuadBufferStereoProcessor;
import org.j3d.aviatrix3d.output.graphics.SingleEyeStereoProcessor;
import org.j3d.aviatrix3d.output.graphics.StandardRenderingProcessor;
import org.j3d.aviatrix3d.output.graphics.StereoRenderingProcessor;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsProfilingData;
import org.j3d.opengl.swt.GLCanvas;

public class StereoSWTSurface
extends BaseSWTSurface {
    private int stereoRenderType;
    private boolean quadBuffersAvailable;
    private float eyeSeparation;
    private GLCapabilities requestedCapabilities;
    private GLCapabilitiesChooser requestedChooser;
    private boolean useLightweight;
    private boolean renderLeftFrame;
    private Composite parentWidget;
    private int swtStyle;

    public StereoSWTSurface(Composite composite, int n, GLCapabilities gLCapabilities, int n2) {
        this(composite, n, gLCapabilities, null, null, n2);
    }

    public StereoSWTSurface(Composite composite, int n, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, int n2) {
        this(composite, n, gLCapabilities, gLCapabilitiesChooser, null, n2);
    }

    public StereoSWTSurface(Composite composite, int n, GLCapabilities gLCapabilities, boolean bl, int n2) {
        this(composite, n, gLCapabilities, null, null, bl, n2);
    }

    public StereoSWTSurface(Composite composite, int n, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, boolean bl, int n2) {
        this(composite, n, gLCapabilities, gLCapabilitiesChooser, null, bl, n2);
    }

    public StereoSWTSurface(Composite composite, int n, GLCapabilities gLCapabilities, BaseSurface baseSurface, int n2) {
        this(composite, n, gLCapabilities, null, baseSurface, false, n2);
    }

    public StereoSWTSurface(Composite composite, int n, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, BaseSurface baseSurface, int n2) {
        this(composite, n, gLCapabilities, gLCapabilitiesChooser, baseSurface, false, n2);
    }

    public StereoSWTSurface(Composite composite, int n, GLCapabilities gLCapabilities, BaseSurface baseSurface, boolean bl, int n2) {
        this(composite, n, gLCapabilities, null, baseSurface, bl, n2);
    }

    public StereoSWTSurface(Composite composite, int n, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, BaseSurface baseSurface, boolean bl, int n2) {
        super(baseSurface);
        this.requestedCapabilities = gLCapabilities;
        this.requestedChooser = gLCapabilitiesChooser;
        this.useLightweight = bl;
        this.parentWidget = composite;
        this.swtStyle = n;
        this.renderLeftFrame = true;
        this.quadBuffersAvailable = false;
        this.eyeSeparation = 0.001f;
        this.setStereoRenderingPolicy(n2);
        this.init();
    }

    public boolean isStereoAvailable() {
        return true;
    }

    public boolean isQuadStereoAvailable() {
        return this.quadBuffersAvailable;
    }

    public void setStereoEyeSeparation(float f) {
        float f2 = this.eyeSeparation = f < 0.0f ? -f : f;
        if (this.canvasRenderer instanceof StereoRenderingProcessor) {
            StereoRenderingProcessor stereoRenderingProcessor = (StereoRenderingProcessor)this.canvasRenderer;
            stereoRenderingProcessor.setStereoEyeSeparation(f);
        }
    }

    public float getStereoEyeSeparation() {
        return this.eyeSeparation;
    }

    public void setStereoRenderingPolicy(int n) {
        GLContext gLContext = null;
        if (this.sharedSurface != null) {
            gLContext = this.sharedSurface.canvasContext;
        }
        this.swtCanvas = new GLCanvas(this.parentWidget, this.swtStyle, this.requestedCapabilities, this.requestedChooser, gLContext);
        this.swtCanvas.addControlListener((ControlListener)this.resizer);
        this.canvas = this.swtCanvas.getGLDrawable();
        this.canvasContext = this.swtCanvas.getGLContext();
        switch (n) {
            case 0: {
                this.canvasRenderer = new StandardRenderingProcessor(this.canvasContext);
                break;
            }
            case 1: {
                this.canvasRenderer = new QuadBufferStereoProcessor(this.canvasContext);
                StereoRenderingProcessor stereoRenderingProcessor = (StereoRenderingProcessor)this.canvasRenderer;
                stereoRenderingProcessor.setStereoEyeSeparation(this.eyeSeparation);
                break;
            }
            case 2: {
                this.canvasRenderer = new SingleEyeStereoProcessor(this.canvasContext);
                StereoRenderingProcessor stereoRenderingProcessor = (StereoRenderingProcessor)this.canvasRenderer;
                stereoRenderingProcessor.setStereoEyeSeparation(this.eyeSeparation);
                break;
            }
            case 3: {
                System.out.println("Dual canvas stereo is not implemented yet");
                return;
            }
            default: {
                throw new IllegalArgumentException("Unknown stereo policy");
            }
        }
        this.stereoRenderType = n;
    }

    public int getStereoRenderingPolicy() {
        return this.stereoRenderType;
    }

    public boolean draw(GraphicsProfilingData graphicsProfilingData) {
        if (!this.initComplete && !this.initCanvas()) {
            return false;
        }
        int n = this.numRenderables;
        GLPbuffer[] gLPbufferArray = this.renderableList;
        if (n > 1) {
            for (int i = 0; i < n && !this.terminate; ++i) {
                if (gLPbufferArray[i] == null) continue;
                gLPbufferArray[i].display();
            }
        }
        if (this.terminate) {
            return false;
        }
        switch (this.stereoRenderType) {
            case 2: {
                SingleEyeStereoProcessor singleEyeStereoProcessor = (SingleEyeStereoProcessor)this.canvasRenderer;
                singleEyeStereoProcessor.setEyeToRender(this.renderLeftFrame);
                this.canvasRenderer.render(graphicsProfilingData);
                this.renderLeftFrame = !this.renderLeftFrame;
                break;
            }
            default: {
                this.canvasRenderer.render(graphicsProfilingData);
            }
        }
        return !this.terminate;
    }

    public Object getSurfaceObject() {
        return this.canvas;
    }

    public boolean completeCanvasInitialisation(GL gL) {
        byte[] byArray = new byte[1];
        gL.glGetBooleanv(3123, byArray, 0);
        this.quadBuffersAvailable = byArray[0] == 1;
        return true;
    }

    public void resychronizeRenderTarget() {
    }
}

