/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.output.graphics;

import java.awt.Component;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLJPanel;
import javax.media.opengl.GLPbuffer;
import org.j3d.aviatrix3d.output.graphics.BaseAWTSurface;
import org.j3d.aviatrix3d.output.graphics.BaseSurface;
import org.j3d.aviatrix3d.output.graphics.QuadBufferStereoProcessor;
import org.j3d.aviatrix3d.output.graphics.SingleEyeStereoProcessor;
import org.j3d.aviatrix3d.output.graphics.StandardRenderingProcessor;
import org.j3d.aviatrix3d.output.graphics.StereoRenderingProcessor;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsProfilingData;

public class StereoAWTSurface
extends BaseAWTSurface {
    private int stereoRenderType;
    private boolean quadBuffersAvailable;
    private float eyeSeparation;
    private GLCapabilities requestedCapabilities;
    private GLCapabilitiesChooser requestedChooser;
    private boolean renderLeftFrame;

    public StereoAWTSurface(GLCapabilities gLCapabilities, int n) {
        this(gLCapabilities, null, null, false, n);
    }

    public StereoAWTSurface(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, int n) {
        this(gLCapabilities, gLCapabilitiesChooser, null, false, n);
    }

    public StereoAWTSurface(GLCapabilities gLCapabilities, boolean bl, int n) {
        this(gLCapabilities, null, null, bl, n);
    }

    public StereoAWTSurface(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, boolean bl, int n) {
        this(gLCapabilities, gLCapabilitiesChooser, null, bl, n);
    }

    public StereoAWTSurface(GLCapabilities gLCapabilities, BaseSurface baseSurface, int n) {
        this(gLCapabilities, null, baseSurface, false, n);
    }

    public StereoAWTSurface(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, BaseSurface baseSurface, int n) {
        this(gLCapabilities, gLCapabilitiesChooser, baseSurface, false, n);
    }

    public StereoAWTSurface(GLCapabilities gLCapabilities, BaseSurface baseSurface, boolean bl, int n) {
        this(gLCapabilities, null, baseSurface, bl, n);
    }

    public StereoAWTSurface(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, BaseSurface baseSurface, boolean bl, int n) {
        super(baseSurface, bl);
        this.requestedCapabilities = gLCapabilities;
        this.requestedChooser = gLCapabilitiesChooser;
        this.renderLeftFrame = true;
        this.quadBuffersAvailable = false;
        this.eyeSeparation = 0.001f;
        this.setStereoRenderingPolicy(n);
        this.init();
    }

    public boolean isStereoAvailable() {
        return true;
    }

    public boolean isQuadStereoAvailable() {
        return this.quadBuffersAvailable;
    }

    public void setStereoEyeSeparation(float f) {
        float f2 = this.eyeSeparation = f < 0.0f ? -f : f;
        if (this.canvasRenderer instanceof StereoRenderingProcessor) {
            StereoRenderingProcessor stereoRenderingProcessor = (StereoRenderingProcessor)this.canvasRenderer;
            stereoRenderingProcessor.setStereoEyeSeparation(f);
        }
    }

    public float getStereoEyeSeparation() {
        return this.eyeSeparation;
    }

    public void setStereoRenderingPolicy(int n) {
        GLContext gLContext = null;
        if (this.sharedSurface != null) {
            gLContext = this.sharedSurface.canvasContext;
        }
        this.canvas = this.lightweight ? new GLJPanel(this.requestedCapabilities, this.requestedChooser, gLContext) : new GLCanvas(this.requestedCapabilities, this.requestedChooser, gLContext, null);
        ((Component)this.canvas).addComponentListener(this.resizer);
        ((Component)this.canvas).setIgnoreRepaint(true);
        this.stereoRenderType = n;
        this.canvasContext = ((GLAutoDrawable)this.canvas).getContext();
        if (this.canvasContext == null) {
            return;
        }
        switch (n) {
            case 0: {
                this.canvasRenderer = new StandardRenderingProcessor(this.canvasContext);
                break;
            }
            case 1: {
                this.canvasRenderer = new QuadBufferStereoProcessor(this.canvasContext);
                StereoRenderingProcessor stereoRenderingProcessor = (StereoRenderingProcessor)this.canvasRenderer;
                stereoRenderingProcessor.setStereoEyeSeparation(this.eyeSeparation);
                break;
            }
            case 2: {
                this.canvasRenderer = new SingleEyeStereoProcessor(this.canvasContext);
                StereoRenderingProcessor stereoRenderingProcessor = (StereoRenderingProcessor)this.canvasRenderer;
                stereoRenderingProcessor.setStereoEyeSeparation(this.eyeSeparation);
                break;
            }
            case 3: {
                System.out.println("Dual canvas stereo is not implemented yet");
                return;
            }
            default: {
                throw new IllegalArgumentException("Unknown stereo policy");
            }
        }
    }

    public int getStereoRenderingPolicy() {
        return this.stereoRenderType;
    }

    public boolean draw(GraphicsProfilingData graphicsProfilingData) {
        if (!this.initComplete && !this.initCanvas()) {
            return false;
        }
        int n = this.numRenderables;
        GLPbuffer[] gLPbufferArray = this.renderableList;
        if (n > 1) {
            for (int i = 0; i < n && !this.terminate; ++i) {
                if (gLPbufferArray[i] == null) continue;
                gLPbufferArray[i].display();
            }
        }
        if (this.terminate) {
            return false;
        }
        switch (this.stereoRenderType) {
            case 2: {
                SingleEyeStereoProcessor singleEyeStereoProcessor = (SingleEyeStereoProcessor)this.canvasRenderer;
                singleEyeStereoProcessor.setEyeToRender(this.renderLeftFrame);
                this.canvasRenderer.render(graphicsProfilingData);
                this.renderLeftFrame = !this.renderLeftFrame;
                break;
            }
            default: {
                this.canvasRenderer.render(graphicsProfilingData);
            }
        }
        return !this.terminate;
    }

    public Object getSurfaceObject() {
        return this.canvas;
    }

    protected boolean createLightweightContext() {
        try {
            this.canvasContext = ((GLAutoDrawable)this.canvas).getContext();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.canvasContext != null) {
            ((GLJPanel)this.canvas).setAutoSwapBufferMode(false);
            switch (this.stereoRenderType) {
                case 0: {
                    this.canvasRenderer = new StandardRenderingProcessor(this.canvasContext);
                    break;
                }
                case 1: {
                    this.canvasRenderer = new QuadBufferStereoProcessor(this.canvasContext);
                    StereoRenderingProcessor stereoRenderingProcessor = (StereoRenderingProcessor)this.canvasRenderer;
                    stereoRenderingProcessor.setStereoEyeSeparation(this.eyeSeparation);
                    break;
                }
                case 2: {
                    this.canvasRenderer = new SingleEyeStereoProcessor(this.canvasContext);
                    StereoRenderingProcessor stereoRenderingProcessor = (StereoRenderingProcessor)this.canvasRenderer;
                    stereoRenderingProcessor.setStereoEyeSeparation(this.eyeSeparation);
                    break;
                }
                case 3: {
                    System.out.println("Dual canvas stereo is not implemented yet");
                }
            }
            return true;
        }
        return false;
    }

    public boolean completeCanvasInitialisation(GL gL) {
        byte[] byArray = new byte[1];
        gL.glGetBooleanv(3123, byArray, 0);
        this.quadBuffersAvailable = byArray[0] == 1;
        return true;
    }

    public void resychronizeRenderTarget() {
    }
}

