/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.output.graphics;

import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsListenerMulticaster;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsResizeListener;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;

class SWTResizeHandler
implements ControlListener {
    private static final String SIZE_ERROR_MSG = "Error sending size changed notification to: ";
    private GraphicsResizeListener listeners;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();

    SWTResizeHandler() {
    }

    public void controlMoved(ControlEvent controlEvent) {
        this.fireResizeNotification(controlEvent);
    }

    public void controlResized(ControlEvent controlEvent) {
        this.fireResizeNotification(controlEvent);
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public void addGraphicsResizeListener(GraphicsResizeListener graphicsResizeListener) {
        this.listeners = GraphicsListenerMulticaster.add(this.listeners, graphicsResizeListener);
    }

    public void removeGraphicsResizeListener(GraphicsResizeListener graphicsResizeListener) {
        this.listeners = GraphicsListenerMulticaster.remove(this.listeners, graphicsResizeListener);
    }

    private void fireResizeNotification(ControlEvent controlEvent) {
        if (this.listeners != null) {
            Control control = (Control)controlEvent.getSource();
            Point point = control.getSize();
            try {
                this.listeners.graphicsDeviceResized(0, 0, point.x, point.y);
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(SIZE_ERROR_MSG + this.listeners, exception);
            }
        }
    }
}

