/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.output.graphics;

import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import org.j3d.aviatrix3d.output.graphics.BaseBufferDescriptor;
import org.j3d.aviatrix3d.output.graphics.BaseRenderingProcessor;
import org.j3d.aviatrix3d.output.graphics.StereoRenderingProcessor;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsEnvironmentData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsProfilingData;
import org.j3d.aviatrix3d.rendering.BackgroundRenderable;
import org.j3d.aviatrix3d.rendering.BufferStateRenderable;
import org.j3d.aviatrix3d.rendering.ComponentRenderable;
import org.j3d.aviatrix3d.rendering.CustomGeometryRenderable;
import org.j3d.aviatrix3d.rendering.CustomRenderable;
import org.j3d.aviatrix3d.rendering.GeometryRenderable;
import org.j3d.aviatrix3d.rendering.ObjectRenderable;
import org.j3d.aviatrix3d.rendering.ShaderComponentRenderable;
import org.j3d.aviatrix3d.rendering.TextureRenderable;

public class QuadBufferStereoProcessor
extends BaseRenderingProcessor
implements StereoRenderingProcessor {
    private float eyeSeparation = 0.005f;
    private boolean stereoAvailability = false;

    public QuadBufferStereoProcessor(GLContext gLContext) {
        super(gLContext);
    }

    protected void init() {
        super.init();
        GL gL = this.glContext.getGL();
        byte[] byArray = new byte[1];
        gL.glGetBooleanv(3123, byArray, 0);
        this.stereoAvailability = byArray[0] == 1;
    }

    public void display(GraphicsProfilingData graphicsProfilingData) {
        GL gL = this.glContext.getGL();
        if (gL == null) {
            return;
        }
        this.processRequestData(gL);
        if (this.terminate) {
            return;
        }
        gL.glMatrixMode(5888);
        gL.glDrawBuffer(1026);
        if (this.terminate) {
            return;
        }
        this.render(gL, true, graphicsProfilingData);
        if (this.terminate) {
            return;
        }
        gL.glMatrixMode(5888);
        gL.glDrawBuffer(1027);
        if (this.terminate) {
            return;
        }
        this.render(gL, false, graphicsProfilingData);
    }

    public boolean isStereoAvailable() {
        return this.stereoAvailability;
    }

    public void setStereoEyeSeparation(float f) {
        this.eyeSeparation = f < 0.0f ? -f : f;
    }

    public float getStereoEyeSeparation() {
        return this.eyeSeparation;
    }

    private void render(GL gL, boolean bl, GraphicsProfilingData graphicsProfilingData) {
        GraphicsEnvironmentData graphicsEnvironmentData = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = true;
        ObjectRenderable objectRenderable = null;
        block35: for (int i = 0; i < this.numRenderables && !this.terminate; ++i) {
            switch (this.operationList[i]) {
                case 33: {
                    graphicsEnvironmentData = this.environmentList[n];
                    n3 = n++;
                    n4 = 0;
                    if (bl3) continue block35;
                    gL.glDrawBuffer(1033);
                    gL.glReadBuffer(1033);
                    this.setupMultipassViewport(gL, graphicsEnvironmentData);
                    continue block35;
                }
                case 40: {
                    if (bl3) continue block35;
                    gL.glDrawBuffer(1029);
                    gL.glRasterPos2i(graphicsEnvironmentData.viewport[0], graphicsEnvironmentData.viewport[1]);
                    gL.glCopyPixels(0, 0, graphicsEnvironmentData.viewport[2], graphicsEnvironmentData.viewport[3], 6144);
                    gL.glReadBuffer(1029);
                    continue block35;
                }
                case 34: {
                    if (n4 != 0) {
                        gL.glClear(n4);
                    }
                    graphicsEnvironmentData = this.environmentList[n];
                    this.preMPPassEnvironmentDraw(gL, graphicsEnvironmentData);
                    continue block35;
                }
                case 39: {
                    graphicsEnvironmentData = this.environmentList[n];
                    ++n;
                    this.postMPPassEnvironmentDraw(gL, graphicsEnvironmentData);
                    continue block35;
                }
                case 35: {
                    BufferStateRenderable bufferStateRenderable = (BufferStateRenderable)this.renderableList[i].renderable;
                    bufferStateRenderable.setBufferState(gL);
                    if (!bufferStateRenderable.checkClearBufferState()) continue block35;
                    n4 |= bufferStateRenderable.getBufferBitMask();
                    continue block35;
                }
                case 36: {
                    BufferStateRenderable bufferStateRenderable = (BufferStateRenderable)this.renderableList[i].renderable;
                    if (bufferStateRenderable.checkClearBufferState()) {
                        n4 |= bufferStateRenderable.getBufferBitMask();
                        continue block35;
                    }
                    n4 &= ~bufferStateRenderable.getBufferBitMask();
                    continue block35;
                }
                case 37: {
                    BufferStateRenderable bufferStateRenderable = (BufferStateRenderable)this.renderableList[i].renderable;
                    bufferStateRenderable.updateBufferState(gL);
                    if (bufferStateRenderable.checkClearBufferState()) {
                        n4 |= bufferStateRenderable.getBufferBitMask();
                        continue block35;
                    }
                    n4 &= ~bufferStateRenderable.getBufferBitMask();
                    continue block35;
                }
                case 38: {
                    BufferStateRenderable bufferStateRenderable = (BufferStateRenderable)this.renderableList[i].renderable;
                    bufferStateRenderable.clearBufferState(gL);
                    n4 &= ~bufferStateRenderable.getBufferBitMask();
                    continue block35;
                }
                case 29: {
                    gL.glClear(256);
                    n2 = n;
                    graphicsEnvironmentData = this.environmentList[n2];
                    bl2 = graphicsEnvironmentData.fog != null;
                    objectRenderable = graphicsEnvironmentData.fog;
                    this.preLayerEnvironmentDraw(gL, graphicsEnvironmentData, bl);
                    continue block35;
                }
                case 30: {
                    graphicsEnvironmentData = this.environmentList[n2];
                    this.postLayerEnvironmentDraw(gL, graphicsEnvironmentData, graphicsProfilingData);
                    bl2 = false;
                    bl3 = false;
                    n2 = ++n;
                    continue block35;
                }
                case 31: {
                    graphicsEnvironmentData = this.environmentList[n2];
                    this.setupViewport(gL, graphicsEnvironmentData);
                    continue block35;
                }
                case 32: {
                    continue block35;
                }
                case 1: {
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform, 0);
                    ObjectRenderable objectRenderable2 = (ObjectRenderable)this.renderableList[i].renderable;
                    objectRenderable2.render(gL);
                    continue block35;
                }
                case 2: {
                    ObjectRenderable objectRenderable2 = (ObjectRenderable)this.renderableList[i].renderable;
                    objectRenderable2.postRender(gL);
                    gL.glPopMatrix();
                    continue block35;
                }
                case 5: {
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform, 0);
                    ((GeometryRenderable)this.renderableList[i].renderable).render(gL);
                    gL.glPopMatrix();
                    continue block35;
                }
                case 6: {
                    gL.glRasterPos2f(this.renderableList[i].transform[3], this.renderableList[i].transform[7]);
                    gL.glPixelZoom(this.renderableList[i].transform[0], this.renderableList[i].transform[5]);
                    ((GeometryRenderable)this.renderableList[i].renderable).render(gL);
                    gL.glPopMatrix();
                    continue block35;
                }
                case 7: {
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform, 0);
                    CustomGeometryRenderable customGeometryRenderable = (CustomGeometryRenderable)this.renderableList[i].renderable;
                    customGeometryRenderable.render(gL, this.renderableList[i].instructions);
                    gL.glPopMatrix();
                    continue block35;
                }
                case 9: {
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform, 0);
                    CustomRenderable customRenderable = (CustomRenderable)this.renderableList[i].renderable;
                    customRenderable.render(gL, this.renderableList[i].instructions);
                    gL.glPopMatrix();
                    continue block35;
                }
                case 10: {
                    ObjectRenderable objectRenderable2 = (ObjectRenderable)this.renderableList[i].renderable;
                    objectRenderable2.render(gL);
                    continue block35;
                }
                case 11: {
                    ObjectRenderable objectRenderable2 = (ObjectRenderable)this.renderableList[i].renderable;
                    objectRenderable2.postRender(gL);
                    continue block35;
                }
                case 12: {
                    if (this.lastLightIdx >= this.availableLights.length) continue block35;
                    Integer n5 = this.availableLights[this.lastLightIdx++];
                    this.lightIdMap.put(this.renderableList[i].id, (Object)n5);
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform, 0);
                    ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[i].renderable;
                    componentRenderable.render(gL, n5);
                    gL.glPopMatrix();
                    continue block35;
                }
                case 13: {
                    if (this.lastLightIdx >= this.availableLights.length) continue block35;
                    Integer n5 = (Integer)this.lightIdMap.remove(this.renderableList[i].id);
                    ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[i].renderable;
                    componentRenderable.postRender(gL, n5);
                    this.availableLights[--this.lastLightIdx] = n5;
                    continue block35;
                }
                case 20: {
                    if (this.lastClipIdx >= this.availableClips.length) continue block35;
                    Integer n6 = this.availableClips[this.lastClipIdx++];
                    this.clipIdMap.put(this.renderableList[i].id, (Object)n6);
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform, 0);
                    ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[i].renderable;
                    componentRenderable.render(gL, n6);
                    gL.glPopMatrix();
                    continue block35;
                }
                case 21: {
                    if (this.lastClipIdx >= this.availableClips.length) continue block35;
                    Integer n6 = (Integer)this.clipIdMap.remove(this.renderableList[i].id);
                    ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[i].renderable;
                    componentRenderable.postRender(gL, n6);
                    this.availableClips[--this.lastClipIdx] = n6;
                    continue block35;
                }
                case 14: {
                    gL.glDepthMask(false);
                    gL.glEnable(3042);
                    gL.glBlendFunc(770, 771);
                    continue block35;
                }
                case 15: {
                    gL.glDisable(3042);
                    gL.glDepthMask(true);
                    continue block35;
                }
                case 22: {
                    if (!bl2) {
                        gL.glEnable(2912);
                        bl2 = true;
                    }
                    ObjectRenderable objectRenderable2 = (ObjectRenderable)this.renderableList[i].renderable;
                    objectRenderable2.render(gL);
                    continue block35;
                }
                case 23: {
                    if (objectRenderable != null) {
                        objectRenderable.render(gL);
                        continue block35;
                    }
                    ObjectRenderable objectRenderable2 = (ObjectRenderable)this.renderableList[i].renderable;
                    objectRenderable2.postRender(gL);
                    bl2 = false;
                    gL.glDisable(2912);
                    continue block35;
                }
                case 24: {
                    ShaderComponentRenderable shaderComponentRenderable = (ShaderComponentRenderable)this.renderableList[i].renderable;
                    if (!shaderComponentRenderable.isValid(gL)) {
                        this.currentShaderProgramId = INVALID_SHADER;
                        continue block35;
                    }
                    this.currentShaderProgramId = new Integer(shaderComponentRenderable.getProgramId(gL));
                    shaderComponentRenderable.render(gL);
                    continue block35;
                }
                case 25: {
                    if (this.currentShaderProgramId == INVALID_SHADER) continue block35;
                    ObjectRenderable objectRenderable2 = (ObjectRenderable)this.renderableList[i].renderable;
                    objectRenderable2.postRender(gL);
                    this.currentShaderProgramId = INVALID_SHADER;
                    continue block35;
                }
                case 26: {
                    if (this.currentShaderProgramId == INVALID_SHADER) continue block35;
                    ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[i].renderable;
                    componentRenderable.render(gL, this.currentShaderProgramId);
                    continue block35;
                }
                case 27: {
                    Object object;
                    TextureRenderable textureRenderable = (TextureRenderable)this.renderableList[i].renderable;
                    if (textureRenderable.isOffscreenSource()) {
                        object = (BaseBufferDescriptor)textureRenderable.getBuffer(this.glContext);
                        ((BaseBufferDescriptor)object).unbindBuffer();
                    }
                    object = (Integer)this.renderableList[i].instructions;
                    textureRenderable.render(gL, object);
                    continue block35;
                }
                case 28: {
                    TextureRenderable textureRenderable = (TextureRenderable)this.renderableList[i].renderable;
                    if (textureRenderable.isOffscreenSource()) {
                        BaseBufferDescriptor baseBufferDescriptor = (BaseBufferDescriptor)textureRenderable.getBuffer(this.glContext);
                        baseBufferDescriptor.unbindBuffer();
                    }
                    Object object = (Integer)this.renderableList[i].instructions;
                    textureRenderable.postRender(gL, object);
                }
            }
        }
        if (this.terminate) {
            return;
        }
        gL.glFlush();
    }

    protected void setupViewport(GL gL, GraphicsEnvironmentData graphicsEnvironmentData) {
        if (!graphicsEnvironmentData.useStereo) {
            super.setupViewport(gL, graphicsEnvironmentData);
        } else {
            gL.glViewport(graphicsEnvironmentData.viewport[0], graphicsEnvironmentData.viewport[1], graphicsEnvironmentData.viewport[2], graphicsEnvironmentData.viewport[3]);
        }
    }

    protected void preLayerEnvironmentDraw(GL gL, GraphicsEnvironmentData graphicsEnvironmentData, boolean bl) {
        if (!graphicsEnvironmentData.useStereo) {
            super.preLayerEnvironmentDraw(gL, graphicsEnvironmentData);
        } else {
            if (graphicsEnvironmentData.effectsProcessor != null) {
                graphicsEnvironmentData.effectsProcessor.preDraw(gL, graphicsEnvironmentData.userData);
            }
            if (graphicsEnvironmentData.background != null) {
                if (((BackgroundRenderable)graphicsEnvironmentData.background).is2D()) {
                    graphicsEnvironmentData.background.render(gL);
                    graphicsEnvironmentData.background.postRender(gL);
                } else {
                    gL.glMatrixMode(5889);
                    gL.glPushMatrix();
                    gL.glLoadIdentity();
                    gL.glFrustum(graphicsEnvironmentData.backgroundFrustum[0], graphicsEnvironmentData.backgroundFrustum[1], graphicsEnvironmentData.backgroundFrustum[2], graphicsEnvironmentData.backgroundFrustum[3], graphicsEnvironmentData.backgroundFrustum[4], graphicsEnvironmentData.backgroundFrustum[5]);
                    gL.glClear(256);
                    gL.glMatrixMode(5888);
                    gL.glPushMatrix();
                    gL.glLoadMatrixf(graphicsEnvironmentData.backgroundTransform, 0);
                    gL.glDepthMask(false);
                    gL.glDisable(3042);
                    gL.glDisable(2929);
                    graphicsEnvironmentData.background.render(gL);
                    graphicsEnvironmentData.background.postRender(gL);
                    gL.glDepthMask(true);
                    gL.glEnable(2929);
                    gL.glEnable(3042);
                    gL.glPopMatrix();
                    gL.glMatrixMode(5889);
                    gL.glPopMatrix();
                    gL.glMatrixMode(5888);
                }
            }
            this.renderViewpoint(gL, graphicsEnvironmentData, bl);
            if (graphicsEnvironmentData.fog != null) {
                gL.glEnable(2912);
                graphicsEnvironmentData.fog.render(gL);
            }
        }
    }

    private void renderViewpoint(GL gL, GraphicsEnvironmentData graphicsEnvironmentData, boolean bl) {
        this.updateProjectionMatrix(gL, graphicsEnvironmentData, bl);
        gL.glLoadIdentity();
        if (bl) {
            gL.glTranslated(0.0, 0.0, (double)(-this.eyeSeparation));
        } else {
            gL.glTranslated(0.0, 0.0, (double)this.eyeSeparation);
        }
        graphicsEnvironmentData.viewpoint.render(gL);
        gL.glMultMatrixf(graphicsEnvironmentData.cameraTransform, 0);
    }

    private void updateProjectionMatrix(GL gL, GraphicsEnvironmentData graphicsEnvironmentData, boolean bl) {
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        switch (graphicsEnvironmentData.viewProjectionType) {
            case 1: {
                if (bl) {
                    gL.glFrustum(graphicsEnvironmentData.viewFrustum[0] - (double)this.eyeSeparation, graphicsEnvironmentData.viewFrustum[1], graphicsEnvironmentData.viewFrustum[2], graphicsEnvironmentData.viewFrustum[3] - (double)this.eyeSeparation, graphicsEnvironmentData.viewFrustum[4], graphicsEnvironmentData.viewFrustum[5]);
                    break;
                }
                gL.glFrustum(graphicsEnvironmentData.viewFrustum[0] + (double)this.eyeSeparation, graphicsEnvironmentData.viewFrustum[1], graphicsEnvironmentData.viewFrustum[2], graphicsEnvironmentData.viewFrustum[3] + (double)this.eyeSeparation, graphicsEnvironmentData.viewFrustum[4], graphicsEnvironmentData.viewFrustum[5]);
                break;
            }
            case 2: {
                gL.glOrtho(0.0, (double)graphicsEnvironmentData.viewport[2], 0.0, (double)graphicsEnvironmentData.viewport[3], graphicsEnvironmentData.viewFrustum[4], graphicsEnvironmentData.viewFrustum[5]);
                break;
            }
            default: {
                System.out.println("unknown projection type");
            }
        }
        gL.glMatrixMode(5888);
    }
}

