/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.output.graphics;

import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import org.j3d.aviatrix3d.output.graphics.BaseSurface;
import org.j3d.aviatrix3d.output.graphics.PbufferUnavailableException;
import org.j3d.aviatrix3d.output.graphics.StandardRenderingProcessor;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsResizeListener;

public class PbufferSurface
extends BaseSurface {
    private static final String RESIZE_CALLBACK_ERR = "The GraphicsResizeListener we just called has tossed a wobbly";
    private static final String NOT_AVAILABLE_MSG = "The underlying platform cannot create pbuffers.";
    private final int surfaceWidth;
    private final int surfaceHeight;

    public PbufferSurface(GLCapabilities gLCapabilities, int n, int n2) throws PbufferUnavailableException {
        this(gLCapabilities, null, null, n, n2);
    }

    public PbufferSurface(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) throws PbufferUnavailableException {
        this(gLCapabilities, gLCapabilitiesChooser, null, n, n2);
    }

    public PbufferSurface(GLCapabilities gLCapabilities, BaseSurface baseSurface, int n, int n2) throws PbufferUnavailableException {
        this(gLCapabilities, null, baseSurface, n, n2);
    }

    public PbufferSurface(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, BaseSurface baseSurface, int n, int n2) throws PbufferUnavailableException {
        super(baseSurface);
        this.surfaceWidth = n;
        this.surfaceHeight = n2;
        this.init(gLCapabilities, gLCapabilitiesChooser);
    }

    public Object getSurfaceObject() {
        return this.canvas;
    }

    public void addGraphicsResizeListener(GraphicsResizeListener graphicsResizeListener) {
        try {
            graphicsResizeListener.graphicsDeviceResized(0, 0, this.surfaceWidth, this.surfaceHeight);
        }
        catch (Exception exception) {
            this.errorReporter.errorReport(RESIZE_CALLBACK_ERR, exception);
        }
    }

    public void removeGraphicsResizeListener(GraphicsResizeListener graphicsResizeListener) {
    }

    private void init(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) throws PbufferUnavailableException {
        GLDrawableFactory gLDrawableFactory;
        GLContext gLContext = null;
        if (this.sharedSurface != null) {
            gLContext = this.sharedSurface.getGLContext();
        }
        if (!(gLDrawableFactory = GLDrawableFactory.getFactory()).canCreateGLPbuffer()) {
            throw new PbufferUnavailableException(NOT_AVAILABLE_MSG);
        }
        this.canvas = gLDrawableFactory.createGLPbuffer(gLCapabilities, gLCapabilitiesChooser, this.surfaceWidth, this.surfaceHeight, gLContext);
        this.canvasContext = ((GLAutoDrawable)this.canvas).getContext();
        this.canvasRenderer = new StandardRenderingProcessor(this.canvasContext);
        this.init();
    }
}

