/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.output.graphics;

import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.vecmath.Point3f;
import org.j3d.aviatrix3d.output.graphics.BaseRenderingProcessor;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsEnvironmentData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsProfilingData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsResizeListener;
import org.j3d.aviatrix3d.rendering.ComponentRenderable;
import org.j3d.aviatrix3d.rendering.CustomGeometryRenderable;
import org.j3d.aviatrix3d.rendering.CustomRenderable;
import org.j3d.aviatrix3d.rendering.GeometryRenderable;
import org.j3d.aviatrix3d.rendering.ObjectRenderable;
import org.j3d.aviatrix3d.rendering.ShaderComponentRenderable;
import org.j3d.device.output.elumens.SPI;

public class ElumensRenderingProcessor
extends BaseRenderingProcessor
implements GraphicsResizeListener {
    private SPI spi = new SPI();
    private boolean initSpi = true;
    private boolean initComplete;
    private int newNumChannels = 3;
    private int numChannels;
    private int spiFormat = 2049;
    private double lastNear;
    private double lastFar;
    private boolean terminate;
    private float[] eyePos;
    private float[] lensPos;
    private double[] screenOrientation;
    private int[] chanSize = new int[]{1024, 1024};
    private int windowWidth;
    private int windowHeight;
    private boolean resizeNeeded = false;

    public ElumensRenderingProcessor(GLContext gLContext) {
        super(gLContext);
    }

    public void graphicsDeviceResized(int n, int n2, int n3, int n4) {
        this.windowWidth = n3;
        this.windowHeight = n4;
        this.resizeNeeded = true;
    }

    public void init() {
        super.init();
        this.spi = new SPI();
        this.initializeSPI();
    }

    public void display(GraphicsProfilingData graphicsProfilingData) {
        int n;
        GL gL;
        int n2;
        if (this.resizeNeeded) {
            n2 = this.windowWidth > this.chanSize[0] ? this.chanSize[0] : this.windowWidth;
            int n3 = this.windowHeight > this.chanSize[1] ? this.chanSize[1] : this.windowHeight;
            for (int i = 0; i < this.numChannels; ++i) {
                this.spi.setChanSize(this.getSpiToken(i), n2, n3);
            }
            this.resizeNeeded = false;
        }
        if ((gL = this.glContext.getGL()) == null) {
            return;
        }
        this.processRequestData(gL);
        if (this.terminate) {
            return;
        }
        if (this.initSpi) {
            this.initializeSPI();
        }
        if (this.terminate) {
            return;
        }
        if (this.alwaysLocalClear) {
            GLDrawable gLDrawable = this.glContext.getGLDrawable();
            int n4 = gLDrawable.getWidth();
            n = gLDrawable.getHeight();
            gL.glViewport(0, 0, n4, n);
            gL.glScissor(0, 0, n4, n);
            gL.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
            gL.glClear(16384);
        }
        n = 0;
        boolean bl = false;
        ObjectRenderable objectRenderable = null;
        this.renderViewpoint(gL, this.environmentList[0]);
        if (this.terminate) {
            return;
        }
        this.spi.begin();
        if (this.terminate) {
            return;
        }
        for (int i = 0; i < this.numChannels && !this.terminate; ++i) {
            n2 = this.getSpiToken(i);
            this.spi.preRender(n2);
            block34: for (int j = 0; j < this.numRenderables && !this.terminate; ++j) {
                switch (this.operationList[j]) {
                    case 29: {
                        gL.glClear(256);
                        GraphicsEnvironmentData graphicsEnvironmentData = this.environmentList[n];
                        bl = graphicsEnvironmentData.fog != null;
                        objectRenderable = graphicsEnvironmentData.fog;
                        this.preLayerEnvironmentDraw(gL, graphicsEnvironmentData);
                        continue block34;
                    }
                    case 30: {
                        GraphicsEnvironmentData graphicsEnvironmentData = this.environmentList[n];
                        this.postLayerEnvironmentDraw(gL, graphicsEnvironmentData, graphicsProfilingData);
                        bl = false;
                        ++n;
                        continue block34;
                    }
                    case 31: {
                        GraphicsEnvironmentData graphicsEnvironmentData = this.environmentList[n];
                        this.setupViewport(gL, graphicsEnvironmentData);
                        continue block34;
                    }
                    case 32: {
                        continue block34;
                    }
                    case 1: {
                        gL.glPushMatrix();
                        gL.glMultMatrixf(this.renderableList[j].transform, 0);
                        ObjectRenderable objectRenderable2 = (ObjectRenderable)this.renderableList[j].renderable;
                        objectRenderable2.render(gL);
                        continue block34;
                    }
                    case 2: {
                        ObjectRenderable objectRenderable3 = (ObjectRenderable)this.renderableList[j].renderable;
                        objectRenderable3.postRender(gL);
                        gL.glPopMatrix();
                        continue block34;
                    }
                    case 5: {
                        gL.glPushMatrix();
                        gL.glMultMatrixf(this.renderableList[j].transform, 0);
                        ((GeometryRenderable)this.renderableList[j].renderable).render(gL);
                        gL.glPopMatrix();
                        continue block34;
                    }
                    case 7: {
                        gL.glPushMatrix();
                        gL.glMultMatrixf(this.renderableList[j].transform, 0);
                        CustomGeometryRenderable customGeometryRenderable = (CustomGeometryRenderable)this.renderableList[j].renderable;
                        customGeometryRenderable.render(gL, this.renderableList[j].instructions);
                        gL.glPopMatrix();
                        continue block34;
                    }
                    case 9: {
                        gL.glPushMatrix();
                        gL.glMultMatrixf(this.renderableList[j].transform, 0);
                        CustomRenderable customRenderable = (CustomRenderable)this.renderableList[j].renderable;
                        customRenderable.render(gL, this.renderableList[j].instructions);
                        gL.glPopMatrix();
                        continue block34;
                    }
                    case 10: {
                        ObjectRenderable objectRenderable4 = (ObjectRenderable)this.renderableList[j].renderable;
                        objectRenderable4.render(gL);
                        continue block34;
                    }
                    case 11: {
                        ObjectRenderable objectRenderable5 = (ObjectRenderable)this.renderableList[j].renderable;
                        objectRenderable5.postRender(gL);
                        continue block34;
                    }
                    case 12: {
                        if (this.lastLightIdx >= this.availableLights.length) continue block34;
                        Integer n5 = this.availableLights[this.lastLightIdx++];
                        this.lightIdMap.put(this.renderableList[j].id, (Object)n5);
                        gL.glPushMatrix();
                        gL.glMultMatrixf(this.renderableList[j].transform, 0);
                        ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[j].renderable;
                        componentRenderable.render(gL, n5);
                        gL.glPopMatrix();
                        continue block34;
                    }
                    case 13: {
                        if (this.lastLightIdx >= this.availableLights.length) continue block34;
                        Integer n5 = (Integer)this.lightIdMap.remove(this.renderableList[j].id);
                        ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[j].renderable;
                        componentRenderable.postRender(gL, n5);
                        this.availableLights[--this.lastLightIdx] = n5;
                        continue block34;
                    }
                    case 20: {
                        if (this.lastClipIdx >= this.availableClips.length) continue block34;
                        Integer n6 = this.availableClips[this.lastClipIdx++];
                        this.clipIdMap.put(this.renderableList[j].id, (Object)n6);
                        gL.glPushMatrix();
                        gL.glMultMatrixf(this.renderableList[j].transform, 0);
                        ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[j].renderable;
                        componentRenderable.render(gL, n6);
                        gL.glPopMatrix();
                        continue block34;
                    }
                    case 21: {
                        if (this.lastClipIdx >= this.availableClips.length) continue block34;
                        Integer n6 = (Integer)this.clipIdMap.remove(this.renderableList[j].id);
                        ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[j].renderable;
                        componentRenderable.postRender(gL, n6);
                        this.availableClips[--this.lastClipIdx] = n6;
                        continue block34;
                    }
                    case 14: {
                        gL.glDepthMask(false);
                        gL.glEnable(3042);
                        gL.glBlendFunc(770, 771);
                        continue block34;
                    }
                    case 15: {
                        gL.glDisable(3042);
                        gL.glDepthMask(true);
                        continue block34;
                    }
                    case 22: {
                        if (!bl) {
                            gL.glEnable(2912);
                            bl = true;
                        }
                        ObjectRenderable objectRenderable6 = (ObjectRenderable)this.renderableList[j].renderable;
                        objectRenderable6.render(gL);
                        continue block34;
                    }
                    case 23: {
                        if (objectRenderable != null) {
                            objectRenderable.render(gL);
                            continue block34;
                        }
                        ObjectRenderable objectRenderable7 = (ObjectRenderable)this.renderableList[j].renderable;
                        objectRenderable7.postRender(gL);
                        bl = false;
                        gL.glDisable(2912);
                        continue block34;
                    }
                    case 24: {
                        ShaderComponentRenderable shaderComponentRenderable = (ShaderComponentRenderable)this.renderableList[j].renderable;
                        if (!shaderComponentRenderable.isValid(gL)) {
                            this.currentShaderProgramId = INVALID_SHADER;
                            continue block34;
                        }
                        this.currentShaderProgramId = new Integer(shaderComponentRenderable.getProgramId(gL));
                        shaderComponentRenderable.render(gL);
                        continue block34;
                    }
                    case 25: {
                        if (this.currentShaderProgramId == INVALID_SHADER) continue block34;
                        ObjectRenderable objectRenderable8 = (ObjectRenderable)this.renderableList[j].renderable;
                        objectRenderable8.postRender(gL);
                        this.currentShaderProgramId = INVALID_SHADER;
                        continue block34;
                    }
                    case 26: {
                        if (this.currentShaderProgramId == INVALID_SHADER) continue block34;
                        ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[j].renderable;
                        componentRenderable.render(gL, this.currentShaderProgramId);
                        continue block34;
                    }
                    case 27: {
                        ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[j].renderable;
                        Integer n7 = (Integer)this.renderableList[j].instructions;
                        componentRenderable.render(gL, n7);
                        continue block34;
                    }
                    case 28: {
                        ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[j].renderable;
                        Integer n7 = (Integer)this.renderableList[j].instructions;
                        componentRenderable.postRender(gL, n7);
                    }
                }
            }
            if (this.terminate) {
                return;
            }
            gL.glFlush();
            if (this.terminate) {
                return;
            }
            this.spi.postRender(n2);
        }
        this.environmentList[0].viewpoint.postRender(gL);
        if (this.terminate) {
            return;
        }
        this.spi.end();
        gL.glClearColor(0.0f, 0.0f, 0.4f, 1.0f);
        gL.glClear(0x4000 | 0x100);
        switch (this.numChannels) {
            case 1: {
                this.spi.flush(1);
                break;
            }
            case 2: {
                this.spi.flush(6);
                break;
            }
            case 3: {
                this.spi.flush(56);
                break;
            }
            case 4: {
                this.spi.flush(120);
            }
        }
    }

    public void getPixelLocationInSurface(float f, float f2, Point3f point3f) {
        System.out.println("ElumensRenderingProcessor::getPixelLocationInSurface() not fixed yet");
    }

    public void getCenterEyeInSurface(Point3f point3f) {
        point3f.set(this.eyePoint);
    }

    void setChanLensPosition(int n, float f, float f2, float f3) {
        this.lensPos = new float[]{f, f2, f3};
        if (this.initComplete) {
            this.spi.setChanLensPosition(n, this.lensPos[0], this.lensPos[1], this.lensPos[2]);
        }
    }

    void setChanEyePosition(int n, float f, float f2, float f3) {
        this.eyePos = new float[]{f, f2, f3};
        if (this.initComplete) {
            this.spi.setChanEyePosition(n, this.eyePos[0], this.eyePos[1], this.eyePos[2]);
        }
    }

    void setScreenOrientation(double d, double d2, double d3) {
        this.screenOrientation = new double[]{d, d2, d3};
        if (this.initComplete) {
            this.spi.setScreenOrientation(this.screenOrientation[0], this.screenOrientation[1], this.screenOrientation[2]);
        }
    }

    void setChanSize(int n, int n2, int n3) {
        this.chanSize = new int[]{n2, n3};
        if (this.initComplete) {
            this.spi.setChanSize(n, n2, n3);
        }
    }

    void setNumberOfChannels(int n) {
        this.newNumChannels = n;
        this.initSpi = true;
    }

    private int getSpiToken(int n) {
        switch (this.numChannels) {
            case 1: {
                return 1;
            }
            case 2: {
                switch (n) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 4;
                    }
                }
                System.out.println("Unknown wall: " + n);
            }
            case 3: {
                switch (n) {
                    case 0: {
                        return 8;
                    }
                    case 1: {
                        return 16;
                    }
                    case 2: {
                        return 32;
                    }
                }
                System.out.println("Unknown wall: " + n);
            }
            case 4: {
                switch (n) {
                    case 0: {
                        return 8;
                    }
                    case 1: {
                        return 16;
                    }
                    case 2: {
                        return 32;
                    }
                    case 3: {
                        return 64;
                    }
                }
                System.out.println("Unknown wall: " + n);
            }
        }
        System.out.println("Unsupported number of channels in: " + this);
        return 0;
    }

    private int getSpiFormat() {
        int n = 1;
        switch (this.numChannels) {
            case 1: {
                return 0x200 | n;
            }
            case 2: {
                return 0x400 | n;
            }
            case 3: {
                return 0x800 | n;
            }
            case 4: {
                return 0x1000 | n;
            }
        }
        System.out.println("Unsupported number of channels in: " + this);
        return 0;
    }

    private void initializeSPI() {
        this.numChannels = this.newNumChannels;
        this.spiFormat = this.getSpiFormat();
        this.spi.initialize(this.spiFormat, this.numChannels);
        float f = 0.1f;
        float f2 = 3000.0f;
        this.lastNear = f;
        this.lastFar = f2;
        this.spi.setNearFar(f, f2);
        int n = 0;
        switch (this.numChannels) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 6;
                break;
            }
            case 3: {
                n = 56;
                break;
            }
            case 4: {
                n = 120;
            }
        }
        if (this.initComplete) {
            int n2 = this.windowWidth > this.chanSize[0] ? this.chanSize[0] : this.windowWidth;
            int n3 = this.windowHeight > this.chanSize[1] ? this.chanSize[1] : this.windowHeight;
            switch (this.numChannels) {
                case 1: {
                    this.spi.setChanSize(1, n2, n3);
                    break;
                }
                case 2: {
                    this.spi.setChanSize(6, n2, n3);
                    break;
                }
                case 3: {
                    this.spi.setChanSize(56, n2, n3);
                    break;
                }
                case 4: {
                    this.spi.setChanSize(120, n2, n3);
                }
            }
        }
        if (this.lensPos != null) {
            System.out.println("Setting lensPosition: " + this.lensPos[0] + " " + this.lensPos[1] + " " + this.lensPos[2]);
            this.spi.setChanLensPosition(n, this.lensPos[0], this.lensPos[1], this.lensPos[2]);
        }
        if (this.eyePos != null) {
            System.out.println("Setting eyePosition: " + this.eyePos[0] + " " + this.eyePos[1] + " " + this.eyePos[2]);
            this.spi.setChanEyePosition(n, this.eyePos[0], this.eyePos[1], this.eyePos[2]);
        }
        if (this.screenOrientation != null) {
            System.out.println("Setting screenOrientation: " + this.screenOrientation[0] + " " + this.screenOrientation[1] + " " + this.screenOrientation[2]);
            this.spi.setScreenOrientation(this.screenOrientation[0], this.screenOrientation[1], this.screenOrientation[2]);
        }
        this.initSpi = false;
    }

    protected void updateProjectionMatrix(GL gL, GraphicsEnvironmentData graphicsEnvironmentData) {
        super.updateProjectionMatrix(gL, graphicsEnvironmentData);
        this.spi.setNearFar((float)graphicsEnvironmentData.viewFrustum[4], (float)graphicsEnvironmentData.viewFrustum[5]);
    }
}

