/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.output.graphics;

import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.TraceGL;
import javax.media.opengl.glu.GLU;
import org.j3d.aviatrix3d.output.graphics.BaseBufferDescriptor;
import org.j3d.aviatrix3d.output.graphics.BaseRenderingProcessor;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsEnvironmentData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsProfilingData;
import org.j3d.aviatrix3d.rendering.BufferStateRenderable;
import org.j3d.aviatrix3d.rendering.ComponentRenderable;
import org.j3d.aviatrix3d.rendering.CustomGeometryRenderable;
import org.j3d.aviatrix3d.rendering.CustomRenderable;
import org.j3d.aviatrix3d.rendering.GeometryRenderable;
import org.j3d.aviatrix3d.rendering.ObjectRenderable;
import org.j3d.aviatrix3d.rendering.Renderable;
import org.j3d.aviatrix3d.rendering.ShaderComponentRenderable;
import org.j3d.aviatrix3d.rendering.TextureRenderable;

public class DebugRenderingProcessor
extends BaseRenderingProcessor {
    private static final boolean PRINT_STATES = false;
    private TraceGL debugGL;
    private int dumpNextFrameCount = 0;
    private GLU glu = new GLU();
    private boolean initialised;

    public DebugRenderingProcessor(GLContext gLContext) {
        this(gLContext, null);
    }

    public DebugRenderingProcessor(GLContext gLContext, BaseBufferDescriptor baseBufferDescriptor) {
        super(gLContext, baseBufferDescriptor);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void display(GraphicsProfilingData graphicsProfilingData) {
        Object object;
        GL gL = this.glContext.getGL();
        if (gL == null) {
            return;
        }
        if (this.ownerRenderable != null && !this.ownerRenderable.isInitialised()) {
            this.ownerRenderable.initialise(gL);
        }
        this.processRequestData(gL);
        if (this.terminate) {
            return;
        }
        boolean bl = false;
        if (this.dumpNextFrameCount != 0) {
            --this.dumpNextFrameCount;
            bl = true;
        }
        if (bl) {
            if (this.ownerRenderable != null) {
                System.out.println("*** Starting Pbuffer render***");
            } else {
                System.out.println("*** Starting final render***");
            }
        }
        if (bl) {
            if (this.debugGL == null) {
                this.debugGL = new TraceGL(gL, System.out);
            }
            gL = this.debugGL;
        }
        if (this.terminate) {
            return;
        }
        if (this.alwaysLocalClear) {
            int n;
            object = this.glContext.getGLDrawable();
            int n2 = object.getWidth();
            int n3 = object.getHeight();
            gL.glViewport(0, 0, n2, n3);
            gL.glScissor(0, 0, n2, n3);
            gL.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
            gL.glClear(16384);
            if (bl && (n = gL.glGetError()) != 0) {
                System.out.println("Error: after clearing local");
                System.out.println(this.glu.gluErrorString(n));
            }
        }
        GraphicsEnvironmentData graphicsEnvironmentData = null;
        int n = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl2 = false;
        boolean bl3 = true;
        ObjectRenderable objectRenderable = null;
        block37: for (int i = 0; i < this.numRenderables && !this.terminate; ++i) {
            int n7;
            switch (this.operationList[i]) {
                case 33: {
                    if (bl) {
                        System.out.println("Start multipass. First layer? " + bl3);
                    }
                    n6 = 0;
                    graphicsEnvironmentData = this.environmentList[n];
                    n5 = n++;
                    if (bl3) break;
                    gL.glDrawBuffer(1033);
                    gL.glReadBuffer(1033);
                    this.setupMultipassViewport(gL, graphicsEnvironmentData);
                    break;
                }
                case 40: {
                    if (bl) {
                        System.out.println("Stop multipass. First layer? " + bl3);
                    }
                    if (bl3) break;
                    gL.glDrawBuffer(1029);
                    gL.glRasterPos2i(graphicsEnvironmentData.viewport[0], graphicsEnvironmentData.viewport[1]);
                    gL.glCopyPixels(0, 0, graphicsEnvironmentData.viewport[2], graphicsEnvironmentData.viewport[3], 6144);
                    gL.glReadBuffer(1029);
                    break;
                }
                case 34: {
                    if (bl) {
                        System.out.println("Start multipass pass. Clear Buffers 0x" + Integer.toHexString(n6));
                    }
                    if (n6 != 0) {
                        gL.glClear(n6);
                    }
                    graphicsEnvironmentData = this.environmentList[n];
                    this.preMPPassEnvironmentDraw(gL, graphicsEnvironmentData);
                    break;
                }
                case 39: {
                    if (bl) {
                        System.out.println("Stop multipass pass.");
                    }
                    graphicsEnvironmentData = this.environmentList[n];
                    ++n;
                    this.postMPPassEnvironmentDraw(gL, graphicsEnvironmentData);
                    break;
                }
                case 35: {
                    if (bl) {
                        Renderable renderable = this.renderableList[i].renderable;
                        System.out.println("Start buffer state " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    BufferStateRenderable bufferStateRenderable = (BufferStateRenderable)this.renderableList[i].renderable;
                    bufferStateRenderable.setBufferState(gL);
                    if (!bufferStateRenderable.checkClearBufferState()) break;
                    n6 |= bufferStateRenderable.getBufferBitMask();
                    break;
                }
                case 36: {
                    if (bl) {
                        Renderable renderable = this.renderableList[i].renderable;
                        System.out.println("Set buffer clear bit " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    BufferStateRenderable bufferStateRenderable = (BufferStateRenderable)this.renderableList[i].renderable;
                    if (bufferStateRenderable.checkClearBufferState()) {
                        n6 |= bufferStateRenderable.getBufferBitMask();
                        break;
                    }
                    n6 &= ~bufferStateRenderable.getBufferBitMask();
                    break;
                }
                case 37: {
                    if (bl) {
                        Renderable renderable = this.renderableList[i].renderable;
                        System.out.println("Change buffer state " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    BufferStateRenderable bufferStateRenderable = (BufferStateRenderable)this.renderableList[i].renderable;
                    bufferStateRenderable.updateBufferState(gL);
                    if (bufferStateRenderable.checkClearBufferState()) {
                        n6 |= bufferStateRenderable.getBufferBitMask();
                        break;
                    }
                    n6 &= ~bufferStateRenderable.getBufferBitMask();
                    break;
                }
                case 38: {
                    if (bl) {
                        Renderable renderable = this.renderableList[i].renderable;
                        System.out.println("Stop buffer state " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    BufferStateRenderable bufferStateRenderable = (BufferStateRenderable)this.renderableList[i].renderable;
                    bufferStateRenderable.clearBufferState(gL);
                    n6 &= ~bufferStateRenderable.getBufferBitMask();
                    break;
                }
                case 29: {
                    n4 = n;
                    graphicsEnvironmentData = this.environmentList[n4];
                    if (bl) {
                        System.out.println("Start layer " + n4 + " 0x" + Integer.toHexString(graphicsEnvironmentData.hashCode()));
                    }
                    gL.glClear(256);
                    bl2 = graphicsEnvironmentData.fog != null;
                    objectRenderable = graphicsEnvironmentData.fog;
                    this.preLayerEnvironmentDraw(gL, graphicsEnvironmentData);
                    break;
                }
                case 30: {
                    graphicsEnvironmentData = this.environmentList[n4];
                    if (bl) {
                        System.out.println("Stop Layer " + n4 + " 0x" + Integer.toHexString(graphicsEnvironmentData.hashCode()));
                    }
                    this.postLayerEnvironmentDraw(gL, graphicsEnvironmentData, graphicsProfilingData);
                    bl2 = false;
                    n4 = ++n;
                    break;
                }
                case 31: {
                    graphicsEnvironmentData = this.environmentList[n4];
                    if (bl) {
                        System.out.println("Start viewport " + n4 + " 0x" + Integer.toHexString(graphicsEnvironmentData.hashCode()));
                    }
                    this.setupViewport(gL, graphicsEnvironmentData);
                    break;
                }
                case 32: {
                    if (!bl) break;
                    System.out.println("Stop viewport");
                    break;
                }
                case 1: {
                    if (bl) {
                        Renderable renderable = this.renderableList[i].renderable;
                        System.out.println("Start render " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform, 0);
                    object = (ObjectRenderable)this.renderableList[i].renderable;
                    object.render(gL);
                    break;
                }
                case 2: {
                    if (bl) {
                        Renderable renderable = this.renderableList[i].renderable;
                        System.out.println("Stop render " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    object = (ObjectRenderable)this.renderableList[i].renderable;
                    object.postRender(gL);
                    gL.glPopMatrix();
                    break;
                }
                case 3: {
                    if (bl) {
                        Renderable renderable = this.renderableList[i].renderable;
                        System.out.println("Start 2D render " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    gL.glRasterPos2f(this.renderableList[i].transform[3], this.renderableList[i].transform[7]);
                    gL.glPixelZoom(this.renderableList[i].transform[0], this.renderableList[i].transform[5]);
                    object = (ObjectRenderable)this.renderableList[i].renderable;
                    object.render(gL);
                    break;
                }
                case 4: {
                    if (bl) {
                        Renderable renderable = this.renderableList[i].renderable;
                        System.out.println("Stop 2D render " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    object = (ObjectRenderable)this.renderableList[i].renderable;
                    object.postRender(gL);
                    break;
                }
                case 5: {
                    if (bl) {
                        Renderable renderable = this.renderableList[i].renderable;
                        System.out.println("Render geometry " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform, 0);
                    ((GeometryRenderable)this.renderableList[i].renderable).render(gL);
                    gL.glPopMatrix();
                    break;
                }
                case 6: {
                    if (bl) {
                        Renderable renderable = this.renderableList[i].renderable;
                        System.out.println("Render 2D geometry " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    gL.glRasterPos2f(this.renderableList[i].transform[3], this.renderableList[i].transform[7]);
                    gL.glPixelZoom(this.renderableList[i].transform[0], this.renderableList[i].transform[5]);
                    ((GeometryRenderable)this.renderableList[i].renderable).render(gL);
                    break;
                }
                case 7: {
                    if (bl) {
                        Renderable renderable = this.renderableList[i].renderable;
                        System.out.println("Render custom geometry " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform, 0);
                    CustomGeometryRenderable customGeometryRenderable = (CustomGeometryRenderable)this.renderableList[i].renderable;
                    customGeometryRenderable.render(gL, this.renderableList[i].instructions);
                    gL.glPopMatrix();
                    break;
                }
                case 9: {
                    Renderable renderable;
                    if (bl) {
                        renderable = this.renderableList[i].renderable;
                        System.out.println("Render custom " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform, 0);
                    renderable = (CustomRenderable)this.renderableList[i].renderable;
                    renderable.render(gL, this.renderableList[i].instructions);
                    gL.glPopMatrix();
                    break;
                }
                case 10: {
                    Comparable comparable2;
                    if (bl) {
                        comparable2 = this.renderableList[i].renderable;
                        System.out.println("Start state " + comparable2.getClass() + " 0x" + Integer.toHexString(comparable2.hashCode()));
                    }
                    object = (ObjectRenderable)this.renderableList[i].renderable;
                    object.render(gL);
                    break;
                }
                case 11: {
                    Comparable comparable2;
                    if (bl) {
                        comparable2 = this.renderableList[i].renderable;
                        System.out.println("Stop state " + comparable2.getClass() + " 0x" + Integer.toHexString(comparable2.hashCode()));
                    }
                    object = (ObjectRenderable)this.renderableList[i].renderable;
                    object.postRender(gL);
                    break;
                }
                case 12: {
                    Comparable comparable2;
                    if (bl) {
                        comparable2 = this.renderableList[i].renderable;
                        System.out.println("Start light " + comparable2.getClass() + " 0x" + Integer.toHexString(comparable2.hashCode()));
                    }
                    if (this.lastLightIdx >= this.availableLights.length) continue block37;
                    comparable2 = this.availableLights[this.lastLightIdx++];
                    this.lightIdMap.put(this.renderableList[i].id, (Object)comparable2);
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform, 0);
                    ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[i].renderable;
                    componentRenderable.render(gL, comparable2);
                    gL.glPopMatrix();
                    break;
                }
                case 13: {
                    Comparable comparable;
                    if (bl) {
                        comparable = this.renderableList[i].renderable;
                        System.out.println("Stop light " + comparable.getClass() + " 0x" + Integer.toHexString(comparable.hashCode()));
                    }
                    if (this.lastLightIdx >= this.availableLights.length) continue block37;
                    Comparable comparable2 = (Integer)this.lightIdMap.remove(this.renderableList[i].id);
                    ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[i].renderable;
                    componentRenderable.postRender(gL, comparable2);
                    this.availableLights[--this.lastLightIdx] = comparable2;
                    break;
                }
                case 20: {
                    Comparable comparable;
                    if (bl) {
                        comparable = this.renderableList[i].renderable;
                        System.out.println("Start clip plane " + comparable.getClass() + " 0x" + Integer.toHexString(comparable.hashCode()));
                    }
                    if (this.lastClipIdx >= this.availableClips.length) continue block37;
                    comparable = this.availableClips[this.lastClipIdx++];
                    this.clipIdMap.put(this.renderableList[i].id, (Object)comparable);
                    gL.glPushMatrix();
                    gL.glMultMatrixf(this.renderableList[i].transform, 0);
                    ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[i].renderable;
                    componentRenderable.render(gL, comparable);
                    gL.glPopMatrix();
                    break;
                }
                case 21: {
                    Renderable renderable;
                    if (bl) {
                        renderable = this.renderableList[i].renderable;
                        System.out.println("Stop clip plane " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    if (this.lastClipIdx >= this.availableClips.length) continue block37;
                    Comparable comparable = (Integer)this.clipIdMap.remove(this.renderableList[i].id);
                    ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[i].renderable;
                    componentRenderable.postRender(gL, comparable);
                    this.availableClips[--this.lastClipIdx] = comparable;
                    break;
                }
                case 14: {
                    if (bl) {
                        System.out.println("Start transparency");
                    }
                    gL.glDepthMask(false);
                    gL.glEnable(3042);
                    gL.glBlendFunc(770, 771);
                    break;
                }
                case 15: {
                    if (bl) {
                        System.out.println("Stop transparency");
                    }
                    gL.glDisable(3042);
                    gL.glDepthMask(true);
                    break;
                }
                case 22: {
                    Renderable renderable;
                    if (bl) {
                        renderable = this.renderableList[i].renderable;
                        System.out.println("Start fog " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    if (!bl2) {
                        gL.glEnable(2912);
                        bl2 = true;
                    }
                    object = (ObjectRenderable)this.renderableList[i].renderable;
                    object.render(gL);
                    break;
                }
                case 23: {
                    Renderable renderable;
                    if (bl) {
                        renderable = this.renderableList[i].renderable;
                        System.out.println("Stop fog " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    if (objectRenderable != null) {
                        objectRenderable.render(gL);
                        break;
                    }
                    object = (ObjectRenderable)this.renderableList[i].renderable;
                    object.postRender(gL);
                    bl2 = false;
                    gL.glDisable(2912);
                    break;
                }
                case 24: {
                    Renderable renderable;
                    if (bl) {
                        renderable = this.renderableList[i].renderable;
                        System.out.println("Start shader program " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    renderable = (ShaderComponentRenderable)this.renderableList[i].renderable;
                    if (!renderable.isValid(gL)) {
                        this.currentShaderProgramId = INVALID_SHADER;
                        continue block37;
                    }
                    this.currentShaderProgramId = new Integer(renderable.getProgramId(gL));
                    renderable.render(gL);
                    break;
                }
                case 25: {
                    Renderable renderable;
                    if (bl) {
                        renderable = this.renderableList[i].renderable;
                        System.out.println("Stop shader program " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    if (this.currentShaderProgramId == INVALID_SHADER) continue block37;
                    object = (ObjectRenderable)this.renderableList[i].renderable;
                    object.postRender(gL);
                    this.currentShaderProgramId = INVALID_SHADER;
                    break;
                }
                case 26: {
                    Renderable renderable;
                    if (bl) {
                        renderable = this.renderableList[i].renderable;
                        System.out.println("Set shader args " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    if (this.currentShaderProgramId == INVALID_SHADER) continue block37;
                    ComponentRenderable componentRenderable = (ComponentRenderable)this.renderableList[i].renderable;
                    componentRenderable.render(gL, this.currentShaderProgramId);
                    break;
                }
                case 27: {
                    Object object2;
                    Renderable renderable;
                    if (bl) {
                        renderable = this.renderableList[i].renderable;
                        System.out.println("Start texture " + renderable.getClass() + " 0x" + Integer.toHexString(renderable.hashCode()));
                    }
                    renderable = (TextureRenderable)this.renderableList[i].renderable;
                    if (renderable.isOffscreenSource()) {
                        object2 = (BaseBufferDescriptor)renderable.getBuffer(this.glContext);
                        ((BaseBufferDescriptor)object2).bindBuffer();
                    }
                    object2 = (Integer)this.renderableList[i].instructions;
                    renderable.render(gL, object2);
                    break;
                }
                case 28: {
                    Object object3;
                    if (bl) {
                        object3 = this.renderableList[i].renderable;
                        System.out.println("Stop texture " + object3.getClass() + " 0x" + Integer.toHexString(object3.hashCode()));
                    }
                    Renderable renderable = (TextureRenderable)this.renderableList[i].renderable;
                    Object object2 = (Integer)this.renderableList[i].instructions;
                    renderable.postRender(gL, object2);
                    if (!renderable.isOffscreenSource()) break;
                    object3 = (BaseBufferDescriptor)renderable.getBuffer(this.glContext);
                    ((BaseBufferDescriptor)object3).unbindBuffer();
                }
            }
            if (!bl || (n7 = gL.glGetError()) == 0) continue;
            System.out.println("Error: after " + this.renderableList[i].renderable);
            System.out.println(this.glu.gluErrorString(n7));
        }
        if (this.terminate) {
            return;
        }
        gL.glFlush();
        if (this.ownerRenderable != null && !this.ownerRenderable.isInitialised()) {
            this.ownerRenderable.swapBuffers(gL);
        }
    }

    public void traceNextFrames(int n) {
        this.dumpNextFrameCount = n;
    }
}

