/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.output.graphics;

import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import org.j3d.aviatrix3d.output.graphics.BaseBufferDescriptor;
import org.j3d.aviatrix3d.output.graphics.PbufferTextureDescriptor;
import org.j3d.aviatrix3d.output.graphics.RenderingProcessor;
import org.j3d.aviatrix3d.output.graphics.StandardRenderingProcessor;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsInstructions;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsOutputDevice;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsProfilingData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsRequestData;
import org.j3d.aviatrix3d.rendering.OffscreenBufferRenderable;
import org.j3d.aviatrix3d.rendering.ProfilingData;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;

public abstract class BaseSurface
implements GraphicsOutputDevice {
    protected static final String FAILED_CONTEXT_MSG = "The GL context failed to initialise for some mysterious reason";
    private static final int LIST_START_SIZE = 20;
    protected static boolean avoidPbufferTextures = false;
    protected GLDrawable canvas;
    protected GLContext canvasContext;
    protected RenderingProcessor canvasRenderer;
    protected GLPbuffer[] renderableList;
    protected int numRenderables;
    protected boolean initComplete;
    private String[] extensionList;
    private int numExtensions;
    protected Map<GLPbuffer, RenderingProcessor> rendererMap;
    private Map<OffscreenBufferRenderable, GLPbuffer> glDrawableMap;
    private float[] colourTmp;
    protected BaseSurface sharedSurface;
    protected boolean canCreatePBuffers;
    protected ErrorReporter errorReporter;
    protected boolean terminate;
    protected boolean singleThreaded;

    protected BaseSurface(BaseSurface baseSurface) {
        this.sharedSurface = baseSurface;
        this.terminate = false;
        this.singleThreaded = false;
    }

    public boolean isStereoAvailable() {
        return false;
    }

    public boolean isQuadStereoAvailable() {
        return false;
    }

    public void setStereoEyeSeparation(float f) {
    }

    public float getStereoEyeSeparation() {
        return 0.0f;
    }

    public void setStereoRenderingPolicy(int n) {
    }

    public int getStereoRenderingPolicy() {
        return 0;
    }

    public void setClearColor(float f, float f2, float f3, float f4) {
        this.canvasRenderer.setClearColor(f, f2, f3, f4);
    }

    public void setColorClearNeeded(boolean bl) {
        this.canvasRenderer.setColorClearNeeded(bl);
    }

    public void setDrawableObjects(GraphicsRequestData graphicsRequestData, GraphicsInstructions[] graphicsInstructionsArray, int n) {
        int n2;
        if (this.renderableList.length < n) {
            this.renderableList = new GLPbuffer[n];
        } else {
            for (n2 = n; n2 < this.renderableList.length; ++n2) {
                this.renderableList[n2] = null;
            }
        }
        n2 = this.numRenderables = n;
        while (--n2 >= 0) {
            GraphicsInstructions graphicsInstructions = graphicsInstructionsArray[n2];
            if (graphicsInstructions.pbuffer != null) {
                OffscreenBufferRenderable offscreenBufferRenderable = graphicsInstructions.pbuffer;
                GLPbuffer gLPbuffer = this.glDrawableMap.get(offscreenBufferRenderable);
                RenderingProcessor renderingProcessor = null;
                if (gLPbuffer == null) {
                    GLAutoDrawable gLAutoDrawable;
                    GLContext gLContext;
                    if (graphicsInstructions.parentSource == null) {
                        gLContext = this.canvasContext;
                    } else {
                        gLAutoDrawable = (GLAutoDrawable)this.glDrawableMap.get(graphicsInstructions.parentSource);
                        gLContext = gLAutoDrawable.getContext();
                    }
                    if (!this.canCreatePBuffers) continue;
                    gLAutoDrawable = offscreenBufferRenderable.getGLSetup();
                    int n3 = offscreenBufferRenderable.getWidth();
                    int n4 = offscreenBufferRenderable.getHeight();
                    GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory();
                    gLPbuffer = gLDrawableFactory.createGLPbuffer((GLCapabilities)gLAutoDrawable, null, n3, n4, gLContext);
                    PbufferTextureDescriptor pbufferTextureDescriptor = new PbufferTextureDescriptor(offscreenBufferRenderable);
                    pbufferTextureDescriptor.pbuffer = gLPbuffer;
                    renderingProcessor = this.createRenderingProcessor(gLPbuffer.getContext(), pbufferTextureDescriptor);
                    renderingProcessor.enableSingleThreaded(this.singleThreaded);
                    offscreenBufferRenderable.registerBuffer(gLContext, pbufferTextureDescriptor);
                    this.rendererMap.put(gLPbuffer, renderingProcessor);
                    this.glDrawableMap.put(offscreenBufferRenderable, gLPbuffer);
                } else {
                    renderingProcessor = this.rendererMap.get(gLPbuffer);
                }
                this.renderableList[n2] = gLPbuffer;
                if (graphicsInstructions.copyOf != null) {
                    graphicsInstructions = (GraphicsInstructions)graphicsInstructions.copyOf;
                }
                offscreenBufferRenderable.getClearColor(this.colourTmp);
                renderingProcessor.setClearColor(this.colourTmp[0], this.colourTmp[1], this.colourTmp[2], this.colourTmp[3]);
                renderingProcessor.setDrawableObjects(graphicsRequestData, graphicsInstructions.renderList, graphicsInstructions.renderOps, graphicsInstructions.numValid, graphicsInstructions.renderData);
                continue;
            }
            this.canvasRenderer.setDrawableObjects(graphicsRequestData, graphicsInstructions.renderList, graphicsInstructions.renderOps, graphicsInstructions.numValid, graphicsInstructions.renderData);
            this.renderableList[n2] = null;
        }
    }

    public void swap() {
        block3: {
            if (!this.terminate) {
                try {
                    this.canvasRenderer.swapBuffers();
                }
                catch (GLException gLException) {
                    if (gLException.getCause() instanceof InterruptedException) break block3;
                    throw gLException;
                }
            }
        }
    }

    public boolean getSurfaceToVWorld(int n, int n2, int n3, int n4, Matrix4f matrix4f, String string, boolean bl) {
        return this.canvasRenderer.getSurfaceToVWorld(n, n2, n3, n4, matrix4f, string, bl);
    }

    public boolean getPixelLocationInSurface(int n, int n2, int n3, int n4, Point3f point3f, String string, boolean bl) {
        return this.canvasRenderer.getPixelLocationInSurface(n, n2, n3, n4, point3f, string, bl);
    }

    public boolean getCenterEyeInSurface(int n, int n2, int n3, int n4, Point3f point3f, String string, boolean bl) {
        return this.canvasRenderer.getCenterEyeInSurface(n, n2, n3, n4, point3f, string, bl);
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        this.canvasRenderer.setErrorReporter(errorReporter);
    }

    public boolean draw(ProfilingData profilingData) {
        if (!this.initComplete && !this.initCanvas()) {
            return false;
        }
        int n = this.numRenderables;
        GLPbuffer[] gLPbufferArray = this.renderableList;
        boolean bl = true;
        if (n > 1) {
            for (int i = 0; i < n && !this.terminate && bl; ++i) {
                if (gLPbufferArray[i] == null) continue;
                RenderingProcessor renderingProcessor = this.rendererMap.get(gLPbufferArray[i]);
                bl = renderingProcessor.render((GraphicsProfilingData)profilingData);
            }
        }
        if (!this.terminate && bl) {
            bl = this.canvasRenderer.render((GraphicsProfilingData)profilingData);
        }
        return !this.terminate && bl;
    }

    public void dispose() {
        this.terminate = true;
        this.canvasRenderer.halt();
        for (int i = 0; i < this.numRenderables; ++i) {
            if (this.renderableList[i] == null) continue;
            RenderingProcessor renderingProcessor = this.rendererMap.get(this.renderableList[i]);
            renderingProcessor.halt();
        }
    }

    public boolean isDisposed() {
        return this.terminate;
    }

    public void enableSingleThreaded(boolean bl) {
        this.singleThreaded = bl;
        if (this.canvasRenderer != null) {
            this.canvasRenderer.enableSingleThreaded(bl);
        }
        for (int i = 0; i < this.numRenderables; ++i) {
            if (this.renderableList[i] == null) continue;
            RenderingProcessor renderingProcessor = this.rendererMap.get(this.renderableList[i]);
            renderingProcessor.enableSingleThreaded(bl);
        }
    }

    public void disposeSingleThreadResources() {
        if (this.canvasRenderer != null) {
            this.canvasRenderer.disposeSingleThreadResources();
        }
        for (int i = 0; i < this.numRenderables; ++i) {
            if (this.renderableList[i] == null) continue;
            RenderingProcessor renderingProcessor = this.rendererMap.get(this.renderableList[i]);
            renderingProcessor.disposeSingleThreadResources();
        }
    }

    protected RenderingProcessor createRenderingProcessor(GLContext gLContext, BaseBufferDescriptor baseBufferDescriptor) {
        return new StandardRenderingProcessor(gLContext, baseBufferDescriptor);
    }

    public void checkForExtension(String string) {
        if (this.extensionList == null || this.extensionList.length == this.numExtensions) {
            String[] stringArray = new String[this.numExtensions + 5];
            if (this.extensionList != null) {
                System.arraycopy(this.extensionList, 0, stringArray, 0, this.numExtensions);
            }
            this.extensionList = stringArray;
        }
        this.extensionList[this.numExtensions++] = string;
    }

    public boolean isShared() {
        return this.sharedSurface != null;
    }

    public boolean completeCanvasInitialisation(GL gL) {
        return true;
    }

    protected void init() {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory();
        this.canCreatePBuffers = gLDrawableFactory.canCreateGLPbuffer();
        this.colourTmp = new float[4];
        this.initComplete = false;
        this.renderableList = new GLPbuffer[20];
        this.numRenderables = 0;
        this.numExtensions = 0;
        this.rendererMap = new HashMap<GLPbuffer, RenderingProcessor>();
        this.glDrawableMap = new HashMap<OffscreenBufferRenderable, GLPbuffer>();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    protected boolean initCanvas() {
        if (this.canvasContext == null) {
            return false;
        }
        int n = this.canvasContext.makeCurrent();
        switch (n) {
            case 0: {
                this.errorReporter.messageReport("Trying to make current again");
                n = this.canvasContext.makeCurrent();
                if (n != 0) break;
                this.errorReporter.errorReport(FAILED_CONTEXT_MSG, null);
                return false;
            }
        }
        GL gL = this.canvasContext.getGL();
        for (int i = 0; i < this.numExtensions; ++i) {
            if (gL.isExtensionAvailable(this.extensionList[i])) continue;
            this.errorReporter.messageReport("Extension " + this.extensionList[i] + " not available");
        }
        if (this.completeCanvasInitialisation(gL)) {
            this.canvasContext.release();
            this.initComplete = true;
        }
        return this.initComplete;
    }

    GLContext getGLContext() {
        return this.canvasContext;
    }

    protected GLContext getSharedGLContext() {
        return this.sharedSurface != null ? this.sharedSurface.getGLContext() : null;
    }

    static {
        String string = System.getProperty("os.name");
        if (string.equalsIgnoreCase("Mac OS X")) {
            avoidPbufferTextures = true;
        }
    }
}

