/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.output.graphics;

import java.util.HashMap;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import org.j3d.aviatrix3d.output.graphics.BaseBufferDescriptor;
import org.j3d.aviatrix3d.output.graphics.RenderingProcessor;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsDetails;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsEnvironmentData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsProfilingData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsRequestData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsResizeListener;
import org.j3d.aviatrix3d.rendering.BackgroundRenderable;
import org.j3d.aviatrix3d.rendering.ShaderSourceRenderable;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;
import org.j3d.util.IntHashMap;

public abstract class BaseRenderingProcessor
implements RenderingProcessor {
    protected static final int LIST_START_SIZE = 400;
    protected static final int INITIAL_PATH_DEPTH = 64;
    protected static final Integer INVALID_SHADER = new Integer(-1);
    private static final String FAILED_CONTEXT_MSG = "The GL context failed to initialise for some mysterious reason";
    private static final String GL_RENDER_ERROR = "An unexpected OpenGL error happened during rendering.";
    protected float[] clearColor;
    protected boolean resetColor;
    protected GraphicsDetails[] renderableList;
    protected int[] operationList;
    protected int numRenderables;
    protected GraphicsEnvironmentData[] environmentList;
    protected GraphicsRequestData otherDataRequests;
    protected Integer currentShaderProgramId;
    protected Integer[] availableLights;
    protected int lastLightIdx;
    protected IntHashMap lightIdMap;
    protected Integer[] availableClips;
    protected int lastClipIdx;
    protected IntHashMap clipIdMap;
    protected boolean alwaysLocalClear;
    protected Matrix4f surfaceMatrix;
    protected float[] eyePoint;
    protected float[] currentViewport;
    protected boolean initComplete;
    protected boolean terminate;
    private GraphicsResizeListener listeners;
    protected ErrorReporter errorReporter;
    protected GLContext glContext;
    private boolean contextNotDestroyed;
    protected boolean singleThreaded;
    private boolean contextIsCurrent;
    private float[] colorTmp;
    private HashMap<String, GraphicsEnvironmentData> envSaveMap;
    protected BaseBufferDescriptor ownerRenderable;

    protected BaseRenderingProcessor(GLContext gLContext) {
        this(gLContext, null);
    }

    protected BaseRenderingProcessor(GLContext gLContext, BaseBufferDescriptor baseBufferDescriptor) {
        this.glContext = gLContext;
        this.ownerRenderable = baseBufferDescriptor;
        this.colorTmp = new float[4];
        this.clearColor = new float[4];
        this.surfaceMatrix = new Matrix4f();
        this.eyePoint = new float[3];
        this.resetColor = false;
        this.initComplete = false;
        this.terminate = false;
        this.contextNotDestroyed = true;
        this.alwaysLocalClear = true;
        this.singleThreaded = false;
        this.contextIsCurrent = false;
        this.numRenderables = 0;
        this.lightIdMap = new IntHashMap();
        this.clipIdMap = new IntHashMap();
        this.envSaveMap = new HashMap();
        this.lastLightIdx = 0;
        this.lastClipIdx = 0;
        this.currentShaderProgramId = INVALID_SHADER;
        this.otherDataRequests = new GraphicsRequestData();
        this.currentViewport = new float[4];
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public void halt() {
        this.terminate = true;
    }

    public void setClearColor(float f, float f2, float f3, float f4) {
        this.clearColor[0] = f;
        this.clearColor[1] = f2;
        this.clearColor[2] = f3;
        this.clearColor[3] = f4;
        this.resetColor = true;
    }

    public void setColorClearNeeded(boolean bl) {
        this.alwaysLocalClear = bl;
    }

    public void setDrawableObjects(GraphicsRequestData graphicsRequestData, GraphicsDetails[] graphicsDetailsArray, int[] nArray, int n, GraphicsEnvironmentData[] graphicsEnvironmentDataArray) {
        this.renderableList = graphicsDetailsArray;
        this.operationList = nArray;
        this.numRenderables = n;
        this.environmentList = graphicsEnvironmentDataArray;
        if (graphicsRequestData != null) {
            int n2;
            if (graphicsRequestData.shaderInitList != null) {
                n2 = graphicsRequestData.shaderInitList.length;
                this.otherDataRequests.shaderInitList = new ShaderSourceRenderable[n2];
                System.arraycopy(graphicsRequestData.shaderInitList, 0, this.otherDataRequests.shaderInitList, 0, n2);
            }
            if (graphicsRequestData.shaderLogList != null) {
                n2 = graphicsRequestData.shaderLogList.length;
                this.otherDataRequests.shaderLogList = new ShaderSourceRenderable[n2];
                System.arraycopy(graphicsRequestData.shaderLogList, 0, this.otherDataRequests.shaderLogList, 0, n2);
            }
        }
    }

    public final boolean render(GraphicsProfilingData graphicsProfilingData) {
        if (this.terminate) {
            this.terminateCleanup();
            return false;
        }
        try {
            if (!(this.singleThreaded && this.initComplete && this.contextIsCurrent)) {
                int n = this.glContext.makeCurrent();
                switch (n) {
                    case 1: {
                        if (!this.initComplete) {
                            this.init();
                        }
                        this.contextIsCurrent = true;
                        break;
                    }
                    case 2: {
                        this.init();
                        this.contextIsCurrent = true;
                        break;
                    }
                    case 0: {
                        this.errorReporter.errorReport(FAILED_CONTEXT_MSG, null);
                        this.contextIsCurrent = false;
                        return false;
                    }
                }
            }
            if (this.contextIsCurrent && !this.terminate) {
                this.display(graphicsProfilingData);
            }
            if (this.terminate) {
                this.terminateCleanup();
            }
        }
        catch (GLException gLException) {
            if (gLException.getCause() instanceof InterruptedException) {
                this.terminate = true;
            }
            this.errorReporter.errorReport(GL_RENDER_ERROR, (Exception)((Object)gLException));
        }
        return !this.terminate;
    }

    public void swapBuffers() {
        if (!this.contextIsCurrent) {
            return;
        }
        this.glContext.getGLDrawable().swapBuffers();
        if (!this.singleThreaded) {
            this.contextIsCurrent = false;
            this.glContext.release();
        }
    }

    public void enableSingleThreaded(boolean bl) {
    }

    public void disposeSingleThreadResources() {
        if (this.singleThreaded && this.contextIsCurrent) {
            this.contextIsCurrent = false;
            this.glContext.release();
        }
    }

    public boolean getSurfaceToVWorld(int n, int n2, int n3, int n4, Matrix4f matrix4f, String string, boolean bl) {
        GraphicsEnvironmentData graphicsEnvironmentData = this.matchEnvData(n, n2, n3, n4, string, bl);
        if (graphicsEnvironmentData == null) {
            return false;
        }
        matrix4f.set(graphicsEnvironmentData.viewTransform);
        return true;
    }

    public boolean getPixelLocationInSurface(int n, int n2, int n3, int n4, Point3f point3f, String string, boolean bl) {
        GraphicsEnvironmentData graphicsEnvironmentData = this.matchEnvData(n, n2, n3, n4, string, bl);
        if (graphicsEnvironmentData == null) {
            return false;
        }
        if (graphicsEnvironmentData.viewProjectionType == 1) {
            float f = graphicsEnvironmentData.viewport[2];
            float f2 = graphicsEnvironmentData.viewport[3];
            int n5 = graphicsEnvironmentData.viewport[0];
            int n6 = graphicsEnvironmentData.viewport[1];
            point3f.x = (float)((graphicsEnvironmentData.viewFrustum[1] - graphicsEnvironmentData.viewFrustum[0]) * (double)((float)(n -= n5) / f - 0.5f));
            point3f.y = (float)((graphicsEnvironmentData.viewFrustum[3] - graphicsEnvironmentData.viewFrustum[2]) * (double)((float)(n2 -= n6) / f2 - 0.5f));
            point3f.z = (float)(-graphicsEnvironmentData.viewFrustum[4]);
        } else if (graphicsEnvironmentData.viewProjectionType == 2) {
            int n7 = graphicsEnvironmentData.viewport[0];
            int n8 = graphicsEnvironmentData.viewport[1];
            float f = graphicsEnvironmentData.viewport[2];
            float f3 = graphicsEnvironmentData.viewport[3];
            point3f.x = (float)graphicsEnvironmentData.viewFrustum[0] + (float)((graphicsEnvironmentData.viewFrustum[1] - graphicsEnvironmentData.viewFrustum[0]) * (double)((float)(n -= n7) / f));
            point3f.y = (float)graphicsEnvironmentData.viewFrustum[2] + (float)((graphicsEnvironmentData.viewFrustum[3] - graphicsEnvironmentData.viewFrustum[2]) * (double)((float)(n2 -= n8) / f3));
            point3f.z = (float)(-graphicsEnvironmentData.viewFrustum[4]);
        }
        return true;
    }

    public boolean getCenterEyeInSurface(int n, int n2, int n3, int n4, Point3f point3f, String string, boolean bl) {
        GraphicsEnvironmentData graphicsEnvironmentData = this.matchEnvData(n, n2, n3, n4, string, bl);
        if (graphicsEnvironmentData == null) {
            return false;
        }
        if (graphicsEnvironmentData.viewProjectionType == 1) {
            point3f.set(graphicsEnvironmentData.eyeOffset);
        } else if (graphicsEnvironmentData.viewProjectionType == 2) {
            int n5 = graphicsEnvironmentData.viewport[0];
            int n6 = graphicsEnvironmentData.viewport[1];
            float f = graphicsEnvironmentData.viewport[2];
            float f2 = graphicsEnvironmentData.viewport[3];
            point3f.x = (float)graphicsEnvironmentData.viewFrustum[0] + (float)((graphicsEnvironmentData.viewFrustum[1] - graphicsEnvironmentData.viewFrustum[0]) * (double)((float)(n -= n5) / f));
            point3f.y = (float)graphicsEnvironmentData.viewFrustum[2] + (float)((graphicsEnvironmentData.viewFrustum[3] - graphicsEnvironmentData.viewFrustum[2]) * (double)((float)(n2 -= n6) / f2));
            point3f.z = 0.0f;
        }
        return true;
    }

    protected abstract void display(GraphicsProfilingData var1);

    protected void init() {
        int n;
        GL gL = this.glContext.getGL();
        gL.glClearColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], this.clearColor[3]);
        gL.glEnable(2929);
        gL.glEnable(2977);
        gL.glEnable(3089);
        gL.glEnable(2884);
        gL.glCullFace(1029);
        gL.glBlendFunc(770, 771);
        gL.glHint(3152, 4354);
        gL.glHint(3156, 4354);
        int[] nArray = new int[1];
        gL.glGetIntegerv(3378, nArray, 0);
        this.availableClips = new Integer[nArray[0]];
        for (n = 0; n < nArray[0]; ++n) {
            this.availableClips[n] = new Integer(12288 + n);
        }
        gL.glGetIntegerv(3377, nArray, 0);
        this.availableLights = new Integer[nArray[0]];
        for (n = 0; n < nArray[0]; ++n) {
            this.availableLights[n] = new Integer(16385 + n);
        }
        this.initComplete = true;
    }

    protected void processRequestData(GL gL) {
        int n;
        if (this.otherDataRequests == null) {
            return;
        }
        if (this.otherDataRequests.deletionRequests != null) {
            for (n = 0; n < this.otherDataRequests.deletionRequests.length && !this.terminate; ++n) {
                this.otherDataRequests.deletionRequests[n].cleanup(gL);
                this.otherDataRequests.deletionRequests[n] = null;
            }
            this.otherDataRequests.deletionRequests = null;
        }
        if (this.otherDataRequests.shaderInitList != null) {
            for (n = 0; n < this.otherDataRequests.shaderInitList.length && !this.terminate; ++n) {
                this.otherDataRequests.shaderInitList[n].initialize(gL);
                this.otherDataRequests.shaderInitList[n] = null;
            }
            this.otherDataRequests.shaderInitList = null;
        }
        if (this.otherDataRequests.shaderLogList != null) {
            for (n = 0; n < this.otherDataRequests.shaderLogList.length && !this.terminate; ++n) {
                this.otherDataRequests.shaderLogList[n].fetchLogInfo(gL);
                this.otherDataRequests.shaderLogList[n] = null;
            }
            this.otherDataRequests.shaderLogList = null;
        }
    }

    protected void terminateCleanup() {
        if (this.contextNotDestroyed) {
            this.contextNotDestroyed = false;
            this.contextIsCurrent = false;
            this.glContext.release();
            this.glContext.destroy();
        }
    }

    protected void setupViewport(GL gL, GraphicsEnvironmentData graphicsEnvironmentData) {
        gL.glViewport(graphicsEnvironmentData.viewport[0], graphicsEnvironmentData.viewport[1], graphicsEnvironmentData.viewport[2], graphicsEnvironmentData.viewport[3]);
        gL.glScissor(graphicsEnvironmentData.viewport[0], graphicsEnvironmentData.viewport[1], graphicsEnvironmentData.viewport[2], graphicsEnvironmentData.viewport[3]);
    }

    protected void setupMultipassViewport(GL gL, GraphicsEnvironmentData graphicsEnvironmentData) {
        gL.glViewport(0, 0, graphicsEnvironmentData.viewport[2], graphicsEnvironmentData.viewport[3]);
        gL.glScissor(0, 0, graphicsEnvironmentData.viewport[2], graphicsEnvironmentData.viewport[3]);
    }

    protected void preLayerEnvironmentDraw(GL gL, GraphicsEnvironmentData graphicsEnvironmentData) {
        if (graphicsEnvironmentData.effectsProcessor != null) {
            graphicsEnvironmentData.effectsProcessor.preDraw(gL, graphicsEnvironmentData.userData);
        }
        if (graphicsEnvironmentData.background != null) {
            if (((BackgroundRenderable)graphicsEnvironmentData.background).is2D()) {
                graphicsEnvironmentData.background.render(gL);
                graphicsEnvironmentData.background.postRender(gL);
            } else {
                gL.glMatrixMode(5889);
                gL.glPushMatrix();
                gL.glLoadIdentity();
                gL.glFrustum(graphicsEnvironmentData.backgroundFrustum[0], graphicsEnvironmentData.backgroundFrustum[1], graphicsEnvironmentData.backgroundFrustum[2], graphicsEnvironmentData.backgroundFrustum[3], graphicsEnvironmentData.backgroundFrustum[4], graphicsEnvironmentData.backgroundFrustum[5]);
                gL.glClear(256);
                gL.glMatrixMode(5888);
                gL.glPushMatrix();
                gL.glLoadMatrixf(graphicsEnvironmentData.backgroundTransform, 0);
                gL.glDepthMask(false);
                gL.glDisable(3042);
                gL.glDisable(2929);
                graphicsEnvironmentData.background.render(gL);
                graphicsEnvironmentData.background.postRender(gL);
                gL.glDepthMask(true);
                gL.glEnable(2929);
                gL.glEnable(3042);
                gL.glPopMatrix();
                gL.glMatrixMode(5889);
                gL.glPopMatrix();
                gL.glMatrixMode(5888);
            }
        }
        this.renderViewpoint(gL, graphicsEnvironmentData);
        if (graphicsEnvironmentData.fog != null) {
            gL.glEnable(2912);
            graphicsEnvironmentData.fog.render(gL);
        }
    }

    protected void postLayerEnvironmentDraw(GL gL, GraphicsEnvironmentData graphicsEnvironmentData, GraphicsProfilingData graphicsProfilingData) {
        if (graphicsEnvironmentData.fog != null) {
            graphicsEnvironmentData.fog.postRender(gL);
            gL.glDisable(2912);
        }
        if (this.terminate) {
            return;
        }
        if (graphicsEnvironmentData.effectsProcessor != null) {
            graphicsEnvironmentData.effectsProcessor.postDraw(gL, graphicsProfilingData, graphicsEnvironmentData.userData);
        }
        if (this.terminate) {
            return;
        }
        if (graphicsEnvironmentData.viewpoint != null) {
            graphicsEnvironmentData.viewpoint.postRender(gL);
        }
    }

    protected void preMPPassEnvironmentDraw(GL gL, GraphicsEnvironmentData graphicsEnvironmentData) {
        this.renderViewpoint(gL, graphicsEnvironmentData);
        if (graphicsEnvironmentData.fog != null) {
            gL.glEnable(2912);
            graphicsEnvironmentData.fog.render(gL);
        }
    }

    protected void postMPPassEnvironmentDraw(GL gL, GraphicsEnvironmentData graphicsEnvironmentData) {
        if (graphicsEnvironmentData.fog != null) {
            graphicsEnvironmentData.fog.postRender(gL);
            gL.glDisable(2912);
        }
        if (this.terminate) {
            return;
        }
        if (this.terminate) {
            return;
        }
        if (graphicsEnvironmentData.viewpoint != null) {
            graphicsEnvironmentData.viewpoint.postRender(gL);
        }
    }

    protected void renderViewpoint(GL gL, GraphicsEnvironmentData graphicsEnvironmentData) {
        if (graphicsEnvironmentData.viewpoint == null) {
            return;
        }
        this.updateProjectionMatrix(gL, graphicsEnvironmentData);
        gL.glLoadIdentity();
        graphicsEnvironmentData.viewpoint.render(gL);
        gL.glMultMatrixf(graphicsEnvironmentData.cameraTransform, 0);
    }

    protected void updateProjectionMatrix(GL gL, GraphicsEnvironmentData graphicsEnvironmentData) {
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        switch (graphicsEnvironmentData.viewProjectionType) {
            case 1: {
                gL.glFrustum(graphicsEnvironmentData.viewFrustum[0], graphicsEnvironmentData.viewFrustum[1], graphicsEnvironmentData.viewFrustum[2], graphicsEnvironmentData.viewFrustum[3], graphicsEnvironmentData.viewFrustum[4], graphicsEnvironmentData.viewFrustum[5]);
                break;
            }
            case 2: {
                gL.glOrtho(graphicsEnvironmentData.viewFrustum[0], graphicsEnvironmentData.viewFrustum[1], graphicsEnvironmentData.viewFrustum[2], graphicsEnvironmentData.viewFrustum[3], graphicsEnvironmentData.viewFrustum[4], graphicsEnvironmentData.viewFrustum[5]);
                break;
            }
            default: {
                System.out.println("unknown projection type");
            }
        }
        gL.glMatrixMode(5888);
    }

    private GraphicsEnvironmentData matchEnvData(int n, int n2, int n3, int n4, String string, boolean bl) {
        Object object;
        if (this.environmentList == null || this.environmentList.length == 0) {
            return null;
        }
        Object object2 = null;
        if (bl) {
            object = this.envSaveMap.get(string);
            if (object.layerId == n3 && object.subLayerId == n4) {
                object2 = object;
            }
        }
        if (object2 == null) {
            object = this.environmentList;
            for (int i = 0; i < ((GraphicsEnvironmentData[])object).length; ++i) {
                if (object[i] == null || object[i].layerId != n3 || object[i].subLayerId != n4 || n < object[i].viewport[0] || n2 < object[i].viewport[1] || n >= object[i].viewport[0] + object[i].viewport[2] || n2 >= object[i].viewport[1] + object[i].viewport[3]) continue;
                object2 = object[i];
                this.envSaveMap.put(string, object[i]);
                break;
            }
        }
        return object2;
    }
}

