/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.output.graphics;

import javax.media.opengl.GLJPanel;
import org.j3d.aviatrix3d.output.graphics.AWTResizeHandler;
import org.j3d.aviatrix3d.output.graphics.BaseSurface;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsInstructions;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsProfilingData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsRequestData;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsResizeListener;
import org.j3d.aviatrix3d.rendering.ProfilingData;
import org.j3d.util.ErrorReporter;

public abstract class BaseAWTSurface
extends BaseSurface {
    protected AWTResizeHandler resizer = new AWTResizeHandler();
    protected final boolean lightweight;

    protected BaseAWTSurface(BaseSurface baseSurface, boolean bl) {
        super(baseSurface);
        this.lightweight = bl;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        super.setErrorReporter(errorReporter);
        this.resizer.setErrorReporter(this.errorReporter);
    }

    public void addGraphicsResizeListener(GraphicsResizeListener graphicsResizeListener) {
        this.resizer.addGraphicsResizeListener(graphicsResizeListener);
    }

    public void removeGraphicsResizeListener(GraphicsResizeListener graphicsResizeListener) {
        this.resizer.removeGraphicsResizeListener(graphicsResizeListener);
    }

    public void setDrawableObjects(GraphicsRequestData graphicsRequestData, GraphicsInstructions[] graphicsInstructionsArray, int n) {
        if (this.lightweight && this.canvasRenderer == null && !this.createLightweightContext()) {
            return;
        }
        super.setDrawableObjects(graphicsRequestData, graphicsInstructionsArray, n);
    }

    public void swap() {
        if (this.lightweight && this.canvasRenderer == null) {
            return;
        }
        super.swap();
        if (this.lightweight) {
            ((GLJPanel)this.canvas).repaint();
        }
    }

    public boolean draw(ProfilingData profilingData) {
        long l = System.nanoTime();
        if (this.lightweight && this.canvasRenderer == null && !this.createLightweightContext()) {
            return false;
        }
        boolean bl = super.draw((GraphicsProfilingData)profilingData);
        return bl;
    }

    protected abstract boolean createLightweightContext();
}

