/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.output.graphics;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsListenerMulticaster;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsResizeListener;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;

class AWTResizeHandler
extends ComponentAdapter {
    private static final String SIZE_ERROR_MSG = "Error sending size changed notification to: ";
    private GraphicsResizeListener listeners;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();

    AWTResizeHandler() {
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.listeners != null) {
            Component component = componentEvent.getComponent();
            try {
                this.listeners.graphicsDeviceResized(0, 0, component.getWidth(), component.getHeight());
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(SIZE_ERROR_MSG + this.listeners, exception);
            }
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public void addGraphicsResizeListener(GraphicsResizeListener graphicsResizeListener) {
        this.listeners = GraphicsListenerMulticaster.add(this.listeners, graphicsResizeListener);
    }

    public void removeGraphicsResizeListener(GraphicsResizeListener graphicsResizeListener) {
        this.listeners = GraphicsListenerMulticaster.remove(this.listeners, graphicsResizeListener);
    }
}

