/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.output.audio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import net.java.games.joal.AL;
import net.java.games.joal.ALC;
import net.java.games.joal.ALCcontext;
import net.java.games.joal.ALCdevice;
import net.java.games.joal.ALException;
import net.java.games.joal.ALFactory;
import org.j3d.aviatrix3d.pipeline.RenderableRequestData;
import org.j3d.aviatrix3d.pipeline.audio.AudioDetails;
import org.j3d.aviatrix3d.pipeline.audio.AudioInstructions;
import org.j3d.aviatrix3d.pipeline.audio.AudioOutputDevice;
import org.j3d.aviatrix3d.rendering.AudioRenderable;
import org.j3d.aviatrix3d.rendering.ProfilingData;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;
import org.j3d.util.MatrixUtils;

public class OpenALAudioDevice
implements AudioOutputDevice {
    private static final String DISPOSE_FAILURE_MSG = "An error occurred during the audio surface dispose handling.";
    private static final String DRAW_FAILURE_MSG = "An error occurred during the audio surface draw loop handling";
    private static final String INIT_FAILURE_MSG = "An error occurred during the audio surface initialisation proces";
    private static final FloatBuffer DEFAULT_ORIENTATION;
    private static final int LIST_START_SIZE = 20;
    protected RenderableRequestData otherDataRequests;
    private int numRenderables;
    private boolean initComplete = false;
    private AL al;
    private ALCcontext context;
    private ALCdevice device;
    private AudioInstructions commands;
    private MatrixUtils matrixUtils = new MatrixUtils();
    private Matrix4f tmpMatrix = new Matrix4f();
    private Point3f listenerPoint;
    private Point3f tmpPoint = new Point3f();
    private boolean initFailed = false;
    private boolean terminate = false;
    private int lastId = 0;
    private ErrorReporter errorReporter;
    private boolean singleThreaded = false;

    public OpenALAudioDevice() {
        this.listenerPoint = new Point3f(0.0f, 0.0f, 0.0f);
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setDrawableObjects(RenderableRequestData renderableRequestData, AudioInstructions audioInstructions) {
        this.commands = audioInstructions;
        this.otherDataRequests = renderableRequestData;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public boolean draw(ProfilingData profilingData) {
        if (this.initFailed) {
            return false;
        }
        if (!this.initComplete) {
            if (this.commands == null || this.commands.numValid == 0) {
                return true;
            }
            try {
                this.al = ALFactory.getAL();
                ALC aLC = ALFactory.getALC();
                this.device = aLC.alcOpenDevice(null);
                this.context = aLC.alcCreateContext(this.device, null);
                aLC.alcMakeContextCurrent(this.context);
                this.al.alGetError();
                this.al.alDistanceModel(53250);
                aLC.alcMakeContextCurrent(null);
                this.initComplete = true;
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(INIT_FAILURE_MSG, exception);
                this.initFailed = true;
                return false;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.errorReporter.errorReport(INIT_FAILURE_MSG, null);
                this.initFailed = true;
                return false;
            }
        }
        if (this.commands == null) {
            return true;
        }
        AudioInstructions audioInstructions = this.commands;
        int n = audioInstructions.numValid;
        if (n == 0) {
            return true;
        }
        if (n > this.lastId) {
            this.lastId = n;
        }
        try {
            ALC aLC = ALFactory.getALC();
            aLC.alcMakeContextCurrent(this.context);
            AudioDetails[] audioDetailsArray = audioInstructions.renderList;
            this.matrixUtils.inverse(audioInstructions.renderData.viewTransform, this.tmpMatrix);
            this.tmpMatrix.transform(this.listenerPoint, this.tmpPoint);
            this.al.alListener3f(4100, this.tmpPoint.x, this.tmpPoint.y, this.tmpPoint.z);
            this.al.alListenerfv(4111, DEFAULT_ORIENTATION);
            block9: for (int i = 0; i < n && !this.terminate; ++i) {
                switch (audioInstructions.renderOps[i]) {
                    case 1: {
                        AudioRenderable audioRenderable = (AudioRenderable)audioDetailsArray[i].renderable;
                        audioRenderable.render(this.al, audioDetailsArray[i].transform);
                        continue block9;
                    }
                    case 2: {
                        AudioRenderable audioRenderable = (AudioRenderable)audioDetailsArray[i].renderable;
                        audioRenderable.postRender(this.al);
                        continue block9;
                    }
                    default: {
                        System.out.println("Unknown OP in AudioDevice");
                    }
                }
            }
            aLC.alcMakeContextCurrent(null);
        }
        catch (ALException aLException) {
            this.errorReporter.errorReport(DRAW_FAILURE_MSG, (Exception)((Object)aLException));
        }
        return !this.terminate;
    }

    public Object getSurfaceObject() {
        return null;
    }

    public void dispose() {
        this.terminate = true;
        if (this.initComplete) {
            try {
                ALC aLC = ALFactory.getALC();
                aLC.alcMakeContextCurrent(this.context);
                int[] nArray = new int[this.lastId + 1];
                for (int i = 0; i <= this.lastId; ++i) {
                    nArray[i] = i;
                }
                this.al.alDeleteBuffers(nArray.length, nArray, 0);
                this.al.alDeleteSources(nArray.length, nArray, 0);
                aLC.alcMakeContextCurrent(null);
                aLC.alcDestroyContext(this.context);
                aLC.alcCloseDevice(this.device);
                this.al = null;
            }
            catch (ALException aLException) {
                this.errorReporter.errorReport(DISPOSE_FAILURE_MSG, (Exception)((Object)aLException));
            }
        }
    }

    public boolean isDisposed() {
        return this.terminate || this.initFailed;
    }

    public void enableSingleThreaded(boolean bl) {
        this.singleThreaded = bl;
    }

    public void disposeSingleThreadResources() {
    }

    static {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(24);
        byteBuffer.order(ByteOrder.nativeOrder());
        DEFAULT_ORIENTATION = byteBuffer.asFloatBuffer();
        float[] fArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f};
        DEFAULT_ORIENTATION.put(fArray);
        DEFAULT_ORIENTATION.rewind();
    }
}

