/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.management;

import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Layer;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.management.DisplayCollection;
import org.j3d.aviatrix3d.management.LayerContainer;
import org.j3d.aviatrix3d.pipeline.RenderPipeline;
import org.j3d.aviatrix3d.pipeline.RenderableRequestData;
import org.j3d.aviatrix3d.pipeline.audio.AudioRenderPipeline;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsOutputDevice;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsRenderPipeline;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsRequestData;
import org.j3d.aviatrix3d.rendering.DeletableRenderable;
import org.j3d.aviatrix3d.rendering.LayerCullable;
import org.j3d.aviatrix3d.rendering.ShaderSourceRenderable;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;

public class SingleDisplayCollection
extends DisplayCollection {
    private LayerContainer layerContainer = new LayerContainer();
    private Layer[] layers = new Layer[1];
    private int numLayers;
    private LayerCullable[] cullables;
    private GraphicsRenderPipeline graphicsPipeline;
    private AudioRenderPipeline audioPipeline;
    private boolean pipelineAdded = false;

    public SingleDisplayCollection() {
    }

    public SingleDisplayCollection(GraphicsRenderPipeline graphicsRenderPipeline) {
        this();
        this.graphicsPipeline = graphicsRenderPipeline;
    }

    public SingleDisplayCollection(GraphicsRenderPipeline graphicsRenderPipeline, AudioRenderPipeline audioRenderPipeline) {
        this();
        this.graphicsPipeline = graphicsRenderPipeline;
        this.audioPipeline = audioRenderPipeline;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.layerContainer.setLive(bl);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean process() {
        RenderableRequestData renderableRequestData;
        if (!this.enabled || this.terminate) {
            return false;
        }
        boolean bl = true;
        if (this.graphicsPipeline != null) {
            renderableRequestData = this.checkForGraphicsRequests();
            this.graphicsPipeline.setRequestData(renderableRequestData);
            bl = this.graphicsPipeline.render();
            if (bl) {
                this.graphicsPipeline.swapBuffers();
            }
        }
        if (this.terminate) {
            return false;
        }
        if (this.audioPipeline != null) {
            renderableRequestData = this.checkForAudioRequests();
            this.audioPipeline.setRequestData(renderableRequestData);
            bl &= this.audioPipeline.render();
        }
        this.pipelineAdded = false;
        this.clearDeletables();
        return bl;
    }

    public boolean displayOnly() {
        if (!this.enabled || this.terminate) {
            return false;
        }
        boolean bl = true;
        if (this.pipelineAdded) {
            bl = this.process();
        } else {
            RenderableRequestData renderableRequestData;
            if (this.graphicsPipeline != null) {
                renderableRequestData = this.checkForGraphicsRequests();
                this.graphicsPipeline.setRequestData(renderableRequestData);
                bl = renderableRequestData == null ? this.graphicsPipeline.displayOnly() : this.graphicsPipeline.render();
                if (bl) {
                    this.graphicsPipeline.swapBuffers();
                }
            }
            if (this.terminate) {
                return false;
            }
            if (this.audioPipeline != null) {
                renderableRequestData = this.checkForAudioRequests();
                this.audioPipeline.setRequestData(renderableRequestData);
                bl &= this.audioPipeline.displayOnly();
            }
            this.clearDeletables();
        }
        return bl;
    }

    public void halt() {
        if (this.graphicsPipeline != null) {
            this.graphicsPipeline.halt();
        }
        if (this.audioPipeline != null) {
            this.audioPipeline.halt();
        }
    }

    public void setLayers(Layer[] layerArray, int n) throws IllegalArgumentException, InvalidWriteTimingException {
        int n2;
        if (this.enabled && !this.writeEnabled) {
            throw new InvalidWriteTimingException("You cannot set layers right now. The system is actively management and you did not make the call during the ApplicationUpdateObserver.updateSceneGraph() method callback.");
        }
        int n3 = n2 = layerArray == null ? 0 : layerArray.length;
        if (n2 < n) {
            throw new IllegalArgumentException("The length of the layers argument is not long enough for the value defined by numLayers");
        }
        if (this.layers.length < n) {
            this.layers = new Layer[n];
        }
        System.arraycopy(layerArray, 0, this.layers, 0, n);
        this.numLayers = n;
        this.cullables = new LayerCullable[n];
        this.layerContainer.changeLayers(layerArray, n);
        for (int i = 0; i < n; ++i) {
            this.cullables[i] = layerArray[i].getCullable(0);
        }
        if (this.graphicsPipeline != null) {
            this.graphicsPipeline.setRenderableLayers(layerArray, n);
        }
        if (this.audioPipeline != null) {
            this.audioPipeline.setRenderableLayers(layerArray, n);
        }
    }

    public int numLayers() {
        return this.numLayers;
    }

    public void getLayers(Layer[] layerArray) {
        if (layerArray == null || layerArray.length < this.numLayers) {
            return;
        }
        System.arraycopy(this.layers, 0, layerArray, 0, this.numLayers);
    }

    public void addPipeline(RenderPipeline renderPipeline) throws IllegalStateException {
        if (this.enabled && !this.writeEnabled) {
            throw new IllegalStateException("You cannot make this call now because the system is currently management. To make this call, first disable the management. ");
        }
        if (renderPipeline instanceof GraphicsRenderPipeline) {
            this.graphicsPipeline = (GraphicsRenderPipeline)renderPipeline;
            if (this.graphicsPipeline != null) {
                this.graphicsPipeline.setRenderableLayers(this.layers, this.numLayers);
            }
        } else if (renderPipeline instanceof AudioRenderPipeline) {
            this.audioPipeline = (AudioRenderPipeline)renderPipeline;
            if (this.audioPipeline != null) {
                this.audioPipeline.setRenderableLayers(this.layers, this.numLayers);
            }
        }
    }

    public void removePipeline(RenderPipeline renderPipeline) throws IllegalStateException {
        if (this.enabled && !this.writeEnabled) {
            throw new IllegalStateException("You cannot make this call now because the system is currently management. To make this call, first disable the management. ");
        }
        if (renderPipeline instanceof GraphicsRenderPipeline) {
            if (renderPipeline == this.graphicsPipeline) {
                this.graphicsPipeline.setRenderableLayers(null, 0);
                this.graphicsPipeline = null;
            }
        } else if (renderPipeline instanceof AudioRenderPipeline && renderPipeline == this.audioPipeline) {
            this.audioPipeline.setRenderableLayers(null, 0);
            this.audioPipeline = null;
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        this.layerContainer.setUpdateHandler(nodeUpdateHandler);
    }

    public void shutdown() {
        if (this.terminate || !this.enabled) {
            return;
        }
        this.terminate = true;
        if (this.graphicsPipeline != null) {
            this.graphicsPipeline.halt();
        }
        if (this.audioPipeline != null) {
            this.audioPipeline.halt();
        }
    }

    public boolean isDisposed() {
        if (super.isDisposed()) {
            return true;
        }
        if (this.graphicsPipeline != null) {
            GraphicsOutputDevice graphicsOutputDevice = this.graphicsPipeline.getGraphicsOutputDevice();
            return graphicsOutputDevice != null ? graphicsOutputDevice.isDisposed() : false;
        }
        return false;
    }

    private void clearDeletables() {
        for (int i = 0; i < this.numDeletables; ++i) {
            this.deletionList[i] = null;
        }
        this.numDeletables = 0;
    }

    private GraphicsRequestData checkForGraphicsRequests() {
        int n;
        GraphicsRequestData graphicsRequestData = null;
        if (this.numDeletables != 0) {
            graphicsRequestData = new GraphicsRequestData();
            graphicsRequestData.deletionRequests = new DeletableRenderable[this.numDeletables];
            System.arraycopy(this.deletionList, 0, graphicsRequestData.deletionRequests, 0, this.numDeletables);
        }
        if (this.numShaderInit != 0) {
            if (graphicsRequestData == null) {
                graphicsRequestData = new GraphicsRequestData();
            }
            graphicsRequestData.shaderInitList = new ShaderSourceRenderable[this.numShaderInit];
            System.arraycopy(this.shaderInitList, 0, graphicsRequestData.shaderInitList, 0, this.numShaderInit);
            for (n = 0; n < this.numShaderInit; ++n) {
                this.shaderInitList[n] = null;
            }
            this.numShaderInit = 0;
        }
        if (this.numShaderLog != 0) {
            if (graphicsRequestData == null) {
                graphicsRequestData = new GraphicsRequestData();
            }
            graphicsRequestData.shaderLogList = new ShaderSourceRenderable[this.numShaderLog];
            System.arraycopy(this.shaderLogList, 0, graphicsRequestData.shaderLogList, 0, this.numShaderLog);
            for (n = 0; n < this.numShaderLog; ++n) {
                this.shaderLogList[n] = null;
            }
            this.numShaderLog = 0;
        }
        return graphicsRequestData;
    }

    private RenderableRequestData checkForAudioRequests() {
        GraphicsRequestData graphicsRequestData = null;
        if (this.numDeletables != 0) {
            graphicsRequestData = new GraphicsRequestData();
            graphicsRequestData.deletionRequests = new DeletableRenderable[this.numDeletables];
            System.arraycopy(this.deletionList, 0, graphicsRequestData.deletionRequests, 0, this.numDeletables);
        }
        return graphicsRequestData;
    }
}

