/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.management;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import org.j3d.aviatrix3d.ApplicationUpdateObserver;
import org.j3d.aviatrix3d.InternalLayerUpdateListener;
import org.j3d.aviatrix3d.InternalNodeUpdateListener;
import org.j3d.aviatrix3d.InvalidListenerSetTimingException;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.management.DefaultPickingHandler;
import org.j3d.aviatrix3d.management.DisplayCollection;
import org.j3d.aviatrix3d.management.DisplayCollectionThread;
import org.j3d.aviatrix3d.management.PipelineStateObserver;
import org.j3d.aviatrix3d.management.RenderManager;
import org.j3d.aviatrix3d.management.ShutdownThread;
import org.j3d.aviatrix3d.management.ThreadPrivilegedAction;
import org.j3d.aviatrix3d.picking.PickingManager;
import org.j3d.aviatrix3d.rendering.DeletableRenderable;
import org.j3d.aviatrix3d.rendering.ShaderSourceRenderable;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;
import org.j3d.util.HashSet;

public class MultiThreadRenderManager
implements Runnable,
NodeUpdateHandler,
RenderManager,
PipelineStateObserver {
    private static final String ACTIVE_RENDERING_MSG = "You cannot make this call now because the system is currently management. To make this call, first disable the management. ";
    private static final String LAYER_SET_SIZE_ERR = "The length of the layers argument is not long enough for the value defined by numLayers";
    private static final String LAYER_TIMING_MSG = "You cannot set layers right now. The system is actively management and you did not make the call during the ApplicationUpdateObserver.updateSceneGraph() method callback.";
    private static final String USER_UPDATE_ERR = "An error was caught in user code during the processing of the updateSceneGraph() method.";
    private static final String USER_SHUTDOWN_ERR = "An error was caught in user code during the processing of the appShutdown() method.";
    private static final String DATA_TIMING_MSG = "dataChanged() cannot be called in while processing a NodeUpdateListener callback. I may only be called during the ApplicationUpdateObserver.updateSceneGraph() method.";
    private static final String BOUNDS_TIMING_MSG = "boundsChanged() cannot be called in while processing a NodeUpdateListener callback. I may only be called during the ApplicationUpdateObserver.updateSceneGraph() method.";
    private static final String SHADER_INIT_TIMING_MSG = "shareRequiresInit() cannot be called in while processing a NodeUpdateListener callback. I may only be called during the ApplicationUpdateObserver.updateSceneGraph() method.";
    private static final String SHADER_LOG_TIMING_MSG = "shareRequiresLog() cannot be called in while processing a NodeUpdateListener callback. I may only be called during the ApplicationUpdateObserver.updateSceneGraph() method.";
    private static final String DATA_CALLBACK_ERROR = "An exception was generated in user code during the processing of the dataChanged() callback.";
    private static final String BOUNDS_CALLBACK_ERROR = "An exception was generated in user code during the processing of the boundsChanged() callback.";
    private static final String BOUNDS_UPDATE_ERROR = "An internally generated exception was caught during the processing of the updateBoundsAndNotify() callback.";
    private static final String SOUND_UPDATE_ERROR = "An internally generated exception was caught during the processing of the disableActiveAudioState() callback.";
    private static final int CHANGELIST_START_SIZE = 200;
    private static final int CHANGELIST_INCREMENT = 100;
    private static final int SHADERLIST_START_SIZE = 64;
    private static final int SHADERLIST_INCREMENT = 32;
    private NodeUpdateListener[] dataChangeList;
    private NodeUpdateListener[] boundsChangeList;
    private Object[] dataSourceList;
    private Object[] boundsSourceList;
    private InternalNodeUpdateListener[] boundsInternalList;
    private InternalLayerUpdateListener activeSoundLayer;
    private int lastDataChangeItem;
    private int lastBoundsChangeItem;
    private HashSet dataChangeListenerSet;
    private HashSet dataChangeSrcSet;
    private HashSet boundsChangeListenerSet;
    private HashSet boundsChangeSrcSet;
    private ShaderSourceRenderable[] shaderInitList;
    private ShaderSourceRenderable[] shaderLogList;
    private int lastShaderInitItem;
    private int lastShaderLogItem;
    private HashSet shaderInitSet;
    private HashSet shaderLogSet;
    private ArrayList<DisplayCollection> displays;
    private DisplayCollectionThread[] displayThread;
    private int numDisplayThreads;
    private HashMap<DisplayCollection, DisplayCollectionThread> displayThreadMap;
    private PickingManager pickHandler;
    private int minimumCycleTime;
    private boolean enabled = false;
    private Thread runtimeThread;
    private boolean terminate = false;
    private ApplicationUpdateObserver observer;
    private DeletableRenderable[] deletionQueue;
    private int numDeletables;
    private boolean pickPermitted = false;
    private Object writableBoundsObject;
    private Object writableDataObject;
    private Object frameFinishLock;
    private int completedFrameCount;
    private Object renderWaitLock;
    private boolean processing = false;
    private boolean haltOnError = true;
    private boolean sceneChanged = false;
    private Thread shutdownThread;
    private ErrorReporter errorReporter;

    public MultiThreadRenderManager() {
        this(2);
    }

    public MultiThreadRenderManager(int n) {
        this.displays = new ArrayList(n);
        this.displayThreadMap = new HashMap();
        this.displayThread = new DisplayCollectionThread[n];
        this.renderWaitLock = new Object();
        this.frameFinishLock = new Object();
        this.dataChangeList = new NodeUpdateListener[200];
        this.dataSourceList = new Object[200];
        this.dataChangeListenerSet = new HashSet(200);
        this.dataChangeSrcSet = new HashSet(200);
        this.boundsChangeList = new NodeUpdateListener[200];
        this.boundsInternalList = new InternalNodeUpdateListener[200];
        this.boundsSourceList = new Object[200];
        this.boundsChangeListenerSet = new HashSet(200);
        this.boundsChangeSrcSet = new HashSet(200);
        this.shaderInitList = new ShaderSourceRenderable[64];
        this.shaderInitSet = new HashSet(64);
        this.shaderLogList = new ShaderSourceRenderable[64];
        this.shaderLogSet = new HashSet(64);
        this.pickHandler = new DefaultPickingHandler();
        this.deletionQueue = new DeletableRenderable[200];
        this.lastDataChangeItem = 0;
        this.lastBoundsChangeItem = 0;
        this.lastShaderInitItem = 0;
        this.lastShaderLogItem = 0;
        this.minimumCycleTime = 0;
        this.completedFrameCount = 0;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.shutdownThread = new ShutdownThread(this);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Runtime runtime = Runtime.getRuntime();
                runtime.addShutdownHook(MultiThreadRenderManager.this.shutdownThread);
                return null;
            }
        });
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        this.pickHandler.setErrorReporter(this.errorReporter);
    }

    public void setHaltOnError(boolean bl) {
        this.haltOnError = bl;
    }

    public boolean isHaltingOnError() {
        return this.haltOnError;
    }

    public synchronized void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        if (bl) {
            this.enabled = true;
            this.terminate = false;
            this.pickPermitted = false;
            if (this.runtimeThread == null) {
                ThreadPrivilegedAction threadPrivilegedAction = new ThreadPrivilegedAction(this);
                this.runtimeThread = threadPrivilegedAction.getThread();
            }
        } else {
            this.enabled = false;
            this.terminate = true;
            this.pickPermitted = true;
            for (int i = 0; i < this.numDisplayThreads; ++i) {
                this.displayThread[i].halt();
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void renderOnce() throws IllegalStateException {
        if (this.enabled) {
            throw new IllegalStateException(ACTIVE_RENDERING_MSG);
        }
        this.processChangeList();
        this.processShaderLists();
        for (int i = 0; i < this.numDisplayThreads; ++i) {
            this.displayThread[i].render();
        }
    }

    public void requestFullSceneRender() {
        this.sceneChanged = true;
    }

    public void setMinimumFrameInterval(int n) {
        this.minimumCycleTime = n;
    }

    public int getMinimumFrameInterval() {
        return this.minimumCycleTime;
    }

    public void addDisplay(DisplayCollection displayCollection) throws IllegalStateException {
        if (this.enabled) {
            throw new IllegalStateException(ACTIVE_RENDERING_MSG);
        }
        if (displayCollection == null) {
            return;
        }
        if (this.numDisplayThreads == this.displayThread.length) {
            DisplayCollectionThread[] displayCollectionThreadArray = new DisplayCollectionThread[this.numDisplayThreads + 2];
            System.arraycopy(this.displayThread, 0, displayCollectionThreadArray, 0, this.numDisplayThreads);
            this.displayThread = displayCollectionThreadArray;
        }
        this.displays.add(displayCollection);
        this.displayThread[this.numDisplayThreads] = new DisplayCollectionThread(displayCollection);
        this.displayThread[this.numDisplayThreads].setStateObserver(this);
        this.displayThreadMap.put(displayCollection, this.displayThread[this.numDisplayThreads]);
        displayCollection.setEnabled(true);
        ++this.numDisplayThreads;
    }

    public void removeDisplay(DisplayCollection displayCollection) throws IllegalStateException {
        if (this.enabled) {
            throw new IllegalStateException(ACTIVE_RENDERING_MSG);
        }
        if (!this.displays.remove(displayCollection)) {
            return;
        }
        displayCollection.setEnabled(false);
        DisplayCollectionThread displayCollectionThread = this.displayThreadMap.remove(displayCollection);
        for (int i = 0; i < this.numDisplayThreads; ++i) {
            if (this.displayThread[i] != displayCollectionThread) continue;
            this.displayThread[i].shutdown();
            this.displayThread[i].setStateObserver(null);
            System.arraycopy(this.displayThread, i + 1, this.displayThread, i, this.numDisplayThreads - i - 1);
            --this.numDisplayThreads;
            break;
        }
    }

    public void setApplicationObserver(ApplicationUpdateObserver applicationUpdateObserver) {
        this.observer = applicationUpdateObserver;
    }

    public void disableInternalShutdown() {
        if (this.shutdownThread != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Runtime runtime = Runtime.getRuntime();
                    runtime.removeShutdownHook(MultiThreadRenderManager.this.shutdownThread);
                    return null;
                }
            });
            this.shutdownThread = null;
        }
    }

    public synchronized void shutdown() {
        if (this.terminate || !this.enabled) {
            return;
        }
        this.terminate = true;
        this.setEnabled(false);
        if (this.shutdownThread != null && this.observer != null) {
            try {
                this.observer.appShutdown();
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(USER_SHUTDOWN_ERR, exception);
            }
            this.observer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        for (int i = 0; i < this.numDisplayThreads; ++i) {
            if (this.displayThread[i].isAlive()) continue;
            this.displayThread[i].start();
        }
        while (!this.terminate) {
            int n;
            long l = System.currentTimeMillis();
            if (!this.terminate && this.observer != null) {
                this.pickPermitted = true;
                for (int i = 0; i < this.numDisplayThreads && !this.terminate; ++i) {
                    this.displayThread[i].enableLayerChange(true);
                }
                try {
                    this.observer.updateSceneGraph();
                }
                catch (Exception exception) {
                    this.errorReporter.errorReport(USER_UPDATE_ERR, exception);
                    if (this.haltOnError) {
                        this.enabled = false;
                        return;
                    }
                }
                finally {
                    this.pickPermitted = false;
                }
                for (int i = 0; i < this.numDisplayThreads && !this.terminate; ++i) {
                    this.displayThread[i].enableLayerChange(true);
                }
            }
            if (this.terminate) break;
            for (int i = 0; i < this.numDeletables; ++i) {
                for (n = 0; n < this.numDisplayThreads; ++n) {
                    this.displayThread[n].queueDeletedObjects(this.deletionQueue, this.numDeletables);
                }
            }
            if (this.terminate) break;
            this.processShaderLists();
            if (this.terminate) break;
            Object object = this.frameFinishLock;
            synchronized (object) {
                if (this.lastDataChangeItem == 0 && this.lastBoundsChangeItem == 0 && !this.sceneChanged) {
                    for (n = 0; n < this.numDisplayThreads && !this.terminate; ++n) {
                        this.displayThread[n].displayOnly();
                    }
                } else {
                    if (!this.processChangeList() && this.haltOnError) {
                        this.enabled = false;
                        return;
                    }
                    if (this.terminate) {
                        break;
                    }
                    this.sceneChanged = false;
                    for (n = 0; n < this.numDisplayThreads && !this.terminate; ++n) {
                        this.displayThread[n].render();
                    }
                }
                if (this.terminate) {
                    break;
                }
            }
            if (!this.terminate && this.numDisplayThreads != 0) {
                try {
                    object = this.renderWaitLock;
                    synchronized (object) {
                        this.renderWaitLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.terminate) break;
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (l3 < (long)this.minimumCycleTime) {
                try {
                    Thread.sleep((long)this.minimumCycleTime - l3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Thread.yield();
        }
        this.runtimeThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void frameFinished() {
        Object object = this.frameFinishLock;
        synchronized (object) {
            if (++this.completedFrameCount >= this.numDisplayThreads) {
                Object object2 = this.renderWaitLock;
                synchronized (object2) {
                    this.completedFrameCount = 0;
                    this.renderWaitLock.notify();
                }
            }
        }
    }

    public boolean isDataWritePermitted(Object object) {
        return object == this.writableDataObject || !this.enabled;
    }

    public boolean isBoundsWritePermitted(Object object) {
        return object == this.writableBoundsObject || !this.enabled;
    }

    public boolean isPickingPermitted() {
        return !this.enabled || this.pickPermitted;
    }

    public void notifyUpdateRequired() {
        this.sceneChanged = true;
    }

    public synchronized boolean boundsChanged(NodeUpdateListener nodeUpdateListener, Object object, InternalNodeUpdateListener internalNodeUpdateListener) throws InvalidListenerSetTimingException {
        if (this.processing) {
            throw new InvalidListenerSetTimingException(BOUNDS_CALLBACK_ERROR);
        }
        if (this.boundsChangeSrcSet.contains(object) && this.boundsChangeListenerSet.contains((Object)nodeUpdateListener)) {
            return false;
        }
        this.boundsChangeListenerSet.add((Object)nodeUpdateListener);
        this.boundsChangeSrcSet.add(object);
        this.resizeBoundsChangeList();
        this.boundsChangeList[this.lastBoundsChangeItem] = nodeUpdateListener;
        this.boundsInternalList[this.lastBoundsChangeItem] = internalNodeUpdateListener;
        this.boundsSourceList[this.lastBoundsChangeItem] = object;
        ++this.lastBoundsChangeItem;
        return true;
    }

    public synchronized void dataChanged(NodeUpdateListener nodeUpdateListener, Object object) throws InvalidListenerSetTimingException {
        if (this.processing) {
            throw new InvalidListenerSetTimingException(DATA_CALLBACK_ERROR);
        }
        if (this.dataChangeSrcSet.contains(object) && this.dataChangeListenerSet.contains((Object)nodeUpdateListener)) {
            return;
        }
        this.dataChangeListenerSet.add((Object)nodeUpdateListener);
        this.dataChangeSrcSet.add(object);
        this.resizeDataChangeList();
        this.dataChangeList[this.lastDataChangeItem] = nodeUpdateListener;
        this.dataSourceList[this.lastDataChangeItem] = object;
        ++this.lastDataChangeItem;
    }

    public void activeSoundLayerChanged(InternalLayerUpdateListener internalLayerUpdateListener) throws InvalidListenerSetTimingException {
        if (this.activeSoundLayer == internalLayerUpdateListener) {
            return;
        }
        if (this.activeSoundLayer != null) {
            try {
                this.activeSoundLayer.disableActiveAudioState();
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(SOUND_UPDATE_ERROR, exception);
            }
        }
        this.activeSoundLayer = internalLayerUpdateListener;
    }

    public void shaderRequiresInit(ShaderSourceRenderable shaderSourceRenderable, boolean bl) {
        if (this.processing && !bl) {
            throw new RuntimeException(SHADER_INIT_TIMING_MSG);
        }
        if (this.shaderInitSet.contains((Object)shaderSourceRenderable)) {
            return;
        }
        this.shaderInitSet.add((Object)shaderSourceRenderable);
        this.resizeShaderInitList();
        this.shaderInitList[this.lastShaderInitItem] = shaderSourceRenderable;
        ++this.lastShaderInitItem;
    }

    public void shaderRequiresLogInfo(ShaderSourceRenderable shaderSourceRenderable, boolean bl) {
        if (this.processing && !bl) {
            throw new RuntimeException(SHADER_LOG_TIMING_MSG);
        }
        if (this.shaderLogSet.contains((Object)shaderSourceRenderable)) {
            return;
        }
        this.shaderLogSet.add((Object)shaderSourceRenderable);
        this.resizeShaderLogList();
        this.shaderLogList[this.lastShaderLogItem] = shaderSourceRenderable;
        ++this.lastShaderLogItem;
    }

    public void requestDeletion(DeletableRenderable deletableRenderable) {
    }

    public void rescindDeletionRequest(DeletableRenderable deletableRenderable) {
    }

    public PickingManager getPickingManager() {
        return this.pickHandler;
    }

    private boolean processChangeList() {
        int n;
        this.processing = true;
        for (n = 0; n < this.lastBoundsChangeItem; ++n) {
            block9: {
                this.writableBoundsObject = this.boundsSourceList[n];
                try {
                    this.boundsChangeList[n].updateNodeBoundsChanges(this.boundsSourceList[n]);
                }
                catch (Exception exception) {
                    this.errorReporter.errorReport(BOUNDS_CALLBACK_ERROR, exception);
                    if (!this.haltOnError) break block9;
                    return false;
                }
            }
            this.boundsChangeList[n] = null;
            this.boundsSourceList[n] = null;
        }
        this.writableBoundsObject = null;
        for (n = 0; n < this.lastBoundsChangeItem; ++n) {
            block10: {
                try {
                    this.boundsInternalList[n].updateBoundsAndNotify();
                }
                catch (Exception exception) {
                    this.errorReporter.errorReport(BOUNDS_UPDATE_ERROR, exception);
                    if (!this.haltOnError) break block10;
                    return false;
                }
            }
            this.boundsInternalList[n] = null;
        }
        this.lastBoundsChangeItem = 0;
        this.boundsChangeSrcSet.clear();
        this.boundsChangeListenerSet.clear();
        for (n = 0; n < this.lastDataChangeItem; ++n) {
            block11: {
                this.writableDataObject = this.dataSourceList[n];
                try {
                    this.dataChangeList[n].updateNodeDataChanges(this.dataSourceList[n]);
                }
                catch (Exception exception) {
                    this.errorReporter.errorReport(DATA_CALLBACK_ERROR, exception);
                    if (!this.haltOnError) break block11;
                    return false;
                }
            }
            this.dataChangeList[n] = null;
            this.dataSourceList[n] = null;
        }
        this.writableDataObject = null;
        this.lastDataChangeItem = 0;
        this.dataChangeSrcSet.clear();
        this.dataChangeListenerSet.clear();
        this.processing = false;
        return true;
    }

    private void processShaderLists() {
        int n;
        if (this.lastShaderInitItem == 0 && this.lastShaderLogItem == 0) {
            return;
        }
        for (n = 0; n < this.numDisplayThreads; ++n) {
            this.displayThread[n].queueShaderObjects(this.shaderInitList, this.lastShaderInitItem, this.shaderLogList, this.lastShaderLogItem);
        }
        for (n = 0; n < this.lastShaderInitItem; ++n) {
            this.shaderInitList[0] = null;
        }
        for (n = 0; n < this.lastShaderLogItem; ++n) {
            this.shaderLogList[0] = null;
        }
        this.lastShaderInitItem = 0;
        this.lastShaderLogItem = 0;
        this.shaderInitSet.clear();
        this.shaderLogSet.clear();
    }

    private final void resizeDataChangeList() {
        if (this.lastDataChangeItem + 1 == this.dataChangeList.length) {
            int n = this.dataChangeList.length;
            int n2 = n + 100;
            NodeUpdateListener[] nodeUpdateListenerArray = new NodeUpdateListener[n2];
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.dataChangeList, 0, nodeUpdateListenerArray, 0, n);
            System.arraycopy(this.dataSourceList, 0, objectArray, 0, n);
            this.dataChangeList = nodeUpdateListenerArray;
            this.dataSourceList = objectArray;
        }
    }

    private final void resizeBoundsChangeList() {
        if (this.lastBoundsChangeItem + 1 == this.boundsChangeList.length) {
            int n = this.boundsChangeList.length;
            int n2 = n + 100;
            NodeUpdateListener[] nodeUpdateListenerArray = new NodeUpdateListener[n2];
            InternalNodeUpdateListener[] internalNodeUpdateListenerArray = new InternalNodeUpdateListener[n2];
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.boundsChangeList, 0, nodeUpdateListenerArray, 0, n);
            System.arraycopy(this.boundsSourceList, 0, objectArray, 0, n);
            System.arraycopy(this.boundsInternalList, 0, internalNodeUpdateListenerArray, 0, n);
            this.boundsChangeList = nodeUpdateListenerArray;
            this.boundsSourceList = objectArray;
            this.boundsInternalList = internalNodeUpdateListenerArray;
        }
    }

    private final void resizeShaderInitList() {
        if (this.lastShaderInitItem + 1 == this.shaderInitList.length) {
            int n = this.shaderInitList.length;
            int n2 = n + 32;
            ShaderSourceRenderable[] shaderSourceRenderableArray = new ShaderSourceRenderable[n2];
            System.arraycopy(this.shaderInitList, 0, shaderSourceRenderableArray, 0, n);
            this.shaderInitList = shaderSourceRenderableArray;
        }
    }

    private final void resizeShaderLogList() {
        if (this.lastShaderLogItem + 1 == this.shaderLogList.length) {
            int n = this.shaderLogList.length;
            int n2 = n + 32;
            ShaderSourceRenderable[] shaderSourceRenderableArray = new ShaderSourceRenderable[n2];
            System.arraycopy(this.shaderLogList, 0, shaderSourceRenderableArray, 0, n);
            this.shaderLogList = shaderSourceRenderableArray;
        }
    }
}

