/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.management;

import org.j3d.aviatrix3d.management.PipelineStateObserver;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsOutputDevice;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsRenderPipeline;

class GraphicsPipelineThread
extends Thread {
    private boolean terminate;
    private GraphicsRenderPipeline pipeline;
    private PipelineStateObserver observer;
    private Object displayLock;
    private boolean waiting;
    private boolean noProcessing;

    GraphicsPipelineThread(GraphicsRenderPipeline graphicsRenderPipeline) {
        super("Aviatrix3D multithreaded render pipeline");
        this.pipeline = graphicsRenderPipeline;
        this.terminate = false;
        this.waiting = false;
        this.noProcessing = false;
        this.displayLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = true;
        while (!this.terminate && bl) {
            try {
                Object object;
                System.out.println("noProcess3: " + this.noProcessing);
                boolean bl2 = this.noProcessing ? this.pipeline.displayOnly() : this.pipeline.render();
                if (this.terminate) break;
                if (bl2 && (object = this.pipeline.getGraphicsOutputDevice()).isDisposed()) {
                    bl = false;
                }
                if (this.terminate) break;
                object = this.displayLock;
                synchronized (object) {
                    if (this.observer != null) {
                        this.observer.frameFinished();
                    }
                    if (this.terminate) {
                        break;
                    }
                    this.displayLock.wait();
                }
                Thread.yield();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.terminate) break;
            this.pipeline.swapBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void halt() {
        this.pipeline.halt();
        try {
            Object object = this.displayLock;
            synchronized (object) {
                if (this.observer != null) {
                    this.observer.frameFinished();
                }
                this.displayLock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayOnly() {
        this.noProcessing = true;
        Object object = this.displayLock;
        synchronized (object) {
            this.displayLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void render() {
        this.noProcessing = false;
        Object object = this.displayLock;
        synchronized (object) {
            this.displayLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.terminate = true;
        GraphicsOutputDevice graphicsOutputDevice = this.pipeline.getGraphicsOutputDevice();
        graphicsOutputDevice.dispose();
        this.pipeline.halt();
        Object object = this.displayLock;
        synchronized (object) {
            this.displayLock.notify();
        }
    }

    void setStateObserver(PipelineStateObserver pipelineStateObserver) {
        this.observer = pipelineStateObserver;
    }
}

