/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.management;

import org.j3d.aviatrix3d.management.DisplayCollection;
import org.j3d.aviatrix3d.management.PipelineStateObserver;
import org.j3d.aviatrix3d.rendering.DeletableRenderable;
import org.j3d.aviatrix3d.rendering.ShaderSourceRenderable;

class DisplayCollectionThread
extends Thread {
    private boolean terminate;
    private DisplayCollection display;
    private PipelineStateObserver observer;
    private Object displayLock;
    private boolean waiting;
    private boolean noProcessing;

    DisplayCollectionThread(DisplayCollection displayCollection) {
        super("Aviatrix3D multithreaded display collection");
        this.display = displayCollection;
        this.terminate = false;
        this.waiting = false;
        this.noProcessing = false;
        this.displayLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        System.out.println("Running thread");
        boolean bl = true;
        while (!this.terminate && bl) {
            try {
                System.out.println("noProcess1: " + this.noProcessing);
                boolean bl2 = this.noProcessing ? this.display.displayOnly() : this.display.process();
                if (this.terminate) break;
                if (bl2 && this.display.isDisposed()) {
                    bl = false;
                }
                if (this.terminate) break;
                Object object = this.displayLock;
                synchronized (object) {
                    if (this.observer != null) {
                        this.observer.frameFinished();
                    }
                    if (this.terminate) {
                        break;
                    }
                    this.displayLock.wait();
                }
                Thread.yield();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void halt() {
        this.display.halt();
        try {
            Object object = this.displayLock;
            synchronized (object) {
                if (this.observer != null) {
                    this.observer.frameFinished();
                }
                this.displayLock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayOnly() {
        this.noProcessing = true;
        Object object = this.displayLock;
        synchronized (object) {
            this.displayLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void render() {
        this.noProcessing = false;
        Object object = this.displayLock;
        synchronized (object) {
            this.displayLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.terminate = true;
        this.display.halt();
        Object object = this.displayLock;
        synchronized (object) {
            this.displayLock.notify();
        }
    }

    void setStateObserver(PipelineStateObserver pipelineStateObserver) {
        this.observer = pipelineStateObserver;
    }

    void queueDeletedObjects(DeletableRenderable[] deletableRenderableArray, int n) {
        this.display.queueDeletedObjects(deletableRenderableArray, n);
    }

    void queueShaderObjects(ShaderSourceRenderable[] shaderSourceRenderableArray, int n, ShaderSourceRenderable[] shaderSourceRenderableArray2, int n2) {
        this.display.queueShaderObjects(shaderSourceRenderableArray, n, shaderSourceRenderableArray2, n2);
    }

    void enableLayerChange(boolean bl) {
        this.display.enableLayerChange(bl);
    }
}

