/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.management;

import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Layer;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.pipeline.RenderPipeline;
import org.j3d.aviatrix3d.rendering.DeletableRenderable;
import org.j3d.aviatrix3d.rendering.ShaderSourceRenderable;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;

public abstract class DisplayCollection {
    protected static final String LAYER_SET_SIZE_ERR = "The length of the layers argument is not long enough for the value defined by numLayers";
    protected static final String LAYER_TIMING_MSG = "You cannot set layers right now. The system is actively management and you did not make the call during the ApplicationUpdateObserver.updateSceneGraph() method callback.";
    protected static final String ACTIVE_RENDERING_MSG = "You cannot make this call now because the system is currently management. To make this call, first disable the management. ";
    private static final int LIST_START_SIZE = 64;
    protected ShaderSourceRenderable[] shaderInitList;
    protected ShaderSourceRenderable[] shaderLogList;
    protected DeletableRenderable[] deletionList;
    protected int numShaderInit;
    protected int numShaderLog;
    protected int numDeletables;
    protected boolean enabled = false;
    protected boolean terminate = false;
    protected ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    protected boolean writeEnabled = true;

    protected DisplayCollection() {
        this.shaderInitList = new ShaderSourceRenderable[64];
        this.shaderLogList = new ShaderSourceRenderable[64];
        this.deletionList = new DeletableRenderable[64];
    }

    public abstract boolean process();

    public abstract boolean displayOnly();

    public abstract void halt();

    public abstract void setLayers(Layer[] var1, int var2) throws IllegalArgumentException, InvalidWriteTimingException;

    public abstract int numLayers();

    public abstract void getLayers(Layer[] var1);

    public abstract void addPipeline(RenderPipeline var1) throws IllegalStateException;

    public abstract void removePipeline(RenderPipeline var1) throws IllegalStateException;

    protected abstract void setUpdateHandler(NodeUpdateHandler var1);

    protected void enableLayerChange(boolean bl) {
        this.writeEnabled = bl;
    }

    protected void queueDeletedObjects(DeletableRenderable[] deletableRenderableArray, int n) {
        if (n > this.deletionList.length) {
            this.deletionList = new DeletableRenderable[n];
        }
        System.arraycopy(deletableRenderableArray, 0, this.deletionList, 0, n);
        this.numDeletables = n;
    }

    protected void queueShaderObjects(ShaderSourceRenderable[] shaderSourceRenderableArray, int n, ShaderSourceRenderable[] shaderSourceRenderableArray2, int n2) {
        if (n > this.shaderInitList.length) {
            this.shaderInitList = new ShaderSourceRenderable[n];
        }
        if (n2 > this.shaderLogList.length) {
            this.shaderLogList = new ShaderSourceRenderable[n2];
        }
        System.arraycopy(shaderSourceRenderableArray, 0, this.shaderInitList, 0, n);
        System.arraycopy(shaderSourceRenderableArray2, 0, this.shaderLogList, 0, n2);
        this.numShaderInit = n;
        this.numShaderLog = n2;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void shutdown() {
        this.terminate = true;
    }

    public boolean isDisposed() {
        return this.terminate;
    }
}

