/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.management;

import java.util.ArrayList;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import org.j3d.aviatrix3d.BoundingGeometry;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.SceneGraphPath;
import org.j3d.aviatrix3d.management.DefaultBatchPickingHandler;
import org.j3d.aviatrix3d.picking.CustomPickTarget;
import org.j3d.aviatrix3d.picking.GroupPickTarget;
import org.j3d.aviatrix3d.picking.LeafPickTarget;
import org.j3d.aviatrix3d.picking.NotPickableException;
import org.j3d.aviatrix3d.picking.PickInstructions;
import org.j3d.aviatrix3d.picking.PickRequest;
import org.j3d.aviatrix3d.picking.PickTarget;
import org.j3d.aviatrix3d.picking.PickingManager;
import org.j3d.aviatrix3d.picking.SinglePickTarget;
import org.j3d.aviatrix3d.picking.TransformPickTarget;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;
import org.j3d.util.MatrixUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultPickingHandler
implements PickingManager {
    private static final String NO_PICK_TYPE_MSG = "AV3D: No or unknown picking type has been specified in the PickRequest";
    private static final String NO_SORT_TYPE_MSG = "AV3D: No or unknown sorting type has been specified in the PickRequest";
    private static final String UNKNOWN_PROXY_TYPE_MSG = "AV3D Proxy geometry contains an unknown picking type so we can't evaluate it. Defaulting back to the normal geometry.";
    private static final int LIST_START_SIZE = 32;
    private static final int LIST_INCREMENT = 8;
    private DefaultBatchPickingHandler batchPicker;
    private PickTarget[] pickPath;
    private Matrix4f[] transformPath;
    private boolean[] validTransform;
    private int lastPathIndex;
    private float closestDistance;
    private float[] start = new float[4];
    private float[] end = new float[4];
    private float[] vertexPickData;
    private Matrix4f vworldMatrix;
    private Matrix4f invertedMatrix;
    private Vector4f wkVec;
    private Vector3f wkNormal;
    private Vector4f[] frustumPlanes;
    private MatrixUtils matrixUtils;
    private PickInstructions pickInstructions;
    private ErrorReporter errorReporter;

    DefaultPickingHandler() {
        this.start[3] = 1.0f;
        this.end[3] = 1.0f;
        this.vertexPickData = new float[3];
        this.pickPath = new PickTarget[32];
        this.transformPath = new Matrix4f[32];
        this.validTransform = new boolean[32];
        for (int i = 0; i < 32; ++i) {
            this.transformPath[i] = new Matrix4f();
        }
        this.vworldMatrix = new Matrix4f();
        this.invertedMatrix = new Matrix4f();
        this.wkVec = new Vector4f();
        this.wkVec.w = 1.0f;
        this.wkNormal = new Vector3f();
        this.frustumPlanes = new Vector4f[]{new Vector4f(), new Vector4f(), new Vector4f(), new Vector4f(), new Vector4f(), new Vector4f()};
        this.matrixUtils = new MatrixUtils();
        this.pickInstructions = new PickInstructions();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    @Override
    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        this.batchPicker.setErrorReporter(this.errorReporter);
    }

    @Override
    public synchronized void pickBatch(PickTarget pickTarget, PickRequest[] pickRequestArray, int n) throws NotPickableException {
        if (n == 0 || pickTarget == null || pickRequestArray == null || pickRequestArray.length == 0) {
            return;
        }
        if (n == 1 || pickRequestArray.length == 1) {
            this.pickSingle(pickTarget, pickRequestArray[0]);
        }
        if (this.batchPicker == null) {
            this.batchPicker = new DefaultBatchPickingHandler();
        }
        this.batchPicker.processPick(pickTarget, pickRequestArray, n);
    }

    @Override
    public synchronized void pickSingle(PickTarget pickTarget, PickRequest pickRequest) throws NotPickableException {
        if (pickTarget == null || pickRequest == null) {
            return;
        }
        if (!pickTarget.checkPickMask(pickRequest.pickType)) {
            pickRequest.pickCount = 0;
            return;
        }
        switch (pickRequest.pickGeometryType) {
            case 1: {
                this.pickPoint(pickTarget, pickRequest);
                break;
            }
            case 2: {
                this.pickRay(pickTarget, pickRequest);
                break;
            }
            case 3: {
                this.pickLineSegment(pickTarget, pickRequest);
                break;
            }
            case 4: 
            case 5: {
                this.pickCylinder(pickTarget, pickRequest);
                break;
            }
            case 6: 
            case 7: {
                this.pickCone(pickTarget, pickRequest);
                break;
            }
            case 8: {
                this.pickBox(pickTarget, pickRequest);
                break;
            }
            case 10: {
                this.pickFrustum(pickTarget, pickRequest);
                break;
            }
            case 9: {
                this.pickSphere(pickTarget, pickRequest);
                break;
            }
            default: {
                this.errorReporter.warningReport(NO_PICK_TYPE_MSG, null);
            }
        }
        for (int i = 0; i < this.pickPath.length; ++i) {
            this.pickPath[i] = null;
        }
    }

    private void pickPoint(PickTarget pickTarget, PickRequest pickRequest) {
        switch (pickRequest.pickSortType) {
            case 1: 
            case 3: {
                this.pickAllPoint(pickTarget, pickRequest);
                break;
            }
            case 2: 
            case 4: {
                this.pickSinglePoint(pickTarget, pickRequest);
                break;
            }
            default: {
                this.errorReporter.warningReport(NO_SORT_TYPE_MSG, null);
            }
        }
    }

    private void pickSinglePoint(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget.getPickableBounds();
        if (boundingVolume == null || !boundingVolume.checkIntersectionPoint(pickRequest.origin)) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.start[3] = 1.0f;
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n = object.numPickableChildren();
                if (n == 0) break;
                if (pickTarget2 instanceof TransformPickTarget) {
                    pickTargetArray = (PickTarget[])pickTarget2;
                    pickTargetArray.getTransform(this.transformPath[0]);
                    pickTargetArray.getInverseTransform(this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block18: for (int i = 0; i < n && !bl; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            bl = this.pickSinglePoint((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block18;
                        }
                        case 2: {
                            bl = this.pickSinglePoint((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block18;
                        }
                        case 3: {
                            bl = this.pickSinglePoint((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block18;
                        }
                        case 4: {
                            bl = this.pickSinglePoint((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                        }
                    }
                }
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSinglePoint((LeafPickTarget)pickTarget2, pickRequest, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSinglePoint((SinglePickTarget)pickTarget2, pickRequest, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                break;
            }
            case 4: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                if (!this.pickCustom((CustomPickTarget)pickTarget2, pickRequest)) break;
                CustomPickTarget customPickTarget = (CustomPickTarget)pickTarget2;
                int n = this.pickInstructions.numChildren;
                if (this.pickInstructions.hasTransform) {
                    this.transformPath[0].set(this.pickInstructions.localTransform);
                    this.matrixUtils.inverse(this.transformPath[0], this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
                block19: for (int i = 0; i < n && !bl; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            bl = this.pickSinglePoint((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block19;
                        }
                        case 2: {
                            bl = this.pickSinglePoint((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block19;
                        }
                        case 3: {
                            bl = this.pickSinglePoint((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block19;
                        }
                        case 4: {
                            bl = this.pickSinglePoint((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                        }
                    }
                }
                break;
            }
        }
        pickRequest.pickCount = bl ? 1 : 0;
    }

    private boolean pickSinglePoint(SinglePickTarget singlePickTarget, PickRequest pickRequest, float[] fArray, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget == null) {
            return false;
        }
        boolean bl2 = false;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                bl2 = this.pickSinglePoint((GroupPickTarget)pickTarget, pickRequest, fArray, sceneGraphPath, bl);
                break;
            }
            case 2: {
                bl2 = this.pickSinglePoint((SinglePickTarget)pickTarget, pickRequest, fArray, sceneGraphPath, bl);
                break;
            }
            case 3: {
                bl2 = this.pickSinglePoint((LeafPickTarget)pickTarget, pickRequest, fArray, sceneGraphPath, bl);
                break;
            }
            case 4: {
                bl2 = this.pickSinglePoint((CustomPickTarget)pickTarget, pickRequest, fArray, sceneGraphPath, bl);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return bl2;
    }

    private boolean pickSinglePoint(GroupPickTarget groupPickTarget, PickRequest pickRequest, float[] fArray, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionPoint(fArray)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSinglePoint((GroupPickTarget)((Object)node), pickRequest, fArray, sceneGraphPath, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSinglePoint((SinglePickTarget)((Object)node), pickRequest, fArray, sceneGraphPath, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSinglePoint((LeafPickTarget)((Object)node), pickRequest, fArray, sceneGraphPath, bl);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickSinglePoint((CustomPickTarget)((Object)node), pickRequest, fArray, sceneGraphPath, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl2 = false;
        int n = groupPickTarget.numPickableChildren();
        if (n != 0) {
            PickTarget[] pickTargetArray;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                transformPickTarget.getInverseTransform(this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block6: for (int i = 0; i < n && !bl2; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl2 = this.pickSinglePoint((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, sceneGraphPath, bl);
                        continue block6;
                    }
                    case 2: {
                        bl2 = this.pickSinglePoint((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, sceneGraphPath, bl);
                        continue block6;
                    }
                    case 3: {
                        bl2 = this.pickSinglePoint((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, sceneGraphPath, bl);
                        continue block6;
                    }
                    case 4: {
                        bl2 = this.pickSinglePoint((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, sceneGraphPath, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
        }
        return bl2;
    }

    private boolean pickSinglePoint(CustomPickTarget customPickTarget, PickRequest pickRequest, float[] fArray, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionPoint(fArray)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSinglePoint((GroupPickTarget)((Object)node), pickRequest, fArray, sceneGraphPath, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSinglePoint((SinglePickTarget)((Object)node), pickRequest, fArray, sceneGraphPath, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSinglePoint((LeafPickTarget)((Object)node), pickRequest, fArray, sceneGraphPath, bl);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickSinglePoint((CustomPickTarget)((Object)node), pickRequest, fArray, sceneGraphPath, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl2 = false;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            int n = this.pickInstructions.numChildren;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            if (this.pickInstructions.hasTransform) {
                this.transformPath[this.lastPathIndex].set(this.pickInstructions.localTransform);
                this.matrixUtils.inverse(this.transformPath[this.lastPathIndex], this.invertedMatrix);
                this.transform(this.invertedMatrix, this.start);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block6: for (int i = 0; i < n && !bl2; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl2 = this.pickSinglePoint((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                        continue block6;
                    }
                    case 2: {
                        bl2 = this.pickSinglePoint((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                        continue block6;
                    }
                    case 3: {
                        bl2 = this.pickSinglePoint((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                        continue block6;
                    }
                    case 4: {
                        bl2 = this.pickSinglePoint((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, sceneGraphPath, pickRequest.generateVWorldMatrix);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
        }
        return bl2;
    }

    private boolean pickSinglePoint(LeafPickTarget leafPickTarget, PickRequest pickRequest, float[] fArray, SceneGraphPath sceneGraphPath, boolean bl) {
        if (leafPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        boolean bl2 = false;
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionPoint(fArray)) {
            this.resizePath();
            this.pickPath[this.lastPathIndex] = leafPickTarget;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            bl2 = true;
            --this.lastPathIndex;
        }
        return bl2;
    }

    private void pickAllPoint(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        int n = 0;
        ArrayList<SceneGraphPath> arrayList = null;
        if (pickRequest.foundPaths instanceof ArrayList) {
            arrayList = (ArrayList<SceneGraphPath>)pickRequest.foundPaths;
            arrayList.clear();
        } else {
            pickRequest.foundPaths = arrayList = new ArrayList<SceneGraphPath>();
        }
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        if (boundingVolume == null || !boundingVolume.checkIntersectionPoint(pickRequest.origin)) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.start[3] = 1.0f;
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n2 = object.numPickableChildren();
                if (n2 == 0) break;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[0];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                    transformPickTarget.getInverseTransform(this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n2; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            n += this.pickAllPoint((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 2: {
                            n += this.pickAllPoint((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 3: {
                            n += this.pickAllPoint((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, arrayList, n, pickRequest.generateVWorldMatrix);
                        }
                        case 4: {
                            n += this.pickAllPoint((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, arrayList, n, pickRequest.generateVWorldMatrix);
                        }
                    }
                }
                pickRequest.pickCount = n;
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllPoint((SinglePickTarget)pickTarget2, pickRequest, this.start, arrayList, 0, pickRequest.generateVWorldMatrix);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = (LeafPickTarget)pickTarget2;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllPoint((LeafPickTarget)pickTarget2, pickRequest, this.start, arrayList, 0, pickRequest.generateVWorldMatrix);
            }
        }
    }

    private int pickAllPoint(GroupPickTarget groupPickTarget, PickRequest pickRequest, float[] fArray, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionPoint(fArray)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickAllPoint((GroupPickTarget)((Object)node), pickRequest, fArray, arrayList, n, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickAllPoint((SinglePickTarget)((Object)node), pickRequest, fArray, arrayList, n, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickAllPoint((LeafPickTarget)((Object)node), pickRequest, fArray, arrayList, n, bl);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickAllPoint((CustomPickTarget)((Object)node), pickRequest, fArray, arrayList, n, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        int n2 = 0;
        int n3 = groupPickTarget.numPickableChildren();
        if (n3 != 0) {
            PickTarget[] pickTargetArray;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                transformPickTarget.getInverseTransform(this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block6: for (int i = 0; i < n3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        n2 += this.pickAllPoint((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 2: {
                        n2 += this.pickAllPoint((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 3: {
                        n2 += this.pickAllPoint((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 4: {
                        n2 += this.pickAllPoint((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, arrayList, n + n2, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
        }
        return n2;
    }

    private int pickAllPoint(SinglePickTarget singlePickTarget, PickRequest pickRequest, float[] fArray, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget == null) {
            return 0;
        }
        int n2 = 0;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                n2 = this.pickAllPoint((GroupPickTarget)pickTarget, pickRequest, fArray, arrayList, n, bl);
                break;
            }
            case 2: {
                n2 = this.pickAllPoint((SinglePickTarget)pickTarget, pickRequest, fArray, arrayList, n, bl);
                break;
            }
            case 3: {
                n2 = this.pickAllPoint((LeafPickTarget)pickTarget, pickRequest, fArray, arrayList, n, bl);
                break;
            }
            case 4: {
                n2 = this.pickAllPoint((CustomPickTarget)pickTarget, pickRequest, fArray, arrayList, n, bl);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return n2;
    }

    private int pickAllPoint(CustomPickTarget customPickTarget, PickRequest pickRequest, float[] fArray, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionPoint(fArray)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickAllPoint((GroupPickTarget)((Object)node), pickRequest, fArray, arrayList, n, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickAllPoint((SinglePickTarget)((Object)node), pickRequest, fArray, arrayList, n, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickAllPoint((LeafPickTarget)((Object)node), pickRequest, fArray, arrayList, n, bl);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickAllPoint((CustomPickTarget)((Object)node), pickRequest, fArray, arrayList, n, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        int n2 = 0;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            int n3 = this.pickInstructions.numChildren;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            if (this.pickInstructions.hasTransform) {
                this.transformPath[this.lastPathIndex].set(this.pickInstructions.localTransform);
                this.matrixUtils.inverse(this.pickInstructions.localTransform, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block6: for (int i = 0; i < n3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        n2 += this.pickAllPoint((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 2: {
                        n2 += this.pickAllPoint((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 3: {
                        n2 += this.pickAllPoint((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 4: {
                        n2 += this.pickAllPoint((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, arrayList, n + n2, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
        }
        return n2;
    }

    private int pickAllPoint(LeafPickTarget leafPickTarget, PickRequest pickRequest, float[] fArray, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!leafPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        int n2 = 0;
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionPoint(fArray)) {
            SceneGraphPath sceneGraphPath;
            this.resizePath();
            this.pickPath[this.lastPathIndex] = leafPickTarget;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (n >= arrayList.size()) {
                sceneGraphPath = new SceneGraphPath();
                arrayList.add(sceneGraphPath);
            } else {
                sceneGraphPath = arrayList.get(n);
            }
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            n2 = 1;
            --this.lastPathIndex;
        }
        return n2;
    }

    private void pickLineSegment(PickTarget pickTarget, PickRequest pickRequest) {
        switch (pickRequest.pickSortType) {
            case 1: {
                this.pickAllLineSegment(pickTarget, pickRequest);
                break;
            }
            case 3: {
                this.pickAllLineSegmentSorted(pickTarget, pickRequest);
                break;
            }
            case 2: {
                this.pickSingleLineSegment(pickTarget, pickRequest);
                break;
            }
            case 4: {
                this.pickSingleLineSegmentSorted(pickTarget, pickRequest);
                break;
            }
            default: {
                this.errorReporter.warningReport(NO_SORT_TYPE_MSG, null);
            }
        }
    }

    private void pickSingleLineSegment(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        if (boundingVolume == null || !boundingVolume.checkIntersectionSegment(pickRequest.origin, pickRequest.destination)) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.start[3] = 1.0f;
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        this.end[3] = 1.0f;
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n = object.numPickableChildren();
                if (n == 0) break;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[0];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                    transformPickTarget.getInverseTransform(this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                    this.transform(this.invertedMatrix, this.end);
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n && !bl; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            bl = this.pickSingleLineSegment((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue block11;
                        }
                        case 2: {
                            bl = this.pickSingleLineSegment((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue block11;
                        }
                        case 3: {
                            bl = this.pickSingleLineSegment((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
                            continue block11;
                        }
                        case 4: {
                            bl = this.pickSingleLineSegment((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                        }
                    }
                }
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleLineSegment((SinglePickTarget)pickTarget2, pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleLineSegment((LeafPickTarget)pickTarget2, pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
            }
        }
        pickRequest.pickCount = bl ? 1 : 0;
    }

    private boolean pickSingleLineSegment(GroupPickTarget groupPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionSegment(fArray, fArray2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleLineSegment((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleLineSegment((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleLineSegment((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, false);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickSingleLineSegment((CustomPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl3 = false;
        int n = groupPickTarget.numPickableChildren();
        if (n != 0) {
            PickTarget[] pickTargetArray;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                transformPickTarget.getInverseTransform(this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block6: for (int i = 0; i < n && !bl3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl3 = this.pickSingleLineSegment((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                        continue block6;
                    }
                    case 2: {
                        bl3 = this.pickSingleLineSegment((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                        continue block6;
                    }
                    case 3: {
                        bl3 = this.pickSingleLineSegment((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, false);
                        continue block6;
                    }
                    case 4: {
                        bl3 = this.pickSingleLineSegment((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return bl3;
    }

    private boolean pickSingleLineSegment(SinglePickTarget singlePickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget == null) {
            return false;
        }
        boolean bl3 = false;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                bl3 = this.pickSingleLineSegment((GroupPickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                break;
            }
            case 2: {
                bl3 = this.pickSingleLineSegment((SinglePickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                break;
            }
            case 3: {
                bl3 = this.pickSingleLineSegment((LeafPickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, false);
                break;
            }
            case 4: {
                bl3 = this.pickSingleLineSegment((CustomPickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return bl3;
    }

    private boolean pickSingleLineSegment(CustomPickTarget customPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionSegment(fArray, fArray2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleLineSegment((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleLineSegment((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleLineSegment((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, false);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickSingleLineSegment((CustomPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl3 = false;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            int n = this.pickInstructions.numChildren;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (this.pickInstructions.hasTransform) {
                this.transformPath[this.lastPathIndex].set(this.pickInstructions.localTransform);
                this.matrixUtils.inverse(this.pickInstructions.localTransform, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block6: for (int i = 0; i < n && !bl3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl3 = this.pickSingleLineSegment((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                        continue block6;
                    }
                    case 2: {
                        bl3 = this.pickSingleLineSegment((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                        continue block6;
                    }
                    case 3: {
                        bl3 = this.pickSingleLineSegment((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, false);
                        continue block6;
                    }
                    case 4: {
                        bl3 = this.pickSingleLineSegment((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return bl3;
    }

    private boolean pickSingleLineSegment(LeafPickTarget leafPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2, boolean bl3) {
        if (!leafPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        boolean bl4 = false;
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionSegment(fArray, fArray2)) {
            if (bl2) {
                if (leafPickTarget.pickLineSegment(fArray, fArray2, bl3, this.vertexPickData, 0)) {
                    this.resizePath();
                    this.pickPath[this.lastPathIndex] = leafPickTarget;
                    this.validTransform[this.lastPathIndex] = false;
                    ++this.lastPathIndex;
                    if (bl) {
                        this.buildVWorldTransform();
                    } else {
                        this.vworldMatrix.setIdentity();
                    }
                    sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
                    bl4 = true;
                    --this.lastPathIndex;
                }
            } else {
                this.resizePath();
                this.pickPath[this.lastPathIndex] = leafPickTarget;
                this.validTransform[this.lastPathIndex] = false;
                ++this.lastPathIndex;
                if (bl) {
                    this.buildVWorldTransform();
                } else {
                    this.vworldMatrix.setIdentity();
                }
                sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
                bl4 = true;
                --this.lastPathIndex;
            }
        }
        return bl4;
    }

    private void pickAllLineSegment(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        int n = 0;
        ArrayList<SceneGraphPath> arrayList = null;
        if (pickRequest.foundPaths instanceof ArrayList) {
            arrayList = (ArrayList<SceneGraphPath>)pickRequest.foundPaths;
        } else {
            pickRequest.foundPaths = arrayList = new ArrayList<SceneGraphPath>();
        }
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        if (boundingVolume == null || !boundingVolume.checkIntersectionSegment(pickRequest.origin, pickRequest.destination)) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.start[3] = 1.0f;
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        this.end[3] = 1.0f;
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n2 = object.numPickableChildren();
                if (n2 == 0) break;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[0];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                    transformPickTarget.getInverseTransform(this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                    this.transform(this.invertedMatrix, this.end);
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n2; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            n += this.pickAllLineSegment((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue block11;
                        }
                        case 2: {
                            n += this.pickAllLineSegment((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue block11;
                        }
                        case 3: {
                            n += this.pickAllLineSegment((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
                            continue block11;
                        }
                        case 4: {
                            n += this.pickAllLineSegment((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                        }
                    }
                }
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                n += this.pickAllLineSegment((SinglePickTarget)pickTarget2, pickRequest, this.start, this.end, arrayList, 0, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                n += this.pickAllLineSegment((LeafPickTarget)pickTarget2, pickRequest, this.start, this.end, arrayList, 0, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
            }
        }
        pickRequest.pickCount = n;
    }

    private int pickAllLineSegment(GroupPickTarget groupPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, ArrayList<SceneGraphPath> arrayList, int n, boolean bl, boolean bl2) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionSegment(fArray, fArray2)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickAllLineSegment((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickAllLineSegment((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickAllLineSegment((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl, bl2, false);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickAllLineSegment((CustomPickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        int n2 = 0;
        int n3 = groupPickTarget.numPickableChildren();
        if (n3 != 0) {
            PickTarget[] pickTargetArray;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                transformPickTarget.getInverseTransform(this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block6: for (int i = 0; i < n3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        n2 += this.pickAllLineSegment((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl, bl2);
                        continue block6;
                    }
                    case 2: {
                        n2 += this.pickAllLineSegment((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl, bl2);
                        continue block6;
                    }
                    case 3: {
                        n2 += this.pickAllLineSegment((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl, bl2, false);
                        continue block6;
                    }
                    case 4: {
                        n2 += this.pickAllLineSegment((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl, bl2);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return n2;
    }

    private int pickAllLineSegment(SinglePickTarget singlePickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, ArrayList<SceneGraphPath> arrayList, int n, boolean bl, boolean bl2) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget == null) {
            return 0;
        }
        int n2 = 0;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                n2 = this.pickAllLineSegment((GroupPickTarget)pickTarget, pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
                break;
            }
            case 2: {
                n2 = this.pickAllLineSegment((SinglePickTarget)pickTarget, pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
                break;
            }
            case 3: {
                n2 = this.pickAllLineSegment((LeafPickTarget)pickTarget, pickRequest, fArray, fArray2, arrayList, n, bl, bl2, false);
                break;
            }
            case 4: {
                n2 = this.pickAllLineSegment((CustomPickTarget)pickTarget, pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return n2;
    }

    private int pickAllLineSegment(CustomPickTarget customPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, ArrayList<SceneGraphPath> arrayList, int n, boolean bl, boolean bl2) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionSegment(fArray, fArray2)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickAllLineSegment((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickAllLineSegment((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickAllLineSegment((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl, bl2, false);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickAllLineSegment((CustomPickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        int n2 = 0;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            int n3 = this.pickInstructions.numChildren;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (this.pickInstructions.hasTransform) {
                this.transformPath[this.lastPathIndex].set(this.pickInstructions.localTransform);
                this.matrixUtils.inverse(this.pickInstructions.localTransform, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block6: for (int i = 0; i < n3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        n2 += this.pickAllLineSegment((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl, bl2);
                        continue block6;
                    }
                    case 2: {
                        n2 += this.pickAllLineSegment((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl, bl2);
                        continue block6;
                    }
                    case 3: {
                        n2 += this.pickAllLineSegment((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl, bl2, false);
                        continue block6;
                    }
                    case 4: {
                        n2 += this.pickAllLineSegment((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl, bl2);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return n2;
    }

    private int pickAllLineSegment(LeafPickTarget leafPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, ArrayList<SceneGraphPath> arrayList, int n, boolean bl, boolean bl2, boolean bl3) {
        if (!leafPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        int n2 = 0;
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionSegment(fArray, fArray2)) {
            if (bl2) {
                if (leafPickTarget.pickLineSegment(fArray, fArray2, bl3, this.vertexPickData, 0)) {
                    SceneGraphPath sceneGraphPath;
                    this.resizePath();
                    this.pickPath[this.lastPathIndex] = leafPickTarget;
                    this.validTransform[this.lastPathIndex] = false;
                    ++this.lastPathIndex;
                    if (n >= arrayList.size()) {
                        sceneGraphPath = new SceneGraphPath();
                        arrayList.add(sceneGraphPath);
                    } else {
                        sceneGraphPath = arrayList.get(n);
                    }
                    if (bl) {
                        this.buildVWorldTransform();
                    } else {
                        this.vworldMatrix.setIdentity();
                    }
                    sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
                    n2 = 1;
                    --this.lastPathIndex;
                }
            } else {
                SceneGraphPath sceneGraphPath;
                this.resizePath();
                this.pickPath[this.lastPathIndex] = leafPickTarget;
                this.validTransform[this.lastPathIndex] = false;
                ++this.lastPathIndex;
                if (n >= arrayList.size()) {
                    sceneGraphPath = new SceneGraphPath();
                    arrayList.add(sceneGraphPath);
                } else {
                    sceneGraphPath = arrayList.get(n);
                }
                if (bl) {
                    this.buildVWorldTransform();
                } else {
                    this.vworldMatrix.setIdentity();
                }
                sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
                n2 = 1;
                --this.lastPathIndex;
            }
        }
        return n2;
    }

    private void pickSingleLineSegmentSorted(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        if (boundingVolume == null || !boundingVolume.checkIntersectionSegment(pickRequest.origin, pickRequest.destination)) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.start[3] = 1.0f;
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        this.end[3] = 1.0f;
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n = object.numPickableChildren();
                if (n == 0) break;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[0];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                    transformPickTarget.getInverseTransform(this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                    this.transform(this.invertedMatrix, this.end);
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n && !bl; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            bl = this.pickSingleLineSegmentSorted((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue block11;
                        }
                        case 2: {
                            bl = this.pickSingleLineSegmentSorted((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue block11;
                        }
                        case 3: {
                            bl = this.pickSingleLineSegment((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, true);
                            continue block11;
                        }
                        case 4: {
                            bl = this.pickSingleLineSegmentSorted((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                        }
                    }
                }
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleLineSegmentSorted((SinglePickTarget)pickTarget2, pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleLineSegment((LeafPickTarget)pickTarget2, pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
            }
        }
        pickRequest.pickCount = bl ? 1 : 0;
    }

    private boolean pickSingleLineSegmentSorted(SinglePickTarget singlePickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget == null) {
            return false;
        }
        boolean bl3 = false;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                bl3 = this.pickSingleLineSegmentSorted((GroupPickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                break;
            }
            case 2: {
                bl3 = this.pickSingleLineSegmentSorted((SinglePickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                break;
            }
            case 3: {
                bl3 = this.pickSingleLineSegment((LeafPickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, true);
                break;
            }
            case 4: {
                bl3 = this.pickSingleLineSegmentSorted((CustomPickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return bl3;
    }

    private boolean pickSingleLineSegmentSorted(GroupPickTarget groupPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionSegment(fArray, fArray2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleLineSegmentSorted((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleLineSegmentSorted((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleLineSegment((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, true);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickSingleLineSegmentSorted((CustomPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl3 = false;
        int n = groupPickTarget.numPickableChildren();
        if (n != 0) {
            PickTarget[] pickTargetArray;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                transformPickTarget.getInverseTransform(this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block6: for (int i = 0; i < n && !bl3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl3 = this.pickSingleLineSegmentSorted((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                        continue block6;
                    }
                    case 2: {
                        bl3 = this.pickSingleLineSegmentSorted((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                        continue block6;
                    }
                    case 3: {
                        bl3 = this.pickSingleLineSegment((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, true);
                        continue block6;
                    }
                    case 4: {
                        bl3 = this.pickSingleLineSegmentSorted((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return bl3;
    }

    private boolean pickSingleLineSegmentSorted(CustomPickTarget customPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionSegment(fArray, fArray2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleLineSegmentSorted((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleLineSegmentSorted((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleLineSegment((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, true);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickSingleLineSegmentSorted((CustomPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl3 = false;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            int n = this.pickInstructions.numChildren;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (this.pickInstructions.hasTransform) {
                this.transformPath[this.lastPathIndex].set(this.pickInstructions.localTransform);
                this.matrixUtils.inverse(this.pickInstructions.localTransform, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block6: for (int i = 0; i < n && !bl3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl3 = this.pickSingleLineSegmentSorted((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                        continue block6;
                    }
                    case 2: {
                        bl3 = this.pickSingleLineSegmentSorted((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                        continue block6;
                    }
                    case 3: {
                        bl3 = this.pickSingleLineSegment((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, true);
                        continue block6;
                    }
                    case 4: {
                        bl3 = this.pickSingleLineSegmentSorted((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return bl3;
    }

    private void pickAllLineSegmentSorted(PickTarget pickTarget, PickRequest pickRequest) {
    }

    private void pickRay(PickTarget pickTarget, PickRequest pickRequest) {
        switch (pickRequest.pickSortType) {
            case 1: 
            case 3: {
                this.pickAllRay(pickTarget, pickRequest);
                break;
            }
            case 2: 
            case 4: {
                this.pickSingleRay(pickTarget, pickRequest);
                break;
            }
            default: {
                this.errorReporter.warningReport(NO_SORT_TYPE_MSG, null);
            }
        }
    }

    private void pickSingleRay(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        if (boundingVolume == null || !boundingVolume.checkIntersectionRay(pickRequest.origin, pickRequest.destination)) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.start[3] = 1.0f;
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        this.end[3] = 1.0f;
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n = object.numPickableChildren();
                if (n == 0) break;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[this.lastPathIndex];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                    transformPickTarget.getInverseTransform(this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                    this.transformNormal(this.invertedMatrix, this.end);
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n && !bl; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            bl = this.pickSingleRay((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue block11;
                        }
                        case 2: {
                            bl = this.pickSingleRay((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue block11;
                        }
                        case 3: {
                            bl = this.pickSingleRay((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
                            continue block11;
                        }
                        case 4: {
                            bl = this.pickSingleRay((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                        }
                    }
                }
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleRay((SinglePickTarget)pickTarget2, pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleRay((LeafPickTarget)pickTarget2, pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
            }
        }
        pickRequest.pickCount = bl ? 1 : 0;
    }

    private boolean pickSingleRay(SinglePickTarget singlePickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget == null) {
            return false;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        boolean bl3 = false;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                bl3 = this.pickSingleRay((GroupPickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                break;
            }
            case 2: {
                bl3 = this.pickSingleRay((SinglePickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                break;
            }
            case 3: {
                bl3 = this.pickSingleRay((LeafPickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, true);
                break;
            }
            case 4: {
                bl3 = this.pickSingleRay((CustomPickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return bl3;
    }

    private boolean pickSingleRay(GroupPickTarget groupPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionRay(fArray, fArray2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleRay((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleRay((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleRay((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, false);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickSingleRay((CustomPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl3 = false;
        int n = groupPickTarget.numPickableChildren();
        if (n != 0) {
            PickTarget[] pickTargetArray;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                transformPickTarget.getInverseTransform(this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block6: for (int i = 0; i < n && !bl3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl3 = this.pickSingleRay((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                        continue block6;
                    }
                    case 2: {
                        bl3 = this.pickSingleRay((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                        continue block6;
                    }
                    case 3: {
                        bl3 = this.pickSingleRay((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, false);
                    }
                    case 4: {
                        bl3 = this.pickSingleRay((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return bl3;
    }

    private boolean pickSingleRay(LeafPickTarget leafPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2, boolean bl3) {
        if (!leafPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        boolean bl4 = false;
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionRay(fArray, fArray2)) {
            if (bl2) {
                if (leafPickTarget.pickLineRay(fArray, fArray2, bl3, this.vertexPickData, 0)) {
                    this.resizePath();
                    this.pickPath[this.lastPathIndex] = leafPickTarget;
                    this.validTransform[this.lastPathIndex] = false;
                    ++this.lastPathIndex;
                    if (bl) {
                        this.buildVWorldTransform();
                    } else {
                        this.vworldMatrix.setIdentity();
                    }
                    sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
                    bl4 = true;
                    --this.lastPathIndex;
                }
            } else {
                this.resizePath();
                this.pickPath[this.lastPathIndex] = leafPickTarget;
                this.validTransform[this.lastPathIndex] = false;
                ++this.lastPathIndex;
                if (bl) {
                    this.buildVWorldTransform();
                } else {
                    this.vworldMatrix.setIdentity();
                }
                sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
                bl4 = true;
                --this.lastPathIndex;
            }
        }
        return bl4;
    }

    private boolean pickSingleRay(CustomPickTarget customPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionRay(fArray, fArray2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleRay((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleRay((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleRay((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, false);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickSingleRay((CustomPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl3 = false;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            int n = this.pickInstructions.numChildren;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (this.pickInstructions.hasTransform) {
                this.transformPath[this.lastPathIndex].set(this.pickInstructions.localTransform);
                this.matrixUtils.inverse(this.pickInstructions.localTransform, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block6: for (int i = 0; i < n && !bl3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl3 = this.pickSingleRay((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                        continue block6;
                    }
                    case 2: {
                        bl3 = this.pickSingleRay((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                        continue block6;
                    }
                    case 3: {
                        bl3 = this.pickSingleRay((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, false);
                    }
                    case 4: {
                        bl3 = this.pickSingleRay((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return bl3;
    }

    private void pickAllRay(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        int n = 0;
        ArrayList<SceneGraphPath> arrayList = null;
        if (pickRequest.foundPaths instanceof ArrayList) {
            arrayList = (ArrayList<SceneGraphPath>)pickRequest.foundPaths;
        } else {
            pickRequest.foundPaths = arrayList = new ArrayList<SceneGraphPath>();
        }
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        if (boundingVolume == null || !boundingVolume.checkIntersectionRay(pickRequest.origin, pickRequest.destination)) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.start[3] = 1.0f;
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        this.end[3] = 1.0f;
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n2 = object.numPickableChildren();
                if (n2 == 0) break;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[0];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                    transformPickTarget.getInverseTransform(this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                    this.transformNormal(this.invertedMatrix, this.end);
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n2; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            n += this.pickAllRay((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue block11;
                        }
                        case 2: {
                            n += this.pickAllRay((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue block11;
                        }
                        case 3: {
                            n += this.pickAllRay((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
                            continue block11;
                        }
                        case 4: {
                            n += this.pickAllRay((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                        }
                    }
                }
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                n += this.pickAllRay((SinglePickTarget)pickTarget2, pickRequest, this.start, this.end, arrayList, 0, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                n += this.pickAllRay((LeafPickTarget)pickTarget2, pickRequest, this.start, this.end, arrayList, 0, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
            }
        }
        pickRequest.pickCount = n;
    }

    private int pickAllRay(GroupPickTarget groupPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, ArrayList<SceneGraphPath> arrayList, int n, boolean bl, boolean bl2) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionRay(fArray, fArray2)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickAllRay((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickAllRay((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickAllRay((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl, bl2, false);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickAllRay((CustomPickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        int n2 = 0;
        int n3 = groupPickTarget.numPickableChildren();
        if (n3 != 0) {
            PickTarget[] pickTargetArray;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            this.resizePath();
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                transformPickTarget.getInverseTransform(this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block6: for (int i = 0; i < n3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        n2 += this.pickAllRay((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl, bl2);
                        continue block6;
                    }
                    case 2: {
                        n2 += this.pickAllRay((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl, bl2);
                        continue block6;
                    }
                    case 3: {
                        n2 += this.pickAllRay((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl, bl2, false);
                        continue block6;
                    }
                    case 4: {
                        n2 += this.pickAllRay((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl, bl2);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return n2;
    }

    private int pickAllRay(SinglePickTarget singlePickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, ArrayList<SceneGraphPath> arrayList, int n, boolean bl, boolean bl2) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget == null) {
            return 0;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        int n2 = 0;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                n2 = this.pickAllRay((GroupPickTarget)pickTarget, pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
                break;
            }
            case 2: {
                n2 = this.pickAllRay((SinglePickTarget)pickTarget, pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
                break;
            }
            case 3: {
                n2 = this.pickAllRay((LeafPickTarget)pickTarget, pickRequest, fArray, fArray2, arrayList, n, bl, bl2, false);
                break;
            }
            case 4: {
                n2 = this.pickAllRay((CustomPickTarget)pickTarget, pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return n2;
    }

    private int pickAllRay(CustomPickTarget customPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, ArrayList<SceneGraphPath> arrayList, int n, boolean bl, boolean bl2) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionRay(fArray, fArray2)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickAllRay((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickAllRay((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickAllRay((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl, bl2, false);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickAllRay((CustomPickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl, bl2);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        int n2 = 0;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            int n3 = this.pickInstructions.numChildren;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            this.resizePath();
            if (this.pickInstructions.hasTransform) {
                this.transformPath[this.lastPathIndex].set(this.pickInstructions.localTransform);
                this.matrixUtils.inverse(this.pickInstructions.localTransform, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block5: for (int i = 0; i < n3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        n2 += this.pickAllRay((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl, bl2);
                        continue block5;
                    }
                    case 2: {
                        n2 += this.pickAllRay((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl, bl2);
                        continue block5;
                    }
                    case 3: {
                        n2 += this.pickAllRay((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl, bl2, false);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return n2;
    }

    private int pickAllRay(LeafPickTarget leafPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, ArrayList<SceneGraphPath> arrayList, int n, boolean bl, boolean bl2, boolean bl3) {
        if (!leafPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        int n2 = 0;
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionRay(fArray, fArray2)) {
            if (bl2) {
                if (leafPickTarget.pickLineRay(fArray, fArray2, bl3, this.vertexPickData, 0)) {
                    SceneGraphPath sceneGraphPath;
                    this.resizePath();
                    this.pickPath[this.lastPathIndex] = leafPickTarget;
                    this.validTransform[this.lastPathIndex] = false;
                    ++this.lastPathIndex;
                    if (n >= arrayList.size()) {
                        sceneGraphPath = new SceneGraphPath();
                        arrayList.add(sceneGraphPath);
                    } else {
                        sceneGraphPath = arrayList.get(n);
                    }
                    if (bl) {
                        this.buildVWorldTransform();
                    } else {
                        this.vworldMatrix.setIdentity();
                    }
                    sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
                    n2 = 1;
                    --this.lastPathIndex;
                }
            } else {
                SceneGraphPath sceneGraphPath;
                this.resizePath();
                this.pickPath[this.lastPathIndex] = leafPickTarget;
                this.validTransform[this.lastPathIndex] = false;
                ++this.lastPathIndex;
                if (n >= arrayList.size()) {
                    sceneGraphPath = new SceneGraphPath();
                    arrayList.add(sceneGraphPath);
                } else {
                    sceneGraphPath = arrayList.get(n);
                }
                if (bl) {
                    this.buildVWorldTransform();
                } else {
                    this.vworldMatrix.setIdentity();
                }
                sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
                n2 = 1;
                --this.lastPathIndex;
            }
        }
        return n2;
    }

    private void pickSingleRaySorted(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        if (boundingVolume == null || !boundingVolume.checkIntersectionRay(pickRequest.origin, pickRequest.destination)) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.start[3] = 1.0f;
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        this.end[3] = 1.0f;
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n = object.numPickableChildren();
                if (n == 0) break;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[0];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                    transformPickTarget.getInverseTransform(this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                    this.transform(this.invertedMatrix, this.end);
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n && !bl; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            bl = this.pickSingleRaySorted((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue block11;
                        }
                        case 2: {
                            bl = this.pickSingleRaySorted((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                            continue block11;
                        }
                        case 3: {
                            bl = this.pickSingleRay((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, true);
                            continue block11;
                        }
                        case 4: {
                            bl = this.pickSingleRaySorted((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                        }
                    }
                }
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleRaySorted((SinglePickTarget)pickTarget2, pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleRay((LeafPickTarget)pickTarget2, pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix, pickRequest.useGeometry, false);
            }
        }
        pickRequest.pickCount = bl ? 1 : 0;
    }

    private boolean pickSingleRaySorted(GroupPickTarget groupPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionRay(fArray, fArray2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleRaySorted((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleRaySorted((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleRay((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, true);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickSingleRaySorted((CustomPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl3 = false;
        int n = groupPickTarget.numPickableChildren();
        if (n != 0) {
            PickTarget[] pickTargetArray;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                transformPickTarget.getInverseTransform(this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block6: for (int i = 0; i < n && !bl3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl3 = this.pickSingleRaySorted((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                        continue block6;
                    }
                    case 2: {
                        bl3 = this.pickSingleRaySorted((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                        continue block6;
                    }
                    case 3: {
                        bl3 = this.pickSingleRay((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, true);
                        continue block6;
                    }
                    case 4: {
                        bl3 = this.pickSingleRaySorted((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return bl3;
    }

    private boolean pickSingleRaySorted(SinglePickTarget singlePickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget == null) {
            return false;
        }
        boolean bl3 = false;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                bl3 = this.pickSingleRaySorted((GroupPickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                break;
            }
            case 2: {
                bl3 = this.pickSingleRaySorted((SinglePickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                break;
            }
            case 3: {
                bl3 = this.pickSingleRay((LeafPickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, true);
                break;
            }
            case 4: {
                bl3 = this.pickSingleRaySorted((CustomPickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return bl3;
    }

    private boolean pickSingleRaySorted(CustomPickTarget customPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl, boolean bl2) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionRay(fArray, fArray2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleRaySorted((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleRaySorted((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleRay((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, true);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickSingleRaySorted((CustomPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl3 = false;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            int n = this.pickInstructions.numChildren;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (this.pickInstructions.hasTransform) {
                this.transformPath[this.lastPathIndex].set(this.pickInstructions.localTransform);
                this.matrixUtils.inverse(this.pickInstructions.localTransform, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block6: for (int i = 0; i < n && !bl3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl3 = this.pickSingleRaySorted((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                        continue block6;
                    }
                    case 2: {
                        bl3 = this.pickSingleRaySorted((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                        continue block6;
                    }
                    case 3: {
                        bl3 = this.pickSingleRay((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2, true);
                        continue block6;
                    }
                    case 4: {
                        bl3 = this.pickSingleRaySorted((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl, bl2);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return bl3;
    }

    private void pickCylinder(PickTarget pickTarget, PickRequest pickRequest) {
        switch (pickRequest.pickSortType) {
            case 1: 
            case 3: {
                this.pickAllCylinder(pickTarget, pickRequest);
                break;
            }
            case 2: 
            case 4: {
                this.pickSingleCylinder(pickTarget, pickRequest);
                break;
            }
            default: {
                this.errorReporter.warningReport(NO_SORT_TYPE_MSG, null);
            }
        }
    }

    private void pickSingleCylinder(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        float f = pickRequest.origin[0] - pickRequest.destination[0];
        float f2 = pickRequest.origin[1] - pickRequest.destination[1];
        float f3 = pickRequest.origin[2] - pickRequest.destination[2];
        float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        if (f4 == 0.0f) {
            pickRequest.pickCount = 0;
            return;
        }
        this.start[0] = (pickRequest.origin[0] + pickRequest.destination[0]) * 0.5f;
        this.start[1] = (pickRequest.origin[1] + pickRequest.destination[0]) * 0.5f;
        this.start[2] = (pickRequest.origin[2] + pickRequest.destination[0]) * 0.5f;
        this.start[3] = 1.0f;
        this.end[0] = f;
        this.end[1] = f2;
        this.end[2] = f3;
        this.end[3] = 1.0f;
        float f5 = pickRequest.additionalData;
        if (boundingVolume == null || !boundingVolume.checkIntersectionCylinder(this.start, this.end, f5, f4)) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n = object.numPickableChildren();
                if (n == 0) break;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[0];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                    transformPickTarget.getInverseTransform(this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                    this.transformNormal(this.invertedMatrix, this.end);
                    float f6 = this.invertedMatrix.getScale();
                    f5 *= f6;
                    f4 *= f6;
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n && !bl; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            bl = this.pickSingleCylinder((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, f5, f4, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 2: {
                            bl = this.pickSingleCylinder((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, this.end, f5, f4, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 3: {
                            bl = this.pickSingleCylinder((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, f5, f4, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 4: {
                            bl = this.pickSingleCylinder((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, f5, f4, sceneGraphPath, pickRequest.generateVWorldMatrix);
                        }
                    }
                }
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleCylinder((SinglePickTarget)pickTarget2, pickRequest, this.start, this.end, f5, f4, sceneGraphPath, pickRequest.generateVWorldMatrix);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleCylinder((LeafPickTarget)pickTarget2, pickRequest, this.start, this.end, f5, f4, sceneGraphPath, pickRequest.generateVWorldMatrix);
            }
        }
        pickRequest.pickCount = bl ? 1 : 0;
    }

    private boolean pickSingleCylinder(GroupPickTarget groupPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, float f, float f2, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionCylinder(fArray, fArray2, f, f2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleCylinder((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleCylinder((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleCylinder((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickSingleCylinder((CustomPickTarget)((Object)node), pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl2 = false;
        int n = groupPickTarget.numPickableChildren();
        if (n != 0) {
            PickTarget[] pickTargetArray;
            float f3 = fArray[0];
            float f4 = fArray[1];
            float f5 = fArray[2];
            float f6 = fArray2[0];
            float f7 = fArray2[1];
            float f8 = fArray2[2];
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                transformPickTarget.getInverseTransform(this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                float f9 = this.invertedMatrix.getScale();
                f *= f9;
                f2 *= f9;
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block5: for (int i = 0; i < n && !bl2; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl2 = this.pickSingleCylinder((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
                        continue block5;
                    }
                    case 2: {
                        bl2 = this.pickSingleCylinder((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
                        continue block5;
                    }
                    case 3: {
                        bl2 = this.pickSingleCylinder((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f3;
            fArray[1] = f4;
            fArray[2] = f5;
            fArray2[0] = f6;
            fArray2[1] = f7;
            fArray2[2] = f8;
        }
        return bl2;
    }

    private boolean pickSingleCylinder(SinglePickTarget singlePickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, float f, float f2, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget == null) {
            return false;
        }
        boolean bl2 = false;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                bl2 = this.pickSingleCylinder((GroupPickTarget)pickTarget, pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
                break;
            }
            case 2: {
                bl2 = this.pickSingleCylinder((SinglePickTarget)pickTarget, pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
                break;
            }
            case 3: {
                bl2 = this.pickSingleCylinder((LeafPickTarget)pickTarget, pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
                break;
            }
            case 4: {
                bl2 = this.pickSingleCylinder((CustomPickTarget)pickTarget, pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return bl2;
    }

    private boolean pickSingleCylinder(CustomPickTarget customPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, float f, float f2, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionCylinder(fArray, fArray2, f, f2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleCylinder((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleCylinder((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleCylinder((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickSingleCylinder((CustomPickTarget)((Object)node), pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl2 = false;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            int n = this.pickInstructions.numChildren;
            float f3 = fArray[0];
            float f4 = fArray[1];
            float f5 = fArray[2];
            float f6 = fArray2[0];
            float f7 = fArray2[1];
            float f8 = fArray2[2];
            if (this.pickInstructions.hasTransform) {
                this.transformPath[this.lastPathIndex].set(this.pickInstructions.localTransform);
                this.matrixUtils.inverse(this.pickInstructions.localTransform, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                float f9 = this.invertedMatrix.getScale();
                f *= f9;
                f2 *= f9;
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block5: for (int i = 0; i < n && !bl2; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl2 = this.pickSingleCylinder((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
                        continue block5;
                    }
                    case 2: {
                        bl2 = this.pickSingleCylinder((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
                        continue block5;
                    }
                    case 3: {
                        bl2 = this.pickSingleCylinder((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, f2, sceneGraphPath, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f3;
            fArray[1] = f4;
            fArray[2] = f5;
            fArray2[0] = f6;
            fArray2[1] = f7;
            fArray2[2] = f8;
        }
        return bl2;
    }

    private boolean pickSingleCylinder(LeafPickTarget leafPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, float f, float f2, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!leafPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        boolean bl2 = false;
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionCylinder(fArray, fArray2, f, f2)) {
            this.resizePath();
            this.pickPath[this.lastPathIndex] = leafPickTarget;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            bl2 = true;
            --this.lastPathIndex;
        }
        return bl2;
    }

    private void pickAllCylinder(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        int n = 0;
        ArrayList<SceneGraphPath> arrayList = null;
        if (pickRequest.foundPaths instanceof ArrayList) {
            arrayList = (ArrayList<SceneGraphPath>)pickRequest.foundPaths;
        } else {
            pickRequest.foundPaths = arrayList = new ArrayList<SceneGraphPath>();
        }
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        float f = pickRequest.origin[0] - pickRequest.destination[0];
        float f2 = pickRequest.origin[1] - pickRequest.destination[1];
        float f3 = pickRequest.origin[2] - pickRequest.destination[2];
        float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        if (f4 == 0.0f) {
            pickRequest.pickCount = 0;
            return;
        }
        this.start[0] = (pickRequest.origin[0] + pickRequest.destination[0]) * 0.5f;
        this.start[1] = (pickRequest.origin[1] + pickRequest.destination[0]) * 0.5f;
        this.start[2] = (pickRequest.origin[2] + pickRequest.destination[0]) * 0.5f;
        this.start[3] = 1.0f;
        this.end[0] = f;
        this.end[1] = f2;
        this.end[2] = f3;
        this.end[3] = 1.0f;
        float f5 = pickRequest.additionalData;
        if (boundingVolume == null || !boundingVolume.checkIntersectionCylinder(this.start, this.end, f5, f4)) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n2 = object.numPickableChildren();
                if (n2 == 0) break;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[0];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                    transformPickTarget.getInverseTransform(this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                    this.transformNormal(this.invertedMatrix, this.end);
                    float f6 = this.invertedMatrix.getScale();
                    f5 *= f6;
                    f4 *= f6;
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n2; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            n += this.pickAllCylinder((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, f5, f4, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 2: {
                            n += this.pickAllCylinder((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, this.end, f5, f4, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 3: {
                            n += this.pickAllCylinder((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, f5, f4, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 4: {
                            n += this.pickAllCylinder((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, f5, f4, arrayList, n, pickRequest.generateVWorldMatrix);
                        }
                    }
                }
                pickRequest.pickCount = n;
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllCylinder((SinglePickTarget)pickTarget2, pickRequest, this.start, this.end, f5, f4, arrayList, 0, pickRequest.generateVWorldMatrix);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllCylinder((LeafPickTarget)pickTarget2, pickRequest, this.start, this.end, f5, f4, arrayList, 0, pickRequest.generateVWorldMatrix);
            }
        }
    }

    private int pickAllCylinder(GroupPickTarget groupPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, float f, float f2, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionCylinder(fArray, fArray2, f, f2)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickAllCylinder((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, f, f2, arrayList, n, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickAllCylinder((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, f, f2, arrayList, n, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickAllCylinder((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, f, f2, arrayList, n, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        int n2 = 0;
        int n3 = groupPickTarget.numPickableChildren();
        if (n3 != 0) {
            PickTarget[] pickTargetArray;
            float f3 = fArray[0];
            float f4 = fArray[1];
            float f5 = fArray[2];
            float f6 = fArray2[0];
            float f7 = fArray2[1];
            float f8 = fArray2[2];
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                transformPickTarget.getInverseTransform(this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                float f9 = this.invertedMatrix.getScale();
                f *= f9;
                f2 *= f9;
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block5: for (int i = 0; i < n3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        n2 += this.pickAllCylinder((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, f2, arrayList, n + n2, bl);
                        continue block5;
                    }
                    case 2: {
                        n2 += this.pickAllCylinder((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, f2, arrayList, n + n2, bl);
                        continue block5;
                    }
                    case 3: {
                        n2 += this.pickAllCylinder((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, f2, arrayList, n + n2, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f3;
            fArray[1] = f4;
            fArray[2] = f5;
            fArray2[0] = f6;
            fArray2[1] = f7;
            fArray2[2] = f8;
        }
        return n2;
    }

    private int pickAllCylinder(SinglePickTarget singlePickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, float f, float f2, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget == null) {
            return 0;
        }
        int n2 = 0;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                n2 = this.pickAllCylinder((GroupPickTarget)pickTarget, pickRequest, fArray, fArray2, f, f2, arrayList, n, bl);
                break;
            }
            case 2: {
                n2 = this.pickAllCylinder((SinglePickTarget)pickTarget, pickRequest, fArray, fArray2, f, f2, arrayList, n, bl);
                break;
            }
            case 3: {
                n2 = this.pickAllCylinder((LeafPickTarget)pickTarget, pickRequest, fArray, fArray2, f, f2, arrayList, n, bl);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return n2;
    }

    private int pickAllCylinder(CustomPickTarget customPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, float f, float f2, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionCylinder(fArray, fArray2, f, f2)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickAllCylinder((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, f, f2, arrayList, n, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickAllCylinder((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, f, f2, arrayList, n, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickAllCylinder((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, f, f2, arrayList, n, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        int n2 = 0;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            int n3 = this.pickInstructions.numChildren;
            float f3 = fArray[0];
            float f4 = fArray[1];
            float f5 = fArray[2];
            float f6 = fArray2[0];
            float f7 = fArray2[1];
            float f8 = fArray2[2];
            if (this.pickInstructions.hasTransform) {
                this.transformPath[this.lastPathIndex].set(this.pickInstructions.localTransform);
                this.matrixUtils.inverse(this.pickInstructions.localTransform, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                float f9 = this.invertedMatrix.getScale();
                f *= f9;
                f2 *= f9;
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block5: for (int i = 0; i < n3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        n2 += this.pickAllCylinder((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, f2, arrayList, n + n2, bl);
                        continue block5;
                    }
                    case 2: {
                        n2 += this.pickAllCylinder((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, f2, arrayList, n + n2, bl);
                        continue block5;
                    }
                    case 3: {
                        n2 += this.pickAllCylinder((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, f2, arrayList, n + n2, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f3;
            fArray[1] = f4;
            fArray[2] = f5;
            fArray2[0] = f6;
            fArray2[1] = f7;
            fArray2[2] = f8;
        }
        return n2;
    }

    private int pickAllCylinder(LeafPickTarget leafPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, float f, float f2, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!leafPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        int n2 = 0;
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionCylinder(fArray, fArray2, f, f2)) {
            SceneGraphPath sceneGraphPath;
            this.resizePath();
            this.pickPath[this.lastPathIndex] = leafPickTarget;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (n >= arrayList.size()) {
                sceneGraphPath = new SceneGraphPath();
                arrayList.add(sceneGraphPath);
            } else {
                sceneGraphPath = arrayList.get(n);
            }
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            n2 = 1;
            --this.lastPathIndex;
        }
        return n2;
    }

    private void pickCone(PickTarget pickTarget, PickRequest pickRequest) {
        switch (pickRequest.pickSortType) {
            case 1: 
            case 3: {
                this.pickAllCone(pickTarget, pickRequest);
                break;
            }
            case 2: 
            case 4: {
                this.pickSingleCone(pickTarget, pickRequest);
                break;
            }
            default: {
                this.errorReporter.warningReport(NO_SORT_TYPE_MSG, null);
            }
        }
    }

    private void pickSingleCone(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        float f = pickRequest.additionalData;
        if (boundingVolume == null || !boundingVolume.checkIntersectionCone(pickRequest.origin, pickRequest.destination, pickRequest.additionalData)) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.start[3] = 1.0f;
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        this.end[3] = 1.0f;
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n = object.numPickableChildren();
                if (n == 0) break;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[0];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                    transformPickTarget.getInverseTransform(this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                    this.transformNormal(this.invertedMatrix, this.end);
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n && !bl; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            bl = this.pickSingleCone((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 2: {
                            bl = this.pickSingleCone((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, this.end, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 3: {
                            bl = this.pickSingleCone((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 4: {
                            bl = this.pickSingleCone((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
                        }
                    }
                }
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleCone((SinglePickTarget)pickTarget2, pickRequest, this.start, this.end, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleCone((LeafPickTarget)pickTarget2, pickRequest, this.start, this.end, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
            }
        }
        pickRequest.pickCount = bl ? 1 : 0;
    }

    private boolean pickSingleCone(GroupPickTarget groupPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, float f, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionCone(fArray, fArray2, f)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleCone((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, f, sceneGraphPath, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleCone((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, f, sceneGraphPath, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleCone((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, f, sceneGraphPath, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl2 = false;
        int n = groupPickTarget.numPickableChildren();
        if (n != 0) {
            PickTarget[] pickTargetArray;
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = fArray2[0];
            float f6 = fArray2[1];
            float f7 = fArray2[2];
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                transformPickTarget.getInverseTransform(this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block5: for (int i = 0; i < n && !bl2; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl2 = this.pickSingleCone((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, sceneGraphPath, bl);
                        continue block5;
                    }
                    case 2: {
                        bl2 = this.pickSingleCone((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, sceneGraphPath, bl);
                        continue block5;
                    }
                    case 3: {
                        bl2 = this.pickSingleCone((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, sceneGraphPath, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f2;
            fArray[1] = f3;
            fArray[2] = f4;
            fArray2[0] = f5;
            fArray2[1] = f6;
            fArray2[2] = f7;
        }
        return bl2;
    }

    private boolean pickSingleCone(SinglePickTarget singlePickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, float f, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget == null) {
            return false;
        }
        boolean bl2 = false;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                bl2 = this.pickSingleCone((GroupPickTarget)pickTarget, pickRequest, fArray, fArray2, f, sceneGraphPath, bl);
                break;
            }
            case 2: {
                bl2 = this.pickSingleCone((SinglePickTarget)pickTarget, pickRequest, fArray, fArray2, f, sceneGraphPath, bl);
                break;
            }
            case 3: {
                bl2 = this.pickSingleCone((LeafPickTarget)pickTarget, pickRequest, fArray, fArray2, f, sceneGraphPath, bl);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return bl2;
    }

    private boolean pickSingleCone(CustomPickTarget customPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, float f, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionCone(fArray, fArray2, f)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleCone((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, f, sceneGraphPath, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleCone((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, f, sceneGraphPath, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleCone((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, f, sceneGraphPath, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl2 = false;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            int n = this.pickInstructions.numChildren;
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = fArray2[0];
            float f6 = fArray2[1];
            float f7 = fArray2[2];
            if (this.pickInstructions.hasTransform) {
                this.transformPath[this.lastPathIndex].set(this.pickInstructions.localTransform);
                this.matrixUtils.inverse(this.pickInstructions.localTransform, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block5: for (int i = 0; i < n && !bl2; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl2 = this.pickSingleCone((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, sceneGraphPath, bl);
                        continue block5;
                    }
                    case 2: {
                        bl2 = this.pickSingleCone((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, sceneGraphPath, bl);
                        continue block5;
                    }
                    case 3: {
                        bl2 = this.pickSingleCone((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, sceneGraphPath, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f2;
            fArray[1] = f3;
            fArray[2] = f4;
            fArray2[0] = f5;
            fArray2[1] = f6;
            fArray2[2] = f7;
        }
        return bl2;
    }

    private boolean pickSingleCone(LeafPickTarget leafPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, float f, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!leafPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        boolean bl2 = false;
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionCone(fArray, fArray2, f)) {
            this.resizePath();
            this.pickPath[this.lastPathIndex] = leafPickTarget;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            bl2 = true;
            --this.lastPathIndex;
        }
        return bl2;
    }

    private void pickAllCone(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        int n = 0;
        ArrayList<SceneGraphPath> arrayList = null;
        if (pickRequest.foundPaths instanceof ArrayList) {
            arrayList = (ArrayList<SceneGraphPath>)pickRequest.foundPaths;
        } else {
            pickRequest.foundPaths = arrayList = new ArrayList<SceneGraphPath>();
        }
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        float f = pickRequest.additionalData;
        if (boundingVolume == null || !boundingVolume.checkIntersectionCone(pickRequest.origin, pickRequest.destination, pickRequest.additionalData)) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.start[3] = 1.0f;
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        this.end[3] = 1.0f;
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n2 = object.numPickableChildren();
                if (n2 == 0) break;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[0];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                    transformPickTarget.getInverseTransform(this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                    this.transformNormal(this.invertedMatrix, this.end);
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n2; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            n += this.pickAllCone((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, f, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 2: {
                            n += this.pickAllCone((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, this.end, f, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 3: {
                            n += this.pickAllCone((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, f, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 4: {
                            n += this.pickAllCone((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, f, arrayList, n, pickRequest.generateVWorldMatrix);
                        }
                    }
                }
                pickRequest.pickCount = n;
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllCone((SinglePickTarget)pickTarget2, pickRequest, this.start, this.end, f, arrayList, 0, pickRequest.generateVWorldMatrix);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllCone((LeafPickTarget)pickTarget2, pickRequest, this.start, this.end, f, arrayList, 0, pickRequest.generateVWorldMatrix);
            }
        }
    }

    private int pickAllCone(GroupPickTarget groupPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, float f, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionCone(fArray, fArray2, f)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickAllCone((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, f, arrayList, n, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickAllCone((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, f, arrayList, n, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickAllCone((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, f, arrayList, n, bl);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickAllCone((CustomPickTarget)((Object)node), pickRequest, fArray, fArray2, f, arrayList, n, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        int n2 = 0;
        int n3 = groupPickTarget.numPickableChildren();
        if (n3 != 0) {
            PickTarget[] pickTargetArray;
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = fArray2[0];
            float f6 = fArray2[1];
            float f7 = fArray2[2];
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                transformPickTarget.getInverseTransform(this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block6: for (int i = 0; i < n3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        n2 += this.pickAllCone((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 2: {
                        n2 += this.pickAllCone((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 3: {
                        n2 += this.pickAllCone((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 4: {
                        n2 += this.pickAllCone((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, arrayList, n + n2, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f2;
            fArray[1] = f3;
            fArray[2] = f4;
            fArray2[0] = f5;
            fArray2[1] = f6;
            fArray2[2] = f7;
        }
        return n2;
    }

    private int pickAllCone(SinglePickTarget singlePickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, float f, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget != null) {
            return 0;
        }
        int n2 = 0;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                n2 = this.pickAllCone((GroupPickTarget)pickTarget, pickRequest, fArray, fArray2, f, arrayList, n, bl);
                break;
            }
            case 2: {
                n2 = this.pickAllCone((SinglePickTarget)pickTarget, pickRequest, fArray, fArray2, f, arrayList, n, bl);
                break;
            }
            case 3: {
                n2 = this.pickAllCone((LeafPickTarget)pickTarget, pickRequest, fArray, fArray2, f, arrayList, n, bl);
                break;
            }
            case 4: {
                n2 = this.pickAllCone((CustomPickTarget)pickTarget, pickRequest, fArray, fArray2, f, arrayList, n, bl);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return n2;
    }

    private int pickAllCone(CustomPickTarget customPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, float f, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionCone(fArray, fArray2, f)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickAllCone((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, f, arrayList, n, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickAllCone((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, f, arrayList, n, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickAllCone((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, f, arrayList, n, bl);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickAllCone((CustomPickTarget)((Object)node), pickRequest, fArray, fArray2, f, arrayList, n, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        int n2 = 0;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            int n3 = this.pickInstructions.numChildren;
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = fArray2[0];
            float f6 = fArray2[1];
            float f7 = fArray2[2];
            if (this.pickInstructions.hasTransform) {
                this.transformPath[this.lastPathIndex].set(this.pickInstructions.localTransform);
                this.matrixUtils.inverse(this.pickInstructions.localTransform, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transformNormal(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block6: for (int i = 0; i < n3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        n2 += this.pickAllCone((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 2: {
                        n2 += this.pickAllCone((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 3: {
                        n2 += this.pickAllCone((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 4: {
                        n2 += this.pickAllCone((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, f, arrayList, n + n2, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f2;
            fArray[1] = f3;
            fArray[2] = f4;
            fArray2[0] = f5;
            fArray2[1] = f6;
            fArray2[2] = f7;
        }
        return n2;
    }

    private int pickAllCone(LeafPickTarget leafPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, float f, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!leafPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        int n2 = 0;
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionCone(fArray, fArray2, f)) {
            SceneGraphPath sceneGraphPath;
            this.resizePath();
            this.pickPath[this.lastPathIndex] = leafPickTarget;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (n >= arrayList.size()) {
                sceneGraphPath = new SceneGraphPath();
                arrayList.add(sceneGraphPath);
            } else {
                sceneGraphPath = arrayList.get(n);
            }
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            n2 = 1;
            --this.lastPathIndex;
        }
        return n2;
    }

    private void pickBox(PickTarget pickTarget, PickRequest pickRequest) {
        switch (pickRequest.pickSortType) {
            case 1: 
            case 3: {
                this.pickAllBox(pickTarget, pickRequest);
                break;
            }
            case 2: 
            case 4: {
                this.pickSingleBox(pickTarget, pickRequest);
                break;
            }
            default: {
                this.errorReporter.warningReport(NO_SORT_TYPE_MSG, null);
            }
        }
    }

    private void pickSingleBox(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        if (boundingVolume == null || !boundingVolume.checkIntersectionBox(pickRequest.origin, pickRequest.destination)) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.start[3] = 1.0f;
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        this.end[3] = 1.0f;
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n = object.numPickableChildren();
                if (n == 0) break;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[0];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                    transformPickTarget.getInverseTransform(this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                    this.transform(this.invertedMatrix, this.end);
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n && !bl; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            bl = this.pickSingleBox((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 2: {
                            bl = this.pickSingleBox((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 3: {
                            bl = this.pickSingleBox((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 4: {
                            bl = this.pickSingleBox((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix);
                        }
                    }
                }
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleBox((SinglePickTarget)pickTarget2, pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleBox((LeafPickTarget)pickTarget2, pickRequest, this.start, this.end, sceneGraphPath, pickRequest.generateVWorldMatrix);
            }
        }
        pickRequest.pickCount = bl ? 1 : 0;
    }

    private boolean pickSingleBox(GroupPickTarget groupPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionBox(fArray, fArray2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleBox((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleBox((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleBox((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl2 = false;
        int n = groupPickTarget.numPickableChildren();
        if (n != 0) {
            PickTarget[] pickTargetArray;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                transformPickTarget.getInverseTransform(this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block5: for (int i = 0; i < n && !bl2; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl2 = this.pickSingleBox((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl);
                        continue block5;
                    }
                    case 2: {
                        bl2 = this.pickSingleBox((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl);
                        continue block5;
                    }
                    case 3: {
                        bl2 = this.pickSingleBox((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return bl2;
    }

    private boolean pickSingleBox(SinglePickTarget singlePickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        boolean bl2 = false;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                bl2 = this.pickSingleBox((GroupPickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl);
                break;
            }
            case 2: {
                bl2 = this.pickSingleBox((SinglePickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl);
                break;
            }
            case 3: {
                bl2 = this.pickSingleBox((LeafPickTarget)pickTarget, pickRequest, fArray, fArray2, sceneGraphPath, bl);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return bl2;
    }

    private boolean pickSingleBox(CustomPickTarget customPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionBox(fArray, fArray2)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleBox((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleBox((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleBox((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, sceneGraphPath, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl2 = false;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            int n = this.pickInstructions.numChildren;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (this.pickInstructions.hasTransform) {
                this.transformPath[this.lastPathIndex].set(this.pickInstructions.localTransform);
                this.matrixUtils.inverse(this.pickInstructions.localTransform, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block5: for (int i = 0; i < n && !bl2; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl2 = this.pickSingleBox((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl);
                        continue block5;
                    }
                    case 2: {
                        bl2 = this.pickSingleBox((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl);
                        continue block5;
                    }
                    case 3: {
                        bl2 = this.pickSingleBox((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, sceneGraphPath, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return bl2;
    }

    private boolean pickSingleBox(LeafPickTarget leafPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!leafPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        boolean bl2 = false;
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionBox(fArray, fArray2)) {
            this.resizePath();
            this.pickPath[this.lastPathIndex] = leafPickTarget;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            bl2 = true;
            --this.lastPathIndex;
        }
        return bl2;
    }

    private void pickAllBox(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        int n = 0;
        ArrayList<SceneGraphPath> arrayList = null;
        if (pickRequest.foundPaths instanceof ArrayList) {
            arrayList = (ArrayList<SceneGraphPath>)pickRequest.foundPaths;
        } else {
            pickRequest.foundPaths = arrayList = new ArrayList<SceneGraphPath>();
        }
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        if (boundingVolume == null || !boundingVolume.checkIntersectionBox(pickRequest.origin, pickRequest.destination)) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.start[3] = 1.0f;
        this.end[0] = pickRequest.destination[0];
        this.end[1] = pickRequest.destination[1];
        this.end[2] = pickRequest.destination[2];
        this.end[3] = 1.0f;
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n2 = object.numPickableChildren();
                if (n2 == 0) break;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[0];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                    transformPickTarget.getInverseTransform(this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                    this.transform(this.invertedMatrix, this.end);
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n2; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            n += this.pickAllBox((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 2: {
                            n += this.pickAllBox((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 3: {
                            n += this.pickAllBox((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 4: {
                            n += this.pickAllBox((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, this.end, arrayList, n, pickRequest.generateVWorldMatrix);
                        }
                    }
                }
                pickRequest.pickCount = n;
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllBox((SinglePickTarget)pickTarget2, pickRequest, this.start, this.end, arrayList, 0, pickRequest.generateVWorldMatrix);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllBox((LeafPickTarget)pickTarget2, pickRequest, this.start, this.end, arrayList, 0, pickRequest.generateVWorldMatrix);
            }
        }
    }

    private int pickAllBox(GroupPickTarget groupPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionBox(fArray, fArray2)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickAllBox((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickAllBox((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickAllBox((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        int n2 = 0;
        int n3 = groupPickTarget.numPickableChildren();
        if (n3 != 0) {
            PickTarget[] pickTargetArray;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                transformPickTarget.getInverseTransform(this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block5: for (int i = 0; i < n3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        n2 += this.pickAllBox((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl);
                        continue block5;
                    }
                    case 2: {
                        n2 += this.pickAllBox((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl);
                        continue block5;
                    }
                    case 3: {
                        n2 += this.pickAllBox((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return n2;
    }

    private int pickAllBox(SinglePickTarget singlePickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget == null) {
            return 0;
        }
        int n2 = 0;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                n2 = this.pickAllBox((GroupPickTarget)pickTarget, pickRequest, fArray, fArray2, arrayList, n, bl);
                break;
            }
            case 2: {
                n2 = this.pickAllBox((SinglePickTarget)pickTarget, pickRequest, fArray, fArray2, arrayList, n, bl);
                break;
            }
            case 3: {
                n2 = this.pickAllBox((LeafPickTarget)pickTarget, pickRequest, fArray, fArray2, arrayList, n, bl);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return n2;
    }

    private int pickAllBox(CustomPickTarget customPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionBox(fArray, fArray2)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickAllBox((GroupPickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickAllBox((SinglePickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickAllBox((LeafPickTarget)((Object)node), pickRequest, fArray, fArray2, arrayList, n, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        int n2 = 0;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            int n3 = this.pickInstructions.numChildren;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray2[0];
            float f5 = fArray2[1];
            float f6 = fArray2[2];
            if (customPickTarget instanceof TransformPickTarget) {
                this.transformPath[this.lastPathIndex].set(this.pickInstructions.localTransform);
                this.matrixUtils.inverse(this.pickInstructions.localTransform, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                this.transform(this.invertedMatrix, fArray2);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block5: for (int i = 0; i < n3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        n2 += this.pickAllBox((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl);
                        continue block5;
                    }
                    case 2: {
                        n2 += this.pickAllBox((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl);
                        continue block5;
                    }
                    case 3: {
                        n2 += this.pickAllBox((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, fArray2, arrayList, n + n2, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            fArray2[0] = f4;
            fArray2[1] = f5;
            fArray2[2] = f6;
        }
        return n2;
    }

    private int pickAllBox(LeafPickTarget leafPickTarget, PickRequest pickRequest, float[] fArray, float[] fArray2, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!leafPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        int n2 = 0;
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionBox(fArray, fArray2)) {
            SceneGraphPath sceneGraphPath;
            this.resizePath();
            this.pickPath[this.lastPathIndex] = leafPickTarget;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (n >= arrayList.size()) {
                sceneGraphPath = new SceneGraphPath();
                arrayList.add(sceneGraphPath);
            } else {
                sceneGraphPath = arrayList.get(n);
            }
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            n2 = 1;
            --this.lastPathIndex;
        }
        return n2;
    }

    private void pickFrustum(PickTarget pickTarget, PickRequest pickRequest) {
        switch (pickRequest.pickSortType) {
            case 1: 
            case 3: {
                this.pickAllFrustum(pickTarget, pickRequest);
                break;
            }
            case 2: 
            case 4: {
                this.pickSingleFrustum(pickTarget, pickRequest);
                break;
            }
            default: {
                this.errorReporter.warningReport(NO_SORT_TYPE_MSG, null);
            }
        }
    }

    private void pickSingleFrustum(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        this.frustumPlanes[0].x = pickRequest.origin[0];
        this.frustumPlanes[0].y = pickRequest.origin[1];
        this.frustumPlanes[0].z = pickRequest.origin[2];
        this.frustumPlanes[0].w = pickRequest.origin[3];
        this.frustumPlanes[1].x = pickRequest.origin[4];
        this.frustumPlanes[1].y = pickRequest.origin[5];
        this.frustumPlanes[1].z = pickRequest.origin[6];
        this.frustumPlanes[1].w = pickRequest.origin[7];
        this.frustumPlanes[2].x = pickRequest.origin[8];
        this.frustumPlanes[2].y = pickRequest.origin[9];
        this.frustumPlanes[2].z = pickRequest.origin[10];
        this.frustumPlanes[2].w = pickRequest.origin[11];
        this.frustumPlanes[3].x = pickRequest.origin[12];
        this.frustumPlanes[3].y = pickRequest.origin[13];
        this.frustumPlanes[3].z = pickRequest.origin[14];
        this.frustumPlanes[3].w = pickRequest.origin[15];
        this.frustumPlanes[4].x = pickRequest.origin[16];
        this.frustumPlanes[4].y = pickRequest.origin[17];
        this.frustumPlanes[4].z = pickRequest.origin[18];
        this.frustumPlanes[4].w = pickRequest.origin[19];
        this.frustumPlanes[5].x = pickRequest.origin[20];
        this.frustumPlanes[5].y = pickRequest.origin[21];
        this.frustumPlanes[5].z = pickRequest.origin[22];
        this.frustumPlanes[5].w = pickRequest.origin[23];
        boolean bl = false;
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        this.transformPath[0].setIdentity();
        if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes, this.transformPath[0]) == 0) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n = object.numPickableChildren();
                if (n == 0) break;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[this.lastPathIndex];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n && !bl; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            bl = this.pickSingleFrustum((GroupPickTarget)pickTargetArray[i], pickRequest, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 2: {
                            bl = this.pickSingleFrustum((SinglePickTarget)pickTargetArray[i], pickRequest, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 3: {
                            bl = this.pickSingleFrustum((LeafPickTarget)pickTargetArray[i], pickRequest, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 4: {
                            bl = this.pickSingleFrustum((CustomPickTarget)pickTargetArray[i], pickRequest, sceneGraphPath, pickRequest.generateVWorldMatrix);
                        }
                    }
                }
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleFrustum((SinglePickTarget)pickTarget2, pickRequest, sceneGraphPath, pickRequest.generateVWorldMatrix);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleFrustum((LeafPickTarget)pickTarget2, pickRequest, sceneGraphPath, pickRequest.generateVWorldMatrix);
            }
        }
        pickRequest.pickCount = bl ? 1 : 0;
    }

    private boolean pickSingleFrustum(SinglePickTarget singlePickTarget, PickRequest pickRequest, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        Matrix4f matrix4f = this.transformPath[this.lastPathIndex - 1];
        this.transformPath[this.lastPathIndex].set(matrix4f);
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget == null) {
            return false;
        }
        boolean bl2 = false;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                bl2 = this.pickSingleFrustum((GroupPickTarget)pickTarget, pickRequest, sceneGraphPath, bl);
                break;
            }
            case 2: {
                bl2 = this.pickSingleFrustum((SinglePickTarget)pickTarget, pickRequest, sceneGraphPath, bl);
                break;
            }
            case 3: {
                bl2 = this.pickSingleFrustum((LeafPickTarget)pickTarget, pickRequest, sceneGraphPath, bl);
                break;
            }
            case 4: {
                bl2 = this.pickSingleFrustum((CustomPickTarget)pickTarget, pickRequest, sceneGraphPath, bl);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return bl2;
    }

    private boolean pickSingleFrustum(GroupPickTarget groupPickTarget, PickRequest pickRequest, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes, this.transformPath[this.lastPathIndex]) == 0) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleFrustum((GroupPickTarget)((Object)node), pickRequest, sceneGraphPath, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleFrustum((SinglePickTarget)((Object)node), pickRequest, sceneGraphPath, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleFrustum((LeafPickTarget)((Object)node), pickRequest, sceneGraphPath, bl);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickSingleFrustum((CustomPickTarget)((Object)node), pickRequest, sceneGraphPath, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl2 = false;
        int n = groupPickTarget.numPickableChildren();
        if (n != 0) {
            PickTarget[] pickTargetArray;
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                pickTargetArray.mul(this.transformPath[this.lastPathIndex - 1], (Matrix4f)pickTargetArray);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                pickTargetArray = this.transformPath[this.lastPathIndex - 1];
                this.transformPath[this.lastPathIndex].set((Matrix4f)pickTargetArray);
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block6: for (int i = 0; i < n && !bl2; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl2 = this.pickSingleFrustum((GroupPickTarget)pickTargetArray[i], pickRequest, sceneGraphPath, bl);
                        continue block6;
                    }
                    case 2: {
                        bl2 = this.pickSingleFrustum((SinglePickTarget)pickTargetArray[i], pickRequest, sceneGraphPath, bl);
                        continue block6;
                    }
                    case 3: {
                        bl2 = this.pickSingleFrustum((LeafPickTarget)pickTargetArray[i], pickRequest, sceneGraphPath, bl);
                        continue block6;
                    }
                    case 4: {
                        bl2 = this.pickSingleFrustum((CustomPickTarget)pickTargetArray[i], pickRequest, sceneGraphPath, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
        }
        return bl2;
    }

    private boolean pickSingleFrustum(CustomPickTarget customPickTarget, PickRequest pickRequest, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes, this.transformPath[this.lastPathIndex]) == 0) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleFrustum((GroupPickTarget)((Object)node), pickRequest, sceneGraphPath, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleFrustum((SinglePickTarget)((Object)node), pickRequest, sceneGraphPath, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleFrustum((LeafPickTarget)((Object)node), pickRequest, sceneGraphPath, bl);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickSingleFrustum((CustomPickTarget)((Object)node), pickRequest, sceneGraphPath, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl2 = false;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            PickTarget[] pickTargetArray;
            int n = this.pickInstructions.numChildren;
            if (this.pickInstructions.hasTransform) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                pickTargetArray.set(this.pickInstructions.localTransform);
                pickTargetArray.mul(this.transformPath[this.lastPathIndex - 1], (Matrix4f)pickTargetArray);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                pickTargetArray = this.transformPath[this.lastPathIndex - 1];
                this.transformPath[this.lastPathIndex].set((Matrix4f)pickTargetArray);
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block6: for (int i = 0; i < n && !bl2; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl2 = this.pickSingleFrustum((GroupPickTarget)pickTargetArray[i], pickRequest, sceneGraphPath, bl);
                        continue block6;
                    }
                    case 2: {
                        bl2 = this.pickSingleFrustum((SinglePickTarget)pickTargetArray[i], pickRequest, sceneGraphPath, bl);
                        continue block6;
                    }
                    case 3: {
                        bl2 = this.pickSingleFrustum((LeafPickTarget)pickTargetArray[i], pickRequest, sceneGraphPath, bl);
                        continue block6;
                    }
                    case 4: {
                        bl2 = this.pickSingleFrustum((CustomPickTarget)pickTargetArray[i], pickRequest, sceneGraphPath, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
        }
        return bl2;
    }

    private boolean pickSingleFrustum(LeafPickTarget leafPickTarget, PickRequest pickRequest, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!leafPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        boolean bl2 = false;
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes, this.transformPath[this.lastPathIndex - 1]) != 0) {
            this.resizePath();
            this.pickPath[this.lastPathIndex] = leafPickTarget;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (bl) {
                this.matrixUtils.inverse(this.transformPath[this.lastPathIndex - 2], this.vworldMatrix);
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.transformPath[this.lastPathIndex - 2], this.vworldMatrix);
            bl2 = true;
            --this.lastPathIndex;
        }
        return bl2;
    }

    private void pickAllFrustum(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        int n = 0;
        ArrayList<SceneGraphPath> arrayList = null;
        if (pickRequest.foundPaths instanceof ArrayList) {
            arrayList = (ArrayList<SceneGraphPath>)pickRequest.foundPaths;
        } else {
            pickRequest.foundPaths = arrayList = new ArrayList<SceneGraphPath>();
        }
        this.frustumPlanes[0].x = pickRequest.origin[0];
        this.frustumPlanes[0].y = pickRequest.origin[1];
        this.frustumPlanes[0].z = pickRequest.origin[2];
        this.frustumPlanes[0].w = pickRequest.origin[3];
        this.frustumPlanes[1].x = pickRequest.origin[4];
        this.frustumPlanes[1].y = pickRequest.origin[5];
        this.frustumPlanes[1].z = pickRequest.origin[6];
        this.frustumPlanes[1].w = pickRequest.origin[7];
        this.frustumPlanes[2].x = pickRequest.origin[8];
        this.frustumPlanes[2].y = pickRequest.origin[9];
        this.frustumPlanes[2].z = pickRequest.origin[10];
        this.frustumPlanes[2].w = pickRequest.origin[11];
        this.frustumPlanes[3].x = pickRequest.origin[12];
        this.frustumPlanes[3].y = pickRequest.origin[13];
        this.frustumPlanes[3].z = pickRequest.origin[14];
        this.frustumPlanes[3].w = pickRequest.origin[15];
        this.frustumPlanes[4].x = pickRequest.origin[16];
        this.frustumPlanes[4].y = pickRequest.origin[17];
        this.frustumPlanes[4].z = pickRequest.origin[18];
        this.frustumPlanes[4].w = pickRequest.origin[19];
        this.frustumPlanes[5].x = pickRequest.origin[20];
        this.frustumPlanes[5].y = pickRequest.origin[21];
        this.frustumPlanes[5].z = pickRequest.origin[22];
        this.frustumPlanes[5].w = pickRequest.origin[23];
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        this.transformPath[0].setIdentity();
        if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes, this.transformPath[0]) == 0) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n2 = object.numPickableChildren();
                if (n2 == 0) break;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[0];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n2; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            n += this.pickAllFrustum((GroupPickTarget)pickTargetArray[i], pickRequest, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 2: {
                            n += this.pickAllFrustum((SinglePickTarget)pickTargetArray[i], pickRequest, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 3: {
                            n += this.pickAllFrustum((LeafPickTarget)pickTargetArray[i], pickRequest, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 4: {
                            n = this.pickAllFrustum((CustomPickTarget)pickTargetArray[i], pickRequest, arrayList, n, pickRequest.generateVWorldMatrix);
                        }
                    }
                }
                pickRequest.pickCount = n;
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllFrustum((SinglePickTarget)pickTarget2, pickRequest, arrayList, 0, pickRequest.generateVWorldMatrix);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllFrustum((LeafPickTarget)pickTarget2, pickRequest, arrayList, 0, pickRequest.generateVWorldMatrix);
            }
        }
    }

    private int pickAllFrustum(SinglePickTarget singlePickTarget, PickRequest pickRequest, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        Matrix4f matrix4f = this.transformPath[this.lastPathIndex - 1];
        this.transformPath[this.lastPathIndex].set(matrix4f);
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget == null) {
            return 0;
        }
        int n2 = 0;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                n2 = this.pickAllFrustum((GroupPickTarget)pickTarget, pickRequest, arrayList, n, bl);
                break;
            }
            case 2: {
                n2 = this.pickAllFrustum((SinglePickTarget)pickTarget, pickRequest, arrayList, n, bl);
                break;
            }
            case 3: {
                n2 = this.pickAllFrustum((LeafPickTarget)pickTarget, pickRequest, arrayList, n, bl);
                break;
            }
            case 4: {
                n2 = this.pickAllFrustum((CustomPickTarget)pickTarget, pickRequest, arrayList, n, bl);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return n2;
    }

    private int pickAllFrustum(GroupPickTarget groupPickTarget, PickRequest pickRequest, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes, this.transformPath[this.lastPathIndex - 1]) == 0) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickAllFrustum((GroupPickTarget)((Object)node), pickRequest, arrayList, n, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickAllFrustum((SinglePickTarget)((Object)node), pickRequest, arrayList, n, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickAllFrustum((LeafPickTarget)((Object)node), pickRequest, arrayList, n, bl);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickAllFrustum((CustomPickTarget)((Object)node), pickRequest, arrayList, n, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        int n2 = 0;
        int n3 = groupPickTarget.numPickableChildren();
        if (n3 != 0) {
            PickTarget[] pickTargetArray;
            this.resizePath();
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                pickTargetArray.mul(this.transformPath[this.lastPathIndex - 1], (Matrix4f)pickTargetArray);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                pickTargetArray = this.transformPath[this.lastPathIndex - 1];
                this.transformPath[this.lastPathIndex].set((Matrix4f)pickTargetArray);
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block6: for (int i = 0; i < n3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        n2 += this.pickAllFrustum((GroupPickTarget)pickTargetArray[i], pickRequest, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 2: {
                        n2 += this.pickAllFrustum((SinglePickTarget)pickTargetArray[i], pickRequest, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 3: {
                        n2 += this.pickAllFrustum((LeafPickTarget)pickTargetArray[i], pickRequest, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 4: {
                        n2 += this.pickAllFrustum((CustomPickTarget)pickTargetArray[i], pickRequest, arrayList, n + n2, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
        }
        return n2;
    }

    private int pickAllFrustum(CustomPickTarget customPickTarget, PickRequest pickRequest, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes, this.transformPath[this.lastPathIndex - 1]) == 0) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickAllFrustum((GroupPickTarget)((Object)node), pickRequest, arrayList, n, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickAllFrustum((SinglePickTarget)((Object)node), pickRequest, arrayList, n, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickAllFrustum((LeafPickTarget)((Object)node), pickRequest, arrayList, n, bl);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickAllFrustum((CustomPickTarget)((Object)node), pickRequest, arrayList, n, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        int n2 = 0;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            PickTarget[] pickTargetArray;
            int n3 = this.pickInstructions.numChildren;
            if (this.pickInstructions.hasTransform) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                pickTargetArray.set(this.pickInstructions.localTransform);
                pickTargetArray.mul(this.transformPath[this.lastPathIndex - 1], (Matrix4f)pickTargetArray);
                this.validTransform[this.lastPathIndex] = true;
            } else {
                pickTargetArray = this.transformPath[this.lastPathIndex - 1];
                this.transformPath[this.lastPathIndex].set((Matrix4f)pickTargetArray);
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block6: for (int i = 0; i < n3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        n2 += this.pickAllFrustum((GroupPickTarget)pickTargetArray[i], pickRequest, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 2: {
                        n2 += this.pickAllFrustum((SinglePickTarget)pickTargetArray[i], pickRequest, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 3: {
                        n2 += this.pickAllFrustum((LeafPickTarget)pickTargetArray[i], pickRequest, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 4: {
                        n2 += this.pickAllFrustum((CustomPickTarget)pickTargetArray[i], pickRequest, arrayList, n + n2, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
        }
        return n2;
    }

    private int pickAllFrustum(LeafPickTarget leafPickTarget, PickRequest pickRequest, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!leafPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        int n2 = 0;
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes, this.transformPath[this.lastPathIndex - 1]) != 0) {
            SceneGraphPath sceneGraphPath;
            this.resizePath();
            this.pickPath[this.lastPathIndex] = leafPickTarget;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (n >= arrayList.size()) {
                sceneGraphPath = new SceneGraphPath();
                arrayList.add(sceneGraphPath);
            } else {
                sceneGraphPath = arrayList.get(n);
            }
            if (bl) {
                this.matrixUtils.inverse(this.transformPath[this.lastPathIndex - 2], this.vworldMatrix);
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.transformPath[this.lastPathIndex - 2], this.vworldMatrix);
            n2 = 1;
            --this.lastPathIndex;
        }
        return n2;
    }

    private void pickSphere(PickTarget pickTarget, PickRequest pickRequest) {
        switch (pickRequest.pickSortType) {
            case 1: 
            case 3: {
                this.pickAllSphere(pickTarget, pickRequest);
                break;
            }
            case 2: 
            case 4: {
                this.pickSingleSphere(pickTarget, pickRequest);
                break;
            }
            default: {
                this.errorReporter.warningReport(NO_SORT_TYPE_MSG, null);
            }
        }
    }

    private void pickSingleSphere(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        SceneGraphPath sceneGraphPath = null;
        if (pickRequest.foundPaths instanceof SceneGraphPath) {
            sceneGraphPath = (SceneGraphPath)pickRequest.foundPaths;
        } else {
            sceneGraphPath = new SceneGraphPath();
            pickRequest.foundPaths = sceneGraphPath;
        }
        boolean bl = false;
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        if (boundingVolume == null || !boundingVolume.checkIntersectionSphere(pickRequest.origin, pickRequest.additionalData)) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.start[3] = 1.0f;
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n = object.numPickableChildren();
                if (n == 0) break;
                float f = pickRequest.additionalData;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[0];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                    transformPickTarget.getInverseTransform(this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                    f *= this.invertedMatrix.getScale();
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n && !bl; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            bl = this.pickSingleSphere((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 2: {
                            bl = this.pickSingleSphere((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 3: {
                            bl = this.pickSingleSphere((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 4: {
                            bl = this.pickSingleSphere((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, f, sceneGraphPath, pickRequest.generateVWorldMatrix);
                        }
                    }
                }
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleSphere((SinglePickTarget)pickTarget2, pickRequest, this.start, pickRequest.additionalData, sceneGraphPath, pickRequest.generateVWorldMatrix);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                bl = this.pickSingleSphere((LeafPickTarget)pickTarget2, pickRequest, this.start, pickRequest.additionalData, sceneGraphPath, pickRequest.generateVWorldMatrix);
            }
        }
        pickRequest.pickCount = bl ? 1 : 0;
    }

    private boolean pickSingleSphere(SinglePickTarget singlePickTarget, PickRequest pickRequest, float[] fArray, float f, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget == null) {
            return false;
        }
        boolean bl2 = false;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                bl2 = this.pickSingleSphere((GroupPickTarget)pickTarget, pickRequest, fArray, f, sceneGraphPath, bl);
                break;
            }
            case 2: {
                bl2 = this.pickSingleSphere((SinglePickTarget)pickTarget, pickRequest, fArray, f, sceneGraphPath, bl);
                break;
            }
            case 3: {
                bl2 = this.pickSingleSphere((LeafPickTarget)pickTarget, pickRequest, fArray, f, sceneGraphPath, bl);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return bl2;
    }

    private boolean pickSingleSphere(GroupPickTarget groupPickTarget, PickRequest pickRequest, float[] fArray, float f, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionSphere(fArray, f)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleSphere((GroupPickTarget)((Object)node), pickRequest, fArray, f, sceneGraphPath, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleSphere((SinglePickTarget)((Object)node), pickRequest, fArray, f, sceneGraphPath, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleSphere((LeafPickTarget)((Object)node), pickRequest, fArray, f, sceneGraphPath, bl);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickSingleSphere((CustomPickTarget)((Object)node), pickRequest, fArray, f, sceneGraphPath, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl2 = false;
        int n = groupPickTarget.numPickableChildren();
        if (n != 0) {
            PickTarget[] pickTargetArray;
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = f;
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                transformPickTarget.getInverseTransform(this.invertedMatrix);
                this.matrixUtils.inverse((Matrix4f)pickTargetArray, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                f *= this.invertedMatrix.getScale();
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block6: for (int i = 0; i < n && !bl2; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl2 = this.pickSingleSphere((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, f, sceneGraphPath, bl);
                        continue block6;
                    }
                    case 2: {
                        bl2 = this.pickSingleSphere((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, f, sceneGraphPath, bl);
                        continue block6;
                    }
                    case 3: {
                        bl2 = this.pickSingleSphere((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, f, sceneGraphPath, bl);
                        continue block6;
                    }
                    case 4: {
                        bl2 = this.pickSingleSphere((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, f, sceneGraphPath, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f2;
            fArray[1] = f3;
            fArray[2] = f4;
            f = f5;
        }
        return bl2;
    }

    private boolean pickSingleSphere(CustomPickTarget customPickTarget, PickRequest pickRequest, float[] fArray, float f, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionSphere(fArray, f)) {
            return false;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickSingleSphere((GroupPickTarget)((Object)node), pickRequest, fArray, f, sceneGraphPath, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickSingleSphere((SinglePickTarget)((Object)node), pickRequest, fArray, f, sceneGraphPath, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickSingleSphere((LeafPickTarget)((Object)node), pickRequest, fArray, f, sceneGraphPath, bl);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickSingleSphere((CustomPickTarget)((Object)node), pickRequest, fArray, f, sceneGraphPath, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        boolean bl2 = false;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            int n = this.pickInstructions.numChildren;
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = f;
            if (this.pickInstructions.hasTransform) {
                this.transformPath[this.lastPathIndex].set(this.pickInstructions.localTransform);
                this.matrixUtils.inverse(this.pickInstructions.localTransform, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                f *= this.invertedMatrix.getScale();
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block6: for (int i = 0; i < n && !bl2; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        bl2 = this.pickSingleSphere((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, f, sceneGraphPath, bl);
                        continue block6;
                    }
                    case 2: {
                        bl2 = this.pickSingleSphere((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, f, sceneGraphPath, bl);
                        continue block6;
                    }
                    case 3: {
                        bl2 = this.pickSingleSphere((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, f, sceneGraphPath, bl);
                        continue block6;
                    }
                    case 4: {
                        bl2 = this.pickSingleSphere((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, f, sceneGraphPath, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f2;
            fArray[1] = f3;
            fArray[2] = f4;
            f = f5;
        }
        return bl2;
    }

    private boolean pickSingleSphere(LeafPickTarget leafPickTarget, PickRequest pickRequest, float[] fArray, float f, SceneGraphPath sceneGraphPath, boolean bl) {
        if (!leafPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        boolean bl2 = false;
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionSphere(fArray, f)) {
            this.resizePath();
            this.pickPath[this.lastPathIndex] = leafPickTarget;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            --this.lastPathIndex;
            bl2 = true;
        }
        return bl2;
    }

    private void pickAllSphere(PickTarget pickTarget, PickRequest pickRequest) {
        Object object;
        int n = 0;
        ArrayList<SceneGraphPath> arrayList = null;
        if (pickRequest.foundPaths instanceof ArrayList) {
            arrayList = (ArrayList<SceneGraphPath>)pickRequest.foundPaths;
        } else {
            pickRequest.foundPaths = arrayList = new ArrayList<SceneGraphPath>();
        }
        PickTarget pickTarget2 = pickTarget;
        BoundingVolume boundingVolume = pickTarget2.getPickableBounds();
        if (boundingVolume == null || !boundingVolume.checkIntersectionSphere(pickRequest.origin, pickRequest.additionalData)) {
            pickRequest.pickCount = 0;
            return;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                pickRequest.pickCount = 0;
                return;
            }
        }
        this.start[0] = pickRequest.origin[0];
        this.start[1] = pickRequest.origin[1];
        this.start[2] = pickRequest.origin[2];
        this.start[3] = 1.0f;
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                PickTarget[] pickTargetArray;
                object = (GroupPickTarget)pickTarget2;
                int n2 = object.numPickableChildren();
                if (n2 == 0) break;
                float f = pickRequest.additionalData;
                if (pickTarget instanceof TransformPickTarget) {
                    pickTargetArray = this.transformPath[0];
                    TransformPickTarget transformPickTarget = (TransformPickTarget)pickTarget;
                    transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                    transformPickTarget.getInverseTransform(this.invertedMatrix);
                    this.transform(this.invertedMatrix, this.start);
                    f *= this.invertedMatrix.getScale();
                } else {
                    this.transformPath[0].setIdentity();
                }
                this.validTransform[0] = true;
                this.pickPath[0] = object;
                pickTargetArray = object.getPickableChildren();
                block11: for (int i = 0; i < n2; ++i) {
                    if (pickTargetArray[i] == null) continue;
                    this.lastPathIndex = 1;
                    switch (pickTargetArray[i].getPickTargetType()) {
                        case 1: {
                            n += this.pickAllSphere((GroupPickTarget)pickTargetArray[i], pickRequest, this.start, f, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 2: {
                            n += this.pickAllSphere((SinglePickTarget)pickTargetArray[i], pickRequest, this.start, f, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 3: {
                            n += this.pickAllSphere((LeafPickTarget)pickTargetArray[i], pickRequest, this.start, f, arrayList, n, pickRequest.generateVWorldMatrix);
                            continue block11;
                        }
                        case 4: {
                            n += this.pickAllSphere((CustomPickTarget)pickTargetArray[i], pickRequest, this.start, f, arrayList, n, pickRequest.generateVWorldMatrix);
                        }
                    }
                }
                pickRequest.pickCount = n;
                break;
            }
            case 2: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllSphere((SinglePickTarget)pickTarget2, pickRequest, this.start, pickRequest.additionalData, arrayList, 0, pickRequest.generateVWorldMatrix);
                break;
            }
            case 3: {
                this.transformPath[0].setIdentity();
                this.validTransform[0] = true;
                this.pickPath[0] = pickTarget2;
                this.lastPathIndex = 1;
                pickRequest.pickCount = n += this.pickAllSphere((LeafPickTarget)pickTarget2, pickRequest, this.start, pickRequest.additionalData, arrayList, 0, pickRequest.generateVWorldMatrix);
            }
        }
    }

    private int pickAllSphere(GroupPickTarget groupPickTarget, PickRequest pickRequest, float[] fArray, float f, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!groupPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        BoundingVolume boundingVolume = groupPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionSphere(fArray, f)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickAllSphere((GroupPickTarget)((Object)node), pickRequest, fArray, f, arrayList, n, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickAllSphere((SinglePickTarget)((Object)node), pickRequest, fArray, f, arrayList, n, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickAllSphere((LeafPickTarget)((Object)node), pickRequest, fArray, f, arrayList, n, bl);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickAllSphere((CustomPickTarget)((Object)node), pickRequest, fArray, f, arrayList, n, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        int n2 = 0;
        int n3 = groupPickTarget.numPickableChildren();
        if (n3 != 0) {
            PickTarget[] pickTargetArray;
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = f;
            if (groupPickTarget instanceof TransformPickTarget) {
                pickTargetArray = this.transformPath[this.lastPathIndex];
                TransformPickTarget transformPickTarget = (TransformPickTarget)((Object)groupPickTarget);
                transformPickTarget.getTransform((Matrix4f)pickTargetArray);
                transformPickTarget.getInverseTransform(this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                f *= this.invertedMatrix.getScale();
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = groupPickTarget;
            ++this.lastPathIndex;
            pickTargetArray = groupPickTarget.getPickableChildren();
            block6: for (int i = 0; i < n3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        n2 += this.pickAllSphere((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, f, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 2: {
                        n2 += this.pickAllSphere((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, f, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 3: {
                        n2 += this.pickAllSphere((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, f, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 4: {
                        n2 += this.pickAllSphere((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, f, arrayList, n + n2, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f2;
            fArray[1] = f3;
            fArray[2] = f4;
            f = f5;
        }
        return n2;
    }

    private int pickAllSphere(SinglePickTarget singlePickTarget, PickRequest pickRequest, float[] fArray, float f, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!singlePickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        if (pickTarget == null) {
            return 0;
        }
        int n2 = 0;
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                n2 = this.pickAllSphere((GroupPickTarget)pickTarget, pickRequest, fArray, f, arrayList, n, bl);
                break;
            }
            case 2: {
                n2 = this.pickAllSphere((SinglePickTarget)pickTarget, pickRequest, fArray, f, arrayList, n, bl);
                break;
            }
            case 3: {
                n2 = this.pickAllSphere((LeafPickTarget)pickTarget, pickRequest, fArray, f, arrayList, n, bl);
                break;
            }
            case 4: {
                n2 = this.pickAllSphere((CustomPickTarget)pickTarget, pickRequest, fArray, f, arrayList, n, bl);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
        return n2;
    }

    private int pickAllSphere(CustomPickTarget customPickTarget, PickRequest pickRequest, float[] fArray, float f, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        BoundingVolume boundingVolume = customPickTarget.getPickableBounds();
        if (!boundingVolume.checkIntersectionSphere(fArray, f)) {
            return 0;
        }
        if (boundingVolume instanceof BoundingGeometry) {
            BoundingGeometry boundingGeometry = (BoundingGeometry)boundingVolume;
            Node node = boundingGeometry.getProxyGeometry();
            if (node instanceof GroupPickTarget) {
                return this.pickAllSphere((GroupPickTarget)((Object)node), pickRequest, fArray, f, arrayList, n, bl);
            }
            if (node instanceof SinglePickTarget) {
                return this.pickAllSphere((SinglePickTarget)((Object)node), pickRequest, fArray, f, arrayList, n, bl);
            }
            if (node instanceof LeafPickTarget) {
                return this.pickAllSphere((LeafPickTarget)((Object)node), pickRequest, fArray, f, arrayList, n, bl);
            }
            if (node instanceof CustomPickTarget) {
                return this.pickAllSphere((CustomPickTarget)((Object)node), pickRequest, fArray, f, arrayList, n, bl);
            }
            if (node != null) {
                this.errorReporter.warningReport(UNKNOWN_PROXY_TYPE_MSG, null);
            }
        }
        int n2 = 0;
        if (this.pickCustom(customPickTarget, pickRequest)) {
            int n3 = this.pickInstructions.numChildren;
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = f;
            if (this.pickInstructions.hasTransform) {
                this.transformPath[this.lastPathIndex].set(this.pickInstructions.localTransform);
                this.matrixUtils.inverse(this.pickInstructions.localTransform, this.invertedMatrix);
                this.transform(this.invertedMatrix, fArray);
                f *= this.invertedMatrix.getScale();
                this.validTransform[this.lastPathIndex] = true;
            } else {
                this.validTransform[this.lastPathIndex] = false;
            }
            this.pickPath[this.lastPathIndex] = customPickTarget;
            ++this.lastPathIndex;
            PickTarget[] pickTargetArray = (PickTarget[])this.pickInstructions.children.clone();
            block6: for (int i = 0; i < n3; ++i) {
                if (pickTargetArray[i] == null) continue;
                switch (pickTargetArray[i].getPickTargetType()) {
                    case 1: {
                        n2 += this.pickAllSphere((GroupPickTarget)pickTargetArray[i], pickRequest, fArray, f, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 2: {
                        n2 += this.pickAllSphere((SinglePickTarget)pickTargetArray[i], pickRequest, fArray, f, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 3: {
                        n2 += this.pickAllSphere((LeafPickTarget)pickTargetArray[i], pickRequest, fArray, f, arrayList, n + n2, bl);
                        continue block6;
                    }
                    case 4: {
                        n2 += this.pickAllSphere((CustomPickTarget)pickTargetArray[i], pickRequest, fArray, f, arrayList, n + n2, bl);
                    }
                }
            }
            --this.lastPathIndex;
            this.pickPath[this.lastPathIndex] = null;
            fArray[0] = f2;
            fArray[1] = f3;
            fArray[2] = f4;
            f = f5;
        }
        return n2;
    }

    private int pickAllSphere(LeafPickTarget leafPickTarget, PickRequest pickRequest, float[] fArray, float f, ArrayList<SceneGraphPath> arrayList, int n, boolean bl) {
        if (!leafPickTarget.checkPickMask(pickRequest.pickType)) {
            return 0;
        }
        int n2 = 0;
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        if (boundingVolume.checkIntersectionSphere(fArray, f)) {
            SceneGraphPath sceneGraphPath;
            this.resizePath();
            this.pickPath[this.lastPathIndex] = leafPickTarget;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            if (n >= arrayList.size()) {
                sceneGraphPath = new SceneGraphPath();
                arrayList.add(sceneGraphPath);
            } else {
                sceneGraphPath = arrayList.get(n);
            }
            if (bl) {
                this.buildVWorldTransform();
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.vworldMatrix, this.invertedMatrix);
            --this.lastPathIndex;
            n2 = 1;
        }
        return n2;
    }

    private boolean pickCustom(CustomPickTarget customPickTarget, PickRequest pickRequest) {
        if (!customPickTarget.checkPickMask(pickRequest.pickType)) {
            return false;
        }
        this.buildVWorldTransform();
        customPickTarget.pickChildren(this.pickInstructions, this.vworldMatrix, pickRequest);
        return this.pickInstructions.numChildren != 0;
    }

    private final void resizePath() {
        if (this.lastPathIndex == this.pickPath.length) {
            int n = this.pickPath.length;
            int n2 = n + 8;
            PickTarget[] pickTargetArray = new PickTarget[n2];
            System.arraycopy(this.pickPath, 0, pickTargetArray, 0, n);
            this.pickPath = pickTargetArray;
            Matrix4f[] matrix4fArray = new Matrix4f[n2];
            System.arraycopy(this.transformPath, 0, matrix4fArray, 0, n);
            this.transformPath = matrix4fArray;
            for (int i = n; i < n2; ++i) {
                this.transformPath[i] = new Matrix4f();
            }
            boolean[] blArray = new boolean[n2];
            System.arraycopy(this.validTransform, 0, blArray, 0, n);
            this.validTransform = blArray;
        }
    }

    private void transform(Matrix4f matrix4f, float[] fArray) {
        this.wkVec.set(fArray);
        matrix4f.transform((Tuple4f)this.wkVec);
        this.wkVec.get(fArray);
    }

    private void transformNormal(Matrix4f matrix4f, float[] fArray) {
        this.wkNormal.set(fArray);
        matrix4f.transform(this.wkNormal);
        this.wkNormal.get(fArray);
    }

    private void buildVWorldTransform() {
        boolean bl = false;
        this.vworldMatrix.set(this.transformPath[0]);
        for (int i = 1; i < this.lastPathIndex; ++i) {
            if (!this.validTransform[i]) continue;
            this.vworldMatrix.mul(this.transformPath[i]);
        }
        this.matrixUtils.inverse(this.vworldMatrix, this.invertedMatrix);
    }
}

