/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.management;

import java.util.ArrayList;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import org.j3d.aviatrix3d.BoundingGeometry;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.SceneGraphPath;
import org.j3d.aviatrix3d.picking.GroupPickTarget;
import org.j3d.aviatrix3d.picking.LeafPickTarget;
import org.j3d.aviatrix3d.picking.NotPickableException;
import org.j3d.aviatrix3d.picking.PickRequest;
import org.j3d.aviatrix3d.picking.PickTarget;
import org.j3d.aviatrix3d.picking.SinglePickTarget;
import org.j3d.aviatrix3d.picking.TransformPickTarget;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;
import org.j3d.util.MatrixUtils;

class DefaultBatchPickingHandler {
    private static final String NO_PICK_TYPE_MSG = "AV3D: No or unknown picking type has been specified in the PickRequest";
    private static final int LIST_START_SIZE = 32;
    private static final int LIST_INCREMENT = 8;
    private int[] activePicks;
    private PickTarget[] pickPath;
    private Matrix4f[] transformPath;
    private boolean[] validTransform;
    private int lastPathIndex;
    private float closestDistance;
    private float[][][] start;
    private float[][][] end;
    private float[][][] extraData;
    private float[] vertexPickData = new float[3];
    private Matrix4f vworldMatrix;
    private Matrix4f invertedMatrix;
    private Vector4f wkVec;
    private Vector3f wkNormal;
    private Vector4f[][] frustumPlanes;
    private MatrixUtils matrixUtils;
    private ErrorReporter errorReporter;

    public DefaultBatchPickingHandler() {
        this.pickPath = new PickTarget[32];
        this.transformPath = new Matrix4f[32];
        this.validTransform = new boolean[32];
        for (int i = 0; i < 32; ++i) {
            this.transformPath[i] = new Matrix4f();
        }
        this.vworldMatrix = new Matrix4f();
        this.invertedMatrix = new Matrix4f();
        this.wkVec = new Vector4f();
        this.wkVec.w = 1.0f;
        this.wkNormal = new Vector3f();
        this.activePicks = new int[0];
        this.matrixUtils = new MatrixUtils();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    void processPick(PickTarget pickTarget, PickRequest[] pickRequestArray, int n) throws NotPickableException {
        this.resizeForBatch(n);
        this.lastPathIndex = 0;
        this.transformPath[0].setIdentity();
        boolean bl = false;
        BoundingVolume boundingVolume = pickTarget.getPickableBounds();
        if (boundingVolume == null) {
            for (int i = 0; i < n; ++i) {
                pickRequestArray[i].pickCount = 0;
            }
            return;
        }
        block15: for (int i = 0; i < n; ++i) {
            this.activePicks[i] = 0;
            pickRequestArray[i].pickCount = 0;
            switch (pickRequestArray[i].pickSortType) {
                case 1: 
                case 3: {
                    if (pickRequestArray[i].foundPaths instanceof ArrayList) break;
                    pickRequestArray[i].foundPaths = new ArrayList();
                    break;
                }
                case 2: 
                case 4: {
                    if (pickRequestArray[i].foundPaths instanceof SceneGraphPath) break;
                    pickRequestArray[i].foundPaths = new SceneGraphPath();
                }
            }
            float[] fArray = this.start[i][0];
            float[] fArray2 = this.end[i][0];
            float[] fArray3 = this.extraData[i][0];
            switch (pickRequestArray[i].pickGeometryType) {
                case 1: {
                    if (!boundingVolume.checkIntersectionPoint(pickRequestArray[i].origin)) continue block15;
                    fArray[0] = pickRequestArray[i].origin[0];
                    fArray[1] = pickRequestArray[i].origin[1];
                    fArray[2] = pickRequestArray[i].origin[2];
                    int n2 = i;
                    this.activePicks[n2] = this.activePicks[n2] + 1;
                    bl = true;
                    continue block15;
                }
                case 2: {
                    if (!boundingVolume.checkIntersectionRay(pickRequestArray[i].origin, pickRequestArray[i].destination)) continue block15;
                    fArray[0] = pickRequestArray[i].origin[0];
                    fArray[1] = pickRequestArray[i].origin[1];
                    fArray[2] = pickRequestArray[i].origin[2];
                    fArray2[0] = pickRequestArray[i].destination[0];
                    fArray2[1] = pickRequestArray[i].destination[1];
                    fArray2[2] = pickRequestArray[i].destination[2];
                    int n3 = i;
                    this.activePicks[n3] = this.activePicks[n3] + 1;
                    bl = true;
                    continue block15;
                }
                case 3: {
                    if (!boundingVolume.checkIntersectionSegment(pickRequestArray[i].origin, pickRequestArray[i].destination)) continue block15;
                    fArray[0] = pickRequestArray[i].origin[0];
                    fArray[1] = pickRequestArray[i].origin[1];
                    fArray[2] = pickRequestArray[i].origin[2];
                    fArray2[0] = pickRequestArray[i].destination[0];
                    fArray2[1] = pickRequestArray[i].destination[1];
                    fArray2[2] = pickRequestArray[i].destination[2];
                    int n4 = i;
                    this.activePicks[n4] = this.activePicks[n4] + 1;
                    bl = true;
                    continue block15;
                }
                case 4: 
                case 5: {
                    float f = pickRequestArray[i].origin[0] - pickRequestArray[i].destination[0];
                    float f2 = pickRequestArray[i].origin[1] - pickRequestArray[i].destination[1];
                    float f3 = pickRequestArray[i].origin[2] - pickRequestArray[i].destination[2];
                    float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
                    if (f4 == 0.0f) {
                        return;
                    }
                    fArray[0] = (pickRequestArray[i].origin[0] + pickRequestArray[i].destination[0]) * 0.5f;
                    fArray[1] = (pickRequestArray[i].origin[1] + pickRequestArray[i].destination[0]) * 0.5f;
                    fArray[2] = (pickRequestArray[i].origin[2] + pickRequestArray[i].destination[0]) * 0.5f;
                    fArray2[0] = f;
                    fArray2[1] = f2;
                    fArray2[2] = f3;
                    float f5 = pickRequestArray[i].additionalData;
                    if (!boundingVolume.checkIntersectionCylinder(fArray, fArray2, f5, f4)) continue block15;
                    fArray3[0] = f5;
                    fArray3[1] = f4;
                    int n5 = i;
                    this.activePicks[n5] = this.activePicks[n5] + 1;
                    bl = true;
                    continue block15;
                }
                case 6: 
                case 7: {
                    if (!boundingVolume.checkIntersectionCone(pickRequestArray[i].origin, pickRequestArray[i].destination, pickRequestArray[i].additionalData)) continue block15;
                    fArray[0] = pickRequestArray[i].origin[0];
                    fArray[1] = pickRequestArray[i].origin[1];
                    fArray[2] = pickRequestArray[i].origin[2];
                    fArray2[0] = pickRequestArray[i].destination[0];
                    fArray2[1] = pickRequestArray[i].destination[1];
                    fArray2[2] = pickRequestArray[i].destination[2];
                    fArray3[0] = pickRequestArray[i].additionalData;
                    int n6 = i;
                    this.activePicks[n6] = this.activePicks[n6] + 1;
                    bl = true;
                    continue block15;
                }
                case 8: {
                    if (!boundingVolume.checkIntersectionBox(pickRequestArray[i].origin, pickRequestArray[i].destination)) continue block15;
                    fArray[0] = pickRequestArray[i].origin[0];
                    fArray[1] = pickRequestArray[i].origin[1];
                    fArray[2] = pickRequestArray[i].origin[2];
                    fArray2[0] = pickRequestArray[i].destination[0];
                    fArray2[1] = pickRequestArray[i].destination[1];
                    fArray2[2] = pickRequestArray[i].destination[2];
                    int n7 = i;
                    this.activePicks[n7] = this.activePicks[n7] + 1;
                    bl = true;
                    continue block15;
                }
                case 10: {
                    this.frustumPlanes[i][0].x = pickRequestArray[i].origin[0];
                    this.frustumPlanes[i][0].y = pickRequestArray[i].origin[1];
                    this.frustumPlanes[i][0].z = pickRequestArray[i].origin[2];
                    this.frustumPlanes[i][0].w = pickRequestArray[i].origin[3];
                    this.frustumPlanes[i][1].x = pickRequestArray[i].origin[4];
                    this.frustumPlanes[i][1].y = pickRequestArray[i].origin[5];
                    this.frustumPlanes[i][1].z = pickRequestArray[i].origin[6];
                    this.frustumPlanes[i][1].w = pickRequestArray[i].origin[7];
                    this.frustumPlanes[i][2].x = pickRequestArray[i].origin[8];
                    this.frustumPlanes[i][2].y = pickRequestArray[i].origin[9];
                    this.frustumPlanes[i][2].z = pickRequestArray[i].origin[10];
                    this.frustumPlanes[i][2].w = pickRequestArray[i].origin[11];
                    this.frustumPlanes[i][3].x = pickRequestArray[i].origin[12];
                    this.frustumPlanes[i][3].y = pickRequestArray[i].origin[13];
                    this.frustumPlanes[i][3].z = pickRequestArray[i].origin[14];
                    this.frustumPlanes[i][3].w = pickRequestArray[i].origin[15];
                    this.frustumPlanes[i][4].x = pickRequestArray[i].origin[16];
                    this.frustumPlanes[i][4].y = pickRequestArray[i].origin[17];
                    this.frustumPlanes[i][4].z = pickRequestArray[i].origin[18];
                    this.frustumPlanes[i][4].w = pickRequestArray[i].origin[19];
                    this.frustumPlanes[i][5].x = pickRequestArray[i].origin[20];
                    this.frustumPlanes[i][5].y = pickRequestArray[i].origin[21];
                    this.frustumPlanes[i][5].z = pickRequestArray[i].origin[22];
                    this.frustumPlanes[i][5].w = pickRequestArray[i].origin[23];
                    if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes[i], this.transformPath[this.lastPathIndex]) != 0) continue block15;
                    int n8 = i;
                    this.activePicks[n8] = this.activePicks[n8] + 1;
                    bl = true;
                    continue block15;
                }
                case 9: {
                    if (!boundingVolume.checkIntersectionSphere(pickRequestArray[i].origin, pickRequestArray[i].additionalData)) continue block15;
                    fArray[0] = pickRequestArray[i].origin[0];
                    fArray[1] = pickRequestArray[i].origin[1];
                    fArray[2] = pickRequestArray[i].origin[2];
                    fArray3[0] = pickRequestArray[i].additionalData;
                    int n9 = i;
                    this.activePicks[n9] = this.activePicks[n9] + 1;
                    bl = true;
                    continue block15;
                }
                default: {
                    this.errorReporter.warningReport(NO_PICK_TYPE_MSG, null);
                }
            }
        }
        if (bl) {
            this.descendTree(pickTarget, pickRequestArray, n);
        }
    }

    private void descendTree(PickTarget pickTarget, PickRequest[] pickRequestArray, int n) {
        int n2;
        Object object;
        BoundingVolume boundingVolume = pickTarget.getPickableBounds();
        PickTarget pickTarget2 = pickTarget;
        int n3 = 0;
        if (boundingVolume instanceof BoundingGeometry) {
            object = (BoundingGeometry)boundingVolume;
            Node node = ((BoundingGeometry)object).getProxyGeometry();
            if (node instanceof PickTarget) {
                pickTarget2 = (PickTarget)((Object)node);
            } else {
                return;
            }
        }
        switch (pickTarget2.getPickTargetType()) {
            case 1: {
                object = (GroupPickTarget)pickTarget2;
                n3 = object.numPickableChildren();
                if (n3 != 0) break;
                return;
            }
            case 2: {
                this.descendSingleTree((SinglePickTarget)pickTarget2, pickRequestArray, n);
                return;
            }
            case 3: {
                this.testLeaf((LeafPickTarget)pickTarget2, pickRequestArray, n);
                return;
            }
        }
        if (pickTarget2 instanceof TransformPickTarget) {
            object = this.transformPath[this.lastPathIndex];
            ((TransformPickTarget)pickTarget2).getTransform((Matrix4f)object);
            ((TransformPickTarget)pickTarget2).getInverseTransform(this.invertedMatrix);
            float f = this.invertedMatrix.getScale();
            object.mul(this.transformPath[this.lastPathIndex - 1], (Matrix4f)object);
            this.validTransform[this.lastPathIndex] = true;
            block25: for (n2 = 0; n2 < n; ++n2) {
                if (this.activePicks[n2] < this.lastPathIndex) continue;
                switch (pickRequestArray[n2].pickGeometryType) {
                    case 1: {
                        this.transform(this.invertedMatrix, this.start[n2][this.lastPathIndex], this.start[n2][this.lastPathIndex + 1]);
                        continue block25;
                    }
                    case 2: {
                        this.transform(this.invertedMatrix, this.start[n2][this.lastPathIndex], this.start[n2][this.lastPathIndex + 1]);
                        this.transformNormal(this.invertedMatrix, this.end[n2][this.lastPathIndex], this.end[n2][this.lastPathIndex + 1]);
                        continue block25;
                    }
                    case 3: {
                        this.transform(this.invertedMatrix, this.start[n2][this.lastPathIndex], this.start[n2][this.lastPathIndex + 1]);
                        this.transform(this.invertedMatrix, this.end[n2][this.lastPathIndex], this.end[n2][this.lastPathIndex + 1]);
                        continue block25;
                    }
                    case 4: 
                    case 5: {
                        this.transform(this.invertedMatrix, this.start[n2][this.lastPathIndex], this.start[n2][this.lastPathIndex + 1]);
                        this.transformNormal(this.invertedMatrix, this.end[n2][this.lastPathIndex], this.end[n2][this.lastPathIndex + 1]);
                        this.extraData[n2][this.lastPathIndex + 1][0] = f * this.extraData[n2][this.lastPathIndex][0];
                        this.extraData[n2][this.lastPathIndex + 1][1] = f * this.extraData[n2][this.lastPathIndex][1];
                        continue block25;
                    }
                    case 6: 
                    case 7: {
                        this.transform(this.invertedMatrix, this.start[n2][this.lastPathIndex], this.start[n2][this.lastPathIndex + 1]);
                        this.transformNormal(this.invertedMatrix, this.end[n2][this.lastPathIndex], this.end[n2][this.lastPathIndex + 1]);
                        this.extraData[n2][this.lastPathIndex + 1][0] = f * this.extraData[n2][this.lastPathIndex][0];
                        continue block25;
                    }
                    case 8: {
                        this.transform(this.invertedMatrix, this.start[n2][this.lastPathIndex], this.start[n2][this.lastPathIndex + 1]);
                        this.transform(this.invertedMatrix, this.end[n2][this.lastPathIndex], this.end[n2][this.lastPathIndex + 1]);
                        continue block25;
                    }
                    case 10: {
                        continue block25;
                    }
                    case 9: {
                        this.transform(this.invertedMatrix, this.start[n2][this.lastPathIndex], this.start[n2][this.lastPathIndex + 1]);
                        this.extraData[n2][this.lastPathIndex + 1][0] = f * this.extraData[n2][this.lastPathIndex][0];
                        continue block25;
                    }
                }
            }
        } else {
            this.validTransform[this.lastPathIndex] = false;
            if (this.lastPathIndex == 0) {
                this.transformPath[this.lastPathIndex].setIdentity();
            } else {
                this.transformPath[this.lastPathIndex].set(this.transformPath[this.lastPathIndex - 1]);
            }
            for (int i = 0; i < n; ++i) {
                if (this.activePicks[i] < this.lastPathIndex) continue;
                this.start[i][this.lastPathIndex + 1][0] = this.start[i][this.lastPathIndex][0];
                this.start[i][this.lastPathIndex + 1][1] = this.start[i][this.lastPathIndex][1];
                this.start[i][this.lastPathIndex + 1][2] = this.start[i][this.lastPathIndex][2];
                this.end[i][this.lastPathIndex + 1][0] = this.end[i][this.lastPathIndex][0];
                this.end[i][this.lastPathIndex + 1][1] = this.end[i][this.lastPathIndex][1];
                this.end[i][this.lastPathIndex + 1][2] = this.end[i][this.lastPathIndex][2];
                this.extraData[i][this.lastPathIndex + 1][0] = this.extraData[i][this.lastPathIndex][0];
                this.extraData[i][this.lastPathIndex + 1][1] = this.extraData[i][this.lastPathIndex][1];
            }
        }
        GroupPickTarget groupPickTarget = (GroupPickTarget)pickTarget2;
        PickTarget[] pickTargetArray = groupPickTarget.getPickableChildren();
        this.pickPath[this.lastPathIndex] = groupPickTarget;
        ++this.lastPathIndex;
        for (int i = 0; i < n3; ++i) {
            int n4;
            n2 = 0;
            if (pickTargetArray[i] == null) continue;
            boundingVolume = pickTargetArray[i].getPickableBounds();
            block28: for (n4 = 0; n4 < n; ++n4) {
                if (this.activePicks[n4] < this.lastPathIndex) continue;
                switch (pickRequestArray[n4].pickGeometryType) {
                    case 1: {
                        if (!boundingVolume.checkIntersectionPoint(this.start[n4][this.lastPathIndex])) continue block28;
                        n2 = 1;
                        int n5 = n4;
                        this.activePicks[n5] = this.activePicks[n5] + 1;
                        continue block28;
                    }
                    case 2: {
                        if (!boundingVolume.checkIntersectionRay(this.start[n4][this.lastPathIndex], this.end[n4][this.lastPathIndex])) continue block28;
                        n2 = 1;
                        int n6 = n4;
                        this.activePicks[n6] = this.activePicks[n6] + 1;
                        continue block28;
                    }
                    case 3: {
                        if (!boundingVolume.checkIntersectionSegment(this.start[n4][this.lastPathIndex], this.end[n4][this.lastPathIndex])) continue block28;
                        n2 = 1;
                        int n7 = n4;
                        this.activePicks[n7] = this.activePicks[n7] + 1;
                        continue block28;
                    }
                    case 4: 
                    case 5: {
                        if (!boundingVolume.checkIntersectionCylinder(this.start[n4][this.lastPathIndex], this.end[n4][this.lastPathIndex], this.extraData[n4][this.lastPathIndex][0], this.extraData[n4][this.lastPathIndex][1])) continue block28;
                        n2 = 1;
                        int n8 = n4;
                        this.activePicks[n8] = this.activePicks[n8] + 1;
                        continue block28;
                    }
                    case 6: 
                    case 7: {
                        if (!boundingVolume.checkIntersectionCone(this.start[n4][this.lastPathIndex], this.end[n4][this.lastPathIndex], this.extraData[n4][this.lastPathIndex][0])) continue block28;
                        n2 = 1;
                        int n9 = n4;
                        this.activePicks[n9] = this.activePicks[n9] + 1;
                        continue block28;
                    }
                    case 8: {
                        if (!boundingVolume.checkIntersectionBox(this.start[n4][this.lastPathIndex], this.end[n4][this.lastPathIndex])) continue block28;
                        n2 = 1;
                        int n10 = n4;
                        this.activePicks[n10] = this.activePicks[n10] + 1;
                        continue block28;
                    }
                    case 10: {
                        if (boundingVolume.checkIntersectionFrustum(this.frustumPlanes[n4], this.transformPath[this.lastPathIndex]) != 0) continue block28;
                        n2 = 1;
                        int n11 = n4;
                        this.activePicks[n11] = this.activePicks[n11] + 1;
                        continue block28;
                    }
                    case 9: {
                        if (!boundingVolume.checkIntersectionSphere(this.start[n4][this.lastPathIndex], this.extraData[n4][this.lastPathIndex][0])) continue block28;
                        n2 = 1;
                        int n12 = n4;
                        this.activePicks[n12] = this.activePicks[n12] + 1;
                        continue block28;
                    }
                }
            }
            if (n2 == 0) continue;
            this.descendTree(pickTargetArray[i], pickRequestArray, n);
            for (n4 = 0; n4 < n; ++n4) {
                if (this.activePicks[n4] <= this.lastPathIndex) continue;
                int n13 = n4;
                this.activePicks[n13] = this.activePicks[n13] - 1;
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
    }

    private void descendSingleTree(SinglePickTarget singlePickTarget, PickRequest[] pickRequestArray, int n) {
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (!singlePickTarget.checkPickMask(pickRequestArray[i].pickType)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        this.resizePath();
        this.validTransform[this.lastPathIndex] = false;
        this.pickPath[this.lastPathIndex] = singlePickTarget;
        ++this.lastPathIndex;
        PickTarget pickTarget = singlePickTarget.getPickableChild();
        switch (pickTarget.getPickTargetType()) {
            case 1: {
                this.descendTree((GroupPickTarget)pickTarget, pickRequestArray, n);
                break;
            }
            case 2: {
                this.descendSingleTree((SinglePickTarget)pickTarget, pickRequestArray, n);
                break;
            }
            case 3: {
                this.testLeaf((LeafPickTarget)pickTarget, pickRequestArray, n);
            }
        }
        --this.lastPathIndex;
        this.pickPath[this.lastPathIndex] = null;
    }

    private void testLeaf(LeafPickTarget leafPickTarget, PickRequest[] pickRequestArray, int n) {
        BoundingVolume boundingVolume = leafPickTarget.getPickableBounds();
        for (int i = 0; i < n; ++i) {
            if (this.activePicks[i] < this.lastPathIndex || !leafPickTarget.checkPickMask(pickRequestArray[i].pickType) || pickRequestArray[i].pickSortType == 2 && pickRequestArray[i].pickCount == 1) continue;
            boolean bl = false;
            switch (pickRequestArray[i].pickGeometryType) {
                case 1: {
                    bl = boundingVolume.checkIntersectionPoint(this.start[i][this.lastPathIndex]);
                    break;
                }
                case 2: {
                    if (!boundingVolume.checkIntersectionRay(this.start[i][this.lastPathIndex], this.end[i][this.lastPathIndex])) break;
                    if (pickRequestArray[i].useGeometry) {
                        boolean bl2 = pickRequestArray[i].pickSortType == 4 || pickRequestArray[i].pickSortType == 3;
                        bl = leafPickTarget.pickLineRay(this.start[i][this.lastPathIndex], this.end[i][this.lastPathIndex], bl2, this.vertexPickData, 0);
                        bl = true;
                        break;
                    }
                    bl = true;
                    break;
                }
                case 3: {
                    if (!boundingVolume.checkIntersectionSegment(this.start[i][this.lastPathIndex], this.end[i][this.lastPathIndex])) break;
                    if (pickRequestArray[i].useGeometry) {
                        boolean bl3 = pickRequestArray[i].pickSortType == 4 || pickRequestArray[i].pickSortType == 3;
                        bl = leafPickTarget.pickLineSegment(this.start[i][this.lastPathIndex], this.end[i][this.lastPathIndex], bl3, this.vertexPickData, 0);
                        bl = true;
                        break;
                    }
                    bl = true;
                    break;
                }
                case 4: 
                case 5: {
                    bl = boundingVolume.checkIntersectionCylinder(this.start[i][this.lastPathIndex], this.end[i][this.lastPathIndex], this.extraData[i][this.lastPathIndex][0], this.extraData[i][this.lastPathIndex][1]);
                    break;
                }
                case 6: 
                case 7: {
                    bl = boundingVolume.checkIntersectionCone(this.start[i][this.lastPathIndex], this.end[i][this.lastPathIndex], this.extraData[i][this.lastPathIndex][0]);
                    break;
                }
                case 8: {
                    bl = boundingVolume.checkIntersectionBox(this.start[i][this.lastPathIndex], this.end[i][this.lastPathIndex]);
                    break;
                }
                case 10: {
                    bl = boundingVolume.checkIntersectionFrustum(this.frustumPlanes[i], this.transformPath[this.lastPathIndex]) == 0;
                    break;
                }
                case 9: {
                    bl = boundingVolume.checkIntersectionSphere(this.start[i][this.lastPathIndex], this.extraData[i][this.lastPathIndex][0]);
                    break;
                }
            }
            if (!bl) continue;
            this.resizePath();
            this.pickPath[this.lastPathIndex] = leafPickTarget;
            this.validTransform[this.lastPathIndex] = false;
            ++this.lastPathIndex;
            SceneGraphPath sceneGraphPath = null;
            switch (pickRequestArray[i].pickSortType) {
                case 1: 
                case 3: {
                    ArrayList arrayList = (ArrayList)pickRequestArray[i].foundPaths;
                    if (pickRequestArray[i].pickCount >= arrayList.size()) {
                        sceneGraphPath = new SceneGraphPath();
                        arrayList.add(sceneGraphPath);
                        break;
                    }
                    sceneGraphPath = (SceneGraphPath)arrayList.get(pickRequestArray[i].pickCount);
                    break;
                }
                case 2: 
                case 4: {
                    sceneGraphPath = (SceneGraphPath)pickRequestArray[i].foundPaths;
                }
            }
            if (pickRequestArray[i].generateVWorldMatrix) {
                this.matrixUtils.inverse(this.transformPath[this.lastPathIndex - 1], this.vworldMatrix);
            } else {
                this.vworldMatrix.setIdentity();
            }
            sceneGraphPath.updatePath(this.pickPath, this.lastPathIndex, this.transformPath[this.lastPathIndex - 1], this.vworldMatrix);
            ++pickRequestArray[i].pickCount;
            --this.lastPathIndex;
        }
    }

    private final void resizePath() {
        if (this.lastPathIndex == this.pickPath.length) {
            int n = this.pickPath.length;
            int n2 = n + 8;
            PickTarget[] pickTargetArray = new PickTarget[n2];
            System.arraycopy(this.pickPath, 0, pickTargetArray, 0, n);
            this.pickPath = pickTargetArray;
            Matrix4f[] matrix4fArray = new Matrix4f[n2];
            System.arraycopy(this.transformPath, 0, matrix4fArray, 0, n);
            this.transformPath = matrix4fArray;
            for (int i = n; i < n2; ++i) {
                this.transformPath[i] = new Matrix4f();
            }
            boolean[] blArray = new boolean[n2];
            System.arraycopy(this.validTransform, 0, blArray, 0, n);
            this.validTransform = blArray;
        }
    }

    private void resizeForBatch(int n) {
        if (n <= this.activePicks.length) {
            return;
        }
        this.activePicks = new int[n];
        int n2 = this.lastPathIndex == 0 ? 32 : this.lastPathIndex;
        this.start = new float[n][n2][3];
        this.end = new float[n][n2][3];
        this.extraData = new float[n][n2][2];
        this.frustumPlanes = new Vector4f[n][6];
        for (int i = 0; i < n; ++i) {
            this.frustumPlanes[i][0] = new Vector4f();
            this.frustumPlanes[i][1] = new Vector4f();
            this.frustumPlanes[i][2] = new Vector4f();
            this.frustumPlanes[i][3] = new Vector4f();
            this.frustumPlanes[i][4] = new Vector4f();
            this.frustumPlanes[i][5] = new Vector4f();
        }
    }

    private void transform(Matrix4f matrix4f, float[] fArray, float[] fArray2) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        fArray2[0] = f * matrix4f.m00 + f2 * matrix4f.m01 + f3 * matrix4f.m02 + matrix4f.m03;
        fArray2[1] = f * matrix4f.m10 + f2 * matrix4f.m11 + f3 * matrix4f.m12 + matrix4f.m13;
        fArray2[2] = f * matrix4f.m20 + f2 * matrix4f.m21 + f3 * matrix4f.m22 + matrix4f.m23;
    }

    private void transformNormal(Matrix4f matrix4f, float[] fArray, float[] fArray2) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        fArray2[0] = f * matrix4f.m00 + f2 * matrix4f.m01 + f3 * matrix4f.m02;
        fArray2[1] = f * matrix4f.m10 + f2 * matrix4f.m11 + f3 * matrix4f.m12;
        fArray2[2] = f * matrix4f.m20 + f2 * matrix4f.m21 + f3 * matrix4f.m22;
    }
}

