/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.management;

import org.j3d.aviatrix3d.management.PipelineStateObserver;
import org.j3d.aviatrix3d.pipeline.audio.AudioOutputDevice;
import org.j3d.aviatrix3d.pipeline.audio.AudioRenderPipeline;

class AudioPipelineThread
extends Thread {
    private boolean terminate;
    private AudioRenderPipeline pipeline;
    private PipelineStateObserver observer;
    private Object displayLock;
    private boolean waiting;
    private boolean noProcessing;

    AudioPipelineThread(AudioRenderPipeline audioRenderPipeline) {
        super("Aviatrix3D audio pipeline");
        this.pipeline = audioRenderPipeline;
        this.terminate = false;
        this.waiting = false;
        this.noProcessing = false;
        this.displayLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = true;
        while (!this.terminate && bl) {
            try {
                Object object;
                boolean bl2 = this.noProcessing ? this.pipeline.displayOnly() : this.pipeline.render();
                if (this.terminate) break;
                if (bl2 && (object = this.pipeline.getAudioOutputDevice()).isDisposed()) {
                    bl = false;
                }
                if (this.terminate) break;
                object = this.displayLock;
                synchronized (object) {
                    if (this.observer != null) {
                        this.observer.frameFinished();
                    }
                    if (this.terminate) {
                        break;
                    }
                    this.displayLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void halt() {
        this.pipeline.halt();
        try {
            Object object = this.displayLock;
            synchronized (object) {
                if (this.observer != null) {
                    this.observer.frameFinished();
                }
                this.displayLock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayOnly() {
        this.noProcessing = true;
        Object object = this.displayLock;
        synchronized (object) {
            this.displayLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void render() {
        this.noProcessing = false;
        Object object = this.displayLock;
        synchronized (object) {
            this.displayLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.terminate = true;
        AudioOutputDevice audioOutputDevice = this.pipeline.getAudioOutputDevice();
        audioOutputDevice.dispose();
        Object object = this.displayLock;
        synchronized (object) {
            this.displayLock.notify();
        }
    }

    void setStateObserver(PipelineStateObserver pipelineStateObserver) {
        this.observer = pipelineStateObserver;
    }
}

