/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d.iutil;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.iutil.SubTextureUpdateListener;
import org.j3d.aviatrix3d.iutil.TextureUpdateData;

public class TextureUpdateStateManager
implements SubTextureUpdateListener {
    private static final int PENDING_LIST_INC = 10;
    public static final int UPDATE_BUFFER_ALL = 1;
    public static final int UPDATE_BUFFER_LAST = 2;
    public static final int UPDATE_DISCARD_OVERWRITES = 3;
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private ArrayList<Entry> entryCache;
    private ArrayList<TextureUpdateData> updateObjectCache;
    private int format;
    private int updateStrategy;

    public TextureUpdateStateManager(int n) {
        this(n, 2, 0.9f);
    }

    public TextureUpdateStateManager(int n, int n2, float f) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n2 == 0) {
            n2 = 1;
        }
        this.updateStrategy = n;
        this.loadFactor = f;
        this.table = new Entry[n2];
        this.threshold = (int)((float)n2 * f);
        this.entryCache = new ArrayList(n2);
        this.updateObjectCache = new ArrayList(n2);
    }

    public void textureUpdated(int n, int n2, int n3, int n4, int n5, int n6, int n7, byte[] byArray) {
        switch (this.updateStrategy) {
            case 1: {
                this.updateAppend(n, n2, n4, n5, n7, byArray);
                break;
            }
            case 2: {
                this.updateReplace(n, n2, n4, n5, n7, byArray);
                break;
            }
            case 3: {
                this.updateOverlap(n, n2, n4, n5, n7, byArray);
            }
        }
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public void setTextureFormat(int n) {
        this.format = n;
    }

    public void setUpdateStrategy(int n) {
        this.updateStrategy = n;
    }

    public int getNumUpdatesPending(GL gL) {
        Entry[] entryArray = this.table;
        int n = gL.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n) {
                return entry.numUpdatesPending;
            }
            entry = entry.next;
        }
        return 0;
    }

    public TextureUpdateData[] getUpdatesAndClear(GL gL) {
        Entry[] entryArray = this.table;
        int n = gL.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n) {
                entry.numUpdatesPending = 0;
                return entry.updatesPending;
            }
            entry = entry.next;
        }
        return null;
    }

    public void addContext(GL gL) {
        Entry[] entryArray = this.table;
        int n = gL.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n) {
                return;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entry = this.getNewEntry();
        entry.hash = n;
        entry.numUpdatesPending = 0;
        entry.next = entryArray[n2];
        if (entry.updatesPending == null) {
            entry.updatesPending = new TextureUpdateData[1];
        }
        entryArray[n2] = entry;
        ++this.count;
    }

    public void removeContext(GL gL) {
        Entry[] entryArray = this.table;
        int n = gL.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                this.releaseEntry(entry);
            }
            entry2 = entry;
            entry = entry.next;
        }
    }

    public void clear() {
        if (this.count == 0) {
            return;
        }
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            Entry entry = entryArray[n];
            if (entry == null) continue;
            while (entry.next != null) {
                this.releaseEntry(entry);
                Entry entry2 = entry.next;
                entry.next = null;
                entry = entry2;
            }
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public void clearPendingUpdates() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                for (int i = 0; i < entry.numUpdatesPending; ++i) {
                    this.releaseUpdate(entry.updatesPending[i]);
                    entry.updatesPending[i] = null;
                }
                entry.numUpdatesPending = 0;
                entry = entry.next;
            }
        }
    }

    private void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    private void updateReplace(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        Entry[] entryArray = this.table;
        int n6 = entryArray.length;
        while (--n6 >= 0) {
            Entry entry = entryArray[n6];
            while (entry != null) {
                TextureUpdateData textureUpdateData;
                if (entry.updatesPending[0] != null) {
                    textureUpdateData = entry.updatesPending[0];
                } else {
                    entry.updatesPending[0] = textureUpdateData = this.getNewUpdate();
                }
                textureUpdateData.x = n;
                textureUpdateData.y = n2;
                textureUpdateData.width = n3;
                textureUpdateData.height = n4;
                textureUpdateData.level = n5;
                textureUpdateData.format = this.format;
                this.copyPixels(textureUpdateData, byArray);
                entry.numUpdatesPending = 1;
                entry = entry.next;
            }
        }
    }

    private void updateOverlap(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        boolean bl = false;
        Entry[] entryArray = this.table;
        int n6 = entryArray.length;
        while (--n6 >= 0) {
            Entry entry = entryArray[n6];
            while (entry != null) {
                TextureUpdateData textureUpdateData;
                for (int i = 0; i < entry.numUpdatesPending; ++i) {
                    TextureUpdateData textureUpdateData2 = entry.updatesPending[i];
                    if (n5 != textureUpdateData2.level || n > textureUpdateData2.x || n2 > textureUpdateData2.y || n + n3 < textureUpdateData2.x + textureUpdateData2.width || n2 + n4 < textureUpdateData2.y + textureUpdateData2.height) continue;
                    if (bl) {
                        System.arraycopy(entry.updatesPending, i + 1, entry.updatesPending, i, entry.numUpdatesPending - i - 1);
                        --entry.numUpdatesPending;
                        continue;
                    }
                    textureUpdateData2.x = n;
                    textureUpdateData2.y = n2;
                    textureUpdateData2.width = n3;
                    textureUpdateData2.height = n4;
                    textureUpdateData2.level = n5;
                    textureUpdateData2.format = this.format;
                    bl = true;
                    this.copyPixels(textureUpdateData2, byArray);
                }
                if (bl) continue;
                this.checkUpdateListSize(entry);
                if (entry.updatesPending[entry.numUpdatesPending] == null) {
                    entry.updatesPending[entry.numUpdatesPending] = textureUpdateData = this.getNewUpdate();
                } else {
                    textureUpdateData = entry.updatesPending[entry.numUpdatesPending];
                }
                textureUpdateData.x = n;
                textureUpdateData.y = n2;
                textureUpdateData.width = n3;
                textureUpdateData.height = n4;
                textureUpdateData.level = n5;
                textureUpdateData.format = this.format;
                this.copyPixels(textureUpdateData, byArray);
            }
        }
    }

    private void updateAppend(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        Entry[] entryArray = this.table;
        int n6 = entryArray.length;
        while (--n6 >= 0) {
            Entry entry = entryArray[n6];
            while (entry != null) {
                TextureUpdateData textureUpdateData;
                this.checkUpdateListSize(entry);
                if (entry.updatesPending[entry.numUpdatesPending] == null) {
                    entry.updatesPending[entry.numUpdatesPending] = textureUpdateData = this.getNewUpdate();
                } else {
                    textureUpdateData = entry.updatesPending[entry.numUpdatesPending];
                }
                textureUpdateData.x = n;
                textureUpdateData.y = n2;
                textureUpdateData.width = n3;
                textureUpdateData.height = n4;
                textureUpdateData.level = n5;
                textureUpdateData.format = this.format;
                this.copyPixels(textureUpdateData, byArray);
                entry = entry.next;
            }
        }
    }

    private void copyPixels(TextureUpdateData textureUpdateData, byte[] byArray) {
        int n = textureUpdateData.width * textureUpdateData.height * this.bytesPerPixel();
        if (textureUpdateData.pixels == null || n > textureUpdateData.pixels.capacity()) {
            textureUpdateData.pixels = ByteBuffer.allocateDirect(n);
            textureUpdateData.pixels.order(ByteOrder.nativeOrder());
        }
        textureUpdateData.pixels.clear();
        textureUpdateData.pixels.put(byArray, 0, n);
    }

    private int bytesPerPixel() {
        int n = 4;
        switch (this.format) {
            case 6407: 
            case 32992: {
                n = 3;
                break;
            }
            case 6408: 
            case 32993: {
                n = 4;
                break;
            }
            case 6410: {
                n = 2;
                break;
            }
            case 6406: 
            case 6409: 
            case 32841: {
                n = 1;
            }
        }
        return n;
    }

    private Entry getNewEntry() {
        int n = this.entryCache.size();
        Entry entry = n == 0 ? new Entry() : this.entryCache.remove(n - 1);
        return entry;
    }

    private void releaseEntry(Entry entry) {
        entry.numUpdatesPending = 0;
        this.entryCache.add(entry);
    }

    private TextureUpdateData getNewUpdate() {
        int n = this.updateObjectCache.size();
        TextureUpdateData textureUpdateData = n == 0 ? new TextureUpdateData() : this.updateObjectCache.remove(n - 1);
        return textureUpdateData;
    }

    private void releaseUpdate(TextureUpdateData textureUpdateData) {
        this.updateObjectCache.add(textureUpdateData);
    }

    private void checkUpdateListSize(Entry entry) {
        if (entry.numUpdatesPending < entry.updatesPending.length) {
            return;
        }
        int n = entry.updatesPending.length;
        int n2 = n + 10;
        TextureUpdateData[] textureUpdateDataArray = new TextureUpdateData[n2];
        System.arraycopy(entry.updatesPending, 0, textureUpdateDataArray, 0, n);
        entry.updatesPending = textureUpdateDataArray;
    }

    private static class Entry {
        int hash;
        TextureUpdateData[] updatesPending;
        int numUpdatesPending;
        Entry next;

        private Entry() {
        }
    }
}

