/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.SceneGraphObject;

public abstract class Viewport
extends SceneGraphObject {
    public static final int SIMPLE = 0;
    public static final int COMPOSITE = 1;
    public static final int MULTIPASS = 2;
    public static final int FLAT = 3;
    protected final int viewportType;
    protected int viewX;
    protected int viewY;
    protected int viewWidth;
    protected int viewHeight;
    private boolean valid;

    protected Viewport(int n) {
        this.viewportType = n;
        this.valid = false;
    }

    public void setDimensions(int n, int n2, int n3, int n4) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.viewX = n;
        this.viewY = n2;
        this.viewWidth = n3;
        this.viewHeight = n4;
        this.valid = n3 > 0 && n4 > 0 && n + n3 > 0 && n2 + n4 > 0;
    }

    public void getDimensions(int[] nArray) {
        nArray[0] = this.viewX;
        nArray[1] = this.viewY;
        nArray[2] = this.viewWidth;
        nArray[3] = this.viewHeight;
    }

    public int getX() {
        return this.viewX;
    }

    public int getY() {
        return this.viewY;
    }

    public int getWidth() {
        return this.viewWidth;
    }

    public int getHeight() {
        return this.viewHeight;
    }

    public int getType() {
        return this.viewportType;
    }

    public boolean isValid() {
        return this.valid;
    }

    boolean hasParent() {
        return this.updateHandler != null;
    }
}

