/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Leaf;
import org.j3d.aviatrix3d.rendering.Cullable;
import org.j3d.aviatrix3d.rendering.EnvironmentCullable;
import org.j3d.aviatrix3d.rendering.ObjectRenderable;
import org.j3d.aviatrix3d.rendering.Renderable;

public class Viewpoint
extends Leaf
implements ObjectRenderable,
EnvironmentCullable {
    private static final float[] DIR_LOCATION = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
    private static final float[] SPOT_LOCATION = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    private static final float[] DEFAULT_AMBIENT = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
    private boolean useHeadlight = false;
    private boolean useDirectionalLight = true;
    private boolean useGlobalAmbient = false;
    private float[] globalColor;

    public Cullable getCullableParent() {
        return this.parent instanceof Cullable ? (Cullable)((Object)this.parent) : null;
    }

    public Renderable getRenderable() {
        return this;
    }

    public void render(GL gL) {
        if (this.useHeadlight) {
            gL.glEnable(16384);
            if (!this.useDirectionalLight) {
                gL.glLightfv(16384, 4611, SPOT_LOCATION, 0);
                gL.glLightf(16384, 4614, 45.0f);
            } else {
                gL.glLightfv(16384, 4611, DIR_LOCATION, 0);
            }
        } else {
            gL.glDisable(16384);
        }
        if (this.useGlobalAmbient) {
            gL.glLightModelfv(2899, this.globalColor, 0);
        }
    }

    public void postRender(GL gL) {
        if (this.useHeadlight) {
            gL.glDisable(16384);
        } else {
            gL.glEnable(16384);
        }
        if (this.useGlobalAmbient) {
            gL.glLightModelfv(2899, DEFAULT_AMBIENT, 0);
        }
    }

    protected void markBoundsDirty() {
    }

    public int compareTo(Object object) throws ClassCastException {
        Viewpoint viewpoint = (Viewpoint)object;
        return this.compareTo(viewpoint);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Viewpoint)) {
            return false;
        }
        return this.equals((Viewpoint)object);
    }

    public boolean isHeadlightEnabled() {
        return this.useHeadlight;
    }

    public void setHeadlightEnabled(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.useHeadlight = bl;
    }

    public void setGlobalAmbientLightEnabled(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.useGlobalAmbient = bl;
        if (this.globalColor == null) {
            this.globalColor = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
        }
    }

    public boolean isGlobalAmbientLightEnabled() {
        return this.useGlobalAmbient;
    }

    public void setGlobalAmbientColor(float[] fArray) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (fArray[0] < 0.0f || fArray[0] > 1.0f) {
            throw new IllegalArgumentException("Red component out of range");
        }
        if (fArray[1] < 0.0f || fArray[1] > 1.0f) {
            throw new IllegalArgumentException("Green component out of range");
        }
        if (fArray[2] < 0.0f || fArray[2] > 1.0f) {
            throw new IllegalArgumentException("Blue component out of range");
        }
        this.globalColor[0] = fArray[0];
        this.globalColor[1] = fArray[1];
        this.globalColor[2] = fArray[2];
    }

    public void getGlobalAmbientColor(float[] fArray) {
        fArray[0] = this.globalColor[0];
        fArray[1] = this.globalColor[1];
        fArray[2] = this.globalColor[2];
    }

    public boolean isDirectionalLight() {
        return this.useDirectionalLight;
    }

    public void setHeadlightType(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.useDirectionalLight = bl;
    }

    public int compareTo(Viewpoint viewpoint) {
        if (viewpoint == null) {
            return 1;
        }
        if (viewpoint == this) {
            return 0;
        }
        if (this.useDirectionalLight != viewpoint.useDirectionalLight) {
            return !this.useDirectionalLight ? -1 : 1;
        }
        if (this.useGlobalAmbient != viewpoint.useGlobalAmbient) {
            return !this.useGlobalAmbient ? -1 : 1;
        }
        int n = this.compareColor4(this.globalColor, viewpoint.globalColor);
        if (n != 0) {
            return n;
        }
        return 0;
    }

    public boolean equals(Viewpoint viewpoint) {
        if (viewpoint == this) {
            return true;
        }
        if (viewpoint == null || this.useDirectionalLight != viewpoint.useDirectionalLight || this.useGlobalAmbient != viewpoint.useGlobalAmbient) {
            return false;
        }
        return this.equalsColor4(this.globalColor, viewpoint.globalColor);
    }

    private int compareColor4(float[] fArray, float[] fArray2) {
        if (fArray[0] < fArray2[0]) {
            return -1;
        }
        if (fArray[0] > fArray2[0]) {
            return 1;
        }
        if (fArray[1] < fArray2[1]) {
            return -1;
        }
        if (fArray[1] > fArray2[1]) {
            return 1;
        }
        if (fArray[2] < fArray2[2]) {
            return -1;
        }
        if (fArray[2] > fArray2[2]) {
            return 1;
        }
        if (fArray[3] < fArray2[3]) {
            return -1;
        }
        if (fArray[3] > fArray2[3]) {
            return 1;
        }
        return 0;
    }

    private boolean equalsColor4(float[] fArray, float[] fArray2) {
        return fArray[0] == fArray2[0] && fArray[1] == fArray2[1] && fArray[2] == fArray2[2] && fArray[3] == fArray2[3];
    }
}

