/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.vecmath.Point3f;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.rendering.ViewEnvironmentCullable;

public class ViewEnvironment
extends SceneGraphObject
implements ViewEnvironmentCullable {
    private static final String INVALID_PROJECTION_MSG = "Invalid projection type provided. Must be one of ORTHOGRAPHIC_PROJECTION or PERSPECTIVE_PROJECTION";
    private static final String INVALID_FOV_MSG = "The field of view angle provided is invalid. Must be between 0 and 180";
    private static final String NEGATIVE_CLIP_MSG = "The clip distance provided is negative, which is not allowed for perspective projection.";
    private static final String INVERT_CLIP_MSG = "The near clip plane is greater than the far clip plane";
    public static final int PERSPECTIVE_PROJECTION = 1;
    public static final int ORTHOGRAPHIC_PROJECTION = 2;
    public static final int INFINITE_PROJECTION = 3;
    public static final int CUSTOM_PROJECTION = 4;
    public static final int VIEW_X = 0;
    public static final int VIEW_Y = 1;
    public static final int VIEW_WIDTH = 2;
    public static final int VIEW_HEIGHT = 3;
    private boolean useStereo = false;
    private int projectionType = 1;
    private double fov = 45.0;
    private double nearClip = 0.01;
    private double farClip = 1000.0;
    private double aspectRatio = 0.0;
    private int[] viewportSize = new int[4];
    private double[] viewFrustum = new double[6];
    private double orthoLeft = -1.0;
    private double orthoRight = 1.0;
    private double orthoBottom = -1.0;
    private double orthoTop = 1.0;
    private float[] projectionMatrix = new float[16];
    private boolean frustumChanged = true;

    ViewEnvironment() {
    }

    public boolean isStereoEnabled() {
        return this.useStereo;
    }

    public int getProjectionType() {
        return this.projectionType;
    }

    public int[] getViewportDimensions() {
        return this.viewportSize;
    }

    public void getViewFrustum(double[] dArray) {
        this.generateViewFrustum(dArray);
    }

    public double getFieldOfView() {
        return this.fov;
    }

    public void getProjectionMatrix(float[] fArray) {
        if (this.projectionType == 4) {
            fArray[0] = this.projectionMatrix[0];
            fArray[1] = this.projectionMatrix[1];
            fArray[2] = this.projectionMatrix[2];
            fArray[3] = this.projectionMatrix[3];
            fArray[4] = this.projectionMatrix[4];
            fArray[5] = this.projectionMatrix[5];
            fArray[6] = this.projectionMatrix[6];
            fArray[7] = this.projectionMatrix[7];
            fArray[8] = this.projectionMatrix[8];
            fArray[9] = this.projectionMatrix[9];
            fArray[10] = this.projectionMatrix[10];
            fArray[11] = this.projectionMatrix[11];
            fArray[12] = this.projectionMatrix[12];
            fArray[13] = this.projectionMatrix[13];
            fArray[14] = this.projectionMatrix[14];
            fArray[15] = this.projectionMatrix[15];
        } else {
            if (this.frustumChanged) {
                this.recalcFrustum();
            }
            float f = (float)this.viewFrustum[0];
            float f2 = (float)this.viewFrustum[1];
            float f3 = (float)this.viewFrustum[2];
            float f4 = (float)this.viewFrustum[3];
            float f5 = (float)this.viewFrustum[4];
            float f6 = (float)this.viewFrustum[5];
            switch (this.projectionType) {
                case 1: {
                    float f7 = 2.0f * f5 / (f2 - f);
                    float f8 = 2.0f * f5 / (f4 - f3);
                    float f9 = (f2 + f) / (f2 - f);
                    float f10 = (f4 + f3) / (f4 - f3);
                    float f11 = -(f6 + f5) / (f6 - f5);
                    float f12 = -(2.0f * f6 * f5) / (f6 - f5);
                    this.projectionMatrix[0] = f7;
                    this.projectionMatrix[1] = 0.0f;
                    this.projectionMatrix[2] = f9;
                    this.projectionMatrix[3] = 0.0f;
                    this.projectionMatrix[4] = 0.0f;
                    this.projectionMatrix[5] = f8;
                    this.projectionMatrix[6] = f10;
                    this.projectionMatrix[7] = 0.0f;
                    this.projectionMatrix[8] = 0.0f;
                    this.projectionMatrix[9] = 0.0f;
                    this.projectionMatrix[10] = f11;
                    this.projectionMatrix[11] = f12;
                    this.projectionMatrix[12] = 0.0f;
                    this.projectionMatrix[13] = 0.0f;
                    this.projectionMatrix[14] = -1.0f;
                    this.projectionMatrix[15] = 0.0f;
                    break;
                }
                case 2: {
                    float f13 = 2.0f / (f2 - f);
                    float f14 = 2.0f / (f4 - f3);
                    float f15 = -2.0f / (f6 - f5);
                    float f16 = -(f2 + f) / (f2 - f);
                    float f17 = -(f4 + f3) / (f4 - f3);
                    float f18 = -(f6 + f5) / (f6 - f5);
                    this.projectionMatrix[0] = f13;
                    this.projectionMatrix[1] = 0.0f;
                    this.projectionMatrix[2] = 0.0f;
                    this.projectionMatrix[3] = f16;
                    this.projectionMatrix[4] = 0.0f;
                    this.projectionMatrix[5] = f14;
                    this.projectionMatrix[6] = 0.0f;
                    this.projectionMatrix[7] = f17;
                    this.projectionMatrix[8] = 0.0f;
                    this.projectionMatrix[9] = 0.0f;
                    this.projectionMatrix[10] = f15;
                    this.projectionMatrix[11] = f18;
                    this.projectionMatrix[12] = 0.0f;
                    this.projectionMatrix[13] = 0.0f;
                    this.projectionMatrix[14] = 0.0f;
                    this.projectionMatrix[15] = 1.0f;
                    break;
                }
                case 3: {
                    float f19 = 2.0f * (float)this.nearClip;
                    float f20 = f2 - f;
                    float f21 = f2 + f;
                    float f22 = f4 - f3;
                    float f23 = f4 + f3;
                    this.projectionMatrix[0] = f19 / f20;
                    this.projectionMatrix[1] = 0.0f;
                    this.projectionMatrix[2] = 0.0f;
                    this.projectionMatrix[3] = 0.0f;
                    this.projectionMatrix[4] = 0.0f;
                    this.projectionMatrix[5] = f19 / f22;
                    this.projectionMatrix[6] = 0.0f;
                    this.projectionMatrix[7] = 0.0f;
                    this.projectionMatrix[8] = f21 / f20;
                    this.projectionMatrix[9] = f23 / f22;
                    this.projectionMatrix[10] = -1.0f;
                    this.projectionMatrix[11] = -1.0f;
                    this.projectionMatrix[8] = 0.0f;
                    this.projectionMatrix[9] = 0.0f;
                    this.projectionMatrix[10] = -f19;
                    this.projectionMatrix[11] = 0.0f;
                }
            }
            fArray[0] = this.projectionMatrix[0];
            fArray[1] = this.projectionMatrix[1];
            fArray[2] = this.projectionMatrix[2];
            fArray[3] = this.projectionMatrix[3];
            fArray[4] = this.projectionMatrix[4];
            fArray[5] = this.projectionMatrix[5];
            fArray[6] = this.projectionMatrix[6];
            fArray[7] = this.projectionMatrix[7];
            fArray[8] = this.projectionMatrix[8];
            fArray[9] = this.projectionMatrix[9];
            fArray[10] = this.projectionMatrix[10];
            fArray[11] = this.projectionMatrix[11];
            fArray[12] = this.projectionMatrix[12];
            fArray[13] = this.projectionMatrix[13];
            fArray[14] = this.projectionMatrix[14];
            fArray[15] = this.projectionMatrix[15];
        }
    }

    public void setStereoEnabled(boolean bl) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.useStereo = bl;
        if (this.isLive() && this.updateHandler != null) {
            this.updateHandler.notifyUpdateRequired();
        }
    }

    public void setProjectionType(int n) throws IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException(INVALID_PROJECTION_MSG);
        }
        this.projectionType = n;
        if (this.isLive() && this.updateHandler != null) {
            this.updateHandler.notifyUpdateRequired();
        }
    }

    public void setFieldOfView(double d) throws IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (d <= 0.0 || d > 180.0) {
            throw new IllegalArgumentException(INVALID_FOV_MSG);
        }
        this.fov = d;
        this.frustumChanged = true;
        if (this.isLive() && this.updateHandler != null) {
            this.updateHandler.notifyUpdateRequired();
        }
    }

    public void setAspectRatio(double d) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.aspectRatio = d;
        this.frustumChanged = true;
        if (this.isLive() && this.updateHandler != null) {
            this.updateHandler.notifyUpdateRequired();
        }
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public void setNearClipDistance(double d) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.projectionType == 1 && d < 0.0) {
            throw new IllegalArgumentException(NEGATIVE_CLIP_MSG);
        }
        if (d >= this.farClip) {
            throw new IllegalArgumentException(INVERT_CLIP_MSG);
        }
        this.nearClip = d;
        this.frustumChanged = true;
        if (this.isLive() && this.updateHandler != null) {
            this.updateHandler.notifyUpdateRequired();
        }
    }

    public double getNearClipDistance() {
        return this.nearClip;
    }

    public void setClipDistance(double d, double d2) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.projectionType == 1 && d < 0.0) {
            throw new IllegalArgumentException(NEGATIVE_CLIP_MSG);
        }
        if (this.projectionType == 1 && d2 < 0.0) {
            throw new IllegalArgumentException(NEGATIVE_CLIP_MSG);
        }
        if (d >= d2) {
            throw new IllegalArgumentException(INVERT_CLIP_MSG);
        }
        this.nearClip = d;
        this.farClip = d2;
        this.frustumChanged = true;
        if (this.isLive() && this.updateHandler != null) {
            this.updateHandler.notifyUpdateRequired();
        }
    }

    public void setFarClipDistance(double d) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.projectionType == 1 && d < 0.0) {
            throw new IllegalArgumentException(NEGATIVE_CLIP_MSG);
        }
        if (d <= this.nearClip) {
            throw new IllegalArgumentException(INVERT_CLIP_MSG);
        }
        this.farClip = d;
        this.frustumChanged = true;
        if (this.isLive() && this.updateHandler != null) {
            this.updateHandler.notifyUpdateRequired();
        }
    }

    public void setProjectionMatrix(float[] fArray) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.projectionType = 4;
        this.projectionMatrix[0] = fArray[0];
        this.projectionMatrix[1] = fArray[1];
        this.projectionMatrix[2] = fArray[2];
        this.projectionMatrix[3] = fArray[3];
        this.projectionMatrix[4] = fArray[4];
        this.projectionMatrix[5] = fArray[5];
        this.projectionMatrix[6] = fArray[6];
        this.projectionMatrix[7] = fArray[7];
        this.projectionMatrix[8] = fArray[8];
        this.projectionMatrix[9] = fArray[9];
        this.projectionMatrix[10] = fArray[10];
        this.projectionMatrix[11] = fArray[11];
        this.projectionMatrix[12] = fArray[12];
        this.projectionMatrix[13] = fArray[13];
        this.projectionMatrix[14] = fArray[14];
        this.projectionMatrix[15] = fArray[15];
        this.frustumChanged = true;
        if (this.isLive() && this.updateHandler != null) {
            this.updateHandler.notifyUpdateRequired();
        }
    }

    public double getFarClipDistance() {
        return this.farClip;
    }

    public void setOrthoParams(double d, double d2, double d3, double d4) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.orthoLeft = d;
        this.orthoRight = d2;
        this.orthoBottom = d3;
        this.orthoTop = d4;
        this.frustumChanged = true;
        if (this.isLive() && this.updateHandler != null) {
            this.updateHandler.notifyUpdateRequired();
        }
    }

    public void generateViewFrustum(double[] dArray) {
        if (this.frustumChanged) {
            this.recalcFrustum();
        }
        dArray[0] = this.viewFrustum[0];
        dArray[1] = this.viewFrustum[1];
        dArray[2] = this.viewFrustum[2];
        dArray[3] = this.viewFrustum[3];
        dArray[4] = this.viewFrustum[4];
        dArray[5] = this.viewFrustum[5];
    }

    public void getPixelLocationInSurface(float f, float f2, Point3f point3f) {
        this.getPixelLocationInSurface(f, f2, null, point3f);
    }

    public void getPixelLocationInSurface(float f, float f2, Point3f point3f, Point3f point3f2) {
        if (this.viewportSize[2] == 0) {
            return;
        }
        if (this.frustumChanged) {
            this.recalcFrustum();
        }
        if (point3f != null) {
            double d = this.viewFrustum[0] - (double)point3f.x;
            double d2 = this.viewFrustum[1] - (double)point3f.x;
            double d3 = this.viewFrustum[2] - (double)point3f.y;
            double d4 = this.viewFrustum[3] - (double)point3f.y;
            double d5 = this.viewFrustum[4] - (double)point3f.z;
            point3f2.x = (float)((d2 - d) * (double)(f / (float)this.viewportSize[2] - 0.5f));
            point3f2.y = (float)((d4 - d3) * (double)(((float)this.viewportSize[3] - f2) / (float)this.viewportSize[3] - 0.5f));
            point3f2.z = (float)(-d5);
        } else {
            point3f2.x = (float)((this.viewFrustum[1] - this.viewFrustum[0]) * (double)(f / (float)this.viewportSize[2] - 0.5f));
            point3f2.y = (float)((this.viewFrustum[3] - this.viewFrustum[2]) * (double)(((float)this.viewportSize[3] - f2) / (float)this.viewportSize[3] - 0.5f));
            point3f2.z = (float)(-this.viewFrustum[4]);
        }
    }

    void setViewportDimensions(int n, int n2, int n3, int n4) {
        this.viewportSize[0] = n;
        this.viewportSize[1] = n2;
        this.viewportSize[2] = n3;
        this.viewportSize[3] = n4;
        this.frustumChanged = true;
        if (this.isLive() && this.updateHandler != null) {
            this.updateHandler.notifyUpdateRequired();
        }
    }

    private void recalcFrustum() {
        switch (this.projectionType) {
            case 2: {
                this.viewFrustum[0] = this.orthoLeft;
                this.viewFrustum[1] = this.orthoRight;
                this.viewFrustum[2] = this.orthoBottom;
                this.viewFrustum[3] = this.orthoTop;
                this.viewFrustum[4] = this.nearClip;
                this.viewFrustum[5] = this.farClip;
                break;
            }
            case 1: 
            case 3: {
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                d4 = this.nearClip * Math.tan(this.fov * Math.PI / 360.0);
                d3 = -d4;
                if (this.aspectRatio <= 0.0) {
                    double d5 = (double)this.viewportSize[2] / (double)this.viewportSize[3];
                    d = d3 * d5;
                    d2 = d4 * d5;
                } else {
                    d = d3 * this.aspectRatio;
                    d2 = d4 * this.aspectRatio;
                }
                this.viewFrustum[0] = d;
                this.viewFrustum[1] = d2;
                this.viewFrustum[2] = d3;
                this.viewFrustum[3] = d4;
                this.viewFrustum[4] = this.nearClip;
                this.viewFrustum[5] = this.farClip;
                break;
            }
            case 4: {
                this.viewFrustum[0] = 0.0;
                this.viewFrustum[1] = 0.0;
                this.viewFrustum[2] = 0.0;
                this.viewFrustum[3] = 0.0;
                this.viewFrustum[4] = 0.0;
                this.viewFrustum[5] = 0.0;
            }
        }
        this.frustumChanged = false;
    }
}

