/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.VertexGeometry;
import org.j3d.aviatrix3d.picking.NotPickableException;

public class TriangleFanArray
extends VertexGeometry {
    private static final String MIN_COUNT_MSG = "A fan with less than 3 vertices is specified at index ";
    private static final String TOTAL_COUNT_MSG = "The total requested indexes in the fan is greater than the number of valid vertices provided.";
    private int[] fanCounts;
    private int numFans;

    public TriangleFanArray() {
        this.initPolygonDetails(3);
    }

    public TriangleFanArray(boolean bl, int n) {
        super(bl, n);
        this.initPolygonDetails(3);
    }

    public void render(GL gL) {
        if (this.numFans == 0 || (this.vertexFormat & 7) == 0) {
            return;
        }
        this.setVertexState(gL);
        int n = 0;
        for (int i = 0; i < this.numFans; ++i) {
            gL.glDrawArrays(6, n, this.fanCounts[i]);
            n += this.fanCounts[i];
        }
        this.clearVertexState(gL);
    }

    protected boolean isVisible() {
        return super.isVisible() && this.numFans != 0;
    }

    public boolean pickLineSegment(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineSegment(fArray, fArray2, bl, fArray3, n);
        float f = Float.POSITIVE_INFINITY;
        boolean bl2 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = fArray2[0];
        float f6 = fArray2[1];
        float f7 = fArray2[2];
        float f8 = fArray2[0] - fArray[0];
        float f9 = fArray2[1] - fArray[1];
        float f10 = fArray2[2] - fArray[2];
        float f11 = (float)Math.sqrt(f8 * f8 + f9 * f9 + f10 * f10);
        fArray2[0] = f8;
        fArray2[1] = f9;
        fArray2[2] = f10;
        int n2 = 0;
        int n3 = this.vertexFormat & 7;
        for (int i = 0; i < this.numFans; ++i) {
            int n4 = this.fanCounts[i] - 2;
            switch (n3) {
                case 2: {
                    this.wkPolygon[0] = this.coordinates[n2];
                    this.wkPolygon[1] = this.coordinates[n2 + 1];
                    this.wkPolygon[2] = 0.0f;
                    n2 += 2;
                    break;
                }
                case 3: {
                    this.wkPolygon[0] = this.coordinates[n2];
                    this.wkPolygon[1] = this.coordinates[n2 + 1];
                    this.wkPolygon[2] = this.coordinates[n2 + 2];
                    n2 += 3;
                    break;
                }
                case 4: {
                    this.wkPolygon[0] = this.coordinates[n2];
                    this.wkPolygon[1] = this.coordinates[n2 + 1];
                    this.wkPolygon[2] = this.coordinates[n2 + 2];
                    n2 += 4;
                }
            }
            for (int j = 0; j < n4; ++j) {
                switch (n3) {
                    case 2: {
                        this.wkPolygon[3] = this.coordinates[n2];
                        this.wkPolygon[4] = this.coordinates[n2 + 1];
                        this.wkPolygon[5] = 0.0f;
                        this.wkPolygon[6] = this.coordinates[n2 + 2];
                        this.wkPolygon[7] = this.coordinates[n2 + 3];
                        this.wkPolygon[8] = 0.0f;
                        n2 += 2;
                        break;
                    }
                    case 3: {
                        this.wkPolygon[3] = this.coordinates[n2];
                        this.wkPolygon[4] = this.coordinates[n2 + 1];
                        this.wkPolygon[5] = this.coordinates[n2 + 2];
                        this.wkPolygon[6] = this.coordinates[n2 + 3];
                        this.wkPolygon[7] = this.coordinates[n2 + 4];
                        this.wkPolygon[8] = this.coordinates[n2 + 5];
                        n2 += 3;
                        break;
                    }
                    case 4: {
                        this.wkPolygon[3] = this.coordinates[n2];
                        this.wkPolygon[4] = this.coordinates[n2 + 1];
                        this.wkPolygon[5] = this.coordinates[n2 + 2];
                        this.wkPolygon[6] = this.coordinates[n2 + 4];
                        this.wkPolygon[7] = this.coordinates[n2 + 5];
                        this.wkPolygon[8] = this.coordinates[n2 + 6];
                        n2 += 4;
                    }
                }
                if (!this.ray3DTriangleChecked(fArray, fArray2, f11, fArray3)) continue;
                bl2 = true;
                if (bl) break;
                float f12 = fArray[0] - fArray3[0];
                float f13 = fArray[1] - fArray3[1];
                float f14 = fArray[2] - fArray3[2];
                float f15 = f12 * f12 + f13 * f13 + f14 * f14;
                if (!(f15 < f)) continue;
                f = f15;
                f2 = fArray3[0];
                f3 = fArray3[1];
                f4 = fArray3[2];
            }
            n2 += n3;
        }
        fArray3[0] = f2;
        fArray3[1] = f3;
        fArray3[2] = f4;
        fArray2[0] = f5;
        fArray2[1] = f6;
        fArray2[2] = f7;
        return bl2;
    }

    public boolean pickLineRay(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineRay(fArray, fArray2, bl, fArray3, n);
        float f = Float.POSITIVE_INFINITY;
        boolean bl2 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n2 = 0;
        int n3 = this.vertexFormat & 7;
        for (int i = 0; i < this.numFans; ++i) {
            int n4 = this.fanCounts[i] - 2;
            switch (n3) {
                case 2: {
                    this.wkPolygon[0] = this.coordinates[n2];
                    this.wkPolygon[1] = this.coordinates[n2 + 1];
                    this.wkPolygon[2] = 0.0f;
                    n2 += 2;
                    break;
                }
                case 3: {
                    this.wkPolygon[0] = this.coordinates[n2];
                    this.wkPolygon[1] = this.coordinates[n2 + 1];
                    this.wkPolygon[2] = this.coordinates[n2 + 2];
                    n2 += 3;
                    break;
                }
                case 4: {
                    this.wkPolygon[0] = this.coordinates[n2];
                    this.wkPolygon[1] = this.coordinates[n2 + 1];
                    this.wkPolygon[2] = this.coordinates[n2 + 2];
                    n2 += 4;
                }
            }
            for (int j = 0; j < n4; ++j) {
                switch (n3) {
                    case 2: {
                        this.wkPolygon[3] = this.coordinates[n2];
                        this.wkPolygon[4] = this.coordinates[n2 + 1];
                        this.wkPolygon[5] = 0.0f;
                        this.wkPolygon[6] = this.coordinates[n2 + 2];
                        this.wkPolygon[7] = this.coordinates[n2 + 3];
                        this.wkPolygon[8] = 0.0f;
                        n2 += 2;
                        break;
                    }
                    case 3: {
                        this.wkPolygon[3] = this.coordinates[n2];
                        this.wkPolygon[4] = this.coordinates[n2 + 1];
                        this.wkPolygon[5] = this.coordinates[n2 + 2];
                        this.wkPolygon[6] = this.coordinates[n2 + 3];
                        this.wkPolygon[7] = this.coordinates[n2 + 4];
                        this.wkPolygon[8] = this.coordinates[n2 + 5];
                        n2 += 3;
                        break;
                    }
                    case 4: {
                        this.wkPolygon[3] = this.coordinates[n2];
                        this.wkPolygon[4] = this.coordinates[n2 + 1];
                        this.wkPolygon[5] = this.coordinates[n2 + 2];
                        this.wkPolygon[6] = this.coordinates[n2 + 4];
                        this.wkPolygon[7] = this.coordinates[n2 + 5];
                        this.wkPolygon[8] = this.coordinates[n2 + 6];
                        n2 += 4;
                    }
                }
                if (!this.ray3DTriangleChecked(fArray, fArray2, 0.0f, fArray3)) continue;
                bl2 = true;
                if (bl) break;
                float f5 = fArray[0] - fArray3[0];
                float f6 = fArray[1] - fArray3[1];
                float f7 = fArray[2] - fArray3[2];
                float f8 = f5 * f5 + f6 * f6 + f7 * f7;
                if (!(f8 < f)) continue;
                f = f8;
                f2 = fArray3[0];
                f3 = fArray3[1];
                f4 = fArray3[2];
            }
            n2 += 3;
        }
        fArray3[0] = f2;
        fArray3[1] = f3;
        fArray3[2] = f4;
        return bl2;
    }

    public int compareTo(Object object) throws ClassCastException {
        TriangleFanArray triangleFanArray = (TriangleFanArray)object;
        return this.compareTo(triangleFanArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TriangleFanArray)) {
            return false;
        }
        return this.equals((TriangleFanArray)object);
    }

    public void setFanCount(int[] nArray, int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] < 3) {
                throw new IllegalArgumentException(MIN_COUNT_MSG + i);
            }
            n2 += nArray[i];
        }
        if (this.fanCounts == null || this.fanCounts.length < n) {
            this.fanCounts = new int[n];
        }
        if (n2 > this.numCoords) {
            throw new IllegalArgumentException(TOTAL_COUNT_MSG);
        }
        this.numRequiredCoords = n2;
        this.numFans = n;
        if (n > 0) {
            System.arraycopy(nArray, 0, this.fanCounts, 0, n);
        }
    }

    public int getValidFanCount() {
        return this.numFans;
    }

    public void getFanCount(int[] nArray) {
        System.arraycopy(this.fanCounts, 0, nArray, 0, this.numFans);
    }

    public int compareTo(TriangleFanArray triangleFanArray) {
        if (triangleFanArray == null) {
            return 1;
        }
        if (triangleFanArray == this) {
            return 0;
        }
        return 0;
    }

    public boolean equals(TriangleFanArray triangleFanArray) {
        return triangleFanArray == this;
    }
}

