/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.MultipassTextureDestination;
import org.j3d.aviatrix3d.MultipassTextureSource;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.TextureComponent;
import org.j3d.aviatrix3d.TextureComponent2D;
import org.j3d.aviatrix3d.TextureSource;
import org.j3d.aviatrix3d.iutil.TextureUpdateData;

public class TextureCubicEnvironmentMap
extends Texture
implements MultipassTextureDestination {
    public static final int POSITIVE_X = 0;
    public static final int NEGATIVE_X = 1;
    public static final int POSITIVE_Y = 2;
    public static final int NEGATIVE_Y = 3;
    public static final int POSITIVE_Z = 4;
    public static final int NEGATIVE_Z = 5;
    private static final int[] TEXTURE_TARGETS = new int[]{34069, 34070, 34071, 34072, 34073, 34074};
    protected int height;
    protected int boundaryModeT;
    protected int[] mpReadBuffer;
    protected int[][][] mpOffsets;
    protected int mpNumSources;
    protected int[] mpSourceIndices;

    public TextureCubicEnvironmentMap() {
        super(34067, 6);
        this.sources = new TextureSource[6];
        this.height = -1;
        this.init();
    }

    public TextureCubicEnvironmentMap(TextureComponent2D[] textureComponent2DArray) {
        super(34067, 6);
        this.sources = new TextureSource[6];
        this.height = -1;
        if (textureComponent2DArray != null) {
            this.height = textureComponent2DArray[0].getHeight();
            this.sources[0] = textureComponent2DArray[0];
            this.sources[1] = textureComponent2DArray[1];
            this.sources[2] = textureComponent2DArray[2];
            this.sources[3] = textureComponent2DArray[3];
            this.sources[4] = textureComponent2DArray[4];
            this.sources[5] = textureComponent2DArray[5];
            this.numSources = 6;
        }
        this.init();
    }

    public int numMultipassSources() {
        return this.mpNumSources;
    }

    public void getMultipassSources(MultipassTextureSource[] multipassTextureSourceArray, int[] nArray) {
        if (this.mpNumSources == 0) {
            return;
        }
        for (int i = 0; i < this.mpNumSources; ++i) {
            nArray[i] = this.mpSourceIndices[i];
            multipassTextureSourceArray[i] = multipassTextureSourceArray[this.mpSourceIndices[i]];
        }
    }

    public void updateMultipassSource(GL gL, int n, int n2, int n3, int n4, int n5, int n6) {
        gL.glReadBuffer(this.mpReadBuffer[n5]);
        Integer n7 = (Integer)this.textureIdMap.get(gL);
        if (n7 == null) {
            int[] nArray = new int[1];
            gL.glGenTextures(1, nArray, 0);
            this.textureIdMap.put(gL, new Integer(nArray[0]));
            gL.glBindTexture(this.textureType, nArray[0]);
            int n8 = this.sources[n5].getFormat(n6);
            int n9 = 6407;
            switch (n8) {
                case 1: {
                    n9 = 6407;
                    break;
                }
                case 2: {
                    n9 = 6408;
                    break;
                }
                case 3: {
                    n9 = 32992;
                    break;
                }
                case 4: {
                    n9 = 32993;
                    break;
                }
                case 5: {
                    n9 = 6410;
                    break;
                }
                case 6: {
                    switch (this.format) {
                        case 32841: {
                            n9 = 6409;
                            break;
                        }
                        case 6406: {
                            n9 = 6406;
                        }
                    }
                    break;
                }
            }
            gL.glCopyTexImage2D(TEXTURE_TARGETS[n5], n6, n9, n, n2, n3, n4, 0);
        } else {
            gL.glBindTexture(this.textureType, n7.intValue());
            gL.glCopyTexSubImage2D(TEXTURE_TARGETS[n5], n6, this.mpOffsets[n5][n6][0], this.mpOffsets[n5][n6][1], n, n2, n3, n4);
        }
    }

    public void setReadBuffer(int n, int n2) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.mpReadBuffer[n] = n2;
    }

    public int getReadBuffer(int n) {
        return this.mpReadBuffer[n];
    }

    public void setCopyOffset(int n, int n2, int n3, int n4) throws InvalidWriteTimingException {
        this.mpOffsets[n][n2][0] = n3;
        this.mpOffsets[n][n2][1] = n4;
    }

    public void getCopyOffset(int n, int n2, int[] nArray) {
        nArray[0] = this.mpOffsets[n][n2][0];
        nArray[1] = this.mpOffsets[n][n2][1];
    }

    public void setSources(int n, int n2, TextureSource[] textureSourceArray, int n3) throws InvalidWriteTimingException {
        super.setSources(n, n2, textureSourceArray, n3);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            if (!(textureSourceArray[i] instanceof MultipassTextureSource)) continue;
            this.mpSourceIndices[n4++] = i;
        }
        this.mpNumSources = n4;
    }

    public void render(GL gL) {
        int n;
        if (this.numSources == 0) {
            return;
        }
        Integer n2 = (Integer)this.textureIdMap.get(gL);
        if (n2 == null) {
            int[] nArray = new int[1];
            gL.glGenTextures(1, nArray, 0);
            this.textureIdMap.put(gL, new Integer(nArray[0]));
            gL.glBindTexture(this.textureType, nArray[0]);
            this.imageChanged.put(gL, true);
            this.stateChanged.put(gL, true);
            this.updateManagers[0].addContext(gL);
        } else {
            gL.glBindTexture(this.textureType, n2.intValue());
        }
        if (this.stateChanged.getState(gL)) {
            this.stateChanged.put(gL, false);
            int n3 = 0;
            switch (this.magFilter) {
                case 0: 
                case 2: {
                    n3 = 9728;
                    break;
                }
                case 1: 
                case 3: {
                    n3 = 9729;
                    break;
                }
                default: {
                    System.out.println("Unknown mode in MagFilter: " + this.magFilter);
                }
            }
            gL.glTexParameteri(34067, 10240, n3);
            switch (this.minFilter) {
                case 0: 
                case 2: {
                    n3 = 9728;
                    break;
                }
                case 3: {
                    n3 = 9729;
                    break;
                }
                case 5: {
                    n3 = 9987;
                    break;
                }
                case 4: {
                    n3 = 9984;
                    break;
                }
                case 1: {
                    n3 = this.numSources > 1 ? 9987 : 9729;
                    break;
                }
                default: {
                    System.out.println("Unknown mode in MinFilter: " + this.minFilter);
                }
            }
            gL.glTexParameteri(34067, 10241, n3);
            if (this.anisotropicMode != 0) {
                gL.glTexParameterf(34067, 34046, this.anisotropicDegree);
            }
            gL.glPixelStorei(3317, 1);
            if (this.priority >= 0.0f) {
                gL.glTexParameterf(32879, 32870, this.priority);
            }
            if (this.borderColor != null) {
                gL.glTexParameterfv(32879, 4100, this.borderColor, 0);
            }
            if (this.format == 6402) {
                gL.glTexParameterf(32879, 34891, (float)this.depthComponentMode);
                gL.glTexParameterf(32879, 34892, (float)this.compareMode);
                gL.glTexParameterf(32879, 34893, (float)this.compareFunction);
            }
        }
        if (this.imageChanged.getState(gL)) {
            this.imageChanged.put(gL, false);
            for (int i = 0; i < 6; ++i) {
                if (this.sources[i] == null) continue;
                n = this.sources[i].getNumLevels();
                for (int j = 0; j < n; ++j) {
                    TextureComponent2D textureComponent2D = (TextureComponent2D)this.sources[i];
                    ByteBuffer byteBuffer = textureComponent2D.getData(j);
                    byteBuffer.rewind();
                    int n4 = this.sources[i].getWidth();
                    int n5 = textureComponent2D.getHeight();
                    int n6 = this.sources[i].getFormat(j);
                    int n7 = 6407;
                    int n8 = 6407;
                    block11 : switch (n6) {
                        case 1: {
                            n7 = 6407;
                            n8 = 6407;
                            break;
                        }
                        case 2: {
                            n7 = 6408;
                            n8 = 6408;
                            break;
                        }
                        case 3: {
                            n7 = 32992;
                            n8 = 32992;
                            break;
                        }
                        case 4: {
                            n7 = 32993;
                            n8 = 32993;
                            break;
                        }
                        case 5: {
                            n7 = 6410;
                            n8 = 6410;
                            break;
                        }
                        case 6: {
                            switch (this.format) {
                                case 32841: {
                                    n7 = 6409;
                                    n8 = 6409;
                                    break block11;
                                }
                                case 6406: {
                                    n7 = 6406;
                                    n8 = 6406;
                                }
                            }
                        }
                    }
                    gL.glTexImage2D(TEXTURE_TARGETS[i], 0, n7, n4, n5, j, n8, 5121, (Buffer)byteBuffer);
                    byteBuffer.clear();
                    byteBuffer = null;
                    if (n4 > 1) {
                        n4 >>= 1;
                    }
                    if (n5 <= 1) continue;
                    n5 >>= 1;
                }
            }
        }
        for (int i = 0; i < 6; ++i) {
            n = this.updateManagers[i].getNumUpdatesPending(gL);
            if (n == 0) continue;
            TextureUpdateData[] textureUpdateDataArray = this.updateManagers[i].getUpdatesAndClear(gL);
            for (int j = 0; j < n; ++j) {
                textureUpdateDataArray[j].pixels.rewind();
                gL.glTexSubImage2D(3553, textureUpdateDataArray[j].level, textureUpdateDataArray[j].x, textureUpdateDataArray[j].y, textureUpdateDataArray[j].width, textureUpdateDataArray[j].height, textureUpdateDataArray[j].format, 5121, (Buffer)textureUpdateDataArray[j].pixels);
            }
        }
    }

    public void postRender(GL gL) {
    }

    public void setBoundaryModeT(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.boundaryModeT = n;
        this.stateChanged.setAll(true);
    }

    public int getBoundaryModeT() {
        return this.boundaryModeT;
    }

    public int getHeight() {
        return this.height;
    }

    private void init() {
        this.boundaryModeT = 10496;
        this.mpOffsets = new int[6][][];
        this.mpReadBuffer = new int[6];
        this.mpSourceIndices = new int[6];
        if (this.numSources == 0) {
            return;
        }
        int n = 0;
        for (int i = 0; i < this.numSources; ++i) {
            int n2;
            int n3 = n2 = this.mipMapMode == 0 ? 1 : this.sources[i].getNumLevels();
            if (!(this.sources[i] instanceof MultipassTextureSource)) {
                this.mpOffsets[i] = new int[n2][2];
                this.mpSourceIndices[n++] = i;
                continue;
            }
            for (int j = 0; j < n2; ++j) {
                int n4 = this.sources[i].getFormat(j);
                int n5 = 6407;
                switch (n4) {
                    case 1: {
                        n5 = 6407;
                        break;
                    }
                    case 2: {
                        n5 = 6408;
                        break;
                    }
                    case 3: {
                        n5 = 32992;
                        break;
                    }
                    case 4: {
                        n5 = 32993;
                        break;
                    }
                    case 5: {
                        n5 = 6410;
                        break;
                    }
                    case 6: {
                        switch (this.format) {
                            case 32841: {
                                n5 = 6409;
                                break;
                            }
                            case 6406: {
                                n5 = 6406;
                            }
                        }
                        break;
                    }
                }
                this.updateManagers[i].setTextureFormat(n5);
                ((TextureComponent)this.sources[i]).addUpdateListener(this.updateManagers[i]);
            }
        }
        this.mpNumSources = n;
    }

    public int compareTo(Texture texture) {
        int n = super.compareTo(texture);
        if (n != 0) {
            return n;
        }
        TextureCubicEnvironmentMap textureCubicEnvironmentMap = (TextureCubicEnvironmentMap)texture;
        if (this.height != textureCubicEnvironmentMap.height) {
            return this.height < textureCubicEnvironmentMap.height ? -1 : 1;
        }
        if (this.boundaryModeS != textureCubicEnvironmentMap.boundaryModeS) {
            return this.boundaryModeS < textureCubicEnvironmentMap.boundaryModeS ? -1 : 1;
        }
        if (this.boundaryModeT != textureCubicEnvironmentMap.boundaryModeT) {
            return this.boundaryModeT < textureCubicEnvironmentMap.boundaryModeT ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Texture texture) {
        if (!super.equals(texture)) {
            return false;
        }
        if (!(texture instanceof TextureCubicEnvironmentMap)) {
            return false;
        }
        TextureCubicEnvironmentMap textureCubicEnvironmentMap = (TextureCubicEnvironmentMap)texture;
        return this.height == textureCubicEnvironmentMap.height && this.boundaryModeS == textureCubicEnvironmentMap.boundaryModeS && this.boundaryModeT == textureCubicEnvironmentMap.boundaryModeT;
    }
}

