/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.TextureComponent;
import org.j3d.aviatrix3d.TextureComponent3D;
import org.j3d.aviatrix3d.TextureSource;
import org.j3d.aviatrix3d.iutil.TextureUpdateData;

public class Texture3D
extends Texture {
    private int boundaryModeR;
    private int height;
    private int depth;
    private int boundaryModeT;

    public Texture3D() {
        super(32879, 1);
        this.height = -1;
        this.depth = -1;
        this.init();
    }

    public Texture3D(int n, TextureComponent3D textureComponent3D) {
        super(32879, 1);
        this.format = n;
        this.sources = new TextureSource[1];
        this.sources[0] = textureComponent3D;
        this.width = textureComponent3D.getWidth();
        this.height = textureComponent3D.getHeight();
        this.depth = textureComponent3D.getDepth();
        this.numSources = 1;
        this.init();
    }

    public void setSources(int n, int n2, TextureSource[] textureSourceArray, int n3) throws InvalidWriteTimingException {
        if (n3 > 0 && !(textureSourceArray[0] instanceof TextureComponent3D)) {
            throw new IllegalArgumentException("Must be a 3D texture source");
        }
        super.setSources(n, n2, textureSourceArray, n3);
        if (n3 > 0) {
            this.depth = ((TextureComponent3D)this.sources[0]).getDepth();
            this.height = ((TextureComponent3D)this.sources[0]).getHeight();
        }
        this.stateChanged.setAll(true);
    }

    public int compareTo(Texture texture) {
        int n = super.compareTo(texture);
        if (n != 0) {
            return n;
        }
        Texture3D texture3D = (Texture3D)texture;
        if (this.height != texture3D.height) {
            return this.height < texture3D.height ? -1 : 1;
        }
        if (this.depth != texture3D.depth) {
            return this.depth < texture3D.depth ? -1 : 1;
        }
        if (this.boundaryModeS != texture3D.boundaryModeS) {
            return this.boundaryModeS < texture3D.boundaryModeS ? -1 : 1;
        }
        if (this.boundaryModeT != texture3D.boundaryModeT) {
            return this.boundaryModeT < texture3D.boundaryModeT ? -1 : 1;
        }
        if (this.boundaryModeR != texture3D.boundaryModeR) {
            return this.boundaryModeR < texture3D.boundaryModeR ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Texture texture) {
        if (!super.equals(texture)) {
            return false;
        }
        if (!(texture instanceof Texture3D)) {
            return false;
        }
        Texture3D texture3D = (Texture3D)texture;
        return this.height == texture3D.height && this.depth == texture3D.depth && this.boundaryModeS == texture3D.boundaryModeS && this.boundaryModeT == texture3D.boundaryModeT && this.boundaryModeR == texture3D.boundaryModeR;
    }

    public void render(GL gL) {
        int n;
        int n2;
        Object object;
        if (this.numSources == 0) {
            return;
        }
        Integer n3 = (Integer)this.textureIdMap.get(gL);
        if (n3 == null) {
            object = new int[1];
            gL.glGenTextures(1, (int[])object, 0);
            this.textureIdMap.put(gL, new Integer(object[0]));
            gL.glBindTexture(this.textureType, object[0]);
            this.imageChanged.put(gL, true);
            this.stateChanged.put(gL, true);
            this.updateManagers[0].addContext(gL);
        } else {
            gL.glBindTexture(this.textureType, n3.intValue());
        }
        if (this.stateChanged.getState(gL)) {
            this.stateChanged.put(gL, false);
            gL.glPixelStorei(3317, 1);
            gL.glTexParameteri(32879, 10242, this.boundaryModeS);
            gL.glTexParameteri(32879, 10243, this.boundaryModeT);
            gL.glTexParameteri(32879, 32882, this.boundaryModeR);
            int n4 = 0;
            switch (this.magFilter) {
                case 0: 
                case 2: {
                    n4 = 9728;
                    break;
                }
                case 1: 
                case 3: {
                    n4 = 9729;
                    break;
                }
                default: {
                    System.out.println("Unknown mode in MagFilter: " + this.magFilter);
                }
            }
            gL.glTexParameteri(32879, 10240, n4);
            switch (this.minFilter) {
                case 0: 
                case 2: {
                    n4 = 9728;
                    break;
                }
                case 3: {
                    n4 = 9729;
                    break;
                }
                case 5: {
                    n4 = 9987;
                    break;
                }
                case 4: {
                    n4 = 9984;
                    break;
                }
                case 1: {
                    n4 = this.numSources > 1 ? 9987 : 9729;
                    break;
                }
                default: {
                    System.out.println("Unknown mode in MinFilter: " + this.minFilter);
                }
            }
            gL.glTexParameteri(32879, 10241, n4);
            if (this.anisotropicMode != 0) {
                gL.glTexParameterf(32879, 34046, this.anisotropicDegree);
            }
            if (this.priority >= 0.0f) {
                gL.glTexParameterf(32879, 32870, this.priority);
            }
            if (this.borderColor != null) {
                gL.glTexParameterfv(32879, 4100, this.borderColor, 0);
            }
            if (this.format == 6402) {
                gL.glTexParameterf(32879, 34891, (float)this.depthComponentMode);
                gL.glTexParameterf(32879, 34892, (float)this.compareMode);
                gL.glTexParameterf(32879, 34893, (float)this.compareFunction);
            }
        }
        if (this.imageChanged.getState(gL)) {
            this.imageChanged.put(gL, false);
            object = (TextureComponent3D)this.sources[0];
            int n5 = ((TextureComponent)object).getWidth();
            n2 = ((TextureComponent3D)object).getHeight();
            int n6 = ((TextureComponent3D)object).getDepth();
            int n7 = this.mipMapMode == 0 ? 1 : ((TextureComponent)object).getNumLevels();
            for (int i = 0; i < n7; ++i) {
                ByteBuffer byteBuffer = ((TextureComponent)object).getData(i);
                byteBuffer.rewind();
                int n8 = ((TextureComponent)object).getFormat(i);
                int n9 = 6407;
                int n10 = 6407;
                block11 : switch (n8) {
                    case 1: {
                        n9 = 6407;
                        n10 = 6407;
                        break;
                    }
                    case 2: {
                        n9 = 6408;
                        n10 = 6408;
                        break;
                    }
                    case 3: {
                        n9 = 32992;
                        n10 = 32992;
                        break;
                    }
                    case 4: {
                        n9 = 32993;
                        n10 = 32993;
                        break;
                    }
                    case 5: {
                        n9 = 6410;
                        n10 = 6410;
                        break;
                    }
                    case 6: {
                        switch (this.format) {
                            case 32841: {
                                n9 = 32841;
                                n10 = 6409;
                                break block11;
                            }
                            case 6409: {
                                n9 = 6409;
                                n10 = 6409;
                                break block11;
                            }
                            case 6406: {
                                n9 = 6406;
                                n10 = 6406;
                            }
                        }
                    }
                }
                gL.glTexImage3D(32879, i, n9, n5, n2, n6, 0, n10, 5121, (Buffer)byteBuffer);
                byteBuffer.clear();
                byteBuffer = null;
                if (n5 > 1) {
                    n5 >>= 1;
                }
                if (n2 > 1) {
                    n2 >>= 1;
                }
                if (n6 <= 1) continue;
                n6 >>= 1;
            }
        }
        if ((n = this.updateManagers[0].getNumUpdatesPending(gL)) != 0) {
            TextureUpdateData[] textureUpdateDataArray = this.updateManagers[0].getUpdatesAndClear(gL);
            for (n2 = 0; n2 < n; ++n2) {
                textureUpdateDataArray[n2].pixels.rewind();
                gL.glTexSubImage3D(32879, textureUpdateDataArray[n2].level, textureUpdateDataArray[n2].x, textureUpdateDataArray[n2].y, textureUpdateDataArray[n2].z, textureUpdateDataArray[n2].width, textureUpdateDataArray[n2].height, textureUpdateDataArray[n2].depth, textureUpdateDataArray[n2].format, 5121, (Buffer)textureUpdateDataArray[n2].pixels);
            }
        }
    }

    public void postRender(GL gL) {
    }

    public void setBoundaryModeR(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.boundaryModeR = n;
        this.stateChanged.setAll(true);
    }

    public int getBoundaryModeR() {
        return this.boundaryModeR;
    }

    public void setBoundaryModeT(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.boundaryModeT = n;
        this.stateChanged.setAll(true);
    }

    public int getBoundaryModeT() {
        return this.boundaryModeT;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getHeight() {
        return this.height;
    }

    private void init() {
        this.boundaryModeT = 10496;
        this.boundaryModeR = 10496;
        if (this.numSources == 0) {
            return;
        }
        int n = this.mipMapMode == 0 ? 1 : this.sources[0].getNumLevels();
        for (int i = 0; i < this.numSources; ++i) {
            int n2 = this.sources[i].getFormat(0);
            int n3 = 6407;
            switch (n2) {
                case 1: {
                    n3 = 6407;
                    break;
                }
                case 2: {
                    n3 = 6408;
                    break;
                }
                case 3: {
                    n3 = 32992;
                    break;
                }
                case 4: {
                    n3 = 32993;
                    break;
                }
                case 5: {
                    n3 = 6410;
                    break;
                }
                case 6: {
                    switch (this.format) {
                        case 32841: {
                            n3 = 32841;
                            break;
                        }
                        case 6409: {
                            n3 = 6409;
                            break;
                        }
                        case 6406: {
                            n3 = 6406;
                        }
                    }
                    break;
                }
            }
            this.updateManagers[i].setTextureFormat(n3);
            ((TextureComponent)this.sources[i]).addUpdateListener(this.updateManagers[i]);
        }
    }
}

