/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.util.HashMap;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.TextureComponent;
import org.j3d.aviatrix3d.TextureSource;
import org.j3d.aviatrix3d.iutil.GLStateMap;
import org.j3d.aviatrix3d.iutil.TextureUpdateStateManager;
import org.j3d.aviatrix3d.rendering.DeletableRenderable;
import org.j3d.aviatrix3d.rendering.ObjectRenderable;

public abstract class Texture
extends NodeComponent
implements DeletableRenderable,
ObjectRenderable {
    private static final String INVALID_PRIORITY_MSG = "The priority value is out of range. It must be [0,1] or -1";
    private static final int PENDING_LIST_INC = 10;
    public static final int MODE_BASE_LEVEL = 0;
    public static final int MODE_MIPMAP = 1;
    public static final int BM_WRAP = 10497;
    public static final int BM_CLAMP = 10496;
    public static final int BM_CLAMP_TO_EDGE = 33071;
    public static final int BM_CLAMP_TO_BOUNDARY = 33069;
    public static final int BM_MIRRORED_REPEAT = 33648;
    public static final int MAGFILTER_FASTEST = 0;
    public static final int MAGFILTER_NICEST = 1;
    public static final int MAGFILTER_BASE_LEVEL_POINT = 2;
    public static final int MAGFILTER_BASE_LEVEL_LINEAR = 3;
    public static final int MAGFILTER_LINEAR_DETAIL = 4;
    public static final int MAGFILTER_LINEAR_DETAIL_RGB = 5;
    public static final int MAGFILTER_LINEAR_DETAIL_ALPHA = 6;
    public static final int MINFILTER_FASTEST = 0;
    public static final int MINFILTER_NICEST = 1;
    public static final int MINFILTER_BASE_LEVEL_POINT = 2;
    public static final int MINFILTER_BASE_LEVEL_LINEAR = 3;
    public static final int MINFILTER_MULTI_LEVEL_POINT = 4;
    public static final int MINFILTER_MULTI_LEVEL_LINEAR = 5;
    public static final int ANISOTROPIC_MODE_NONE = 0;
    public static final int ANISOTROPIC_MODE_SINGLE = 1;
    public static final int FORMAT_ALPHA = 6406;
    public static final int FORMAT_INTENSITY = 32841;
    public static final int FORMAT_LUMINANCE = 6409;
    public static final int FORMAT_INTENSITY_ALPHA = 6410;
    public static final int FORMAT_LUMINANCE_ALPHA = 6410;
    public static final int FORMAT_RGB = 6407;
    public static final int FORMAT_RGBA = 6408;
    public static final int FORMAT_DEPTH_COMPONENT = 6402;
    public static final int COMPARE_MODE_NONE = 0;
    public static final int COMPARE_MODE_R2TEX = 34894;
    public static final int COMPARE_FUNCTION_LEQUAL = 515;
    public static final int COMPARE_FUNCTION_GEQUAL = 518;
    public static final int UPDATE_BUFFER_ALL = 1;
    public static final int UPDATE_BUFFER_LAST = 2;
    public static final int UPDATE_DISCARD_OVERWRITES = 3;
    protected TextureSource[] sources;
    protected int numSources;
    protected int anisotropicMode;
    protected float anisotropicDegree;
    protected int magFilter;
    protected int minFilter;
    protected int boundaryModeS;
    protected int mipMapMode;
    protected int width = -1;
    protected int format;
    protected float[] borderColor;
    protected GLStateMap imageChanged;
    protected GLStateMap stateChanged;
    protected float priority;
    protected int depthComponentMode;
    protected int compareMode;
    protected int compareFunction;
    protected final int textureType;
    protected HashMap<GL, Integer> textureIdMap;
    protected int updateStrategy;
    protected TextureUpdateStateManager[] updateManagers;

    protected Texture(int n) {
        this(n, 1);
    }

    protected Texture(int n, int n2) {
        this.textureType = n;
        this.priority = -1.0f;
        this.depthComponentMode = 6409;
        this.compareMode = 0;
        this.compareFunction = 518;
        this.mipMapMode = 0;
        this.boundaryModeS = 10496;
        this.magFilter = 0;
        this.minFilter = 0;
        this.updateStrategy = 2;
        this.updateManagers = new TextureUpdateStateManager[n2];
        for (int i = 0; i < n2; ++i) {
            this.updateManagers[i] = new TextureUpdateStateManager(this.updateStrategy);
        }
        this.textureIdMap = new HashMap();
        this.imageChanged = new GLStateMap();
        this.stateChanged = new GLStateMap();
    }

    protected void setLive(boolean bl) {
        if (bl) {
            ++this.liveCount;
        } else if (this.liveCount > 0) {
            --this.liveCount;
        }
        if (this.liveCount == 0 || !this.alive) {
            super.setLive(bl);
            for (int i = 0; i < this.numSources; ++i) {
                ((SceneGraphObject)((Object)this.sources[i])).setLive(bl);
            }
            if (!bl && this.updateHandler != null) {
                this.updateHandler.requestDeletion(this);
            }
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        for (int i = 0; i < this.numSources; ++i) {
            ((SceneGraphObject)((Object)this.sources[i])).setUpdateHandler(this.updateHandler);
        }
    }

    public void cleanup(GL gL) {
        Integer n = this.textureIdMap.get(gL);
        if (n != null) {
            int[] nArray = new int[]{n};
            gL.glDeleteTextures(1, nArray, 0);
            this.textureIdMap.remove(gL);
        }
    }

    public int compareTo(Object object) throws ClassCastException {
        Texture texture = (Texture)object;
        return this.compareTo(texture);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Texture)) {
            return false;
        }
        return this.equals((Texture)object);
    }

    public void setSources(int n, int n2, TextureSource[] textureSourceArray, int n3) throws InvalidWriteTimingException {
        int n4;
        int n5;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.width = n3 == 0 ? -1 : textureSourceArray[0].getWidth();
        this.format = n2;
        this.mipMapMode = n;
        for (n5 = 0; n5 < this.numSources; ++n5) {
            if (!(this.sources[n5] instanceof TextureComponent)) continue;
            ((TextureComponent)this.sources[n5]).removeUpdateListener(this.updateManagers[n5]);
            this.updateManagers[n5].clearPendingUpdates();
        }
        if (this.sources == null || this.sources.length < n3) {
            this.sources = new TextureSource[n3];
            TextureUpdateStateManager[] textureUpdateStateManagerArray = new TextureUpdateStateManager[n3];
            System.arraycopy(this.updateManagers, 0, textureUpdateStateManagerArray, 0, this.numSources);
            this.updateManagers = textureUpdateStateManagerArray;
            for (n4 = this.numSources; n4 < n3; ++n4) {
                this.updateManagers[n4] = new TextureUpdateStateManager(this.updateStrategy);
            }
        } else {
            for (n5 = n3; n5 < this.numSources; ++n5) {
                this.sources[n5] = null;
            }
        }
        System.arraycopy(textureSourceArray, 0, this.sources, 0, n3);
        this.numSources = n3;
        for (n4 = 0; n4 < n3; ++n4) {
            if (!(this.sources[n4] instanceof TextureComponent)) continue;
            TextureComponent textureComponent = (TextureComponent)this.sources[n4];
            textureComponent.setUpdateHandler(this.updateHandler);
            textureComponent.setLive(true);
        }
        this.imageChanged.setAll(true);
        for (n4 = 0; n4 < this.numSources; ++n4) {
            if (!(this.sources[n4] instanceof TextureComponent)) continue;
            TextureComponent textureComponent = (TextureComponent)this.sources[n4];
            int n6 = textureComponent.getFormat(0);
            int n7 = 6407;
            switch (n6) {
                case 1: {
                    n7 = 6407;
                    break;
                }
                case 2: {
                    n7 = 6408;
                    break;
                }
                case 3: {
                    n7 = 32992;
                    break;
                }
                case 4: {
                    n7 = 32993;
                    break;
                }
                case 5: 
                case 7: {
                    n7 = 6410;
                    break;
                }
                case 6: {
                    switch (n2) {
                        case 32841: {
                            n7 = 32841;
                            break;
                        }
                        case 6409: {
                            n7 = 6409;
                            break;
                        }
                        case 6406: {
                            n7 = 6406;
                        }
                    }
                    break;
                }
            }
            this.updateManagers[n4].setTextureFormat(n7);
            textureComponent.addUpdateListener(this.updateManagers[n4]);
        }
    }

    public int getTextureType() {
        return this.textureType;
    }

    public int getFormat() {
        return this.format;
    }

    public int getWidth() {
        return this.width;
    }

    public void setAnisotropicFilterMode(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.anisotropicMode = n;
        this.stateChanged.setAll(true);
    }

    public int getAnisotropicFilterMode() {
        return this.anisotropicMode;
    }

    public void setAnisotropicFilterDegree(float f) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.anisotropicDegree = f;
        this.stateChanged.setAll(true);
    }

    public float getAnisotropicFilterDegree() {
        return this.anisotropicDegree;
    }

    public void setMagFilter(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.magFilter = n;
        this.stateChanged.setAll(true);
    }

    public int getMagFilter() {
        return this.magFilter;
    }

    public void setMinFilter(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.minFilter = n;
        this.stateChanged.setAll(true);
    }

    public int getMinFilter() {
        return this.minFilter;
    }

    public void setBoundaryModeS(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.boundaryModeS = n;
        this.stateChanged.setAll(true);
    }

    public int getBoundaryModeS() {
        return this.boundaryModeS;
    }

    public void setBorderColor(float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.borderColor == null) {
            this.borderColor = new float[4];
        }
        this.borderColor[0] = fArray[0];
        this.borderColor[1] = fArray[1];
        this.borderColor[2] = fArray[2];
        this.borderColor[3] = fArray.length > 3 ? fArray[3] : 1.0f;
        this.stateChanged.setAll(true);
    }

    public void getBorderColor(float[] fArray) {
        if (this.borderColor == null) {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
            if (fArray.length > 3) {
                fArray[3] = 0.0f;
            }
        } else {
            fArray[0] = this.borderColor[0];
            fArray[1] = this.borderColor[1];
            fArray[2] = this.borderColor[2];
            if (fArray.length > 3) {
                fArray[3] = this.borderColor[3];
            }
        }
    }

    public void setDepthFormat(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.depthComponentMode = n;
        this.stateChanged.setAll(true);
    }

    public int getDepthFormat() {
        return this.depthComponentMode;
    }

    public void setCompareMode(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.compareMode = n;
        this.stateChanged.setAll(true);
    }

    public int getCompareMode() {
        return this.compareMode;
    }

    public void setCompareFunction(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.compareFunction = n;
        this.stateChanged.setAll(true);
    }

    public int getCompareFunction() {
        return this.compareFunction;
    }

    public void setUpdateStrategy(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.updateStrategy = n;
        for (int i = 0; i < this.numSources; ++i) {
            this.updateManagers[i].setUpdateStrategy(n);
        }
    }

    public int getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setPriority(float f) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f != -1.0f && (f < 0.0f || f > 1.0f)) {
            throw new IllegalArgumentException(INVALID_PRIORITY_MSG);
        }
        this.priority = f;
        this.stateChanged.setAll(true);
    }

    public float getPriority() {
        return this.priority;
    }

    public int compareTo(Texture texture) {
        int n;
        if (texture == null) {
            return 1;
        }
        if (texture == this) {
            return 0;
        }
        if (this.textureType != texture.textureType) {
            return this.textureType < texture.textureType ? -1 : 1;
        }
        if (this.minFilter != texture.minFilter) {
            return this.minFilter < texture.minFilter ? -1 : 1;
        }
        if (this.magFilter != texture.magFilter) {
            return this.magFilter < texture.magFilter ? -1 : 1;
        }
        if (this.mipMapMode != texture.mipMapMode) {
            return this.mipMapMode < texture.mipMapMode ? -1 : 1;
        }
        if (this.anisotropicMode != texture.anisotropicMode) {
            return this.anisotropicMode < texture.anisotropicMode ? -1 : 1;
        }
        if (this.anisotropicDegree != texture.anisotropicDegree) {
            return this.anisotropicDegree < texture.anisotropicDegree ? -1 : 1;
        }
        if (this.format != texture.format) {
            return this.format < texture.format ? -1 : 1;
        }
        if (this.width != texture.width) {
            return this.width < texture.width ? -1 : 1;
        }
        if (this.priority != texture.priority) {
            return this.priority > texture.priority ? -1 : 1;
        }
        if (this.format == 6402) {
            if (this.depthComponentMode != texture.depthComponentMode) {
                return this.depthComponentMode < texture.depthComponentMode ? -1 : 1;
            }
            if (this.compareMode != texture.compareMode) {
                return this.compareMode < texture.compareMode ? -1 : 1;
            }
            if (this.compareFunction != texture.compareFunction) {
                return this.compareFunction < texture.compareFunction ? -1 : 1;
            }
        }
        if (this.borderColor != texture.borderColor) {
            if (this.borderColor == null) {
                return -1;
            }
            if (texture.borderColor == null) {
                return 1;
            }
            n = this.compareColor4(this.borderColor, texture.borderColor);
            if (n != 0) {
                return n;
            }
        }
        if (this.numSources != texture.numSources) {
            return this.numSources < texture.numSources ? -1 : 1;
        }
        for (n = 0; n < this.numSources; ++n) {
            if (this.sources[n] == texture.sources[n]) continue;
            return this.sources[n].hashCode() < texture.sources[n].hashCode() ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Texture texture) {
        if (texture == this) {
            return true;
        }
        if (texture == null || this.textureType != texture.textureType || this.minFilter != texture.minFilter || this.magFilter != texture.magFilter || this.mipMapMode != texture.mipMapMode || this.anisotropicMode != texture.anisotropicMode || this.anisotropicDegree != texture.anisotropicDegree || this.format != texture.format || this.width != texture.width || this.numSources != texture.numSources || this.priority != texture.priority) {
            return false;
        }
        if (this.format == 6402 && (this.depthComponentMode != texture.depthComponentMode || this.compareMode != texture.compareMode || this.compareFunction != texture.compareFunction)) {
            return false;
        }
        if (this.borderColor != texture.borderColor && this.borderColor == null || texture.borderColor == null || this.borderColor != null && !this.equalsColor4(this.borderColor, texture.borderColor)) {
            return false;
        }
        for (int i = 0; i < this.numSources; ++i) {
            if (this.sources[i] == texture.sources[i]) continue;
            return false;
        }
        return true;
    }

    boolean hasValidData() {
        return this.numSources != 0;
    }

    private int compareColor4(float[] fArray, float[] fArray2) {
        if (fArray[0] < fArray2[0]) {
            return -1;
        }
        if (fArray[0] > fArray2[0]) {
            return 1;
        }
        if (fArray[1] < fArray2[1]) {
            return -1;
        }
        if (fArray[1] > fArray2[1]) {
            return 1;
        }
        if (fArray[2] < fArray2[2]) {
            return -1;
        }
        if (fArray[2] > fArray2[2]) {
            return 1;
        }
        if (fArray[3] < fArray2[3]) {
            return -1;
        }
        if (fArray[3] > fArray2[3]) {
            return 1;
        }
        return 0;
    }

    private boolean equalsColor4(float[] fArray, float[] fArray2) {
        return fArray[0] == fArray2[0] && fArray[1] == fArray2[1] && fArray[2] == fArray2[2] && fArray[3] == fArray2[3];
    }
}

